/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ManifestAnalyzer {
    private static final int START = 0;
    private static final int IN_CLASSPATH_HEADER = 1;
    private static final int PAST_CLASSPATH_HEADER = 2;
    private static final int SKIPPING_WHITESPACE = 3;
    private static final int READING_JAR = 4;
    private static final int CONTINUING = 5;
    private static final int SKIP_LINE = 6;
    private static final char[] CLASSPATH_HEADER_TOKEN = "Class-Path:".toCharArray();
    private int classpathSectionsCount;
    private ArrayList calledFilesNames;

    public boolean analyzeManifestContents(InputStream inputStream) throws IOException {
        char[] cArray = Util.getInputStreamAsCharArray(inputStream, "UTF-8");
        return this.analyzeManifestContents(cArray);
    }

    public boolean analyzeManifestContents(char[] cArray) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.classpathSectionsCount = 0;
        this.calledFilesNames = null;
        int n3 = 0;
        int n4 = cArray.length;
        while (n3 < n4) {
            char c;
            if ((c = cArray[n3++]) == '\r' && n3 < n4) {
                c = cArray[n3++];
            }
            switch (n) {
                case 0: {
                    if (c == CLASSPATH_HEADER_TOKEN[0]) {
                        n = 1;
                        n2 = 1;
                        break;
                    }
                    n = 6;
                    break;
                }
                case 1: {
                    if (c == '\n') {
                        n = 0;
                        break;
                    }
                    if (c != CLASSPATH_HEADER_TOKEN[n2++]) {
                        n = 6;
                        break;
                    }
                    if (n2 != CLASSPATH_HEADER_TOKEN.length) break;
                    n = 2;
                    break;
                }
                case 2: {
                    if (c == ' ') {
                        n = 3;
                        ++this.classpathSectionsCount;
                        break;
                    }
                    return false;
                }
                case 3: {
                    if (c == '\n') {
                        n = 5;
                        break;
                    }
                    if (c != ' ') {
                        stringBuffer.append(c);
                        n = 4;
                        break;
                    }
                    this.addCurrentTokenJarWhenNecessary(stringBuffer);
                    break;
                }
                case 5: {
                    if (c == '\n') {
                        this.addCurrentTokenJarWhenNecessary(stringBuffer);
                        n = 0;
                        break;
                    }
                    if (c == ' ') {
                        n = 3;
                        break;
                    }
                    if (c == CLASSPATH_HEADER_TOKEN[0]) {
                        this.addCurrentTokenJarWhenNecessary(stringBuffer);
                        n = 1;
                        n2 = 1;
                        break;
                    }
                    if (this.calledFilesNames == null) {
                        this.addCurrentTokenJarWhenNecessary(stringBuffer);
                        n = 0;
                        break;
                    }
                    this.addCurrentTokenJarWhenNecessary(stringBuffer);
                    n = 6;
                    break;
                }
                case 6: {
                    if (c != '\n') break;
                    n = 0;
                    break;
                }
                case 4: {
                    if (c == '\n') {
                        n = 5;
                        break;
                    }
                    if (c != ' ') {
                        stringBuffer.append(c);
                        break;
                    }
                    n = 3;
                    this.addCurrentTokenJarWhenNecessary(stringBuffer);
                }
            }
        }
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                this.addCurrentTokenJarWhenNecessary(stringBuffer);
                return true;
            }
            case 5: {
                this.addCurrentTokenJarWhenNecessary(stringBuffer);
                return true;
            }
            case 6: {
                return this.classpathSectionsCount == 0 || this.calledFilesNames != null;
            }
            case 4: {
                return false;
            }
        }
        return true;
    }

    private boolean addCurrentTokenJarWhenNecessary(StringBuffer stringBuffer) {
        if (stringBuffer != null && stringBuffer.length() > 0) {
            if (this.calledFilesNames == null) {
                this.calledFilesNames = new ArrayList();
            }
            this.calledFilesNames.add(stringBuffer.toString());
            stringBuffer.setLength(0);
            return true;
        }
        return false;
    }

    public int getClasspathSectionsCount() {
        return this.classpathSectionsCount;
    }

    public List getCalledFileNames() {
        return this.calledFilesNames;
    }
}

