"use strict";
/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalCssVariables = void 0;
const Identity_1 = require("../Identity");
const light = () => ({
    // Checkbox
    '--checkbox-background': Identity_1.COLOR_V2.GRAY_20,
    '--checkbox-background-disabled': Identity_1.COLOR_V2.GRAY_10,
    '--checkbox-background-disabled-selected': Identity_1.COLOR_V2.GRAY_60,
    '--checkbox-border': Identity_1.COLOR_V2.GRAY_80,
    '--checkbox-border-disabled': Identity_1.COLOR_V2.GRAY_70,
    // Icon Button
    '--icon-button-primary-enabled-bg': Identity_1.COLOR.WHITE,
    '--icon-button-primary-hover-bg': Identity_1.COLOR_V2.GRAY_20,
    '--icon-button-primary-border': Identity_1.COLOR_V2.GRAY_40,
    '--icon-button-primary-disabled-bg': Identity_1.COLOR_V2.GRAY_20,
    '--icon-button-primary-disabled-border': Identity_1.COLOR_V2.GRAY_40,
    '--icon-button-primary-hover-border': Identity_1.COLOR_V2.GRAY_50,
    // Button
    '--button-primary-disabled-bg': Identity_1.COLOR_V2.GRAY_50,
    '--button-primary-disabled-text': Identity_1.COLOR_V2.GRAY_80,
    '--button-tertiary-bg': Identity_1.COLOR.WHITE,
    '--button-tertiary-border': Identity_1.COLOR_V2.GRAY_40,
    '--button-tertiary-hover-bg': Identity_1.COLOR_V2.GRAY_20,
    '--button-tertiary-hover-border': Identity_1.COLOR_V2.GRAY_50,
    '--button-tertiary-disabled-bg': Identity_1.COLOR_V2.GRAY_20,
    '--button-tertiary-disabled-border': 'transparent',
    // Inputs
    '--text-input-background': Identity_1.COLOR.WHITE,
    '--text-input-border': Identity_1.COLOR_V2.GRAY_40,
    '--text-input-border-hover': Identity_1.COLOR_V2.GRAY_60,
    '--text-input-placeholder': Identity_1.COLOR_V2.GRAY_70,
    '--text-input-disabled': Identity_1.COLOR_V2.GRAY_20,
    '--text-input-label': Identity_1.COLOR_V2.GRAY_80,
    // Select
    '--select-focused-description': Identity_1.COLOR_V2.WHITE,
    // Range Input
    '--indicator-range-input-thumb': Identity_1.COLOR_V2.BLUE_LIGHT_700,
    '--indicator-range-input-track-bg': Identity_1.COLOR_V2.GRAY_60,
    // General
    '--danger-color': Identity_1.COLOR_V2.RED_LIGHT_500,
    '--app-bg': Identity_1.COLOR_V2.GRAY_10,
    '--main-color': Identity_1.COLOR.BLACK,
});
const dark = () => ({
    // Checkbox
    '--checkbox-background': Identity_1.COLOR_V2.GRAY_90,
    '--checkbox-background-disabled': Identity_1.COLOR_V2.GRAY_90,
    '--checkbox-background-disabled-selected': Identity_1.COLOR_V2.GRAY_80,
    '--checkbox-border': Identity_1.COLOR_V2.GRAY_60,
    '--checkbox-border-disabled': Identity_1.COLOR_V2.GRAY_60,
    // Icon Button
    '--icon-button-primary-enabled-bg': Identity_1.COLOR_V2.GRAY_90,
    '--icon-button-primary-hover-bg': Identity_1.COLOR_V2.GRAY_80,
    '--icon-button-primary-border': Identity_1.COLOR_V2.GRAY_100,
    '--icon-button-primary-disabled-bg': Identity_1.COLOR_V2.GRAY_95,
    '--icon-button-primary-disabled-border': Identity_1.COLOR_V2.GRAY_90,
    '--icon-button-primary-hover-border': Identity_1.COLOR_V2.GRAY_70,
    // Button
    '--button-primary-disabled-bg': Identity_1.COLOR_V2.GRAY_70,
    '--button-primary-disabled-text': Identity_1.COLOR.BLACK,
    '--button-tertiary-bg': Identity_1.COLOR_V2.GRAY_90,
    '--button-tertiary-border': Identity_1.COLOR_V2.GRAY_100,
    '--button-tertiary-hover-bg': Identity_1.COLOR_V2.GRAY_80,
    '--button-tertiary-hover-border': Identity_1.COLOR_V2.GRAY_80,
    '--button-tertiary-disabled-bg': Identity_1.COLOR_V2.GRAY_95,
    '--button-tertiary-disabled-border': 'transparent',
    // Inputs
    '--text-input-background': Identity_1.COLOR.BLACK,
    '--text-input-border': Identity_1.COLOR_V2.GRAY_80,
    '--text-input-border-hover': Identity_1.COLOR_V2.GRAY_40,
    '--text-input-placeholder': Identity_1.COLOR_V2.GRAY_60,
    '--text-input-disabled': Identity_1.COLOR_V2.GRAY_100,
    '--text-input-label': Identity_1.COLOR_V2.GRAY_40,
    // Select
    '--select-focused-description': Identity_1.COLOR_V2.GRAY_40,
    // Range Input
    '--indicator-range-input-thumb': Identity_1.COLOR_V2.BLUE_DARK_300,
    '--indicator-range-input-track-bg': Identity_1.COLOR_V2.GRAY_70,
    // General
    '--danger-color': Identity_1.COLOR_V2.RED_DARK_500,
    '--app-bg': Identity_1.COLOR_V2.GRAY_95,
    '--main-color': Identity_1.COLOR.WHITE,
});
const accentColors = () => ({
    '--accent-color': Identity_1.COLOR_V2.BLUE_LIGHT_500,
    '--accent-color-highlight': Identity_1.COLOR_V2.BLUE_LIGHT_50,
    '--accent-color-highlight-inversed': Identity_1.COLOR_V2.BLUE_LIGHT_800,
    '--accent-color-border': Identity_1.COLOR_V2.BLUE_LIGHT_500,
    '--accent-color-focus': Identity_1.COLOR_V2.BLUE_LIGHT_400,
    '--button-primary-hover': Identity_1.COLOR_V2.BLUE_LIGHT_600,
    '--button-primary-active': Identity_1.COLOR_V2.BLUE_LIGHT_700,
    '--button-primary-active-border': Identity_1.COLOR_V2.BLUE_LIGHT_700,
    '--button-primary-focus-border': Identity_1.COLOR_V2.BLUE_LIGHT_700,
    '--button-secondary-active-bg': Identity_1.COLOR_V2.BLUE_LIGHT_50,
    '--button-secondary-active-border': Identity_1.COLOR_V2.BLUE_LIGHT_500,
    '--button-secondary-hover-border': Identity_1.COLOR_V2.BLUE_LIGHT_500,
    '--icon-primary-active-fill': Identity_1.COLOR_V2.BLUE_LIGHT_500,
    '--icon-secondary-active-border': 'transparent',
    '--indicator-range-input-thumb': Identity_1.COLOR_V2.BLUE_LIGHT_700,
});
exports.GlobalCssVariables = {
    light,
    dark,
    accentColors,
};
