"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogFactory = void 0;
const ansi_regex_1 = __importDefault(require("ansi-regex"));
const fs = __importStar(require("fs-extra"));
const logdown_1 = __importDefault(require("logdown"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
class LogFactory {
    static getColor() {
        LogFactory.COLOR_CODE.R = (LogFactory.COLOR_CODE.R + LogFactory.COLOR_STEP.R) % 256;
        LogFactory.COLOR_CODE.G = (LogFactory.COLOR_CODE.G + LogFactory.COLOR_STEP.G) % 256;
        LogFactory.COLOR_CODE.B = (LogFactory.COLOR_CODE.B + LogFactory.COLOR_STEP.B) % 256;
        const rHex = Number(LogFactory.COLOR_CODE.R).toString(16).padStart(2, '0');
        const gHex = LogFactory.COLOR_CODE.G.toString(16).padStart(2, '0');
        const bHex = LogFactory.COLOR_CODE.B.toString(16).padStart(2, '0');
        return `#${rHex}${gHex}${bHex}`;
    }
    static addTimestamp(logTransport) {
        const formattedDate = new Date().toISOString().split('.')[0].replace('T', ' ');
        logTransport.args.unshift(`[${formattedDate}]`);
    }
    static async writeTransport(logTransport) {
        const [time] = logTransport.args;
        const logMessage = `${time} ${logTransport.msg}`;
        if (this.logFilePath) {
            await LogFactory.writeMessage(logMessage, this.logFilePath);
        }
    }
    static async writeMessage(message, logFilePath) {
        const withoutColor = message.replace((0, ansi_regex_1.default)(), '');
        await fs.outputFile(logFilePath, `${withoutColor}${os.EOL}`, { flag: 'a' });
    }
    static createLoggerName(fileName, namespace, separator) {
        if (typeof window === 'undefined') {
            fileName = path.basename(fileName, path.extname(fileName));
        }
        return [namespace, fileName].filter(Boolean).join(separator);
    }
    static getLogger(name, options) {
        const defaults = {
            color: LogFactory.getColor(),
            forceEnable: false,
            logFilePath: '',
            namespace: '',
            separator: '::',
        };
        const config = Object.assign(Object.assign({}, defaults), options);
        if (logdown_1.default.transports.length === 0) {
            logdown_1.default.transports.push(LogFactory.addTimestamp.bind({ namespace: config.namespace }));
            logdown_1.default.transports.push(LogFactory.writeTransport.bind({ logFilePath: config.logFilePath }));
        }
        const loggerName = this.createLoggerName(name, config.namespace, config.separator);
        const logger = (0, logdown_1.default)(loggerName, {
            logger: console,
            markdown: false,
            prefixColor: config.color,
        });
        if (config.forceEnable) {
            logger.state.isEnabled = true;
        }
        return logger;
    }
}
exports.LogFactory = LogFactory;
LogFactory.logFilePath = undefined;
LogFactory.COLOR_STEP = {
    B: 97,
    G: 79,
    R: 31,
};
LogFactory.COLOR_CODE = {
    B: 0,
    G: 0,
    R: 0,
};
//# sourceMappingURL=LogFactory.js.map