/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.sdedit.util.Utilities;

public class MultiMap<K, V, C extends Collection<?>, M extends Map<?, ?>> {
    private Class<C> collectionType;
    private Map<K, C> map;

    public MultiMap(Class<?> collectionType, Class<?> mapType) {
        this.collectionType = collectionType;
        this.map = (Map)Utilities.newInstance(mapType.getName(), mapType, new Object[0]);
    }

    private Collection<V> collection(K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = (Collection)Utilities.newInstance(this.collectionType.getName(), this.collectionType, new Object[0]);
            this.map.put(key, collection);
        }
        return collection;
    }

    public void add(K key, V value) {
        this.collection(key).add(value);
    }

    public Collection<V> getValues(K key) {
        return this.collection(key);
    }

    public Set<Map.Entry<K, C>> entries() {
        return this.map.entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }
}

