# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2025)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""A generated list with all existing emojis.

DO NOT EDIT MANUALLY! The list in this file is generated by `scripts/update-emojis.py`.

This module gets lazy-loaded only when an emoji check is required (see string_util).
"""

import re

# fmt: off
### EMOJIS START ###
ALL_EMOJIS = {"#⃣", "#️⃣", "*⃣", "*️⃣", "0⃣", "0️⃣", "1⃣", "1️⃣", "2⃣", "2️⃣", "3⃣", "3️⃣", "4⃣", "4️⃣", "5⃣", "5️⃣", "6⃣", "6️⃣", "7⃣", "7️⃣", "8⃣", "8️⃣", "9⃣", "9️⃣", "©", "©️", "®", "®️", "‼", "‼️", "⁉", "⁉️", "™", "™️", "ℹ", "ℹ️", "↔", "↔️", "↕", "↕️", "↖", "↖️", "↗", "↗️", "↘", "↘️", "↙", "↙️", "↩", "↩️", "↪", "↪️", "⌚", "⌛", "⌨", "⌨️", "⏏", "⏏️", "⏩", "⏪", "⏫", "⏬", "⏭", "⏭️", "⏮", "⏮️", "⏯", "⏯️", "⏰", "⏱", "⏱️", "⏲", "⏲️", "⏳", "⏸", "⏸️", "⏹", "⏹️", "⏺", "⏺️", "Ⓜ", "Ⓜ️", "▪", "▪️", "▫", "▫️", "▶", "▶️", "◀", "◀️", "◻", "◻️", "◼", "◼️", "◽", "◾", "☀", "☀️", "☁", "☁️", "☂", "☂️", "☃", "☃️", "☄", "☄️", "☎", "☎️", "☑", "☑️", "☔", "☕", "☘", "☘️", "☝", "☝️", "☝🏻", "☝🏼", "☝🏽", "☝🏾", "☝🏿", "☠", "☠️", "☢", "☢️", "☣", "☣️", "☦", "☦️", "☪", "☪️", "☮", "☮️", "☯", "☯️", "☸", "☸️", "☹", "☹️", "☺", "☺️", "♀", "♀️", "♂", "♂️", "♈", "♉", "♊", "♋", "♌", "♍", "♎", "♏", "♐", "♑", "♒", "♓", "♟", "♟️", "♠", "♠️", "♣", "♣️", "♥", "♥️", "♦", "♦️", "♨", "♨️", "♻", "♻️", "♾", "♾️", "♿", "⚒", "⚒️", "⚓", "⚔", "⚔️", "⚕", "⚕️", "⚖", "⚖️", "⚗", "⚗️", "⚙", "⚙️", "⚛", "⚛️", "⚜", "⚜️", "⚠", "⚠️", "⚡", "⚧", "⚧️", "⚪", "⚫", "⚰", "⚰️", "⚱", "⚱️", "⚽", "⚾", "⛄", "⛅", "⛈", "⛈️", "⛎", "⛏", "⛏️", "⛑", "⛑️", "⛓", "⛓‍💥", "⛓️", "⛓️‍💥", "⛔", "⛩", "⛩️", "⛪", "⛰", "⛰️", "⛱", "⛱️", "⛲", "⛳", "⛴", "⛴️", "⛵", "⛷", "⛷️", "⛸", "⛸️", "⛹", "⛹‍♀", "⛹‍♀️", "⛹‍♂", "⛹‍♂️", "⛹️", "⛹️‍♀", "⛹️‍♀️", "⛹️‍♂", "⛹️‍♂️", "⛹🏻", "⛹🏻‍♀", "⛹🏻‍♀️", "⛹🏻‍♂", "⛹🏻‍♂️", "⛹🏼", "⛹🏼‍♀", "⛹🏼‍♀️", "⛹🏼‍♂", "⛹🏼‍♂️", "⛹🏽", "⛹🏽‍♀", "⛹🏽‍♀️", "⛹🏽‍♂", "⛹🏽‍♂️", "⛹🏾", "⛹🏾‍♀", "⛹🏾‍♀️", "⛹🏾‍♂", "⛹🏾‍♂️", "⛹🏿", "⛹🏿‍♀", "⛹🏿‍♀️", "⛹🏿‍♂", "⛹🏿‍♂️", "⛺", "⛽", "✂", "✂️", "✅", "✈", "✈️", "✉", "✉️", "✊", "✊🏻", "✊🏼", "✊🏽", "✊🏾", "✊🏿", "✋", "✋🏻", "✋🏼", "✋🏽", "✋🏾", "✋🏿", "✌", "✌️", "✌🏻", "✌🏼", "✌🏽", "✌🏾", "✌🏿", "✍", "✍️", "✍🏻", "✍🏼", "✍🏽", "✍🏾", "✍🏿", "✏", "✏️", "✒", "✒️", "✔", "✔️", "✖", "✖️", "✝", "✝️", "✡", "✡️", "✨", "✳", "✳️", "✴", "✴️", "❄", "❄️", "❇", "❇️", "❌", "❎", "❓", "❔", "❕", "❗", "❣", "❣️", "❤", "❤‍🔥", "❤‍🩹", "❤️", "❤️‍🔥", "❤️‍🩹", "➕", "➖", "➗", "➡", "➡️", "➰", "➿", "⤴", "⤴️", "⤵", "⤵️", "⬅", "⬅️", "⬆", "⬆️", "⬇", "⬇️", "⬛", "⬜", "⭐", "⭕", "〰", "〰️", "〽", "〽️", "㊗", "㊗️", "㊙", "㊙️", "🀄", "🃏", "🅰", "🅰️", "🅱", "🅱️", "🅾", "🅾️", "🅿", "🅿️", "🆎", "🆑", "🆒", "🆓", "🆔", "🆕", "🆖", "🆗", "🆘", "🆙", "🆚", "🇦🇨", "🇦🇩", "🇦🇪", "🇦🇫", "🇦🇬", "🇦🇮", "🇦🇱", "🇦🇲", "🇦🇴", "🇦🇶", "🇦🇷", "🇦🇸", "🇦🇹", "🇦🇺", "🇦🇼", "🇦🇽", "🇦🇿", "🇧🇦", "🇧🇧", "🇧🇩", "🇧🇪", "🇧🇫", "🇧🇬", "🇧🇭", "🇧🇮", "🇧🇯", "🇧🇱", "🇧🇲", "🇧🇳", "🇧🇴", "🇧🇶", "🇧🇷", "🇧🇸", "🇧🇹", "🇧🇻", "🇧🇼", "🇧🇾", "🇧🇿", "🇨🇦", "🇨🇨", "🇨🇩", "🇨🇫", "🇨🇬", "🇨🇭", "🇨🇮", "🇨🇰", "🇨🇱", "🇨🇲", "🇨🇳", "🇨🇴", "🇨🇵", "🇨🇶", "🇨🇷", "🇨🇺", "🇨🇻", "🇨🇼", "🇨🇽", "🇨🇾", "🇨🇿", "🇩🇪", "🇩🇬", "🇩🇯", "🇩🇰", "🇩🇲", "🇩🇴", "🇩🇿", "🇪🇦", "🇪🇨", "🇪🇪", "🇪🇬", "🇪🇭", "🇪🇷", "🇪🇸", "🇪🇹", "🇪🇺", "🇫🇮", "🇫🇯", "🇫🇰", "🇫🇲", "🇫🇴", "🇫🇷", "🇬🇦", "🇬🇧", "🇬🇩", "🇬🇪", "🇬🇫", "🇬🇬", "🇬🇭", "🇬🇮", "🇬🇱", "🇬🇲", "🇬🇳", "🇬🇵", "🇬🇶", "🇬🇷", "🇬🇸", "🇬🇹", "🇬🇺", "🇬🇼", "🇬🇾", "🇭🇰", "🇭🇲", "🇭🇳", "🇭🇷", "🇭🇹", "🇭🇺", "🇮🇨", "🇮🇩", "🇮🇪", "🇮🇱", "🇮🇲", "🇮🇳", "🇮🇴", "🇮🇶", "🇮🇷", "🇮🇸", "🇮🇹", "🇯🇪", "🇯🇲", "🇯🇴", "🇯🇵", "🇰🇪", "🇰🇬", "🇰🇭", "🇰🇮", "🇰🇲", "🇰🇳", "🇰🇵", "🇰🇷", "🇰🇼", "🇰🇾", "🇰🇿", "🇱🇦", "🇱🇧", "🇱🇨", "🇱🇮", "🇱🇰", "🇱🇷", "🇱🇸", "🇱🇹", "🇱🇺", "🇱🇻", "🇱🇾", "🇲🇦", "🇲🇨", "🇲🇩", "🇲🇪", "🇲🇫", "🇲🇬", "🇲🇭", "🇲🇰", "🇲🇱", "🇲🇲", "🇲🇳", "🇲🇴", "🇲🇵", "🇲🇶", "🇲🇷", "🇲🇸", "🇲🇹", "🇲🇺", "🇲🇻", "🇲🇼", "🇲🇽", "🇲🇾", "🇲🇿", "🇳🇦", "🇳🇨", "🇳🇪", "🇳🇫", "🇳🇬", "🇳🇮", "🇳🇱", "🇳🇴", "🇳🇵", "🇳🇷", "🇳🇺", "🇳🇿", "🇴🇲", "🇵🇦", "🇵🇪", "🇵🇫", "🇵🇬", "🇵🇭", "🇵🇰", "🇵🇱", "🇵🇲", "🇵🇳", "🇵🇷", "🇵🇸", "🇵🇹", "🇵🇼", "🇵🇾", "🇶🇦", "🇷🇪", "🇷🇴", "🇷🇸", "🇷🇺", "🇷🇼", "🇸🇦", "🇸🇧", "🇸🇨", "🇸🇩", "🇸🇪", "🇸🇬", "🇸🇭", "🇸🇮", "🇸🇯", "🇸🇰", "🇸🇱", "🇸🇲", "🇸🇳", "🇸🇴", "🇸🇷", "🇸🇸", "🇸🇹", "🇸🇻", "🇸🇽", "🇸🇾", "🇸🇿", "🇹🇦", "🇹🇨", "🇹🇩", "🇹🇫", "🇹🇬", "🇹🇭", "🇹🇯", "🇹🇰", "🇹🇱", "🇹🇲", "🇹🇳", "🇹🇴", "🇹🇷", "🇹🇹", "🇹🇻", "🇹🇼", "🇹🇿", "🇺🇦", "🇺🇬", "🇺🇲", "🇺🇳", "🇺🇸", "🇺🇾", "🇺🇿", "🇻🇦", "🇻🇨", "🇻🇪", "🇻🇬", "🇻🇮", "🇻🇳", "🇻🇺", "🇼🇫", "🇼🇸", "🇽🇰", "🇾🇪", "🇾🇹", "🇿🇦", "🇿🇲", "🇿🇼", "🈁", "🈂", "🈂️", "🈚", "🈯", "🈲", "🈳", "🈴", "🈵", "🈶", "🈷", "🈷️", "🈸", "🈹", "🈺", "🉐", "🉑", "🌀", "🌁", "🌂", "🌃", "🌄", "🌅", "🌆", "🌇", "🌈", "🌉", "🌊", "🌋", "🌌", "🌍", "🌎", "🌏", "🌐", "🌑", "🌒", "🌓", "🌔", "🌕", "🌖", "🌗", "🌘", "🌙", "🌚", "🌛", "🌜", "🌝", "🌞", "🌟", "🌠", "🌡", "🌡️", "🌤", "🌤️", "🌥", "🌥️", "🌦", "🌦️", "🌧", "🌧️", "🌨", "🌨️", "🌩", "🌩️", "🌪", "🌪️", "🌫", "🌫️", "🌬", "🌬️", "🌭", "🌮", "🌯", "🌰", "🌱", "🌲", "🌳", "🌴", "🌵", "🌶", "🌶️", "🌷", "🌸", "🌹", "🌺", "🌻", "🌼", "🌽", "🌾", "🌿", "🍀", "🍁", "🍂", "🍃", "🍄", "🍄‍🟫", "🍅", "🍆", "🍇", "🍈", "🍉", "🍊", "🍋", "🍋‍🟩", "🍌", "🍍", "🍎", "🍏", "🍐", "🍑", "🍒", "🍓", "🍔", "🍕", "🍖", "🍗", "🍘", "🍙", "🍚", "🍛", "🍜", "🍝", "🍞", "🍟", "🍠", "🍡", "🍢", "🍣", "🍤", "🍥", "🍦", "🍧", "🍨", "🍩", "🍪", "🍫", "🍬", "🍭", "🍮", "🍯", "🍰", "🍱", "🍲", "🍳", "🍴", "🍵", "🍶", "🍷", "🍸", "🍹", "🍺", "🍻", "🍼", "🍽", "🍽️", "🍾", "🍿", "🎀", "🎁", "🎂", "🎃", "🎄", "🎅", "🎅🏻", "🎅🏼", "🎅🏽", "🎅🏾", "🎅🏿", "🎆", "🎇", "🎈", "🎉", "🎊", "🎋", "🎌", "🎍", "🎎", "🎏", "🎐", "🎑", "🎒", "🎓", "🎖", "🎖️", "🎗", "🎗️", "🎙", "🎙️", "🎚", "🎚️", "🎛", "🎛️", "🎞", "🎞️", "🎟", "🎟️", "🎠", "🎡", "🎢", "🎣", "🎤", "🎥", "🎦", "🎧", "🎨", "🎩", "🎪", "🎫", "🎬", "🎭", "🎮", "🎯", "🎰", "🎱", "🎲", "🎳", "🎴", "🎵", "🎶", "🎷", "🎸", "🎹", "🎺", "🎻", "🎼", "🎽", "🎾", "🎿", "🏀", "🏁", "🏂", "🏂🏻", "🏂🏼", "🏂🏽", "🏂🏾", "🏂🏿", "🏃", "🏃‍♀", "🏃‍♀‍➡", "🏃‍♀‍➡️", "🏃‍♀️", "🏃‍♀️‍➡", "🏃‍♀️‍➡️", "🏃‍♂", "🏃‍♂‍➡", "🏃‍♂‍➡️", "🏃‍♂️", "🏃‍♂️‍➡", "🏃‍♂️‍➡️", "🏃‍➡", "🏃‍➡️", "🏃🏻", "🏃🏻‍♀", "🏃🏻‍♀‍➡", "🏃🏻‍♀‍➡️", "🏃🏻‍♀️", "🏃🏻‍♀️‍➡", "🏃🏻‍♀️‍➡️", "🏃🏻‍♂", "🏃🏻‍♂‍➡", "🏃🏻‍♂‍➡️", "🏃🏻‍♂️", "🏃🏻‍♂️‍➡", "🏃🏻‍♂️‍➡️", "🏃🏻‍➡", "🏃🏻‍➡️", "🏃🏼", "🏃🏼‍♀", "🏃🏼‍♀‍➡", "🏃🏼‍♀‍➡️", "🏃🏼‍♀️", "🏃🏼‍♀️‍➡", "🏃🏼‍♀️‍➡️", "🏃🏼‍♂", "🏃🏼‍♂‍➡", "🏃🏼‍♂‍➡️", "🏃🏼‍♂️", "🏃🏼‍♂️‍➡", "🏃🏼‍♂️‍➡️", "🏃🏼‍➡", "🏃🏼‍➡️", "🏃🏽", "🏃🏽‍♀", "🏃🏽‍♀‍➡", "🏃🏽‍♀‍➡️", "🏃🏽‍♀️", "🏃🏽‍♀️‍➡", "🏃🏽‍♀️‍➡️", "🏃🏽‍♂", "🏃🏽‍♂‍➡", "🏃🏽‍♂‍➡️", "🏃🏽‍♂️", "🏃🏽‍♂️‍➡", "🏃🏽‍♂️‍➡️", "🏃🏽‍➡", "🏃🏽‍➡️", "🏃🏾", "🏃🏾‍♀", "🏃🏾‍♀‍➡", "🏃🏾‍♀‍➡️", "🏃🏾‍♀️", "🏃🏾‍♀️‍➡", "🏃🏾‍♀️‍➡️", "🏃🏾‍♂", "🏃🏾‍♂‍➡", "🏃🏾‍♂‍➡️", "🏃🏾‍♂️", "🏃🏾‍♂️‍➡", "🏃🏾‍♂️‍➡️", "🏃🏾‍➡", "🏃🏾‍➡️", "🏃🏿", "🏃🏿‍♀", "🏃🏿‍♀‍➡", "🏃🏿‍♀‍➡️", "🏃🏿‍♀️", "🏃🏿‍♀️‍➡", "🏃🏿‍♀️‍➡️", "🏃🏿‍♂", "🏃🏿‍♂‍➡", "🏃🏿‍♂‍➡️", "🏃🏿‍♂️", "🏃🏿‍♂️‍➡", "🏃🏿‍♂️‍➡️", "🏃🏿‍➡", "🏃🏿‍➡️", "🏄", "🏄‍♀", "🏄‍♀️", "🏄‍♂", "🏄‍♂️", "🏄🏻", "🏄🏻‍♀", "🏄🏻‍♀️", "🏄🏻‍♂", "🏄🏻‍♂️", "🏄🏼", "🏄🏼‍♀", "🏄🏼‍♀️", "🏄🏼‍♂", "🏄🏼‍♂️", "🏄🏽", "🏄🏽‍♀", "🏄🏽‍♀️", "🏄🏽‍♂", "🏄🏽‍♂️", "🏄🏾", "🏄🏾‍♀", "🏄🏾‍♀️", "🏄🏾‍♂", "🏄🏾‍♂️", "🏄🏿", "🏄🏿‍♀", "🏄🏿‍♀️", "🏄🏿‍♂", "🏄🏿‍♂️", "🏅", "🏆", "🏇", "🏇🏻", "🏇🏼", "🏇🏽", "🏇🏾", "🏇🏿", "🏈", "🏉", "🏊", "🏊‍♀", "🏊‍♀️", "🏊‍♂", "🏊‍♂️", "🏊🏻", "🏊🏻‍♀", "🏊🏻‍♀️", "🏊🏻‍♂", "🏊🏻‍♂️", "🏊🏼", "🏊🏼‍♀", "🏊🏼‍♀️", "🏊🏼‍♂", "🏊🏼‍♂️", "🏊🏽", "🏊🏽‍♀", "🏊🏽‍♀️", "🏊🏽‍♂", "🏊🏽‍♂️", "🏊🏾", "🏊🏾‍♀", "🏊🏾‍♀️", "🏊🏾‍♂", "🏊🏾‍♂️", "🏊🏿", "🏊🏿‍♀", "🏊🏿‍♀️", "🏊🏿‍♂", "🏊🏿‍♂️", "🏋", "🏋‍♀", "🏋‍♀️", "🏋‍♂", "🏋‍♂️", "🏋️", "🏋️‍♀", "🏋️‍♀️", "🏋️‍♂", "🏋️‍♂️", "🏋🏻", "🏋🏻‍♀", "🏋🏻‍♀️", "🏋🏻‍♂", "🏋🏻‍♂️", "🏋🏼", "🏋🏼‍♀", "🏋🏼‍♀️", "🏋🏼‍♂", "🏋🏼‍♂️", "🏋🏽", "🏋🏽‍♀", "🏋🏽‍♀️", "🏋🏽‍♂", "🏋🏽‍♂️", "🏋🏾", "🏋🏾‍♀", "🏋🏾‍♀️", "🏋🏾‍♂", "🏋🏾‍♂️", "🏋🏿", "🏋🏿‍♀", "🏋🏿‍♀️", "🏋🏿‍♂", "🏋🏿‍♂️", "🏌", "🏌‍♀", "🏌‍♀️", "🏌‍♂", "🏌‍♂️", "🏌️", "🏌️‍♀", "🏌️‍♀️", "🏌️‍♂", "🏌️‍♂️", "🏌🏻", "🏌🏻‍♀", "🏌🏻‍♀️", "🏌🏻‍♂", "🏌🏻‍♂️", "🏌🏼", "🏌🏼‍♀", "🏌🏼‍♀️", "🏌🏼‍♂", "🏌🏼‍♂️", "🏌🏽", "🏌🏽‍♀", "🏌🏽‍♀️", "🏌🏽‍♂", "🏌🏽‍♂️", "🏌🏾", "🏌🏾‍♀", "🏌🏾‍♀️", "🏌🏾‍♂", "🏌🏾‍♂️", "🏌🏿", "🏌🏿‍♀", "🏌🏿‍♀️", "🏌🏿‍♂", "🏌🏿‍♂️", "🏍", "🏍️", "🏎", "🏎️", "🏏", "🏐", "🏑", "🏒", "🏓", "🏔", "🏔️", "🏕", "🏕️", "🏖", "🏖️", "🏗", "🏗️", "🏘", "🏘️", "🏙", "🏙️", "🏚", "🏚️", "🏛", "🏛️", "🏜", "🏜️", "🏝", "🏝️", "🏞", "🏞️", "🏟", "🏟️", "🏠", "🏡", "🏢", "🏣", "🏤", "🏥", "🏦", "🏧", "🏨", "🏩", "🏪", "🏫", "🏬", "🏭", "🏮", "🏯", "🏰", "🏳", "🏳‍⚧", "🏳‍⚧️", "🏳‍🌈", "🏳️", "🏳️‍⚧", "🏳️‍⚧️", "🏳️‍🌈", "🏴", "🏴‍☠", "🏴‍☠️", "🏴󠁧󠁢󠁥󠁮󠁧󠁿", "🏴󠁧󠁢󠁳󠁣󠁴󠁿", "🏴󠁧󠁢󠁷󠁬󠁳󠁿", "🏵", "🏵️", "🏷", "🏷️", "🏸", "🏹", "🏺", "🏻", "🏼", "🏽", "🏾", "🏿", "🐀", "🐁", "🐂", "🐃", "🐄", "🐅", "🐆", "🐇", "🐈", "🐈‍⬛", "🐉", "🐊", "🐋", "🐌", "🐍", "🐎", "🐏", "🐐", "🐑", "🐒", "🐓", "🐔", "🐕", "🐕‍🦺", "🐖", "🐗", "🐘", "🐙", "🐚", "🐛", "🐜", "🐝", "🐞", "🐟", "🐠", "🐡", "🐢", "🐣", "🐤", "🐥", "🐦", "🐦‍⬛", "🐦‍🔥", "🐧", "🐨", "🐩", "🐪", "🐫", "🐬", "🐭", "🐮", "🐯", "🐰", "🐱", "🐲", "🐳", "🐴", "🐵", "🐶", "🐷", "🐸", "🐹", "🐺", "🐻", "🐻‍❄", "🐻‍❄️", "🐼", "🐽", "🐾", "🐿", "🐿️", "👀", "👁", "👁‍🗨", "👁‍🗨️", "👁️", "👁️‍🗨", "👁️‍🗨️", "👂", "👂🏻", "👂🏼", "👂🏽", "👂🏾", "👂🏿", "👃", "👃🏻", "👃🏼", "👃🏽", "👃🏾", "👃🏿", "👄", "👅", "👆", "👆🏻", "👆🏼", "👆🏽", "👆🏾", "👆🏿", "👇", "👇🏻", "👇🏼", "👇🏽", "👇🏾", "👇🏿", "👈", "👈🏻", "👈🏼", "👈🏽", "👈🏾", "👈🏿", "👉", "👉🏻", "👉🏼", "👉🏽", "👉🏾", "👉🏿", "👊", "👊🏻", "👊🏼", "👊🏽", "👊🏾", "👊🏿", "👋", "👋🏻", "👋🏼", "👋🏽", "👋🏾", "👋🏿", "👌", "👌🏻", "👌🏼", "👌🏽", "👌🏾", "👌🏿", "👍", "👍🏻", "👍🏼", "👍🏽", "👍🏾", "👍🏿", "👎", "👎🏻", "👎🏼", "👎🏽", "👎🏾", "👎🏿", "👏", "👏🏻", "👏🏼", "👏🏽", "👏🏾", "👏🏿", "👐", "👐🏻", "👐🏼", "👐🏽", "👐🏾", "👐🏿", "👑", "👒", "👓", "👔", "👕", "👖", "👗", "👘", "👙", "👚", "👛", "👜", "👝", "👞", "👟", "👠", "👡", "👢", "👣", "👤", "👥", "👦", "👦🏻", "👦🏼", "👦🏽", "👦🏾", "👦🏿", "👧", "👧🏻", "👧🏼", "👧🏽", "👧🏾", "👧🏿", "👨", "👨‍⚕", "👨‍⚕️", "👨‍⚖", "👨‍⚖️", "👨‍✈", "👨‍✈️", "👨‍❤‍👨", "👨‍❤‍💋‍👨", "👨‍❤️‍👨", "👨‍❤️‍💋‍👨", "👨‍🌾", "👨‍🍳", "👨‍🍼", "👨‍🎓", "👨‍🎤", "👨‍🎨", "👨‍🏫", "👨‍🏭", "👨‍👦", "👨‍👦‍👦", "👨‍👧", "👨‍👧‍👦", "👨‍👧‍👧", "👨‍👨‍👦", "👨‍👨‍👦‍👦", "👨‍👨‍👧", "👨‍👨‍👧‍👦", "👨‍👨‍👧‍👧", "👨‍👩‍👦", "👨‍👩‍👦‍👦", "👨‍👩‍👧", "👨‍👩‍👧‍👦", "👨‍👩‍👧‍👧", "👨‍💻", "👨‍💼", "👨‍🔧", "👨‍🔬", "👨‍🚀", "👨‍🚒", "👨‍🦯", "👨‍🦯‍➡", "👨‍🦯‍➡️", "👨‍🦰", "👨‍🦱", "👨‍🦲", "👨‍🦳", "👨‍🦼", "👨‍🦼‍➡", "👨‍🦼‍➡️", "👨‍🦽", "👨‍🦽‍➡", "👨‍🦽‍➡️", "👨🏻", "👨🏻‍⚕", "👨🏻‍⚕️", "👨🏻‍⚖", "👨🏻‍⚖️", "👨🏻‍✈", "👨🏻‍✈️", "👨🏻‍❤‍👨🏻", "👨🏻‍❤‍👨🏼", "👨🏻‍❤‍👨🏽", "👨🏻‍❤‍👨🏾", "👨🏻‍❤‍👨🏿", "👨🏻‍❤‍💋‍👨🏻", "👨🏻‍❤‍💋‍👨🏼", "👨🏻‍❤‍💋‍👨🏽", "👨🏻‍❤‍💋‍👨🏾", "👨🏻‍❤‍💋‍👨🏿", "👨🏻‍❤️‍👨🏻", "👨🏻‍❤️‍👨🏼", "👨🏻‍❤️‍👨🏽", "👨🏻‍❤️‍👨🏾", "👨🏻‍❤️‍👨🏿", "👨🏻‍❤️‍💋‍👨🏻", "👨🏻‍❤️‍💋‍👨🏼", "👨🏻‍❤️‍💋‍👨🏽", "👨🏻‍❤️‍💋‍👨🏾", "👨🏻‍❤️‍💋‍👨🏿", "👨🏻‍🌾", "👨🏻‍🍳", "👨🏻‍🍼", "👨🏻‍🎓", "👨🏻‍🎤", "👨🏻‍🎨", "👨🏻‍🏫", "👨🏻‍🏭", "👨🏻‍💻", "👨🏻‍💼", "👨🏻‍🔧", "👨🏻‍🔬", "👨🏻‍🚀", "👨🏻‍🚒", "👨🏻‍🤝‍👨🏼", "👨🏻‍🤝‍👨🏽", "👨🏻‍🤝‍👨🏾", "👨🏻‍🤝‍👨🏿", "👨🏻‍🦯", "👨🏻‍🦯‍➡", "👨🏻‍🦯‍➡️", "👨🏻‍🦰", "👨🏻‍🦱", "👨🏻‍🦲", "👨🏻‍🦳", "👨🏻‍🦼", "👨🏻‍🦼‍➡", "👨🏻‍🦼‍➡️", "👨🏻‍🦽", "👨🏻‍🦽‍➡", "👨🏻‍🦽‍➡️", "👨🏼", "👨🏼‍⚕", "👨🏼‍⚕️", "👨🏼‍⚖", "👨🏼‍⚖️", "👨🏼‍✈", "👨🏼‍✈️", "👨🏼‍❤‍👨🏻", "👨🏼‍❤‍👨🏼", "👨🏼‍❤‍👨🏽", "👨🏼‍❤‍👨🏾", "👨🏼‍❤‍👨🏿", "👨🏼‍❤‍💋‍👨🏻", "👨🏼‍❤‍💋‍👨🏼", "👨🏼‍❤‍💋‍👨🏽", "👨🏼‍❤‍💋‍👨🏾", "👨🏼‍❤‍💋‍👨🏿", "👨🏼‍❤️‍👨🏻", "👨🏼‍❤️‍👨🏼", "👨🏼‍❤️‍👨🏽", "👨🏼‍❤️‍👨🏾", "👨🏼‍❤️‍👨🏿", "👨🏼‍❤️‍💋‍👨🏻", "👨🏼‍❤️‍💋‍👨🏼", "👨🏼‍❤️‍💋‍👨🏽", "👨🏼‍❤️‍💋‍👨🏾", "👨🏼‍❤️‍💋‍👨🏿", "👨🏼‍🌾", "👨🏼‍🍳", "👨🏼‍🍼", "👨🏼‍🎓", "👨🏼‍🎤", "👨🏼‍🎨", "👨🏼‍🏫", "👨🏼‍🏭", "👨🏼‍💻", "👨🏼‍💼", "👨🏼‍🔧", "👨🏼‍🔬", "👨🏼‍🚀", "👨🏼‍🚒", "👨🏼‍🤝‍👨🏻", "👨🏼‍🤝‍👨🏽", "👨🏼‍🤝‍👨🏾", "👨🏼‍🤝‍👨🏿", "👨🏼‍🦯", "👨🏼‍🦯‍➡", "👨🏼‍🦯‍➡️", "👨🏼‍🦰", "👨🏼‍🦱", "👨🏼‍🦲", "👨🏼‍🦳", "👨🏼‍🦼", "👨🏼‍🦼‍➡", "👨🏼‍🦼‍➡️", "👨🏼‍🦽", "👨🏼‍🦽‍➡", "👨🏼‍🦽‍➡️", "👨🏽", "👨🏽‍⚕", "👨🏽‍⚕️", "👨🏽‍⚖", "👨🏽‍⚖️", "👨🏽‍✈", "👨🏽‍✈️", "👨🏽‍❤‍👨🏻", "👨🏽‍❤‍👨🏼", "👨🏽‍❤‍👨🏽", "👨🏽‍❤‍👨🏾", "👨🏽‍❤‍👨🏿", "👨🏽‍❤‍💋‍👨🏻", "👨🏽‍❤‍💋‍👨🏼", "👨🏽‍❤‍💋‍👨🏽", "👨🏽‍❤‍💋‍👨🏾", "👨🏽‍❤‍💋‍👨🏿", "👨🏽‍❤️‍👨🏻", "👨🏽‍❤️‍👨🏼", "👨🏽‍❤️‍👨🏽", "👨🏽‍❤️‍👨🏾", "👨🏽‍❤️‍👨🏿", "👨🏽‍❤️‍💋‍👨🏻", "👨🏽‍❤️‍💋‍👨🏼", "👨🏽‍❤️‍💋‍👨🏽", "👨🏽‍❤️‍💋‍👨🏾", "👨🏽‍❤️‍💋‍👨🏿", "👨🏽‍🌾", "👨🏽‍🍳", "👨🏽‍🍼", "👨🏽‍🎓", "👨🏽‍🎤", "👨🏽‍🎨", "👨🏽‍🏫", "👨🏽‍🏭", "👨🏽‍💻", "👨🏽‍💼", "👨🏽‍🔧", "👨🏽‍🔬", "👨🏽‍🚀", "👨🏽‍🚒", "👨🏽‍🤝‍👨🏻", "👨🏽‍🤝‍👨🏼", "👨🏽‍🤝‍👨🏾", "👨🏽‍🤝‍👨🏿", "👨🏽‍🦯", "👨🏽‍🦯‍➡", "👨🏽‍🦯‍➡️", "👨🏽‍🦰", "👨🏽‍🦱", "👨🏽‍🦲", "👨🏽‍🦳", "👨🏽‍🦼", "👨🏽‍🦼‍➡", "👨🏽‍🦼‍➡️", "👨🏽‍🦽", "👨🏽‍🦽‍➡", "👨🏽‍🦽‍➡️", "👨🏾", "👨🏾‍⚕", "👨🏾‍⚕️", "👨🏾‍⚖", "👨🏾‍⚖️", "👨🏾‍✈", "👨🏾‍✈️", "👨🏾‍❤‍👨🏻", "👨🏾‍❤‍👨🏼", "👨🏾‍❤‍👨🏽", "👨🏾‍❤‍👨🏾", "👨🏾‍❤‍👨🏿", "👨🏾‍❤‍💋‍👨🏻", "👨🏾‍❤‍💋‍👨🏼", "👨🏾‍❤‍💋‍👨🏽", "👨🏾‍❤‍💋‍👨🏾", "👨🏾‍❤‍💋‍👨🏿", "👨🏾‍❤️‍👨🏻", "👨🏾‍❤️‍👨🏼", "👨🏾‍❤️‍👨🏽", "👨🏾‍❤️‍👨🏾", "👨🏾‍❤️‍👨🏿", "👨🏾‍❤️‍💋‍👨🏻", "👨🏾‍❤️‍💋‍👨🏼", "👨🏾‍❤️‍💋‍👨🏽", "👨🏾‍❤️‍💋‍👨🏾", "👨🏾‍❤️‍💋‍👨🏿", "👨🏾‍🌾", "👨🏾‍🍳", "👨🏾‍🍼", "👨🏾‍🎓", "👨🏾‍🎤", "👨🏾‍🎨", "👨🏾‍🏫", "👨🏾‍🏭", "👨🏾‍💻", "👨🏾‍💼", "👨🏾‍🔧", "👨🏾‍🔬", "👨🏾‍🚀", "👨🏾‍🚒", "👨🏾‍🤝‍👨🏻", "👨🏾‍🤝‍👨🏼", "👨🏾‍🤝‍👨🏽", "👨🏾‍🤝‍👨🏿", "👨🏾‍🦯", "👨🏾‍🦯‍➡", "👨🏾‍🦯‍➡️", "👨🏾‍🦰", "👨🏾‍🦱", "👨🏾‍🦲", "👨🏾‍🦳", "👨🏾‍🦼", "👨🏾‍🦼‍➡", "👨🏾‍🦼‍➡️", "👨🏾‍🦽", "👨🏾‍🦽‍➡", "👨🏾‍🦽‍➡️", "👨🏿", "👨🏿‍⚕", "👨🏿‍⚕️", "👨🏿‍⚖", "👨🏿‍⚖️", "👨🏿‍✈", "👨🏿‍✈️", "👨🏿‍❤‍👨🏻", "👨🏿‍❤‍👨🏼", "👨🏿‍❤‍👨🏽", "👨🏿‍❤‍👨🏾", "👨🏿‍❤‍👨🏿", "👨🏿‍❤‍💋‍👨🏻", "👨🏿‍❤‍💋‍👨🏼", "👨🏿‍❤‍💋‍👨🏽", "👨🏿‍❤‍💋‍👨🏾", "👨🏿‍❤‍💋‍👨🏿", "👨🏿‍❤️‍👨🏻", "👨🏿‍❤️‍👨🏼", "👨🏿‍❤️‍👨🏽", "👨🏿‍❤️‍👨🏾", "👨🏿‍❤️‍👨🏿", "👨🏿‍❤️‍💋‍👨🏻", "👨🏿‍❤️‍💋‍👨🏼", "👨🏿‍❤️‍💋‍👨🏽", "👨🏿‍❤️‍💋‍👨🏾", "👨🏿‍❤️‍💋‍👨🏿", "👨🏿‍🌾", "👨🏿‍🍳", "👨🏿‍🍼", "👨🏿‍🎓", "👨🏿‍🎤", "👨🏿‍🎨", "👨🏿‍🏫", "👨🏿‍🏭", "👨🏿‍💻", "👨🏿‍💼", "👨🏿‍🔧", "👨🏿‍🔬", "👨🏿‍🚀", "👨🏿‍🚒", "👨🏿‍🤝‍👨🏻", "👨🏿‍🤝‍👨🏼", "👨🏿‍🤝‍👨🏽", "👨🏿‍🤝‍👨🏾", "👨🏿‍🦯", "👨🏿‍🦯‍➡", "👨🏿‍🦯‍➡️", "👨🏿‍🦰", "👨🏿‍🦱", "👨🏿‍🦲", "👨🏿‍🦳", "👨🏿‍🦼", "👨🏿‍🦼‍➡", "👨🏿‍🦼‍➡️", "👨🏿‍🦽", "👨🏿‍🦽‍➡", "👨🏿‍🦽‍➡️", "👩", "👩‍⚕", "👩‍⚕️", "👩‍⚖", "👩‍⚖️", "👩‍✈", "👩‍✈️", "👩‍❤‍👨", "👩‍❤‍👩", "👩‍❤‍💋‍👨", "👩‍❤‍💋‍👩", "👩‍❤️‍👨", "👩‍❤️‍👩", "👩‍❤️‍💋‍👨", "👩‍❤️‍💋‍👩", "👩‍🌾", "👩‍🍳", "👩‍🍼", "👩‍🎓", "👩‍🎤", "👩‍🎨", "👩‍🏫", "👩‍🏭", "👩‍👦", "👩‍👦‍👦", "👩‍👧", "👩‍👧‍👦", "👩‍👧‍👧", "👩‍👩‍👦", "👩‍👩‍👦‍👦", "👩‍👩‍👧", "👩‍👩‍👧‍👦", "👩‍👩‍👧‍👧", "👩‍💻", "👩‍💼", "👩‍🔧", "👩‍🔬", "👩‍🚀", "👩‍🚒", "👩‍🦯", "👩‍🦯‍➡", "👩‍🦯‍➡️", "👩‍🦰", "👩‍🦱", "👩‍🦲", "👩‍🦳", "👩‍🦼", "👩‍🦼‍➡", "👩‍🦼‍➡️", "👩‍🦽", "👩‍🦽‍➡", "👩‍🦽‍➡️", "👩🏻", "👩🏻‍⚕", "👩🏻‍⚕️", "👩🏻‍⚖", "👩🏻‍⚖️", "👩🏻‍✈", "👩🏻‍✈️", "👩🏻‍❤‍👨🏻", "👩🏻‍❤‍👨🏼", "👩🏻‍❤‍👨🏽", "👩🏻‍❤‍👨🏾", "👩🏻‍❤‍👨🏿", "👩🏻‍❤‍👩🏻", "👩🏻‍❤‍👩🏼", "👩🏻‍❤‍👩🏽", "👩🏻‍❤‍👩🏾", "👩🏻‍❤‍👩🏿", "👩🏻‍❤‍💋‍👨🏻", "👩🏻‍❤‍💋‍👨🏼", "👩🏻‍❤‍💋‍👨🏽", "👩🏻‍❤‍💋‍👨🏾", "👩🏻‍❤‍💋‍👨🏿", "👩🏻‍❤‍💋‍👩🏻", "👩🏻‍❤‍💋‍👩🏼", "👩🏻‍❤‍💋‍👩🏽", "👩🏻‍❤‍💋‍👩🏾", "👩🏻‍❤‍💋‍👩🏿", "👩🏻‍❤️‍👨🏻", "👩🏻‍❤️‍👨🏼", "👩🏻‍❤️‍👨🏽", "👩🏻‍❤️‍👨🏾", "👩🏻‍❤️‍👨🏿", "👩🏻‍❤️‍👩🏻", "👩🏻‍❤️‍👩🏼", "👩🏻‍❤️‍👩🏽", "👩🏻‍❤️‍👩🏾", "👩🏻‍❤️‍👩🏿", "👩🏻‍❤️‍💋‍👨🏻", "👩🏻‍❤️‍💋‍👨🏼", "👩🏻‍❤️‍💋‍👨🏽", "👩🏻‍❤️‍💋‍👨🏾", "👩🏻‍❤️‍💋‍👨🏿", "👩🏻‍❤️‍💋‍👩🏻", "👩🏻‍❤️‍💋‍👩🏼", "👩🏻‍❤️‍💋‍👩🏽", "👩🏻‍❤️‍💋‍👩🏾", "👩🏻‍❤️‍💋‍👩🏿", "👩🏻‍🌾", "👩🏻‍🍳", "👩🏻‍🍼", "👩🏻‍🎓", "👩🏻‍🎤", "👩🏻‍🎨", "👩🏻‍🏫", "👩🏻‍🏭", "👩🏻‍💻", "👩🏻‍💼", "👩🏻‍🔧", "👩🏻‍🔬", "👩🏻‍🚀", "👩🏻‍🚒", "👩🏻‍🤝‍👨🏼", "👩🏻‍🤝‍👨🏽", "👩🏻‍🤝‍👨🏾", "👩🏻‍🤝‍👨🏿", "👩🏻‍🤝‍👩🏼", "👩🏻‍🤝‍👩🏽", "👩🏻‍🤝‍👩🏾", "👩🏻‍🤝‍👩🏿", "👩🏻‍🦯", "👩🏻‍🦯‍➡", "👩🏻‍🦯‍➡️", "👩🏻‍🦰", "👩🏻‍🦱", "👩🏻‍🦲", "👩🏻‍🦳", "👩🏻‍🦼", "👩🏻‍🦼‍➡", "👩🏻‍🦼‍➡️", "👩🏻‍🦽", "👩🏻‍🦽‍➡", "👩🏻‍🦽‍➡️", "👩🏼", "👩🏼‍⚕", "👩🏼‍⚕️", "👩🏼‍⚖", "👩🏼‍⚖️", "👩🏼‍✈", "👩🏼‍✈️", "👩🏼‍❤‍👨🏻", "👩🏼‍❤‍👨🏼", "👩🏼‍❤‍👨🏽", "👩🏼‍❤‍👨🏾", "👩🏼‍❤‍👨🏿", "👩🏼‍❤‍👩🏻", "👩🏼‍❤‍👩🏼", "👩🏼‍❤‍👩🏽", "👩🏼‍❤‍👩🏾", "👩🏼‍❤‍👩🏿", "👩🏼‍❤‍💋‍👨🏻", "👩🏼‍❤‍💋‍👨🏼", "👩🏼‍❤‍💋‍👨🏽", "👩🏼‍❤‍💋‍👨🏾", "👩🏼‍❤‍💋‍👨🏿", "👩🏼‍❤‍💋‍👩🏻", "👩🏼‍❤‍💋‍👩🏼", "👩🏼‍❤‍💋‍👩🏽", "👩🏼‍❤‍💋‍👩🏾", "👩🏼‍❤‍💋‍👩🏿", "👩🏼‍❤️‍👨🏻", "👩🏼‍❤️‍👨🏼", "👩🏼‍❤️‍👨🏽", "👩🏼‍❤️‍👨🏾", "👩🏼‍❤️‍👨🏿", "👩🏼‍❤️‍👩🏻", "👩🏼‍❤️‍👩🏼", "👩🏼‍❤️‍👩🏽", "👩🏼‍❤️‍👩🏾", "👩🏼‍❤️‍👩🏿", "👩🏼‍❤️‍💋‍👨🏻", "👩🏼‍❤️‍💋‍👨🏼", "👩🏼‍❤️‍💋‍👨🏽", "👩🏼‍❤️‍💋‍👨🏾", "👩🏼‍❤️‍💋‍👨🏿", "👩🏼‍❤️‍💋‍👩🏻", "👩🏼‍❤️‍💋‍👩🏼", "👩🏼‍❤️‍💋‍👩🏽", "👩🏼‍❤️‍💋‍👩🏾", "👩🏼‍❤️‍💋‍👩🏿", "👩🏼‍🌾", "👩🏼‍🍳", "👩🏼‍🍼", "👩🏼‍🎓", "👩🏼‍🎤", "👩🏼‍🎨", "👩🏼‍🏫", "👩🏼‍🏭", "👩🏼‍💻", "👩🏼‍💼", "👩🏼‍🔧", "👩🏼‍🔬", "👩🏼‍🚀", "👩🏼‍🚒", "👩🏼‍🤝‍👨🏻", "👩🏼‍🤝‍👨🏽", "👩🏼‍🤝‍👨🏾", "👩🏼‍🤝‍👨🏿", "👩🏼‍🤝‍👩🏻", "👩🏼‍🤝‍👩🏽", "👩🏼‍🤝‍👩🏾", "👩🏼‍🤝‍👩🏿", "👩🏼‍🦯", "👩🏼‍🦯‍➡", "👩🏼‍🦯‍➡️", "👩🏼‍🦰", "👩🏼‍🦱", "👩🏼‍🦲", "👩🏼‍🦳", "👩🏼‍🦼", "👩🏼‍🦼‍➡", "👩🏼‍🦼‍➡️", "👩🏼‍🦽", "👩🏼‍🦽‍➡", "👩🏼‍🦽‍➡️", "👩🏽", "👩🏽‍⚕", "👩🏽‍⚕️", "👩🏽‍⚖", "👩🏽‍⚖️", "👩🏽‍✈", "👩🏽‍✈️", "👩🏽‍❤‍👨🏻", "👩🏽‍❤‍👨🏼", "👩🏽‍❤‍👨🏽", "👩🏽‍❤‍👨🏾", "👩🏽‍❤‍👨🏿", "👩🏽‍❤‍👩🏻", "👩🏽‍❤‍👩🏼", "👩🏽‍❤‍👩🏽", "👩🏽‍❤‍👩🏾", "👩🏽‍❤‍👩🏿", "👩🏽‍❤‍💋‍👨🏻", "👩🏽‍❤‍💋‍👨🏼", "👩🏽‍❤‍💋‍👨🏽", "👩🏽‍❤‍💋‍👨🏾", "👩🏽‍❤‍💋‍👨🏿", "👩🏽‍❤‍💋‍👩🏻", "👩🏽‍❤‍💋‍👩🏼", "👩🏽‍❤‍💋‍👩🏽", "👩🏽‍❤‍💋‍👩🏾", "👩🏽‍❤‍💋‍👩🏿", "👩🏽‍❤️‍👨🏻", "👩🏽‍❤️‍👨🏼", "👩🏽‍❤️‍👨🏽", "👩🏽‍❤️‍👨🏾", "👩🏽‍❤️‍👨🏿", "👩🏽‍❤️‍👩🏻", "👩🏽‍❤️‍👩🏼", "👩🏽‍❤️‍👩🏽", "👩🏽‍❤️‍👩🏾", "👩🏽‍❤️‍👩🏿", "👩🏽‍❤️‍💋‍👨🏻", "👩🏽‍❤️‍💋‍👨🏼", "👩🏽‍❤️‍💋‍👨🏽", "👩🏽‍❤️‍💋‍👨🏾", "👩🏽‍❤️‍💋‍👨🏿", "👩🏽‍❤️‍💋‍👩🏻", "👩🏽‍❤️‍💋‍👩🏼", "👩🏽‍❤️‍💋‍👩🏽", "👩🏽‍❤️‍💋‍👩🏾", "👩🏽‍❤️‍💋‍👩🏿", "👩🏽‍🌾", "👩🏽‍🍳", "👩🏽‍🍼", "👩🏽‍🎓", "👩🏽‍🎤", "👩🏽‍🎨", "👩🏽‍🏫", "👩🏽‍🏭", "👩🏽‍💻", "👩🏽‍💼", "👩🏽‍🔧", "👩🏽‍🔬", "👩🏽‍🚀", "👩🏽‍🚒", "👩🏽‍🤝‍👨🏻", "👩🏽‍🤝‍👨🏼", "👩🏽‍🤝‍👨🏾", "👩🏽‍🤝‍👨🏿", "👩🏽‍🤝‍👩🏻", "👩🏽‍🤝‍👩🏼", "👩🏽‍🤝‍👩🏾", "👩🏽‍🤝‍👩🏿", "👩🏽‍🦯", "👩🏽‍🦯‍➡", "👩🏽‍🦯‍➡️", "👩🏽‍🦰", "👩🏽‍🦱", "👩🏽‍🦲", "👩🏽‍🦳", "👩🏽‍🦼", "👩🏽‍🦼‍➡", "👩🏽‍🦼‍➡️", "👩🏽‍🦽", "👩🏽‍🦽‍➡", "👩🏽‍🦽‍➡️", "👩🏾", "👩🏾‍⚕", "👩🏾‍⚕️", "👩🏾‍⚖", "👩🏾‍⚖️", "👩🏾‍✈", "👩🏾‍✈️", "👩🏾‍❤‍👨🏻", "👩🏾‍❤‍👨🏼", "👩🏾‍❤‍👨🏽", "👩🏾‍❤‍👨🏾", "👩🏾‍❤‍👨🏿", "👩🏾‍❤‍👩🏻", "👩🏾‍❤‍👩🏼", "👩🏾‍❤‍👩🏽", "👩🏾‍❤‍👩🏾", "👩🏾‍❤‍👩🏿", "👩🏾‍❤‍💋‍👨🏻", "👩🏾‍❤‍💋‍👨🏼", "👩🏾‍❤‍💋‍👨🏽", "👩🏾‍❤‍💋‍👨🏾", "👩🏾‍❤‍💋‍👨🏿", "👩🏾‍❤‍💋‍👩🏻", "👩🏾‍❤‍💋‍👩🏼", "👩🏾‍❤‍💋‍👩🏽", "👩🏾‍❤‍💋‍👩🏾", "👩🏾‍❤‍💋‍👩🏿", "👩🏾‍❤️‍👨🏻", "👩🏾‍❤️‍👨🏼", "👩🏾‍❤️‍👨🏽", "👩🏾‍❤️‍👨🏾", "👩🏾‍❤️‍👨🏿", "👩🏾‍❤️‍👩🏻", "👩🏾‍❤️‍👩🏼", "👩🏾‍❤️‍👩🏽", "👩🏾‍❤️‍👩🏾", "👩🏾‍❤️‍👩🏿", "👩🏾‍❤️‍💋‍👨🏻", "👩🏾‍❤️‍💋‍👨🏼", "👩🏾‍❤️‍💋‍👨🏽", "👩🏾‍❤️‍💋‍👨🏾", "👩🏾‍❤️‍💋‍👨🏿", "👩🏾‍❤️‍💋‍👩🏻", "👩🏾‍❤️‍💋‍👩🏼", "👩🏾‍❤️‍💋‍👩🏽", "👩🏾‍❤️‍💋‍👩🏾", "👩🏾‍❤️‍💋‍👩🏿", "👩🏾‍🌾", "👩🏾‍🍳", "👩🏾‍🍼", "👩🏾‍🎓", "👩🏾‍🎤", "👩🏾‍🎨", "👩🏾‍🏫", "👩🏾‍🏭", "👩🏾‍💻", "👩🏾‍💼", "👩🏾‍🔧", "👩🏾‍🔬", "👩🏾‍🚀", "👩🏾‍🚒", "👩🏾‍🤝‍👨🏻", "👩🏾‍🤝‍👨🏼", "👩🏾‍🤝‍👨🏽", "👩🏾‍🤝‍👨🏿", "👩🏾‍🤝‍👩🏻", "👩🏾‍🤝‍👩🏼", "👩🏾‍🤝‍👩🏽", "👩🏾‍🤝‍👩🏿", "👩🏾‍🦯", "👩🏾‍🦯‍➡", "👩🏾‍🦯‍➡️", "👩🏾‍🦰", "👩🏾‍🦱", "👩🏾‍🦲", "👩🏾‍🦳", "👩🏾‍🦼", "👩🏾‍🦼‍➡", "👩🏾‍🦼‍➡️", "👩🏾‍🦽", "👩🏾‍🦽‍➡", "👩🏾‍🦽‍➡️", "👩🏿", "👩🏿‍⚕", "👩🏿‍⚕️", "👩🏿‍⚖", "👩🏿‍⚖️", "👩🏿‍✈", "👩🏿‍✈️", "👩🏿‍❤‍👨🏻", "👩🏿‍❤‍👨🏼", "👩🏿‍❤‍👨🏽", "👩🏿‍❤‍👨🏾", "👩🏿‍❤‍👨🏿", "👩🏿‍❤‍👩🏻", "👩🏿‍❤‍👩🏼", "👩🏿‍❤‍👩🏽", "👩🏿‍❤‍👩🏾", "👩🏿‍❤‍👩🏿", "👩🏿‍❤‍💋‍👨🏻", "👩🏿‍❤‍💋‍👨🏼", "👩🏿‍❤‍💋‍👨🏽", "👩🏿‍❤‍💋‍👨🏾", "👩🏿‍❤‍💋‍👨🏿", "👩🏿‍❤‍💋‍👩🏻", "👩🏿‍❤‍💋‍👩🏼", "👩🏿‍❤‍💋‍👩🏽", "👩🏿‍❤‍💋‍👩🏾", "👩🏿‍❤‍💋‍👩🏿", "👩🏿‍❤️‍👨🏻", "👩🏿‍❤️‍👨🏼", "👩🏿‍❤️‍👨🏽", "👩🏿‍❤️‍👨🏾", "👩🏿‍❤️‍👨🏿", "👩🏿‍❤️‍👩🏻", "👩🏿‍❤️‍👩🏼", "👩🏿‍❤️‍👩🏽", "👩🏿‍❤️‍👩🏾", "👩🏿‍❤️‍👩🏿", "👩🏿‍❤️‍💋‍👨🏻", "👩🏿‍❤️‍💋‍👨🏼", "👩🏿‍❤️‍💋‍👨🏽", "👩🏿‍❤️‍💋‍👨🏾", "👩🏿‍❤️‍💋‍👨🏿", "👩🏿‍❤️‍💋‍👩🏻", "👩🏿‍❤️‍💋‍👩🏼", "👩🏿‍❤️‍💋‍👩🏽", "👩🏿‍❤️‍💋‍👩🏾", "👩🏿‍❤️‍💋‍👩🏿", "👩🏿‍🌾", "👩🏿‍🍳", "👩🏿‍🍼", "👩🏿‍🎓", "👩🏿‍🎤", "👩🏿‍🎨", "👩🏿‍🏫", "👩🏿‍🏭", "👩🏿‍💻", "👩🏿‍💼", "👩🏿‍🔧", "👩🏿‍🔬", "👩🏿‍🚀", "👩🏿‍🚒", "👩🏿‍🤝‍👨🏻", "👩🏿‍🤝‍👨🏼", "👩🏿‍🤝‍👨🏽", "👩🏿‍🤝‍👨🏾", "👩🏿‍🤝‍👩🏻", "👩🏿‍🤝‍👩🏼", "👩🏿‍🤝‍👩🏽", "👩🏿‍🤝‍👩🏾", "👩🏿‍🦯", "👩🏿‍🦯‍➡", "👩🏿‍🦯‍➡️", "👩🏿‍🦰", "👩🏿‍🦱", "👩🏿‍🦲", "👩🏿‍🦳", "👩🏿‍🦼", "👩🏿‍🦼‍➡", "👩🏿‍🦼‍➡️", "👩🏿‍🦽", "👩🏿‍🦽‍➡", "👩🏿‍🦽‍➡️", "👪", "👫", "👫🏻", "👫🏼", "👫🏽", "👫🏾", "👫🏿", "👬", "👬🏻", "👬🏼", "👬🏽", "👬🏾", "👬🏿", "👭", "👭🏻", "👭🏼", "👭🏽", "👭🏾", "👭🏿", "👮", "👮‍♀", "👮‍♀️", "👮‍♂", "👮‍♂️", "👮🏻", "👮🏻‍♀", "👮🏻‍♀️", "👮🏻‍♂", "👮🏻‍♂️", "👮🏼", "👮🏼‍♀", "👮🏼‍♀️", "👮🏼‍♂", "👮🏼‍♂️", "👮🏽", "👮🏽‍♀", "👮🏽‍♀️", "👮🏽‍♂", "👮🏽‍♂️", "👮🏾", "👮🏾‍♀", "👮🏾‍♀️", "👮🏾‍♂", "👮🏾‍♂️", "👮🏿", "👮🏿‍♀", "👮🏿‍♀️", "👮🏿‍♂", "👮🏿‍♂️", "👯", "👯‍♀", "👯‍♀️", "👯‍♂", "👯‍♂️", "👰", "👰‍♀", "👰‍♀️", "👰‍♂", "👰‍♂️", "👰🏻", "👰🏻‍♀", "👰🏻‍♀️", "👰🏻‍♂", "👰🏻‍♂️", "👰🏼", "👰🏼‍♀", "👰🏼‍♀️", "👰🏼‍♂", "👰🏼‍♂️", "👰🏽", "👰🏽‍♀", "👰🏽‍♀️", "👰🏽‍♂", "👰🏽‍♂️", "👰🏾", "👰🏾‍♀", "👰🏾‍♀️", "👰🏾‍♂", "👰🏾‍♂️", "👰🏿", "👰🏿‍♀", "👰🏿‍♀️", "👰🏿‍♂", "👰🏿‍♂️", "👱", "👱‍♀", "👱‍♀️", "👱‍♂", "👱‍♂️", "👱🏻", "👱🏻‍♀", "👱🏻‍♀️", "👱🏻‍♂", "👱🏻‍♂️", "👱🏼", "👱🏼‍♀", "👱🏼‍♀️", "👱🏼‍♂", "👱🏼‍♂️", "👱🏽", "👱🏽‍♀", "👱🏽‍♀️", "👱🏽‍♂", "👱🏽‍♂️", "👱🏾", "👱🏾‍♀", "👱🏾‍♀️", "👱🏾‍♂", "👱🏾‍♂️", "👱🏿", "👱🏿‍♀", "👱🏿‍♀️", "👱🏿‍♂", "👱🏿‍♂️", "👲", "👲🏻", "👲🏼", "👲🏽", "👲🏾", "👲🏿", "👳", "👳‍♀", "👳‍♀️", "👳‍♂", "👳‍♂️", "👳🏻", "👳🏻‍♀", "👳🏻‍♀️", "👳🏻‍♂", "👳🏻‍♂️", "👳🏼", "👳🏼‍♀", "👳🏼‍♀️", "👳🏼‍♂", "👳🏼‍♂️", "👳🏽", "👳🏽‍♀", "👳🏽‍♀️", "👳🏽‍♂", "👳🏽‍♂️", "👳🏾", "👳🏾‍♀", "👳🏾‍♀️", "👳🏾‍♂", "👳🏾‍♂️", "👳🏿", "👳🏿‍♀", "👳🏿‍♀️", "👳🏿‍♂", "👳🏿‍♂️", "👴", "👴🏻", "👴🏼", "👴🏽", "👴🏾", "👴🏿", "👵", "👵🏻", "👵🏼", "👵🏽", "👵🏾", "👵🏿", "👶", "👶🏻", "👶🏼", "👶🏽", "👶🏾", "👶🏿", "👷", "👷‍♀", "👷‍♀️", "👷‍♂", "👷‍♂️", "👷🏻", "👷🏻‍♀", "👷🏻‍♀️", "👷🏻‍♂", "👷🏻‍♂️", "👷🏼", "👷🏼‍♀", "👷🏼‍♀️", "👷🏼‍♂", "👷🏼‍♂️", "👷🏽", "👷🏽‍♀", "👷🏽‍♀️", "👷🏽‍♂", "👷🏽‍♂️", "👷🏾", "👷🏾‍♀", "👷🏾‍♀️", "👷🏾‍♂", "👷🏾‍♂️", "👷🏿", "👷🏿‍♀", "👷🏿‍♀️", "👷🏿‍♂", "👷🏿‍♂️", "👸", "👸🏻", "👸🏼", "👸🏽", "👸🏾", "👸🏿", "👹", "👺", "👻", "👼", "👼🏻", "👼🏼", "👼🏽", "👼🏾", "👼🏿", "👽", "👾", "👿", "💀", "💁", "💁‍♀", "💁‍♀️", "💁‍♂", "💁‍♂️", "💁🏻", "💁🏻‍♀", "💁🏻‍♀️", "💁🏻‍♂", "💁🏻‍♂️", "💁🏼", "💁🏼‍♀", "💁🏼‍♀️", "💁🏼‍♂", "💁🏼‍♂️", "💁🏽", "💁🏽‍♀", "💁🏽‍♀️", "💁🏽‍♂", "💁🏽‍♂️", "💁🏾", "💁🏾‍♀", "💁🏾‍♀️", "💁🏾‍♂", "💁🏾‍♂️", "💁🏿", "💁🏿‍♀", "💁🏿‍♀️", "💁🏿‍♂", "💁🏿‍♂️", "💂", "💂‍♀", "💂‍♀️", "💂‍♂", "💂‍♂️", "💂🏻", "💂🏻‍♀", "💂🏻‍♀️", "💂🏻‍♂", "💂🏻‍♂️", "💂🏼", "💂🏼‍♀", "💂🏼‍♀️", "💂🏼‍♂", "💂🏼‍♂️", "💂🏽", "💂🏽‍♀", "💂🏽‍♀️", "💂🏽‍♂", "💂🏽‍♂️", "💂🏾", "💂🏾‍♀", "💂🏾‍♀️", "💂🏾‍♂", "💂🏾‍♂️", "💂🏿", "💂🏿‍♀", "💂🏿‍♀️", "💂🏿‍♂", "💂🏿‍♂️", "💃", "💃🏻", "💃🏼", "💃🏽", "💃🏾", "💃🏿", "💄", "💅", "💅🏻", "💅🏼", "💅🏽", "💅🏾", "💅🏿", "💆", "💆‍♀", "💆‍♀️", "💆‍♂", "💆‍♂️", "💆🏻", "💆🏻‍♀", "💆🏻‍♀️", "💆🏻‍♂", "💆🏻‍♂️", "💆🏼", "💆🏼‍♀", "💆🏼‍♀️", "💆🏼‍♂", "💆🏼‍♂️", "💆🏽", "💆🏽‍♀", "💆🏽‍♀️", "💆🏽‍♂", "💆🏽‍♂️", "💆🏾", "💆🏾‍♀", "💆🏾‍♀️", "💆🏾‍♂", "💆🏾‍♂️", "💆🏿", "💆🏿‍♀", "💆🏿‍♀️", "💆🏿‍♂", "💆🏿‍♂️", "💇", "💇‍♀", "💇‍♀️", "💇‍♂", "💇‍♂️", "💇🏻", "💇🏻‍♀", "💇🏻‍♀️", "💇🏻‍♂", "💇🏻‍♂️", "💇🏼", "💇🏼‍♀", "💇🏼‍♀️", "💇🏼‍♂", "💇🏼‍♂️", "💇🏽", "💇🏽‍♀", "💇🏽‍♀️", "💇🏽‍♂", "💇🏽‍♂️", "💇🏾", "💇🏾‍♀", "💇🏾‍♀️", "💇🏾‍♂", "💇🏾‍♂️", "💇🏿", "💇🏿‍♀", "💇🏿‍♀️", "💇🏿‍♂", "💇🏿‍♂️", "💈", "💉", "💊", "💋", "💌", "💍", "💎", "💏", "💏🏻", "💏🏼", "💏🏽", "💏🏾", "💏🏿", "💐", "💑", "💑🏻", "💑🏼", "💑🏽", "💑🏾", "💑🏿", "💒", "💓", "💔", "💕", "💖", "💗", "💘", "💙", "💚", "💛", "💜", "💝", "💞", "💟", "💠", "💡", "💢", "💣", "💤", "💥", "💦", "💧", "💨", "💩", "💪", "💪🏻", "💪🏼", "💪🏽", "💪🏾", "💪🏿", "💫", "💬", "💭", "💮", "💯", "💰", "💱", "💲", "💳", "💴", "💵", "💶", "💷", "💸", "💹", "💺", "💻", "💼", "💽", "💾", "💿", "📀", "📁", "📂", "📃", "📄", "📅", "📆", "📇", "📈", "📉", "📊", "📋", "📌", "📍", "📎", "📏", "📐", "📑", "📒", "📓", "📔", "📕", "📖", "📗", "📘", "📙", "📚", "📛", "📜", "📝", "📞", "📟", "📠", "📡", "📢", "📣", "📤", "📥", "📦", "📧", "📨", "📩", "📪", "📫", "📬", "📭", "📮", "📯", "📰", "📱", "📲", "📳", "📴", "📵", "📶", "📷", "📸", "📹", "📺", "📻", "📼", "📽", "📽️", "📿", "🔀", "🔁", "🔂", "🔃", "🔄", "🔅", "🔆", "🔇", "🔈", "🔉", "🔊", "🔋", "🔌", "🔍", "🔎", "🔏", "🔐", "🔑", "🔒", "🔓", "🔔", "🔕", "🔖", "🔗", "🔘", "🔙", "🔚", "🔛", "🔜", "🔝", "🔞", "🔟", "🔠", "🔡", "🔢", "🔣", "🔤", "🔥", "🔦", "🔧", "🔨", "🔩", "🔪", "🔫", "🔬", "🔭", "🔮", "🔯", "🔰", "🔱", "🔲", "🔳", "🔴", "🔵", "🔶", "🔷", "🔸", "🔹", "🔺", "🔻", "🔼", "🔽", "🕉", "🕉️", "🕊", "🕊️", "🕋", "🕌", "🕍", "🕎", "🕐", "🕑", "🕒", "🕓", "🕔", "🕕", "🕖", "🕗", "🕘", "🕙", "🕚", "🕛", "🕜", "🕝", "🕞", "🕟", "🕠", "🕡", "🕢", "🕣", "🕤", "🕥", "🕦", "🕧", "🕯", "🕯️", "🕰", "🕰️", "🕳", "🕳️", "🕴", "🕴️", "🕴🏻", "🕴🏼", "🕴🏽", "🕴🏾", "🕴🏿", "🕵", "🕵‍♀", "🕵‍♀️", "🕵‍♂", "🕵‍♂️", "🕵️", "🕵️‍♀", "🕵️‍♀️", "🕵️‍♂", "🕵️‍♂️", "🕵🏻", "🕵🏻‍♀", "🕵🏻‍♀️", "🕵🏻‍♂", "🕵🏻‍♂️", "🕵🏼", "🕵🏼‍♀", "🕵🏼‍♀️", "🕵🏼‍♂", "🕵🏼‍♂️", "🕵🏽", "🕵🏽‍♀", "🕵🏽‍♀️", "🕵🏽‍♂", "🕵🏽‍♂️", "🕵🏾", "🕵🏾‍♀", "🕵🏾‍♀️", "🕵🏾‍♂", "🕵🏾‍♂️", "🕵🏿", "🕵🏿‍♀", "🕵🏿‍♀️", "🕵🏿‍♂", "🕵🏿‍♂️", "🕶", "🕶️", "🕷", "🕷️", "🕸", "🕸️", "🕹", "🕹️", "🕺", "🕺🏻", "🕺🏼", "🕺🏽", "🕺🏾", "🕺🏿", "🖇", "🖇️", "🖊", "🖊️", "🖋", "🖋️", "🖌", "🖌️", "🖍", "🖍️", "🖐", "🖐️", "🖐🏻", "🖐🏼", "🖐🏽", "🖐🏾", "🖐🏿", "🖕", "🖕🏻", "🖕🏼", "🖕🏽", "🖕🏾", "🖕🏿", "🖖", "🖖🏻", "🖖🏼", "🖖🏽", "🖖🏾", "🖖🏿", "🖤", "🖥", "🖥️", "🖨", "🖨️", "🖱", "🖱️", "🖲", "🖲️", "🖼", "🖼️", "🗂", "🗂️", "🗃", "🗃️", "🗄", "🗄️", "🗑", "🗑️", "🗒", "🗒️", "🗓", "🗓️", "🗜", "🗜️", "🗝", "🗝️", "🗞", "🗞️", "🗡", "🗡️", "🗣", "🗣️", "🗨", "🗨️", "🗯", "🗯️", "🗳", "🗳️", "🗺", "🗺️", "🗻", "🗼", "🗽", "🗾", "🗿", "😀", "😁", "😂", "😃", "😄", "😅", "😆", "😇", "😈", "😉", "😊", "😋", "😌", "😍", "😎", "😏", "😐", "😑", "😒", "😓", "😔", "😕", "😖", "😗", "😘", "😙", "😚", "😛", "😜", "😝", "😞", "😟", "😠", "😡", "😢", "😣", "😤", "😥", "😦", "😧", "😨", "😩", "😪", "😫", "😬", "😭", "😮", "😮‍💨", "😯", "😰", "😱", "😲", "😳", "😴", "😵", "😵‍💫", "😶", "😶‍🌫", "😶‍🌫️", "😷", "😸", "😹", "😺", "😻", "😼", "😽", "😾", "😿", "🙀", "🙁", "🙂", "🙂‍↔", "🙂‍↔️", "🙂‍↕", "🙂‍↕️", "🙃", "🙄", "🙅", "🙅‍♀", "🙅‍♀️", "🙅‍♂", "🙅‍♂️", "🙅🏻", "🙅🏻‍♀", "🙅🏻‍♀️", "🙅🏻‍♂", "🙅🏻‍♂️", "🙅🏼", "🙅🏼‍♀", "🙅🏼‍♀️", "🙅🏼‍♂", "🙅🏼‍♂️", "🙅🏽", "🙅🏽‍♀", "🙅🏽‍♀️", "🙅🏽‍♂", "🙅🏽‍♂️", "🙅🏾", "🙅🏾‍♀", "🙅🏾‍♀️", "🙅🏾‍♂", "🙅🏾‍♂️", "🙅🏿", "🙅🏿‍♀", "🙅🏿‍♀️", "🙅🏿‍♂", "🙅🏿‍♂️", "🙆", "🙆‍♀", "🙆‍♀️", "🙆‍♂", "🙆‍♂️", "🙆🏻", "🙆🏻‍♀", "🙆🏻‍♀️", "🙆🏻‍♂", "🙆🏻‍♂️", "🙆🏼", "🙆🏼‍♀", "🙆🏼‍♀️", "🙆🏼‍♂", "🙆🏼‍♂️", "🙆🏽", "🙆🏽‍♀", "🙆🏽‍♀️", "🙆🏽‍♂", "🙆🏽‍♂️", "🙆🏾", "🙆🏾‍♀", "🙆🏾‍♀️", "🙆🏾‍♂", "🙆🏾‍♂️", "🙆🏿", "🙆🏿‍♀", "🙆🏿‍♀️", "🙆🏿‍♂", "🙆🏿‍♂️", "🙇", "🙇‍♀", "🙇‍♀️", "🙇‍♂", "🙇‍♂️", "🙇🏻", "🙇🏻‍♀", "🙇🏻‍♀️", "🙇🏻‍♂", "🙇🏻‍♂️", "🙇🏼", "🙇🏼‍♀", "🙇🏼‍♀️", "🙇🏼‍♂", "🙇🏼‍♂️", "🙇🏽", "🙇🏽‍♀", "🙇🏽‍♀️", "🙇🏽‍♂", "🙇🏽‍♂️", "🙇🏾", "🙇🏾‍♀", "🙇🏾‍♀️", "🙇🏾‍♂", "🙇🏾‍♂️", "🙇🏿", "🙇🏿‍♀", "🙇🏿‍♀️", "🙇🏿‍♂", "🙇🏿‍♂️", "🙈", "🙉", "🙊", "🙋", "🙋‍♀", "🙋‍♀️", "🙋‍♂", "🙋‍♂️", "🙋🏻", "🙋🏻‍♀", "🙋🏻‍♀️", "🙋🏻‍♂", "🙋🏻‍♂️", "🙋🏼", "🙋🏼‍♀", "🙋🏼‍♀️", "🙋🏼‍♂", "🙋🏼‍♂️", "🙋🏽", "🙋🏽‍♀", "🙋🏽‍♀️", "🙋🏽‍♂", "🙋🏽‍♂️", "🙋🏾", "🙋🏾‍♀", "🙋🏾‍♀️", "🙋🏾‍♂", "🙋🏾‍♂️", "🙋🏿", "🙋🏿‍♀", "🙋🏿‍♀️", "🙋🏿‍♂", "🙋🏿‍♂️", "🙌", "🙌🏻", "🙌🏼", "🙌🏽", "🙌🏾", "🙌🏿", "🙍", "🙍‍♀", "🙍‍♀️", "🙍‍♂", "🙍‍♂️", "🙍🏻", "🙍🏻‍♀", "🙍🏻‍♀️", "🙍🏻‍♂", "🙍🏻‍♂️", "🙍🏼", "🙍🏼‍♀", "🙍🏼‍♀️", "🙍🏼‍♂", "🙍🏼‍♂️", "🙍🏽", "🙍🏽‍♀", "🙍🏽‍♀️", "🙍🏽‍♂", "🙍🏽‍♂️", "🙍🏾", "🙍🏾‍♀", "🙍🏾‍♀️", "🙍🏾‍♂", "🙍🏾‍♂️", "🙍🏿", "🙍🏿‍♀", "🙍🏿‍♀️", "🙍🏿‍♂", "🙍🏿‍♂️", "🙎", "🙎‍♀", "🙎‍♀️", "🙎‍♂", "🙎‍♂️", "🙎🏻", "🙎🏻‍♀", "🙎🏻‍♀️", "🙎🏻‍♂", "🙎🏻‍♂️", "🙎🏼", "🙎🏼‍♀", "🙎🏼‍♀️", "🙎🏼‍♂", "🙎🏼‍♂️", "🙎🏽", "🙎🏽‍♀", "🙎🏽‍♀️", "🙎🏽‍♂", "🙎🏽‍♂️", "🙎🏾", "🙎🏾‍♀", "🙎🏾‍♀️", "🙎🏾‍♂", "🙎🏾‍♂️", "🙎🏿", "🙎🏿‍♀", "🙎🏿‍♀️", "🙎🏿‍♂", "🙎🏿‍♂️", "🙏", "🙏🏻", "🙏🏼", "🙏🏽", "🙏🏾", "🙏🏿", "🚀", "🚁", "🚂", "🚃", "🚄", "🚅", "🚆", "🚇", "🚈", "🚉", "🚊", "🚋", "🚌", "🚍", "🚎", "🚏", "🚐", "🚑", "🚒", "🚓", "🚔", "🚕", "🚖", "🚗", "🚘", "🚙", "🚚", "🚛", "🚜", "🚝", "🚞", "🚟", "🚠", "🚡", "🚢", "🚣", "🚣‍♀", "🚣‍♀️", "🚣‍♂", "🚣‍♂️", "🚣🏻", "🚣🏻‍♀", "🚣🏻‍♀️", "🚣🏻‍♂", "🚣🏻‍♂️", "🚣🏼", "🚣🏼‍♀", "🚣🏼‍♀️", "🚣🏼‍♂", "🚣🏼‍♂️", "🚣🏽", "🚣🏽‍♀", "🚣🏽‍♀️", "🚣🏽‍♂", "🚣🏽‍♂️", "🚣🏾", "🚣🏾‍♀", "🚣🏾‍♀️", "🚣🏾‍♂", "🚣🏾‍♂️", "🚣🏿", "🚣🏿‍♀", "🚣🏿‍♀️", "🚣🏿‍♂", "🚣🏿‍♂️", "🚤", "🚥", "🚦", "🚧", "🚨", "🚩", "🚪", "🚫", "🚬", "🚭", "🚮", "🚯", "🚰", "🚱", "🚲", "🚳", "🚴", "🚴‍♀", "🚴‍♀️", "🚴‍♂", "🚴‍♂️", "🚴🏻", "🚴🏻‍♀", "🚴🏻‍♀️", "🚴🏻‍♂", "🚴🏻‍♂️", "🚴🏼", "🚴🏼‍♀", "🚴🏼‍♀️", "🚴🏼‍♂", "🚴🏼‍♂️", "🚴🏽", "🚴🏽‍♀", "🚴🏽‍♀️", "🚴🏽‍♂", "🚴🏽‍♂️", "🚴🏾", "🚴🏾‍♀", "🚴🏾‍♀️", "🚴🏾‍♂", "🚴🏾‍♂️", "🚴🏿", "🚴🏿‍♀", "🚴🏿‍♀️", "🚴🏿‍♂", "🚴🏿‍♂️", "🚵", "🚵‍♀", "🚵‍♀️", "🚵‍♂", "🚵‍♂️", "🚵🏻", "🚵🏻‍♀", "🚵🏻‍♀️", "🚵🏻‍♂", "🚵🏻‍♂️", "🚵🏼", "🚵🏼‍♀", "🚵🏼‍♀️", "🚵🏼‍♂", "🚵🏼‍♂️", "🚵🏽", "🚵🏽‍♀", "🚵🏽‍♀️", "🚵🏽‍♂", "🚵🏽‍♂️", "🚵🏾", "🚵🏾‍♀", "🚵🏾‍♀️", "🚵🏾‍♂", "🚵🏾‍♂️", "🚵🏿", "🚵🏿‍♀", "🚵🏿‍♀️", "🚵🏿‍♂", "🚵🏿‍♂️", "🚶", "🚶‍♀", "🚶‍♀‍➡", "🚶‍♀‍➡️", "🚶‍♀️", "🚶‍♀️‍➡", "🚶‍♀️‍➡️", "🚶‍♂", "🚶‍♂‍➡", "🚶‍♂‍➡️", "🚶‍♂️", "🚶‍♂️‍➡", "🚶‍♂️‍➡️", "🚶‍➡", "🚶‍➡️", "🚶🏻", "🚶🏻‍♀", "🚶🏻‍♀‍➡", "🚶🏻‍♀‍➡️", "🚶🏻‍♀️", "🚶🏻‍♀️‍➡", "🚶🏻‍♀️‍➡️", "🚶🏻‍♂", "🚶🏻‍♂‍➡", "🚶🏻‍♂‍➡️", "🚶🏻‍♂️", "🚶🏻‍♂️‍➡", "🚶🏻‍♂️‍➡️", "🚶🏻‍➡", "🚶🏻‍➡️", "🚶🏼", "🚶🏼‍♀", "🚶🏼‍♀‍➡", "🚶🏼‍♀‍➡️", "🚶🏼‍♀️", "🚶🏼‍♀️‍➡", "🚶🏼‍♀️‍➡️", "🚶🏼‍♂", "🚶🏼‍♂‍➡", "🚶🏼‍♂‍➡️", "🚶🏼‍♂️", "🚶🏼‍♂️‍➡", "🚶🏼‍♂️‍➡️", "🚶🏼‍➡", "🚶🏼‍➡️", "🚶🏽", "🚶🏽‍♀", "🚶🏽‍♀‍➡", "🚶🏽‍♀‍➡️", "🚶🏽‍♀️", "🚶🏽‍♀️‍➡", "🚶🏽‍♀️‍➡️", "🚶🏽‍♂", "🚶🏽‍♂‍➡", "🚶🏽‍♂‍➡️", "🚶🏽‍♂️", "🚶🏽‍♂️‍➡", "🚶🏽‍♂️‍➡️", "🚶🏽‍➡", "🚶🏽‍➡️", "🚶🏾", "🚶🏾‍♀", "🚶🏾‍♀‍➡", "🚶🏾‍♀‍➡️", "🚶🏾‍♀️", "🚶🏾‍♀️‍➡", "🚶🏾‍♀️‍➡️", "🚶🏾‍♂", "🚶🏾‍♂‍➡", "🚶🏾‍♂‍➡️", "🚶🏾‍♂️", "🚶🏾‍♂️‍➡", "🚶🏾‍♂️‍➡️", "🚶🏾‍➡", "🚶🏾‍➡️", "🚶🏿", "🚶🏿‍♀", "🚶🏿‍♀‍➡", "🚶🏿‍♀‍➡️", "🚶🏿‍♀️", "🚶🏿‍♀️‍➡", "🚶🏿‍♀️‍➡️", "🚶🏿‍♂", "🚶🏿‍♂‍➡", "🚶🏿‍♂‍➡️", "🚶🏿‍♂️", "🚶🏿‍♂️‍➡", "🚶🏿‍♂️‍➡️", "🚶🏿‍➡", "🚶🏿‍➡️", "🚷", "🚸", "🚹", "🚺", "🚻", "🚼", "🚽", "🚾", "🚿", "🛀", "🛀🏻", "🛀🏼", "🛀🏽", "🛀🏾", "🛀🏿", "🛁", "🛂", "🛃", "🛄", "🛅", "🛋", "🛋️", "🛌", "🛌🏻", "🛌🏼", "🛌🏽", "🛌🏾", "🛌🏿", "🛍", "🛍️", "🛎", "🛎️", "🛏", "🛏️", "🛐", "🛑", "🛒", "🛕", "🛖", "🛗", "🛜", "🛝", "🛞", "🛟", "🛠", "🛠️", "🛡", "🛡️", "🛢", "🛢️", "🛣", "🛣️", "🛤", "🛤️", "🛥", "🛥️", "🛩", "🛩️", "🛫", "🛬", "🛰", "🛰️", "🛳", "🛳️", "🛴", "🛵", "🛶", "🛷", "🛸", "🛹", "🛺", "🛻", "🛼", "🟠", "🟡", "🟢", "🟣", "🟤", "🟥", "🟦", "🟧", "🟨", "🟩", "🟪", "🟫", "🟰", "🤌", "🤌🏻", "🤌🏼", "🤌🏽", "🤌🏾", "🤌🏿", "🤍", "🤎", "🤏", "🤏🏻", "🤏🏼", "🤏🏽", "🤏🏾", "🤏🏿", "🤐", "🤑", "🤒", "🤓", "🤔", "🤕", "🤖", "🤗", "🤘", "🤘🏻", "🤘🏼", "🤘🏽", "🤘🏾", "🤘🏿", "🤙", "🤙🏻", "🤙🏼", "🤙🏽", "🤙🏾", "🤙🏿", "🤚", "🤚🏻", "🤚🏼", "🤚🏽", "🤚🏾", "🤚🏿", "🤛", "🤛🏻", "🤛🏼", "🤛🏽", "🤛🏾", "🤛🏿", "🤜", "🤜🏻", "🤜🏼", "🤜🏽", "🤜🏾", "🤜🏿", "🤝", "🤝🏻", "🤝🏼", "🤝🏽", "🤝🏾", "🤝🏿", "🤞", "🤞🏻", "🤞🏼", "🤞🏽", "🤞🏾", "🤞🏿", "🤟", "🤟🏻", "🤟🏼", "🤟🏽", "🤟🏾", "🤟🏿", "🤠", "🤡", "🤢", "🤣", "🤤", "🤥", "🤦", "🤦‍♀", "🤦‍♀️", "🤦‍♂", "🤦‍♂️", "🤦🏻", "🤦🏻‍♀", "🤦🏻‍♀️", "🤦🏻‍♂", "🤦🏻‍♂️", "🤦🏼", "🤦🏼‍♀", "🤦🏼‍♀️", "🤦🏼‍♂", "🤦🏼‍♂️", "🤦🏽", "🤦🏽‍♀", "🤦🏽‍♀️", "🤦🏽‍♂", "🤦🏽‍♂️", "🤦🏾", "🤦🏾‍♀", "🤦🏾‍♀️", "🤦🏾‍♂", "🤦🏾‍♂️", "🤦🏿", "🤦🏿‍♀", "🤦🏿‍♀️", "🤦🏿‍♂", "🤦🏿‍♂️", "🤧", "🤨", "🤩", "🤪", "🤫", "🤬", "🤭", "🤮", "🤯", "🤰", "🤰🏻", "🤰🏼", "🤰🏽", "🤰🏾", "🤰🏿", "🤱", "🤱🏻", "🤱🏼", "🤱🏽", "🤱🏾", "🤱🏿", "🤲", "🤲🏻", "🤲🏼", "🤲🏽", "🤲🏾", "🤲🏿", "🤳", "🤳🏻", "🤳🏼", "🤳🏽", "🤳🏾", "🤳🏿", "🤴", "🤴🏻", "🤴🏼", "🤴🏽", "🤴🏾", "🤴🏿", "🤵", "🤵‍♀", "🤵‍♀️", "🤵‍♂", "🤵‍♂️", "🤵🏻", "🤵🏻‍♀", "🤵🏻‍♀️", "🤵🏻‍♂", "🤵🏻‍♂️", "🤵🏼", "🤵🏼‍♀", "🤵🏼‍♀️", "🤵🏼‍♂", "🤵🏼‍♂️", "🤵🏽", "🤵🏽‍♀", "🤵🏽‍♀️", "🤵🏽‍♂", "🤵🏽‍♂️", "🤵🏾", "🤵🏾‍♀", "🤵🏾‍♀️", "🤵🏾‍♂", "🤵🏾‍♂️", "🤵🏿", "🤵🏿‍♀", "🤵🏿‍♀️", "🤵🏿‍♂", "🤵🏿‍♂️", "🤶", "🤶🏻", "🤶🏼", "🤶🏽", "🤶🏾", "🤶🏿", "🤷", "🤷‍♀", "🤷‍♀️", "🤷‍♂", "🤷‍♂️", "🤷🏻", "🤷🏻‍♀", "🤷🏻‍♀️", "🤷🏻‍♂", "🤷🏻‍♂️", "🤷🏼", "🤷🏼‍♀", "🤷🏼‍♀️", "🤷🏼‍♂", "🤷🏼‍♂️", "🤷🏽", "🤷🏽‍♀", "🤷🏽‍♀️", "🤷🏽‍♂", "🤷🏽‍♂️", "🤷🏾", "🤷🏾‍♀", "🤷🏾‍♀️", "🤷🏾‍♂", "🤷🏾‍♂️", "🤷🏿", "🤷🏿‍♀", "🤷🏿‍♀️", "🤷🏿‍♂", "🤷🏿‍♂️", "🤸", "🤸‍♀", "🤸‍♀️", "🤸‍♂", "🤸‍♂️", "🤸🏻", "🤸🏻‍♀", "🤸🏻‍♀️", "🤸🏻‍♂", "🤸🏻‍♂️", "🤸🏼", "🤸🏼‍♀", "🤸🏼‍♀️", "🤸🏼‍♂", "🤸🏼‍♂️", "🤸🏽", "🤸🏽‍♀", "🤸🏽‍♀️", "🤸🏽‍♂", "🤸🏽‍♂️", "🤸🏾", "🤸🏾‍♀", "🤸🏾‍♀️", "🤸🏾‍♂", "🤸🏾‍♂️", "🤸🏿", "🤸🏿‍♀", "🤸🏿‍♀️", "🤸🏿‍♂", "🤸🏿‍♂️", "🤹", "🤹‍♀", "🤹‍♀️", "🤹‍♂", "🤹‍♂️", "🤹🏻", "🤹🏻‍♀", "🤹🏻‍♀️", "🤹🏻‍♂", "🤹🏻‍♂️", "🤹🏼", "🤹🏼‍♀", "🤹🏼‍♀️", "🤹🏼‍♂", "🤹🏼‍♂️", "🤹🏽", "🤹🏽‍♀", "🤹🏽‍♀️", "🤹🏽‍♂", "🤹🏽‍♂️", "🤹🏾", "🤹🏾‍♀", "🤹🏾‍♀️", "🤹🏾‍♂", "🤹🏾‍♂️", "🤹🏿", "🤹🏿‍♀", "🤹🏿‍♀️", "🤹🏿‍♂", "🤹🏿‍♂️", "🤺", "🤼", "🤼‍♀", "🤼‍♀️", "🤼‍♂", "🤼‍♂️", "🤽", "🤽‍♀", "🤽‍♀️", "🤽‍♂", "🤽‍♂️", "🤽🏻", "🤽🏻‍♀", "🤽🏻‍♀️", "🤽🏻‍♂", "🤽🏻‍♂️", "🤽🏼", "🤽🏼‍♀", "🤽🏼‍♀️", "🤽🏼‍♂", "🤽🏼‍♂️", "🤽🏽", "🤽🏽‍♀", "🤽🏽‍♀️", "🤽🏽‍♂", "🤽🏽‍♂️", "🤽🏾", "🤽🏾‍♀", "🤽🏾‍♀️", "🤽🏾‍♂", "🤽🏾‍♂️", "🤽🏿", "🤽🏿‍♀", "🤽🏿‍♀️", "🤽🏿‍♂", "🤽🏿‍♂️", "🤾", "🤾‍♀", "🤾‍♀️", "🤾‍♂", "🤾‍♂️", "🤾🏻", "🤾🏻‍♀", "🤾🏻‍♀️", "🤾🏻‍♂", "🤾🏻‍♂️", "🤾🏼", "🤾🏼‍♀", "🤾🏼‍♀️", "🤾🏼‍♂", "🤾🏼‍♂️", "🤾🏽", "🤾🏽‍♀", "🤾🏽‍♀️", "🤾🏽‍♂", "🤾🏽‍♂️", "🤾🏾", "🤾🏾‍♀", "🤾🏾‍♀️", "🤾🏾‍♂", "🤾🏾‍♂️", "🤾🏿", "🤾🏿‍♀", "🤾🏿‍♀️", "🤾🏿‍♂", "🤾🏿‍♂️", "🤿", "🥀", "🥁", "🥂", "🥃", "🥄", "🥅", "🥇", "🥈", "🥉", "🥊", "🥋", "🥌", "🥍", "🥎", "🥏", "🥐", "🥑", "🥒", "🥓", "🥔", "🥕", "🥖", "🥗", "🥘", "🥙", "🥚", "🥛", "🥜", "🥝", "🥞", "🥟", "🥠", "🥡", "🥢", "🥣", "🥤", "🥥", "🥦", "🥧", "🥨", "🥩", "🥪", "🥫", "🥬", "🥭", "🥮", "🥯", "🥰", "🥱", "🥲", "🥳", "🥴", "🥵", "🥶", "🥷", "🥷🏻", "🥷🏼", "🥷🏽", "🥷🏾", "🥷🏿", "🥸", "🥹", "🥺", "🥻", "🥼", "🥽", "🥾", "🥿", "🦀", "🦁", "🦂", "🦃", "🦄", "🦅", "🦆", "🦇", "🦈", "🦉", "🦊", "🦋", "🦌", "🦍", "🦎", "🦏", "🦐", "🦑", "🦒", "🦓", "🦔", "🦕", "🦖", "🦗", "🦘", "🦙", "🦚", "🦛", "🦜", "🦝", "🦞", "🦟", "🦠", "🦡", "🦢", "🦣", "🦤", "🦥", "🦦", "🦧", "🦨", "🦩", "🦪", "🦫", "🦬", "🦭", "🦮", "🦯", "🦰", "🦱", "🦲", "🦳", "🦴", "🦵", "🦵🏻", "🦵🏼", "🦵🏽", "🦵🏾", "🦵🏿", "🦶", "🦶🏻", "🦶🏼", "🦶🏽", "🦶🏾", "🦶🏿", "🦷", "🦸", "🦸‍♀", "🦸‍♀️", "🦸‍♂", "🦸‍♂️", "🦸🏻", "🦸🏻‍♀", "🦸🏻‍♀️", "🦸🏻‍♂", "🦸🏻‍♂️", "🦸🏼", "🦸🏼‍♀", "🦸🏼‍♀️", "🦸🏼‍♂", "🦸🏼‍♂️", "🦸🏽", "🦸🏽‍♀", "🦸🏽‍♀️", "🦸🏽‍♂", "🦸🏽‍♂️", "🦸🏾", "🦸🏾‍♀", "🦸🏾‍♀️", "🦸🏾‍♂", "🦸🏾‍♂️", "🦸🏿", "🦸🏿‍♀", "🦸🏿‍♀️", "🦸🏿‍♂", "🦸🏿‍♂️", "🦹", "🦹‍♀", "🦹‍♀️", "🦹‍♂", "🦹‍♂️", "🦹🏻", "🦹🏻‍♀", "🦹🏻‍♀️", "🦹🏻‍♂", "🦹🏻‍♂️", "🦹🏼", "🦹🏼‍♀", "🦹🏼‍♀️", "🦹🏼‍♂", "🦹🏼‍♂️", "🦹🏽", "🦹🏽‍♀", "🦹🏽‍♀️", "🦹🏽‍♂", "🦹🏽‍♂️", "🦹🏾", "🦹🏾‍♀", "🦹🏾‍♀️", "🦹🏾‍♂", "🦹🏾‍♂️", "🦹🏿", "🦹🏿‍♀", "🦹🏿‍♀️", "🦹🏿‍♂", "🦹🏿‍♂️", "🦺", "🦻", "🦻🏻", "🦻🏼", "🦻🏽", "🦻🏾", "🦻🏿", "🦼", "🦽", "🦾", "🦿", "🧀", "🧁", "🧂", "🧃", "🧄", "🧅", "🧆", "🧇", "🧈", "🧉", "🧊", "🧋", "🧌", "🧍", "🧍‍♀", "🧍‍♀️", "🧍‍♂", "🧍‍♂️", "🧍🏻", "🧍🏻‍♀", "🧍🏻‍♀️", "🧍🏻‍♂", "🧍🏻‍♂️", "🧍🏼", "🧍🏼‍♀", "🧍🏼‍♀️", "🧍🏼‍♂", "🧍🏼‍♂️", "🧍🏽", "🧍🏽‍♀", "🧍🏽‍♀️", "🧍🏽‍♂", "🧍🏽‍♂️", "🧍🏾", "🧍🏾‍♀", "🧍🏾‍♀️", "🧍🏾‍♂", "🧍🏾‍♂️", "🧍🏿", "🧍🏿‍♀", "🧍🏿‍♀️", "🧍🏿‍♂", "🧍🏿‍♂️", "🧎", "🧎‍♀", "🧎‍♀‍➡", "🧎‍♀‍➡️", "🧎‍♀️", "🧎‍♀️‍➡", "🧎‍♀️‍➡️", "🧎‍♂", "🧎‍♂‍➡", "🧎‍♂‍➡️", "🧎‍♂️", "🧎‍♂️‍➡", "🧎‍♂️‍➡️", "🧎‍➡", "🧎‍➡️", "🧎🏻", "🧎🏻‍♀", "🧎🏻‍♀‍➡", "🧎🏻‍♀‍➡️", "🧎🏻‍♀️", "🧎🏻‍♀️‍➡", "🧎🏻‍♀️‍➡️", "🧎🏻‍♂", "🧎🏻‍♂‍➡", "🧎🏻‍♂‍➡️", "🧎🏻‍♂️", "🧎🏻‍♂️‍➡", "🧎🏻‍♂️‍➡️", "🧎🏻‍➡", "🧎🏻‍➡️", "🧎🏼", "🧎🏼‍♀", "🧎🏼‍♀‍➡", "🧎🏼‍♀‍➡️", "🧎🏼‍♀️", "🧎🏼‍♀️‍➡", "🧎🏼‍♀️‍➡️", "🧎🏼‍♂", "🧎🏼‍♂‍➡", "🧎🏼‍♂‍➡️", "🧎🏼‍♂️", "🧎🏼‍♂️‍➡", "🧎🏼‍♂️‍➡️", "🧎🏼‍➡", "🧎🏼‍➡️", "🧎🏽", "🧎🏽‍♀", "🧎🏽‍♀‍➡", "🧎🏽‍♀‍➡️", "🧎🏽‍♀️", "🧎🏽‍♀️‍➡", "🧎🏽‍♀️‍➡️", "🧎🏽‍♂", "🧎🏽‍♂‍➡", "🧎🏽‍♂‍➡️", "🧎🏽‍♂️", "🧎🏽‍♂️‍➡", "🧎🏽‍♂️‍➡️", "🧎🏽‍➡", "🧎🏽‍➡️", "🧎🏾", "🧎🏾‍♀", "🧎🏾‍♀‍➡", "🧎🏾‍♀‍➡️", "🧎🏾‍♀️", "🧎🏾‍♀️‍➡", "🧎🏾‍♀️‍➡️", "🧎🏾‍♂", "🧎🏾‍♂‍➡", "🧎🏾‍♂‍➡️", "🧎🏾‍♂️", "🧎🏾‍♂️‍➡", "🧎🏾‍♂️‍➡️", "🧎🏾‍➡", "🧎🏾‍➡️", "🧎🏿", "🧎🏿‍♀", "🧎🏿‍♀‍➡", "🧎🏿‍♀‍➡️", "🧎🏿‍♀️", "🧎🏿‍♀️‍➡", "🧎🏿‍♀️‍➡️", "🧎🏿‍♂", "🧎🏿‍♂‍➡", "🧎🏿‍♂‍➡️", "🧎🏿‍♂️", "🧎🏿‍♂️‍➡", "🧎🏿‍♂️‍➡️", "🧎🏿‍➡", "🧎🏿‍➡️", "🧏", "🧏‍♀", "🧏‍♀️", "🧏‍♂", "🧏‍♂️", "🧏🏻", "🧏🏻‍♀", "🧏🏻‍♀️", "🧏🏻‍♂", "🧏🏻‍♂️", "🧏🏼", "🧏🏼‍♀", "🧏🏼‍♀️", "🧏🏼‍♂", "🧏🏼‍♂️", "🧏🏽", "🧏🏽‍♀", "🧏🏽‍♀️", "🧏🏽‍♂", "🧏🏽‍♂️", "🧏🏾", "🧏🏾‍♀", "🧏🏾‍♀️", "🧏🏾‍♂", "🧏🏾‍♂️", "🧏🏿", "🧏🏿‍♀", "🧏🏿‍♀️", "🧏🏿‍♂", "🧏🏿‍♂️", "🧐", "🧑", "🧑‍⚕", "🧑‍⚕️", "🧑‍⚖", "🧑‍⚖️", "🧑‍✈", "🧑‍✈️", "🧑‍🌾", "🧑‍🍳", "🧑‍🍼", "🧑‍🎄", "🧑‍🎓", "🧑‍🎤", "🧑‍🎨", "🧑‍🏫", "🧑‍🏭", "🧑‍💻", "🧑‍💼", "🧑‍🔧", "🧑‍🔬", "🧑‍🚀", "🧑‍🚒", "🧑‍🤝‍🧑", "🧑‍🦯", "🧑‍🦯‍➡", "🧑‍🦯‍➡️", "🧑‍🦰", "🧑‍🦱", "🧑‍🦲", "🧑‍🦳", "🧑‍🦼", "🧑‍🦼‍➡", "🧑‍🦼‍➡️", "🧑‍🦽", "🧑‍🦽‍➡", "🧑‍🦽‍➡️", "🧑‍🧑‍🧒", "🧑‍🧑‍🧒‍🧒", "🧑‍🧒", "🧑‍🧒‍🧒", "🧑🏻", "🧑🏻‍⚕", "🧑🏻‍⚕️", "🧑🏻‍⚖", "🧑🏻‍⚖️", "🧑🏻‍✈", "🧑🏻‍✈️", "🧑🏻‍❤‍💋‍🧑🏼", "🧑🏻‍❤‍💋‍🧑🏽", "🧑🏻‍❤‍💋‍🧑🏾", "🧑🏻‍❤‍💋‍🧑🏿", "🧑🏻‍❤‍🧑🏼", "🧑🏻‍❤‍🧑🏽", "🧑🏻‍❤‍🧑🏾", "🧑🏻‍❤‍🧑🏿", "🧑🏻‍❤️‍💋‍🧑🏼", "🧑🏻‍❤️‍💋‍🧑🏽", "🧑🏻‍❤️‍💋‍🧑🏾", "🧑🏻‍❤️‍💋‍🧑🏿", "🧑🏻‍❤️‍🧑🏼", "🧑🏻‍❤️‍🧑🏽", "🧑🏻‍❤️‍🧑🏾", "🧑🏻‍❤️‍🧑🏿", "🧑🏻‍🌾", "🧑🏻‍🍳", "🧑🏻‍🍼", "🧑🏻‍🎄", "🧑🏻‍🎓", "🧑🏻‍🎤", "🧑🏻‍🎨", "🧑🏻‍🏫", "🧑🏻‍🏭", "🧑🏻‍💻", "🧑🏻‍💼", "🧑🏻‍🔧", "🧑🏻‍🔬", "🧑🏻‍🚀", "🧑🏻‍🚒", "🧑🏻‍🤝‍🧑🏻", "🧑🏻‍🤝‍🧑🏼", "🧑🏻‍🤝‍🧑🏽", "🧑🏻‍🤝‍🧑🏾", "🧑🏻‍🤝‍🧑🏿", "🧑🏻‍🦯", "🧑🏻‍🦯‍➡", "🧑🏻‍🦯‍➡️", "🧑🏻‍🦰", "🧑🏻‍🦱", "🧑🏻‍🦲", "🧑🏻‍🦳", "🧑🏻‍🦼", "🧑🏻‍🦼‍➡", "🧑🏻‍🦼‍➡️", "🧑🏻‍🦽", "🧑🏻‍🦽‍➡", "🧑🏻‍🦽‍➡️", "🧑🏼", "🧑🏼‍⚕", "🧑🏼‍⚕️", "🧑🏼‍⚖", "🧑🏼‍⚖️", "🧑🏼‍✈", "🧑🏼‍✈️", "🧑🏼‍❤‍💋‍🧑🏻", "🧑🏼‍❤‍💋‍🧑🏽", "🧑🏼‍❤‍💋‍🧑🏾", "🧑🏼‍❤‍💋‍🧑🏿", "🧑🏼‍❤‍🧑🏻", "🧑🏼‍❤‍🧑🏽", "🧑🏼‍❤‍🧑🏾", "🧑🏼‍❤‍🧑🏿", "🧑🏼‍❤️‍💋‍🧑🏻", "🧑🏼‍❤️‍💋‍🧑🏽", "🧑🏼‍❤️‍💋‍🧑🏾", "🧑🏼‍❤️‍💋‍🧑🏿", "🧑🏼‍❤️‍🧑🏻", "🧑🏼‍❤️‍🧑🏽", "🧑🏼‍❤️‍🧑🏾", "🧑🏼‍❤️‍🧑🏿", "🧑🏼‍🌾", "🧑🏼‍🍳", "🧑🏼‍🍼", "🧑🏼‍🎄", "🧑🏼‍🎓", "🧑🏼‍🎤", "🧑🏼‍🎨", "🧑🏼‍🏫", "🧑🏼‍🏭", "🧑🏼‍💻", "🧑🏼‍💼", "🧑🏼‍🔧", "🧑🏼‍🔬", "🧑🏼‍🚀", "🧑🏼‍🚒", "🧑🏼‍🤝‍🧑🏻", "🧑🏼‍🤝‍🧑🏼", "🧑🏼‍🤝‍🧑🏽", "🧑🏼‍🤝‍🧑🏾", "🧑🏼‍🤝‍🧑🏿", "🧑🏼‍🦯", "🧑🏼‍🦯‍➡", "🧑🏼‍🦯‍➡️", "🧑🏼‍🦰", "🧑🏼‍🦱", "🧑🏼‍🦲", "🧑🏼‍🦳", "🧑🏼‍🦼", "🧑🏼‍🦼‍➡", "🧑🏼‍🦼‍➡️", "🧑🏼‍🦽", "🧑🏼‍🦽‍➡", "🧑🏼‍🦽‍➡️", "🧑🏽", "🧑🏽‍⚕", "🧑🏽‍⚕️", "🧑🏽‍⚖", "🧑🏽‍⚖️", "🧑🏽‍✈", "🧑🏽‍✈️", "🧑🏽‍❤‍💋‍🧑🏻", "🧑🏽‍❤‍💋‍🧑🏼", "🧑🏽‍❤‍💋‍🧑🏾", "🧑🏽‍❤‍💋‍🧑🏿", "🧑🏽‍❤‍🧑🏻", "🧑🏽‍❤‍🧑🏼", "🧑🏽‍❤‍🧑🏾", "🧑🏽‍❤‍🧑🏿", "🧑🏽‍❤️‍💋‍🧑🏻", "🧑🏽‍❤️‍💋‍🧑🏼", "🧑🏽‍❤️‍💋‍🧑🏾", "🧑🏽‍❤️‍💋‍🧑🏿", "🧑🏽‍❤️‍🧑🏻", "🧑🏽‍❤️‍🧑🏼", "🧑🏽‍❤️‍🧑🏾", "🧑🏽‍❤️‍🧑🏿", "🧑🏽‍🌾", "🧑🏽‍🍳", "🧑🏽‍🍼", "🧑🏽‍🎄", "🧑🏽‍🎓", "🧑🏽‍🎤", "🧑🏽‍🎨", "🧑🏽‍🏫", "🧑🏽‍🏭", "🧑🏽‍💻", "🧑🏽‍💼", "🧑🏽‍🔧", "🧑🏽‍🔬", "🧑🏽‍🚀", "🧑🏽‍🚒", "🧑🏽‍🤝‍🧑🏻", "🧑🏽‍🤝‍🧑🏼", "🧑🏽‍🤝‍🧑🏽", "🧑🏽‍🤝‍🧑🏾", "🧑🏽‍🤝‍🧑🏿", "🧑🏽‍🦯", "🧑🏽‍🦯‍➡", "🧑🏽‍🦯‍➡️", "🧑🏽‍🦰", "🧑🏽‍🦱", "🧑🏽‍🦲", "🧑🏽‍🦳", "🧑🏽‍🦼", "🧑🏽‍🦼‍➡", "🧑🏽‍🦼‍➡️", "🧑🏽‍🦽", "🧑🏽‍🦽‍➡", "🧑🏽‍🦽‍➡️", "🧑🏾", "🧑🏾‍⚕", "🧑🏾‍⚕️", "🧑🏾‍⚖", "🧑🏾‍⚖️", "🧑🏾‍✈", "🧑🏾‍✈️", "🧑🏾‍❤‍💋‍🧑🏻", "🧑🏾‍❤‍💋‍🧑🏼", "🧑🏾‍❤‍💋‍🧑🏽", "🧑🏾‍❤‍💋‍🧑🏿", "🧑🏾‍❤‍🧑🏻", "🧑🏾‍❤‍🧑🏼", "🧑🏾‍❤‍🧑🏽", "🧑🏾‍❤‍🧑🏿", "🧑🏾‍❤️‍💋‍🧑🏻", "🧑🏾‍❤️‍💋‍🧑🏼", "🧑🏾‍❤️‍💋‍🧑🏽", "🧑🏾‍❤️‍💋‍🧑🏿", "🧑🏾‍❤️‍🧑🏻", "🧑🏾‍❤️‍🧑🏼", "🧑🏾‍❤️‍🧑🏽", "🧑🏾‍❤️‍🧑🏿", "🧑🏾‍🌾", "🧑🏾‍🍳", "🧑🏾‍🍼", "🧑🏾‍🎄", "🧑🏾‍🎓", "🧑🏾‍🎤", "🧑🏾‍🎨", "🧑🏾‍🏫", "🧑🏾‍🏭", "🧑🏾‍💻", "🧑🏾‍💼", "🧑🏾‍🔧", "🧑🏾‍🔬", "🧑🏾‍🚀", "🧑🏾‍🚒", "🧑🏾‍🤝‍🧑🏻", "🧑🏾‍🤝‍🧑🏼", "🧑🏾‍🤝‍🧑🏽", "🧑🏾‍🤝‍🧑🏾", "🧑🏾‍🤝‍🧑🏿", "🧑🏾‍🦯", "🧑🏾‍🦯‍➡", "🧑🏾‍🦯‍➡️", "🧑🏾‍🦰", "🧑🏾‍🦱", "🧑🏾‍🦲", "🧑🏾‍🦳", "🧑🏾‍🦼", "🧑🏾‍🦼‍➡", "🧑🏾‍🦼‍➡️", "🧑🏾‍🦽", "🧑🏾‍🦽‍➡", "🧑🏾‍🦽‍➡️", "🧑🏿", "🧑🏿‍⚕", "🧑🏿‍⚕️", "🧑🏿‍⚖", "🧑🏿‍⚖️", "🧑🏿‍✈", "🧑🏿‍✈️", "🧑🏿‍❤‍💋‍🧑🏻", "🧑🏿‍❤‍💋‍🧑🏼", "🧑🏿‍❤‍💋‍🧑🏽", "🧑🏿‍❤‍💋‍🧑🏾", "🧑🏿‍❤‍🧑🏻", "🧑🏿‍❤‍🧑🏼", "🧑🏿‍❤‍🧑🏽", "🧑🏿‍❤‍🧑🏾", "🧑🏿‍❤️‍💋‍🧑🏻", "🧑🏿‍❤️‍💋‍🧑🏼", "🧑🏿‍❤️‍💋‍🧑🏽", "🧑🏿‍❤️‍💋‍🧑🏾", "🧑🏿‍❤️‍🧑🏻", "🧑🏿‍❤️‍🧑🏼", "🧑🏿‍❤️‍🧑🏽", "🧑🏿‍❤️‍🧑🏾", "🧑🏿‍🌾", "🧑🏿‍🍳", "🧑🏿‍🍼", "🧑🏿‍🎄", "🧑🏿‍🎓", "🧑🏿‍🎤", "🧑🏿‍🎨", "🧑🏿‍🏫", "🧑🏿‍🏭", "🧑🏿‍💻", "🧑🏿‍💼", "🧑🏿‍🔧", "🧑🏿‍🔬", "🧑🏿‍🚀", "🧑🏿‍🚒", "🧑🏿‍🤝‍🧑🏻", "🧑🏿‍🤝‍🧑🏼", "🧑🏿‍🤝‍🧑🏽", "🧑🏿‍🤝‍🧑🏾", "🧑🏿‍🤝‍🧑🏿", "🧑🏿‍🦯", "🧑🏿‍🦯‍➡", "🧑🏿‍🦯‍➡️", "🧑🏿‍🦰", "🧑🏿‍🦱", "🧑🏿‍🦲", "🧑🏿‍🦳", "🧑🏿‍🦼", "🧑🏿‍🦼‍➡", "🧑🏿‍🦼‍➡️", "🧑🏿‍🦽", "🧑🏿‍🦽‍➡", "🧑🏿‍🦽‍➡️", "🧒", "🧒🏻", "🧒🏼", "🧒🏽", "🧒🏾", "🧒🏿", "🧓", "🧓🏻", "🧓🏼", "🧓🏽", "🧓🏾", "🧓🏿", "🧔", "🧔‍♀", "🧔‍♀️", "🧔‍♂", "🧔‍♂️", "🧔🏻", "🧔🏻‍♀", "🧔🏻‍♀️", "🧔🏻‍♂", "🧔🏻‍♂️", "🧔🏼", "🧔🏼‍♀", "🧔🏼‍♀️", "🧔🏼‍♂", "🧔🏼‍♂️", "🧔🏽", "🧔🏽‍♀", "🧔🏽‍♀️", "🧔🏽‍♂", "🧔🏽‍♂️", "🧔🏾", "🧔🏾‍♀", "🧔🏾‍♀️", "🧔🏾‍♂", "🧔🏾‍♂️", "🧔🏿", "🧔🏿‍♀", "🧔🏿‍♀️", "🧔🏿‍♂", "🧔🏿‍♂️", "🧕", "🧕🏻", "🧕🏼", "🧕🏽", "🧕🏾", "🧕🏿", "🧖", "🧖‍♀", "🧖‍♀️", "🧖‍♂", "🧖‍♂️", "🧖🏻", "🧖🏻‍♀", "🧖🏻‍♀️", "🧖🏻‍♂", "🧖🏻‍♂️", "🧖🏼", "🧖🏼‍♀", "🧖🏼‍♀️", "🧖🏼‍♂", "🧖🏼‍♂️", "🧖🏽", "🧖🏽‍♀", "🧖🏽‍♀️", "🧖🏽‍♂", "🧖🏽‍♂️", "🧖🏾", "🧖🏾‍♀", "🧖🏾‍♀️", "🧖🏾‍♂", "🧖🏾‍♂️", "🧖🏿", "🧖🏿‍♀", "🧖🏿‍♀️", "🧖🏿‍♂", "🧖🏿‍♂️", "🧗", "🧗‍♀", "🧗‍♀️", "🧗‍♂", "🧗‍♂️", "🧗🏻", "🧗🏻‍♀", "🧗🏻‍♀️", "🧗🏻‍♂", "🧗🏻‍♂️", "🧗🏼", "🧗🏼‍♀", "🧗🏼‍♀️", "🧗🏼‍♂", "🧗🏼‍♂️", "🧗🏽", "🧗🏽‍♀", "🧗🏽‍♀️", "🧗🏽‍♂", "🧗🏽‍♂️", "🧗🏾", "🧗🏾‍♀", "🧗🏾‍♀️", "🧗🏾‍♂", "🧗🏾‍♂️", "🧗🏿", "🧗🏿‍♀", "🧗🏿‍♀️", "🧗🏿‍♂", "🧗🏿‍♂️", "🧘", "🧘‍♀", "🧘‍♀️", "🧘‍♂", "🧘‍♂️", "🧘🏻", "🧘🏻‍♀", "🧘🏻‍♀️", "🧘🏻‍♂", "🧘🏻‍♂️", "🧘🏼", "🧘🏼‍♀", "🧘🏼‍♀️", "🧘🏼‍♂", "🧘🏼‍♂️", "🧘🏽", "🧘🏽‍♀", "🧘🏽‍♀️", "🧘🏽‍♂", "🧘🏽‍♂️", "🧘🏾", "🧘🏾‍♀", "🧘🏾‍♀️", "🧘🏾‍♂", "🧘🏾‍♂️", "🧘🏿", "🧘🏿‍♀", "🧘🏿‍♀️", "🧘🏿‍♂", "🧘🏿‍♂️", "🧙", "🧙‍♀", "🧙‍♀️", "🧙‍♂", "🧙‍♂️", "🧙🏻", "🧙🏻‍♀", "🧙🏻‍♀️", "🧙🏻‍♂", "🧙🏻‍♂️", "🧙🏼", "🧙🏼‍♀", "🧙🏼‍♀️", "🧙🏼‍♂", "🧙🏼‍♂️", "🧙🏽", "🧙🏽‍♀", "🧙🏽‍♀️", "🧙🏽‍♂", "🧙🏽‍♂️", "🧙🏾", "🧙🏾‍♀", "🧙🏾‍♀️", "🧙🏾‍♂", "🧙🏾‍♂️", "🧙🏿", "🧙🏿‍♀", "🧙🏿‍♀️", "🧙🏿‍♂", "🧙🏿‍♂️", "🧚", "🧚‍♀", "🧚‍♀️", "🧚‍♂", "🧚‍♂️", "🧚🏻", "🧚🏻‍♀", "🧚🏻‍♀️", "🧚🏻‍♂", "🧚🏻‍♂️", "🧚🏼", "🧚🏼‍♀", "🧚🏼‍♀️", "🧚🏼‍♂", "🧚🏼‍♂️", "🧚🏽", "🧚🏽‍♀", "🧚🏽‍♀️", "🧚🏽‍♂", "🧚🏽‍♂️", "🧚🏾", "🧚🏾‍♀", "🧚🏾‍♀️", "🧚🏾‍♂", "🧚🏾‍♂️", "🧚🏿", "🧚🏿‍♀", "🧚🏿‍♀️", "🧚🏿‍♂", "🧚🏿‍♂️", "🧛", "🧛‍♀", "🧛‍♀️", "🧛‍♂", "🧛‍♂️", "🧛🏻", "🧛🏻‍♀", "🧛🏻‍♀️", "🧛🏻‍♂", "🧛🏻‍♂️", "🧛🏼", "🧛🏼‍♀", "🧛🏼‍♀️", "🧛🏼‍♂", "🧛🏼‍♂️", "🧛🏽", "🧛🏽‍♀", "🧛🏽‍♀️", "🧛🏽‍♂", "🧛🏽‍♂️", "🧛🏾", "🧛🏾‍♀", "🧛🏾‍♀️", "🧛🏾‍♂", "🧛🏾‍♂️", "🧛🏿", "🧛🏿‍♀", "🧛🏿‍♀️", "🧛🏿‍♂", "🧛🏿‍♂️", "🧜", "🧜‍♀", "🧜‍♀️", "🧜‍♂", "🧜‍♂️", "🧜🏻", "🧜🏻‍♀", "🧜🏻‍♀️", "🧜🏻‍♂", "🧜🏻‍♂️", "🧜🏼", "🧜🏼‍♀", "🧜🏼‍♀️", "🧜🏼‍♂", "🧜🏼‍♂️", "🧜🏽", "🧜🏽‍♀", "🧜🏽‍♀️", "🧜🏽‍♂", "🧜🏽‍♂️", "🧜🏾", "🧜🏾‍♀", "🧜🏾‍♀️", "🧜🏾‍♂", "🧜🏾‍♂️", "🧜🏿", "🧜🏿‍♀", "🧜🏿‍♀️", "🧜🏿‍♂", "🧜🏿‍♂️", "🧝", "🧝‍♀", "🧝‍♀️", "🧝‍♂", "🧝‍♂️", "🧝🏻", "🧝🏻‍♀", "🧝🏻‍♀️", "🧝🏻‍♂", "🧝🏻‍♂️", "🧝🏼", "🧝🏼‍♀", "🧝🏼‍♀️", "🧝🏼‍♂", "🧝🏼‍♂️", "🧝🏽", "🧝🏽‍♀", "🧝🏽‍♀️", "🧝🏽‍♂", "🧝🏽‍♂️", "🧝🏾", "🧝🏾‍♀", "🧝🏾‍♀️", "🧝🏾‍♂", "🧝🏾‍♂️", "🧝🏿", "🧝🏿‍♀", "🧝🏿‍♀️", "🧝🏿‍♂", "🧝🏿‍♂️", "🧞", "🧞‍♀", "🧞‍♀️", "🧞‍♂", "🧞‍♂️", "🧟", "🧟‍♀", "🧟‍♀️", "🧟‍♂", "🧟‍♂️", "🧠", "🧡", "🧢", "🧣", "🧤", "🧥", "🧦", "🧧", "🧨", "🧩", "🧪", "🧫", "🧬", "🧭", "🧮", "🧯", "🧰", "🧱", "🧲", "🧳", "🧴", "🧵", "🧶", "🧷", "🧸", "🧹", "🧺", "🧻", "🧼", "🧽", "🧾", "🧿", "🩰", "🩱", "🩲", "🩳", "🩴", "🩵", "🩶", "🩷", "🩸", "🩹", "🩺", "🩻", "🩼", "🪀", "🪁", "🪂", "🪃", "🪄", "🪅", "🪆", "🪇", "🪈", "🪉", "🪏", "🪐", "🪑", "🪒", "🪓", "🪔", "🪕", "🪖", "🪗", "🪘", "🪙", "🪚", "🪛", "🪜", "🪝", "🪞", "🪟", "🪠", "🪡", "🪢", "🪣", "🪤", "🪥", "🪦", "🪧", "🪨", "🪩", "🪪", "🪫", "🪬", "🪭", "🪮", "🪯", "🪰", "🪱", "🪲", "🪳", "🪴", "🪵", "🪶", "🪷", "🪸", "🪹", "🪺", "🪻", "🪼", "🪽", "🪾", "🪿", "🫀", "🫁", "🫂", "🫃", "🫃🏻", "🫃🏼", "🫃🏽", "🫃🏾", "🫃🏿", "🫄", "🫄🏻", "🫄🏼", "🫄🏽", "🫄🏾", "🫄🏿", "🫅", "🫅🏻", "🫅🏼", "🫅🏽", "🫅🏾", "🫅🏿", "🫆", "🫎", "🫏", "🫐", "🫑", "🫒", "🫓", "🫔", "🫕", "🫖", "🫗", "🫘", "🫙", "🫚", "🫛", "🫜", "🫟", "🫠", "🫡", "🫢", "🫣", "🫤", "🫥", "🫦", "🫧", "🫨", "🫩", "🫰", "🫰🏻", "🫰🏼", "🫰🏽", "🫰🏾", "🫰🏿", "🫱", "🫱🏻", "🫱🏻‍🫲🏼", "🫱🏻‍🫲🏽", "🫱🏻‍🫲🏾", "🫱🏻‍🫲🏿", "🫱🏼", "🫱🏼‍🫲🏻", "🫱🏼‍🫲🏽", "🫱🏼‍🫲🏾", "🫱🏼‍🫲🏿", "🫱🏽", "🫱🏽‍🫲🏻", "🫱🏽‍🫲🏼", "🫱🏽‍🫲🏾", "🫱🏽‍🫲🏿", "🫱🏾", "🫱🏾‍🫲🏻", "🫱🏾‍🫲🏼", "🫱🏾‍🫲🏽", "🫱🏾‍🫲🏿", "🫱🏿", "🫱🏿‍🫲🏻", "🫱🏿‍🫲🏼", "🫱🏿‍🫲🏽", "🫱🏿‍🫲🏾", "🫲", "🫲🏻", "🫲🏼", "🫲🏽", "🫲🏾", "🫲🏿", "🫳", "🫳🏻", "🫳🏼", "🫳🏽", "🫳🏾", "🫳🏿", "🫴", "🫴🏻", "🫴🏼", "🫴🏽", "🫴🏾", "🫴🏿", "🫵", "🫵🏻", "🫵🏼", "🫵🏽", "🫵🏾", "🫵🏿", "🫶", "🫶🏻", "🫶🏼", "🫶🏽", "🫶🏾", "🫶🏿", "🫷", "🫷🏻", "🫷🏼", "🫷🏽", "🫷🏾", "🫷🏿", "🫸", "🫸🏻", "🫸🏼", "🫸🏽", "🫸🏾", "🫸🏿"}
### EMOJIS END ###


# The ESCAPED_EMOJI list is sorted in descending order to make that longer emoji appear
# first in the regex compiled below. This ensures that we grab the full emoji in a
# multi-character emoji sequence that starts with a shorter emoji (emoji are weird...).
ESCAPED_EMOJI = [re.escape(e) for e in sorted(ALL_EMOJIS, reverse=True)]
EMOJI_EXTRACTION_REGEX = re.compile(f"^({'|'.join(ESCAPED_EMOJI)})[_ -]*(.*)")
