/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.mrtree.TreeUtil;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.EdgeRoutingMode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.Triple;

public class CompactionProcessor
implements ILayoutProcessor<TGraph> {
    private List<Pair<Double, Double>> levels;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Process compaction", 1.0f);
        if (!tGraph.getProperty(MrTreeOptions.COMPACTION).booleanValue()) {
            return;
        }
        Direction dir = tGraph.getProperty(MrTreeOptions.DIRECTION);
        double nodeNodeSpacing = tGraph.getProperty(MrTreeOptions.SPACING_NODE_NODE);
        this.setUpLevels(tGraph, dir);
        this.computeNodeConstraints(tGraph, nodeNodeSpacing / 2.0 / 2.0);
        List<TNode> nodes = tGraph.getNodes();
        nodes.sort((x, y) -> Double.compare(TreeUtil.getDirectionVector(dir).dotProduct(new KVector(x.getPosition().x, x.getPosition().y)), TreeUtil.getDirectionVector(dir).dotProduct(new KVector(y.getPosition().x, y.getPosition().y))));
        for (TNode n : nodes) {
            if (n.getProperty(InternalProperties.ROOT).booleanValue()) continue;
            TNode d = this.getLowestDependentNode(n, dir);
            TNode p = TreeUtil.getLowestParent(n, tGraph);
            double newPos = 0.0;
            double newPosSize = 0.0;
            if (d != null) {
                KVector pos = d.getPosition();
                switch (dir) {
                    case LEFT: {
                        newPos = pos.x - nodeNodeSpacing - n.getSize().x;
                        if (p.getPosition().x - nodeNodeSpacing - n.getSize().x < newPos) {
                            newPos = p.getPosition().x - nodeNodeSpacing - n.getSize().x;
                        }
                        newPosSize = newPos + n.getSize().x;
                        break;
                    }
                    case RIGHT: {
                        newPos = pos.x + d.getSize().x + nodeNodeSpacing;
                        if (p.getPosition().x + nodeNodeSpacing > newPos) {
                            newPos = p.getPosition().x + p.getSize().x + nodeNodeSpacing;
                        }
                        newPosSize = newPos + n.getSize().x;
                        break;
                    }
                    case UP: {
                        newPos = pos.y - nodeNodeSpacing - n.getSize().y;
                        if (p.getPosition().y - nodeNodeSpacing - n.getSize().y < newPos) {
                            newPos = p.getPosition().y - nodeNodeSpacing - n.getSize().y;
                        }
                        newPosSize = newPos + n.getSize().y;
                        break;
                    }
                    case DOWN: {
                        newPos = pos.y + d.getSize().y + nodeNodeSpacing;
                        if (p.getPosition().y + nodeNodeSpacing > newPos) {
                            newPos = p.getPosition().y + p.getSize().y + nodeNodeSpacing;
                        }
                        newPosSize = newPos + n.getSize().y;
                    }
                }
            } else if (p != null) {
                switch (dir) {
                    case LEFT: {
                        newPos = p.getPosition().x - nodeNodeSpacing - n.getSize().x;
                        newPosSize = newPos + n.getSize().x;
                        break;
                    }
                    case RIGHT: {
                        newPos = p.getPosition().x + p.getSize().x + nodeNodeSpacing;
                        newPosSize = newPos + n.getSize().x;
                        break;
                    }
                    case UP: {
                        newPos = p.getPosition().y - nodeNodeSpacing - n.getSize().y;
                        newPosSize = newPos + n.getSize().y;
                        break;
                    }
                    case DOWN: {
                        newPos = p.getPosition().y + p.getSize().y + nodeNodeSpacing;
                        newPosSize = newPos + n.getSize().y;
                    }
                }
            }
            if (tGraph.getProperty(MrTreeOptions.EDGE_ROUTING_MODE) == EdgeRoutingMode.AVOID_OVERLAP) {
                int newIndex;
                double finalNewPos = newPos;
                double finalNewPosSize = newPosSize;
                Optional<Pair> level = this.levels.stream().filter(x -> (Double)x.getFirst() <= finalNewPos && (Double)x.getSecond() >= finalNewPosSize).findFirst();
                if (level.isPresent()) {
                    if (dir.isHorizontal()) {
                        n.getPosition().x = newPos;
                    } else {
                        n.getPosition().y = newPos;
                    }
                } else {
                    level = dir == Direction.LEFT || dir == Direction.UP ? this.levels.stream().skip(1L).filter(x -> (Double)x.getFirst() <= finalNewPos).findFirst() : this.levels.stream().skip(1L).filter(x -> (Double)x.getFirst() >= finalNewPos).findFirst();
                    if (level.isPresent()) {
                        if (dir.isHorizontal()) {
                            n.getPosition().x = (Double)level.get().getFirst();
                        } else {
                            n.getPosition().y = (Double)level.get().getFirst();
                        }
                    }
                }
                if (!level.isPresent() || (newIndex = this.levels.indexOf(level.get())) <= 0 || newIndex == n.getProperty(MrTreeOptions.TREE_LEVEL)) continue;
                n.setProperty(InternalProperties.COMPACT_LEVEL_ASCENSION, (Object)true);
                n.setProperty(MrTreeOptions.TREE_LEVEL, (Object)newIndex);
                continue;
            }
            if (dir.isHorizontal()) {
                n.getPosition().x = newPos;
                continue;
            }
            n.getPosition().y = newPos;
        }
        progressMonitor.done();
    }

    void setUpLevels(TGraph tGraph, Direction dir) {
        this.levels = new ArrayList<Pair<Double, Double>>();
        for (TNode n : tGraph.getNodes()) {
            while (n.getProperty(MrTreeOptions.TREE_LEVEL) > this.levels.size() - 1) {
                this.levels.add(new Pair<Double, Double>((Double)Double.MAX_VALUE, -1.7976931348623157E308));
            }
            int curLevel = n.getProperty(MrTreeOptions.TREE_LEVEL);
            if (dir.isHorizontal()) {
                if (n.getPosition().x < this.levels.get(curLevel).getFirst()) {
                    this.levels.get(curLevel).setFirst(n.getPosition().x);
                }
                if (!(n.getPosition().x + n.getSize().x > this.levels.get(curLevel).getSecond())) continue;
                this.levels.get(curLevel).setSecond(n.getPosition().x + n.getSize().x);
                continue;
            }
            if (n.getPosition().y < this.levels.get(curLevel).getFirst()) {
                this.levels.get(curLevel).setFirst(n.getPosition().y);
            }
            if (!(n.getPosition().y + n.getSize().y > this.levels.get(curLevel).getSecond())) continue;
            this.levels.get(curLevel).setSecond(n.getPosition().y + n.getSize().y);
        }
    }

    void computeNodeConstraints(TGraph tGraph, double nodeNodeSpacing) {
        Direction d = tGraph.getProperty(MrTreeOptions.DIRECTION);
        Direction right = d.isHorizontal() ? Direction.DOWN : Direction.RIGHT;
        List actualNodes = tGraph.getNodes().stream().filter(x -> !x.getLabel().contains("SUPER_ROOT")).collect(Collectors.toList());
        List points = actualNodes.stream().map(x -> new Triple<TNode, KVector, Boolean>((TNode)x, x.getPosition().clone().sub(nodeNodeSpacing, nodeNodeSpacing), true)).collect(Collectors.toList());
        points.addAll(actualNodes.stream().map(x -> new Triple<TNode, KVector, Boolean>((TNode)x, x.getPosition().clone().add(x.getSize().x + nodeNodeSpacing, x.getSize().y + nodeNodeSpacing), false)).collect(Collectors.toList()));
        points.sort((x, y) -> Double.compare(TreeUtil.getDirectionVector(right).dotProduct(((KVector)x.getSecond()).clone()), TreeUtil.getDirectionVector(right).dotProduct(((KVector)y.getSecond()).clone())));
        TreeSet<TNode> s2 = new TreeSet<TNode>((x, y) -> Double.compare(TreeUtil.getDirectionVector(d).dotProduct(x.getPosition().clone()), TreeUtil.getDirectionVector(d).dotProduct(y.getPosition().clone())));
        HashMap<TNode, TNode> cand = new HashMap<TNode, TNode>();
        for (Triple p : points) {
            TNode rightNode;
            TNode leftNode;
            TNode r = (TNode)p.getFirst();
            if (((Boolean)p.getThird()).booleanValue()) {
                s2.add(r);
                if (s2.headSet(r).size() > 0) {
                    cand.put(r, s2.headSet(r).last());
                }
                if (s2.tailSet(r).size() <= 1) continue;
                cand.put(this.getRightElement(s2, r), r);
                continue;
            }
            if (s2.headSet(r).size() > 0 && (leftNode = s2.headSet(r).last()) == cand.get(r)) {
                r.getProperty(InternalProperties.COMPACT_CONSTRAINTS).add(leftNode);
            }
            if (s2.tailSet(r).size() > 1 && cand.get(rightNode = this.getRightElement(s2, r)) == r) {
                rightNode.getProperty(InternalProperties.COMPACT_CONSTRAINTS).add(r);
            }
            s2.remove(r);
        }
    }

    TNode getRightElement(SortedSet<TNode> s2, TNode n) {
        SortedSet<TNode> tailSet = s2.tailSet(n);
        if (tailSet.size() <= 1) {
            throw new NullPointerException();
        }
        Iterator i = tailSet.iterator();
        i.next();
        return (TNode)i.next();
    }

    TNode getLowestDependentNode(TNode n, Direction d) {
        List<TNode> cons = n.getProperty(InternalProperties.COMPACT_CONSTRAINTS);
        if (cons == null || cons.size() < 1) {
            return null;
        }
        if (cons.size() == 1) {
            return cons.get(0);
        }
        TNode lowestCons = null;
        switch (d) {
            case LEFT: {
                lowestCons = (TNode)cons.stream().min((x, y) -> Double.compare(x.getPosition().x, y.getPosition().x)).get();
                break;
            }
            case RIGHT: {
                lowestCons = (TNode)cons.stream().max((x, y) -> Double.compare(x.getPosition().x + x.getSize().x, y.getPosition().x + y.getSize().x)).get();
                break;
            }
            case UP: {
                lowestCons = (TNode)cons.stream().min((x, y) -> Double.compare(x.getPosition().y, y.getPosition().y)).get();
                break;
            }
            case DOWN: {
                lowestCons = (TNode)cons.stream().max((x, y) -> Double.compare(x.getPosition().y + x.getSize().y, y.getPosition().y + y.getSize().y)).get();
            }
        }
        return lowestCons;
    }
}

