/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class LNode
extends LShape {
    private static final long serialVersionUID = -4272570519129722541L;
    private LGraph graph;
    private Layer layer;
    private NodeType type = NodeType.NORMAL;
    private final List<LPort> ports = Lists.newArrayListWithCapacity(6);
    private final List<LLabel> labels = Lists.newArrayListWithCapacity(2);
    private LGraph nestedGraph;
    private final LMargin margin = new LMargin();
    private final LPadding padding = new LPadding();
    private EnumMap<PortSide, Pair<Integer, Integer>> portSideIndices;
    private boolean portSidesCached = false;

    public LNode(LGraph graph) {
        this.graph = graph;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer thelayer) {
        if (this.layer != null) {
            this.layer.getNodes().remove(this);
        }
        this.layer = thelayer;
        if (this.layer != null) {
            this.layer.getNodes().add(this);
        }
    }

    public LGraph getGraph() {
        if (this.graph == null && this.layer != null) {
            return this.layer.getGraph();
        }
        return this.graph;
    }

    public void setGraph(LGraph newGraph) {
        assert (this.layer == null);
        this.graph = newGraph;
    }

    public void setLayer(int index, Layer newlayer) {
        if (newlayer != null && (index < 0 || index > newlayer.getNodes().size())) {
            throw new IllegalArgumentException("index must be >= 0 and <= layer node count");
        }
        if (this.layer != null) {
            this.layer.getNodes().remove(this);
        }
        this.layer = newlayer;
        if (newlayer != null) {
            newlayer.getNodes().add(index, this);
        }
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public Iterable<LPort> getPorts(PortType portType) {
        switch (portType) {
            case INPUT: {
                return Iterables.filter(this.ports, LPort.INPUT_PREDICATE);
            }
            case OUTPUT: {
                return Iterables.filter(this.ports, LPort.OUTPUT_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<LPort> getPorts(PortSide side) {
        switch (side) {
            case NORTH: {
                return Iterables.filter(this.ports, LPort.NORTH_PREDICATE);
            }
            case EAST: {
                return Iterables.filter(this.ports, LPort.EAST_PREDICATE);
            }
            case SOUTH: {
                return Iterables.filter(this.ports, LPort.SOUTH_PREDICATE);
            }
            case WEST: {
                return Iterables.filter(this.ports, LPort.WEST_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public List<LPort> getPortSideView(PortSide side) {
        Pair<Integer, Integer> indices;
        if (!this.portSidesCached) {
            this.findPortIndices();
        }
        if ((indices = this.portSideIndices.get((Object)side)) == null) {
            return Collections.emptyList();
        }
        return this.ports.subList(indices.getFirst(), indices.getSecond());
    }

    public Iterable<LPort> getPorts(PortType portType, PortSide side) {
        Predicate<LPort> typePredicate = null;
        switch (portType) {
            case INPUT: {
                typePredicate = LPort.INPUT_PREDICATE;
                break;
            }
            case OUTPUT: {
                typePredicate = LPort.OUTPUT_PREDICATE;
            }
        }
        Predicate<LPort> sidePredicate = null;
        switch (side) {
            case NORTH: {
                sidePredicate = LPort.NORTH_PREDICATE;
                break;
            }
            case EAST: {
                sidePredicate = LPort.EAST_PREDICATE;
                break;
            }
            case SOUTH: {
                sidePredicate = LPort.SOUTH_PREDICATE;
                break;
            }
            case WEST: {
                sidePredicate = LPort.WEST_PREDICATE;
            }
        }
        if (typePredicate != null && sidePredicate != null) {
            return Iterables.filter(this.ports, Predicates.and(typePredicate, sidePredicate));
        }
        return Collections.emptyList();
    }

    public Iterable<LEdge> getIncomingEdges() {
        ArrayList<List<LEdge>> iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getIncomingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getOutgoingEdges() {
        ArrayList<List<LEdge>> iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getConnectedEdges() {
        ArrayList<Iterable<LEdge>> iterables = Lists.newArrayList();
        for (LPort port : this.ports) {
            iterables.add(port.getConnectedEdges());
        }
        return Iterables.concat(iterables);
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LGraph getNestedGraph() {
        return this.nestedGraph;
    }

    public void setNestedGraph(LGraph nestedGraph) {
        this.nestedGraph = nestedGraph;
    }

    public LMargin getMargin() {
        return this.margin;
    }

    public LPadding getPadding() {
        return this.padding;
    }

    public int getIndex() {
        if (this.layer == null) {
            return -1;
        }
        return this.layer.getNodes().indexOf(this);
    }

    public void borderToContentAreaCoordinates(boolean horizontal, boolean vertical) {
        LGraph thegraph = this.getGraph();
        LPadding graphPadding = thegraph.getPadding();
        KVector offset = thegraph.getOffset();
        KVector pos = this.getPosition();
        if (horizontal) {
            pos.x = pos.x - graphPadding.left - offset.x;
        }
        if (vertical) {
            pos.y = pos.y - graphPadding.top - offset.y;
        }
    }

    public KVector getInteractiveReferencePoint() {
        switch (this.getGraph().getProperty(LayeredOptions.INTERACTIVE_REFERENCE_POINT)) {
            case CENTER: {
                KVector nodePos = this.getPosition();
                KVector nodeSize = this.getSize();
                return new KVector(nodePos.x + nodeSize.x / 2.0, nodePos.y + nodeSize.y / 2.0);
            }
            case TOP_LEFT: {
                return new KVector(this.getPosition());
            }
        }
        return null;
    }

    public void cachePortSides() {
        this.portSidesCached = true;
        this.findPortIndices();
    }

    private void findPortIndices() {
        this.portSideIndices = Maps.newEnumMap(PortSide.class);
        int firstIndexForCurrentSide = 0;
        PortSide currentSide = PortSide.NORTH;
        int currentIndex = 0;
        while (currentIndex < this.ports.size()) {
            LPort port = this.ports.get(currentIndex);
            if (port.getSide() != currentSide) {
                if (firstIndexForCurrentSide != currentIndex) {
                    this.portSideIndices.put(currentSide, Pair.of(firstIndexForCurrentSide, currentIndex));
                }
                currentSide = port.getSide();
                firstIndexForCurrentSide = currentIndex;
            }
            ++currentIndex;
        }
        this.portSideIndices.put(currentSide, Pair.of(firstIndexForCurrentSide, currentIndex));
    }

    @Override
    public String getDesignation() {
        if (!this.labels.isEmpty() && !Strings.isNullOrEmpty(this.labels.get(0).getText())) {
            return this.labels.get(0).getText();
        }
        String id = super.getDesignation();
        if (id != null) {
            return id;
        }
        return Integer.toString(this.getIndex());
    }

    public boolean isInlineEdgeLabel() {
        return this.getType() == NodeType.LABEL && this.getProperty(InternalProperties.REPRESENTED_LABELS).stream().allMatch(label -> label.getProperty(LayeredOptions.EDGE_LABELS_INLINE));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("n");
        if (this.type != NodeType.NORMAL) {
            result.append("(").append(this.type.toString().toLowerCase()).append(")");
        }
        result.append("_").append(this.getDesignation());
        return result.toString();
    }

    public static enum NodeType {
        NORMAL,
        LONG_EDGE,
        EXTERNAL_PORT,
        NORTH_SOUTH_PORT,
        LABEL,
        BREAKING_POINT;


        public String getColor() {
            switch (this) {
                case EXTERNAL_PORT: {
                    return "#cc99cc";
                }
                case LONG_EDGE: {
                    return "#eaed00";
                }
                case NORTH_SOUTH_PORT: {
                    return "#0034de";
                }
                case LABEL: {
                    return "#75c3c3";
                }
                case BREAKING_POINT: {
                    return "#eeeeff";
                }
            }
            return "#eeeeee";
        }
    }
}

