/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.zopfli;

import net.sourceforge.plantuml.zopfli.Cookie;
import net.sourceforge.plantuml.zopfli.Deflate;
import net.sourceforge.plantuml.zopfli.Hash;
import net.sourceforge.plantuml.zopfli.LongestMatchCache;
import net.sourceforge.plantuml.zopfli.LzStore;
import net.sourceforge.plantuml.zopfli.SymbolStats;
import net.sourceforge.plantuml.zopfli.Util;

class Squeeze {
    Squeeze() {
    }

    static LzStore optimal(Cookie cookie, int numIterations, LongestMatchCache lmc, byte[] input, int from, int to) {
        LzStore currentStore = cookie.store1;
        currentStore.reset();
        LzStore store = cookie.store2;
        Deflate.greedy(cookie, lmc, input, from, to, currentStore);
        SymbolStats stats = cookie.stats;
        SymbolStats bestStats = cookie.bestStats;
        SymbolStats lastStats = cookie.lastStats;
        stats.getFreqs(currentStore);
        char[] lengthArray = cookie.lengthArray;
        long[] costs = cookie.costs;
        int bestCost = Integer.MAX_VALUE;
        int lastCost = 0;
        int lastRandomStep = -1;
        for (int i = 0; i < numIterations; ++i) {
            currentStore.reset();
            Squeeze.bestLengths(cookie, lmc, from, input, from, to, stats.minCost(), stats, lengthArray, costs);
            Squeeze.optimalRun(cookie, lmc, input, from, to, lengthArray, currentStore);
            int cost = Deflate.calculateBlockSize(cookie, currentStore.litLens, currentStore.dists, 0, currentStore.size);
            if (cost < bestCost) {
                store.copy(currentStore);
                bestStats.copy(stats);
                bestCost = cost;
            }
            lastStats.copy(stats);
            stats.getFreqs(currentStore);
            if (lastRandomStep != -1) {
                stats.alloy(lastStats);
                stats.calculate();
            }
            if (i > 5 && cost == lastCost) {
                stats.copy(bestStats);
                cookie.rnd = stats.randomizeFreqs(cookie.rnd);
                stats.calculate();
                lastRandomStep = i;
            }
            lastCost = cost;
        }
        return store;
    }

    static void optimalRun(Cookie cookie, LongestMatchCache lmc, byte[] input, int from, int to, char[] lengthArray, LzStore store) {
        char las;
        char[] path = cookie.path;
        int pathSize = 0;
        int size = to - from;
        do {
            las = lengthArray[size];
            path[pathSize++] = las;
        } while ((size -= las) != 0);
        int windowStart = Math.max(from - 32768, 0);
        Hash h2 = cookie.h;
        h2.init(input, windowStart, from, to);
        int pos = from;
        do {
            h2.updateHash(input, pos, to);
            int length = path[--pathSize];
            if (length >= 3) {
                Deflate.findLongestMatch(cookie, lmc, from, h2, input, pos, to, length, null);
                store.append((char)length, (char)cookie.distVal);
            } else {
                length = 1;
                store.append((char)(input[pos] & 0xFF), '\u0000');
            }
            for (int j = 1; j < length; ++j) {
                h2.updateHash(input, pos + j, to);
            }
            pos += length;
        } while (pathSize != 0);
    }

    private static long fixedCost(int litLen, int dist) {
        if (dist == 0) {
            if (litLen <= 143) {
                return 8L;
            }
            return 9L;
        }
        long cost = 12 + (dist < 4097 ? Util.CACHED_DIST_EXTRA_BITS[dist] : (dist < 16385 ? (dist < 8193 ? 11 : 12) : 13)) + Util.LENGTH_EXTRA_BITS[litLen];
        if (Util.LENGTH_SYMBOL[litLen] > 279) {
            return cost + 1L;
        }
        return cost;
    }

    private static void bestLengths(Cookie cookie, LongestMatchCache lmc, int blockStart, byte[] input, int from, int to, long minCost, SymbolStats stats, char[] lengthArray, long[] costs) {
        int windowStart = Math.max(from - 32768, 0);
        Hash h2 = cookie.h;
        h2.init(input, windowStart, from, to);
        Cookie.fillCostMax(costs, to - from + 1);
        costs[0] = 0L;
        lengthArray[0] = '\u0000';
        int[] same = h2.same;
        char[] subLen = cookie.c259a;
        System.arraycopy(Cookie.charZeroes, 0, subLen, 0, 259);
        long[] slLiterals = stats.lLiterals;
        long[] slLengths = stats.lLengths;
        long[] sdSymbols = stats.dSymbols;
        long stepCost = slLengths[258] + sdSymbols[0];
        int[] cachedDistSymbol = Util.CACHED_DIST_SYMBOL;
        int i = from;
        int j = 0;
        while (i < to) {
            long newCost;
            h2.updateHash(input, i, to);
            if (same[i & Short.MAX_VALUE] > 516 && i > from + 259 && i + 517 < to && same[i - 258 & Short.MAX_VALUE] > 258) {
                for (int k = 0; k < 258; ++k) {
                    costs[j + 258] = costs[j] + stepCost;
                    lengthArray[j + 258] = 258;
                    ++j;
                    h2.updateHash(input, ++i, to);
                }
            }
            Deflate.findLongestMatch(cookie, lmc, blockStart, h2, input, i, to, 258, subLen);
            long costsJ = costs[j];
            if (i + 1 <= to && (newCost = costsJ + slLiterals[input[i] & 0xFF]) < costs[j + 1]) {
                costs[j + 1] = newCost;
                lengthArray[j + 1] = '\u0001';
            }
            int lenValue = cookie.lenVal;
            long baseCost = minCost + costsJ;
            if (lenValue > to - i) {
                lenValue = to - i;
            }
            int jpk = j + 3;
            int k = 3;
            while (k <= lenValue) {
                long newCost2;
                if (costs[jpk] > baseCost && costs[jpk] > (newCost2 = costsJ + (slLengths[k] + sdSymbols[cachedDistSymbol[subLen[k]]]))) {
                    costs[jpk] = newCost2;
                    lengthArray[jpk] = k;
                }
                k = (char)(k + 1);
                ++jpk;
            }
            ++i;
            ++j;
        }
    }

    static void bestFixedLengths(Cookie cookie, LongestMatchCache lmc, byte[] input, int from, int to, char[] lengthArray, long[] costs) {
        int windowStart = Math.max(from - 32768, 0);
        Hash h2 = cookie.h;
        h2.init(input, windowStart, from, to);
        Cookie.fillCostMax(costs, to - from + 1);
        costs[0] = 0L;
        lengthArray[0] = '\u0000';
        char[] subLen = cookie.c259a;
        for (int i = from; i < to; ++i) {
            long newCost;
            int j = i - from;
            h2.updateHash(input, i, to);
            if (h2.same[i & Short.MAX_VALUE] > 516 && i > from + 258 + 1 && i + 516 + 1 < to && h2.same[i - 258 & Short.MAX_VALUE] > 258) {
                long symbolCost = Squeeze.fixedCost(258, 1);
                for (int k = 0; k < 258; ++k) {
                    costs[j + 258] = costs[j] + symbolCost;
                    lengthArray[j + 258] = 258;
                    ++j;
                    h2.updateHash(input, ++i, to);
                }
            }
            Deflate.findLongestMatch(cookie, lmc, from, h2, input, i, to, 258, subLen);
            if (i + 1 <= to && (newCost = costs[j] + Squeeze.fixedCost(input[i] & 0xFF, 0)) < costs[j + 1]) {
                costs[j + 1] = newCost;
                lengthArray[j + 1] = '\u0001';
            }
            int lenValue = cookie.lenVal;
            for (int k = 3; k <= lenValue && i + k <= to; k = (int)((char)(k + 1))) {
                long newCost2;
                if ((double)(costs[j + k] - costs[j]) <= 12.0 || (newCost2 = costs[j] + Squeeze.fixedCost(k, subLen[k])) >= costs[j + k]) continue;
                costs[j + k] = newCost2;
                lengthArray[j + k] = k;
            }
        }
    }
}

