/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.command.AddStyle;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleCache;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.regex.Matcher2;

public class CommandCreoleStyle
extends CommandCreoleCache
implements Command {
    private final FontStyle style;
    private final boolean tryExtendedColor;

    @Override
    public String startingChars() {
        return "</*_~-";
    }

    public static Command createCreole(FontStyle style) {
        return new CommandCreoleStyle("^(" + style.getCreoleSyntax() + "(.+?)" + style.getCreoleSyntax() + ")", style, false);
    }

    public static Command createLegacy(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+?)" + style.getDeactivationPattern() + ")", style, style.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+))$", style, style.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String p, FontStyle style, boolean tryExtendedColor) {
        super(p);
        this.style = style;
        this.tryExtendedColor = tryExtendedColor;
    }

    private HColor getExtendedColor(Matcher2 m4) {
        if (this.tryExtendedColor) {
            return this.style.getExtendedColor(m4.group(2));
        }
        return null;
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m4 = this.mypattern.matcher(line);
        if (!m4.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = new AddStyle(this.style, this.getExtendedColor(m4)).apply(fc1);
        stripe.setActualFontConfiguration(fc2);
        int groupCount = m4.groupCount();
        stripe.analyzeAndAdd(m4.group(groupCount));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m4.group(1).length());
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m4 = this.mypattern.matcher(line);
        if (!m4.find()) {
            return 0;
        }
        return m4.group(1).length();
    }
}

