/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilinesBracket;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SkinLoader;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandSkinParamMultilines
extends CommandMultilinesBracket<TitledDiagram> {
    public static final CommandSkinParamMultilines ME = new CommandSkinParamMultilines();

    private CommandSkinParamMultilines() {
        super("^skinparam[%s]*(?:[%s]+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?[%s]*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String line, int level) {
        if (this.hasStartingQuote(line = StringUtils.trin(line))) {
            return true;
        }
        return SkinLoader.p1.matcher(line).matches();
    }

    private boolean hasStartingQuote(CharSequence line) {
        return MyPattern.mtches(line, "^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$");
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines, ParserPass currentPass) {
        SkinLoader skinLoader = new SkinLoader(diagram);
        lines = lines.expandsNewline(true);
        Matcher2 mStart = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        if (!mStart.find()) {
            throw new IllegalStateException();
        }
        String group1 = mStart.group(1);
        return skinLoader.execute(lines, group1);
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE;
    }
}

