/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.klimt.UAntiAliasing;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.utils.Log;

public class EmptyImageBuilder {
    private final BufferedImage im;
    private final Graphics2D g2d;
    private final Color background;
    private final StringBounder stringBounder;

    private static EmptyImageBuilder create(String watermark, int width, int height, Color background, StringBounder stringBounder, double dpiFactor) {
        EmptyImageBuilder result = new EmptyImageBuilder(watermark, (int)((double)width * dpiFactor), (int)((double)height * dpiFactor), background, stringBounder);
        if (dpiFactor != 1.0) {
            result.g2d.setTransform(AffineTransform.getScaleInstance(dpiFactor, dpiFactor));
        }
        return result;
    }

    public EmptyImageBuilder(String watermark, int width, int height, Color background, StringBounder stringBounder) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (width > GraphvizUtils.getenvImageLimit()) {
            Log.info("Width too large " + width + ". You should set PLANTUML_LIMIT_SIZE");
            width = GraphvizUtils.getenvImageLimit();
        }
        if (height > GraphvizUtils.getenvImageLimit()) {
            Log.info("Height too large " + height + ". You should set PLANTUML_LIMIT_SIZE");
            height = GraphvizUtils.getenvImageLimit();
        }
        this.background = background;
        this.stringBounder = stringBounder;
        Log.info("Creating image " + width + "x" + height);
        this.im = new BufferedImage(width, height, this.getType(background));
        this.g2d = this.im.createGraphics();
        UAntiAliasing.ANTI_ALIASING_ON.apply(this.g2d);
        if (background != null) {
            this.g2d.setColor(background);
            this.g2d.fillRect(0, 0, width, height);
        }
        if (watermark != null) {
            int gray = 200;
            this.g2d.setColor(new Color(200, 200, 200));
            this.printWatermark(watermark, width, height);
        }
    }

    private int getType(Color background) {
        if (background == null) {
            return 2;
        }
        if (background.getAlpha() != 255) {
            return 2;
        }
        return 1;
    }

    private void printWatermark(String watermark, int maxWidth, int maxHeight) {
        Font javaFont = this.g2d.getFont();
        FontMetrics fm = this.g2d.getFontMetrics(javaFont);
        Rectangle2D rect = fm.getStringBounds(watermark, this.g2d);
        int height = (int)rect.getHeight();
        int width = (int)rect.getWidth();
        if (height < 2 || width < 2) {
            return;
        }
        if (width <= maxWidth) {
            for (int y = height; y < maxHeight; y += height + 1) {
                for (int x = 0; x < maxWidth; x += width + 10) {
                    this.g2d.drawString(watermark, x, y);
                }
            }
        } else {
            List<String> withBreaks = this.withBreaks(watermark, javaFont, fm, maxWidth);
            for (int y = 0; y < maxHeight; y += 10) {
                for (String s2 : withBreaks) {
                    this.g2d.drawString(s2, 0, y);
                    y += (int)fm.getStringBounds(s2, this.g2d).getHeight();
                }
            }
        }
    }

    private int getWidth(String line, Font javaFont, FontMetrics fm) {
        Rectangle2D rect = fm.getStringBounds(line, this.g2d);
        return (int)rect.getWidth();
    }

    private List<String> withBreaks(String watermark, Font javaFont, FontMetrics fm, int maxWidth) {
        String[] words = watermark.split("\\s+");
        ArrayList<String> result = new ArrayList<String>();
        String pending = "";
        for (String word : words) {
            String candidate;
            String string = candidate = pending.length() == 0 ? word : pending + " " + word;
            if (this.getWidth(candidate, javaFont, fm) < maxWidth) {
                pending = candidate;
                continue;
            }
            result.add(pending);
            pending = word;
        }
        if (pending.length() > 0) {
            result.add(pending);
        }
        return result;
    }

    public BufferedImage getBufferedImage() {
        return this.im;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }
}

