/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.compression;

import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.util.internal.ObjectUtil;
import reactor.netty.http.server.compression.HttpCompressionOption;

public final class ZstdOption
implements HttpCompressionOption {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;

    private ZstdOption(Build build) {
        this.blockSize = build.blockSize;
        this.compressionLevel = build.compressionLevel;
        this.maxEncodeSize = build.maxEncodeSize;
    }

    static ZstdOption provideDefault() {
        return ZstdOption.builder().build();
    }

    CompressionOptions adapt() {
        return StandardCompressionOptions.zstd((int)this.compressionLevel, (int)this.blockSize, (int)this.maxEncodeSize);
    }

    public static Builder builder() {
        if (!Zstd.isAvailable()) {
            throw new IllegalStateException("zstd is not available", Zstd.cause());
        }
        return new Build();
    }

    private static final class Build
    implements Builder {
        private int blockSize = 65536;
        private int compressionLevel = 3;
        private int maxEncodeSize = 1 << this.compressionLevel + 7 + 15;

        private Build() {
        }

        @Override
        public ZstdOption build() {
            return new ZstdOption(this);
        }

        @Override
        public Builder blockSize(int blockSize) {
            ObjectUtil.checkPositive((int)blockSize, (String)"blockSize");
            this.blockSize = blockSize;
            return this;
        }

        @Override
        public Builder compressionLevel(int compressionLevel) {
            ObjectUtil.checkInRange((int)compressionLevel, (int)-131072, (int)22, (String)"compressionLevel");
            this.compressionLevel = compressionLevel;
            return this;
        }

        @Override
        public Builder maxEncodeSize(int maxEncodeSize) {
            ObjectUtil.checkPositive((int)maxEncodeSize, (String)"maxEncodeSize");
            this.maxEncodeSize = maxEncodeSize;
            return this;
        }
    }

    public static interface Builder {
        public ZstdOption build();

        public Builder blockSize(int var1);

        public Builder compressionLevel(int var1);

        public Builder maxEncodeSize(int var1);
    }
}

