/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.baseline;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.baseline.DummyRegressionTrainer;

public class DummyRegressionModel
extends Model<Regressor> {
    private static final long serialVersionUID = 2L;
    private final DummyRegressionTrainer.DummyType dummyType;
    private final Regressor output;
    private final long seed;
    private final Random rng;
    private final double[] means;
    private final double[] variances;
    private final String[] dimensionNames;

    DummyRegressionModel(ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Regressor> outputIDInfo, long seed, double[] means, double[] variances, String[] names) {
        super("dummy-GAUSSIAN-regression", description, featureIDMap, outputIDInfo, false);
        this.dummyType = DummyRegressionTrainer.DummyType.GAUSSIAN;
        this.output = null;
        this.seed = seed;
        this.rng = new Random(seed);
        this.means = Arrays.copyOf(means, means.length);
        this.variances = Arrays.copyOf(variances, variances.length);
        this.dimensionNames = Arrays.copyOf(names, names.length);
    }

    DummyRegressionModel(ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Regressor> outputIDInfo, DummyRegressionTrainer.DummyType dummyType, Regressor regressor) {
        super("dummy-" + (Object)((Object)dummyType) + "-regression", description, featureIDMap, outputIDInfo, false);
        this.dummyType = dummyType;
        this.output = regressor;
        this.seed = 12345L;
        this.rng = null;
        this.means = new double[0];
        this.variances = new double[0];
        this.dimensionNames = new String[0];
    }

    public Prediction<Regressor> predict(Example<Regressor> example) {
        switch (this.dummyType) {
            case CONSTANT: 
            case MEAN: 
            case MEDIAN: 
            case QUARTILE: {
                return new Prediction((Output)this.output, 0, example);
            }
            case GAUSSIAN: {
                Regressor.DimensionTuple[] dimensions = new Regressor.DimensionTuple[this.dimensionNames.length];
                for (int i = 0; i < this.dimensionNames.length; ++i) {
                    double regressionValue = this.rng.nextGaussian() * this.variances[i] + this.means[i];
                    dimensions[i] = new Regressor.DimensionTuple(this.dimensionNames[i], regressionValue);
                }
                return new Prediction((Output)new Regressor(dimensions), 0, example);
            }
        }
        throw new IllegalStateException("Unknown dummyType " + (Object)((Object)this.dummyType));
    }

    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        if (n != 0) {
            return Collections.singletonMap("ALL_OUTPUTS", Collections.singletonList(new Pair((Object)"BIAS", (Object)1.0)));
        }
        return Collections.emptyMap();
    }

    public Optional<Excuse<Regressor>> getExcuse(Example<Regressor> example) {
        return Optional.of(new Excuse(example, this.predict(example), this.getTopFeatures(1)));
    }

    protected Model<Regressor> copy(String newName, ModelProvenance newProvenance) {
        switch (this.dummyType) {
            case GAUSSIAN: {
                return new DummyRegressionModel(newProvenance, this.featureIDMap, (ImmutableOutputInfo<Regressor>)this.outputIDInfo, this.seed, this.means, this.variances, this.dimensionNames);
            }
            case CONSTANT: 
            case MEAN: 
            case MEDIAN: 
            case QUARTILE: {
                return new DummyRegressionModel(newProvenance, this.featureIDMap, (ImmutableOutputInfo<Regressor>)this.outputIDInfo, this.dummyType, this.output.copy());
            }
        }
        throw new IllegalStateException("Unknown dummyType " + (Object)((Object)this.dummyType));
    }
}

