import ZenUml from "@zenuml/core";
const warning = (s) => {
  console.error("Log function was called before initialization", s);
};
const log = {
  trace: warning,
  debug: warning,
  info: warning,
  warn: warning,
  error: warning,
  fatal: warning
};
let getConfig;
const injectUtils = (_log, _setLogLevel, _getConfig, _sanitizeText, _setupGraphViewbox) => {
  _log.info("Mermaid utils injected");
  log.trace = _log.trace;
  log.debug = _log.debug;
  log.info = _log.info;
  log.warn = _log.warn;
  log.error = _log.error;
  log.fatal = _log.fatal;
  getConfig = _getConfig;
};
const parser = {
  parser: { yy: {} },
  parse: () => {
  }
};
const regexp = /^\s*zenuml/;
function createTemporaryZenumlContainer(id) {
  const container = document.createElement("div");
  container.id = `container-${id}`;
  container.style.display = "flex";
  container.innerHTML = `<div id="zenUMLApp-${id}"></div>`;
  const app = container.querySelector(`#zenUMLApp-${id}`);
  return { container, app };
}
function createForeignObject(id) {
  const foreignObject = document.createElementNS("http://www.w3.org/2000/svg", "foreignObject");
  foreignObject.setAttribute("x", "0");
  foreignObject.setAttribute("y", "0");
  foreignObject.setAttribute("width", "100%");
  foreignObject.setAttribute("height", "100%");
  const { container, app } = createTemporaryZenumlContainer(id);
  foreignObject.appendChild(container);
  return { foreignObject, container, app };
}
const draw = async function(text, id) {
  var _a;
  log.info("draw with Zen UML renderer", ZenUml);
  text = text.replace(regexp, "");
  const { securityLevel } = getConfig();
  let sandboxElement = null;
  if (securityLevel === "sandbox") {
    sandboxElement = document.getElementById("i" + id);
  }
  const root = securityLevel === "sandbox" ? (_a = sandboxElement == null ? void 0 : sandboxElement.contentWindow) == null ? void 0 : _a.document : document;
  const svgContainer = root == null ? void 0 : root.querySelector(`svg#${id}`);
  if (!root || !svgContainer) {
    log.error("Cannot find root or svgContainer");
    return;
  }
  const { foreignObject, container, app } = createForeignObject(id);
  svgContainer.appendChild(foreignObject);
  const zenuml = new ZenUml(app);
  await zenuml.render(text, { theme: "default", mode: "static" });
  const { width, height } = window.getComputedStyle(container);
  log.debug("zenuml diagram size", width, height);
  svgContainer.setAttribute("style", `width: ${width}; height: ${height};`);
};
const renderer = {
  draw
};
const diagram = {
  db: {
    clear: () => {
    }
  },
  renderer,
  parser,
  styles: () => {
  },
  injectUtils
};
export {
  diagram
};
