import type { ComputedRef, Ref, ShallowRef } from 'vue';
import type { AutoPlacementOptions, FlipOptions, HideOptions, OffsetOptions, ShiftOptions } from '@floating-ui/core';
import type { DetectOverflowOptions, Middleware } from '@floating-ui/dom';
import type { FloatingElement, ReferenceElement } from '../types';
export declare function useFloatingMiddlewareFromProps(middleware: ShallowRef<Middleware[]>, referenceEl: ComputedRef<ReferenceElement | null>, floatingEl: ComputedRef<FloatingElement | null>, arrowRef: Ref<HTMLElement | null>, props: {
    offset?: OffsetOptions;
    shift?: boolean | number | Partial<ShiftOptions & DetectOverflowOptions>;
    flip?: boolean | number | Partial<FlipOptions & DetectOverflowOptions>;
    arrow?: boolean | number;
    autoPlacement?: boolean | Partial<AutoPlacementOptions & DetectOverflowOptions>;
    hide?: boolean | Partial<HideOptions & DetectOverflowOptions> | Partial<HideOptions & DetectOverflowOptions>[];
    middleware?: Middleware[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
}): void;
