/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

class CopyMoveHelper {
    private CopyMoveHelper() {
    }

    private static CopyOption[] convertMoveToCopyOptions(CopyOption ... options) throws AtomicMoveNotSupportedException {
        int len = options.length;
        CopyOption[] newOptions = new CopyOption[len + 2];
        for (int i = 0; i < len; ++i) {
            CopyOption option = options[i];
            if (option == StandardCopyOption.ATOMIC_MOVE) {
                throw new AtomicMoveNotSupportedException(null, null, "Atomic move between providers is not supported");
            }
            newOptions[i] = option;
        }
        newOptions[len] = LinkOption.NOFOLLOW_LINKS;
        newOptions[len + 1] = StandardCopyOption.COPY_ATTRIBUTES;
        return newOptions;
    }

    static void copyToForeignTarget(Path source, Path target, CopyOption ... options) throws IOException {
        LinkOption[] linkOptionArray;
        CopyOptions opts = CopyOptions.parse(options);
        if (opts.followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = linkOptionArray;
        BasicFileAttributes attrs = Files.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        if (opts.replaceExisting) {
            Files.deleteIfExists(target);
        } else if (Files.exists(target, new LinkOption[0])) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (attrs.isDirectory()) {
            Files.createDirectory(target, new FileAttribute[0]);
        } else {
            try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
                Files.copy(in, target, new CopyOption[0]);
            }
        }
        if (opts.copyAttributes) {
            BasicFileAttributeView view = Files.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    Files.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    static void moveToForeignTarget(Path source, Path target, CopyOption ... options) throws IOException {
        CopyMoveHelper.copyToForeignTarget(source, target, CopyMoveHelper.convertMoveToCopyOptions(options));
        Files.delete(source);
    }

    private static class CopyOptions {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;

        private CopyOptions() {
        }

        static CopyOptions parse(CopyOption ... options) {
            CopyOptions result = new CopyOptions();
            for (CopyOption option : options) {
                if (option == StandardCopyOption.REPLACE_EXISTING) {
                    result.replaceExisting = true;
                    continue;
                }
                if (option == LinkOption.NOFOLLOW_LINKS) {
                    result.followLinks = false;
                    continue;
                }
                if (option == StandardCopyOption.COPY_ATTRIBUTES) {
                    result.copyAttributes = true;
                    continue;
                }
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("'" + option + "' is not a recognized copy option");
            }
            return result;
        }
    }
}

