/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LabelAttributesPanel
extends JPanel {
    private ButtonModel selectedModel;
    private boolean showProperties = true;
    private TextModelImpl textModel;
    private AttributesCheckBox[] nodeCheckBoxs;
    private AttributesCheckBox[] edgeCheckBoxs;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;
    private JPanel controlPanel;
    private JToggleButton edgesToggleButton;
    private ButtonGroup elementButtonGroup;
    private JLabel labelComment;
    private JToggleButton nodesToggleButton;
    private JCheckBox showPropertiesCheckbox;

    public LabelAttributesPanel() {
        this.initComponents();
        this.selectedModel = this.nodesToggleButton.getModel();
        this.elementButtonGroup.setSelected(this.selectedModel, true);
        this.nodesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LabelAttributesPanel.this.nodesToggleButton.isSelected()) {
                    LabelAttributesPanel.this.selectedModel = LabelAttributesPanel.this.nodesToggleButton.getModel();
                    LabelAttributesPanel.this.refresh();
                }
            }
        });
        this.edgesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LabelAttributesPanel.this.edgesToggleButton.isSelected()) {
                    LabelAttributesPanel.this.selectedModel = LabelAttributesPanel.this.edgesToggleButton.getModel();
                    LabelAttributesPanel.this.refresh();
                }
            }
        });
        this.showPropertiesCheckbox.setSelected(this.showProperties);
        this.showPropertiesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LabelAttributesPanel.this.showProperties = LabelAttributesPanel.this.showPropertiesCheckbox.isSelected();
                LabelAttributesPanel.this.refresh();
            }
        });
    }

    public void setup(TextModelImpl model) {
        this.textModel = model;
        this.refresh();
    }

    private void refresh() {
        AttributesCheckBox[] target;
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        ArrayList<Column> availableColumns = new ArrayList<Column>();
        List<Object> selectedColumns = new ArrayList();
        if (this.elementButtonGroup.getSelection() == this.nodesToggleButton.getModel()) {
            for (Column c : graphController.getGraphModel().getNodeTable()) {
                if (!c.isProperty()) {
                    availableColumns.add(c);
                    continue;
                }
                if (!this.showProperties || !c.isProperty() || c.getId().equals("timeset")) continue;
                availableColumns.add(c);
            }
            if (this.textModel.getNodeTextColumns() != null) {
                selectedColumns = Arrays.asList(this.textModel.getNodeTextColumns());
            }
            target = this.nodeCheckBoxs = new AttributesCheckBox[availableColumns.size()];
        } else {
            for (Column c : graphController.getGraphModel().getEdgeTable()) {
                if (!c.isProperty()) {
                    availableColumns.add(c);
                    continue;
                }
                if (!this.showProperties || !this.showProperties || !c.isProperty() || c.getId().equals("timeset")) continue;
                availableColumns.add(c);
            }
            if (this.textModel.getEdgeTextColumns() != null) {
                selectedColumns = Arrays.asList(this.textModel.getEdgeTextColumns());
            }
            this.edgeCheckBoxs = new AttributesCheckBox[availableColumns.size()];
            target = this.edgeCheckBoxs;
        }
        this.contentPanel.removeAll();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        for (int i = 0; i < availableColumns.size(); ++i) {
            AttributesCheckBox c;
            Column column = (Column)availableColumns.get(i);
            target[i] = c = new AttributesCheckBox(column, selectedColumns.contains(column));
            this.contentPanel.add((Component)c.getCheckBox(), "wrap");
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    public void unsetup() {
        ArrayList<Column> nodeColumnsList = new ArrayList<Column>();
        ArrayList<Column> edgeColumnsList = new ArrayList<Column>();
        if (this.nodeCheckBoxs != null) {
            for (AttributesCheckBox c : this.nodeCheckBoxs) {
                if (!c.isSelected()) continue;
                nodeColumnsList.add(c.getColumn());
            }
        }
        if (this.edgeCheckBoxs != null) {
            for (AttributesCheckBox c : this.edgeCheckBoxs) {
                if (!c.isSelected()) continue;
                edgeColumnsList.add(c.getColumn());
            }
        }
        if (edgeColumnsList.size() > 0 || nodeColumnsList.size() > 0) {
            this.textModel.setTextColumns(nodeColumnsList.toArray(new Column[0]), edgeColumnsList.toArray(new Column[0]));
        }
    }

    private void initComponents() {
        this.elementButtonGroup = new ButtonGroup();
        this.controlPanel = new JPanel();
        this.nodesToggleButton = new JToggleButton();
        this.edgesToggleButton = new JToggleButton();
        this.contentScrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.labelComment = new JLabel();
        this.showPropertiesCheckbox = new JCheckBox();
        this.controlPanel.setLayout(new FlowLayout(1, 0, 0));
        this.elementButtonGroup.add(this.nodesToggleButton);
        this.nodesToggleButton.setText(NbBundle.getMessage(LabelAttributesPanel.class, (String)"LabelAttributesPanel.nodesToggleButton.text"));
        this.controlPanel.add(this.nodesToggleButton);
        this.elementButtonGroup.add(this.edgesToggleButton);
        this.edgesToggleButton.setText(NbBundle.getMessage(LabelAttributesPanel.class, (String)"LabelAttributesPanel.edgesToggleButton.text"));
        this.controlPanel.add(this.edgesToggleButton);
        this.contentPanel.setLayout(new GridLayout());
        this.contentScrollPane.setViewportView(this.contentPanel);
        this.labelComment.setText(NbBundle.getMessage(LabelAttributesPanel.class, (String)"LabelAttributesPanel.labelComment.text"));
        this.showPropertiesCheckbox.setText(NbBundle.getMessage(LabelAttributesPanel.class, (String)"LabelAttributesPanel.showPropertiesCheckbox.text"));
        this.showPropertiesCheckbox.setHorizontalAlignment(4);
        this.showPropertiesCheckbox.setHorizontalTextPosition(2);
        this.showPropertiesCheckbox.setMargin(new Insets(2, 2, 2, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentScrollPane, -1, 313, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.controlPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE).addComponent(this.showPropertiesCheckbox)).addComponent(this.labelComment)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.controlPanel, -2, -1, -2).addGap(13, 13, 13).addComponent(this.labelComment)).addComponent(this.showPropertiesCheckbox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentScrollPane, -1, 197, Short.MAX_VALUE).addContainerGap()));
    }

    private static class AttributesCheckBox {
        private JCheckBox checkBox;
        private Column column;

        public AttributesCheckBox(Column column, boolean selected) {
            this.checkBox = new JCheckBox(column.getTitle(), selected);
            this.column = column;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public Column getColumn() {
            return this.column;
        }
    }
}

