/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gpsbabel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.InputStreamGobbler;
import org.fibs.geotag.util.OperatingSystem;

public final class GPSBabel {
    private static boolean available;
    private static Process process;

    private GPSBabel() {
    }

    public static void checkGPSBabelAvailable() {
        boolean found = true;
        ArrayList<String> command = new ArrayList<String>();
        String exiftool = Settings.get(Settings.SETTING.GPSBABEL_PATH, "gpsbabel");
        command.add(exiftool);
        command.add("-V");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            process = processBuilder.redirectErrorStream(true).start();
            new InputStreamGobbler(process, (OutputStream)System.out).start();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            found = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            found = false;
        }
        available = found;
    }

    public static boolean isAvailable() {
        return available;
    }

    public static String getDefaultDevice() {
        if (OperatingSystem.isLinux()) {
            String file = "/dev/ttyUSB0";
            if (new File(file).exists()) {
                return file;
            }
            return "/dev/ttyS0";
        }
        if (OperatingSystem.isWindows()) {
            return "COM1:";
        }
        return "serial";
    }

    public static File readTracks(InputStreamGobbler gobbler) {
        File file = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(Settings.get(Settings.SETTING.GPSBABEL_PATH, "gpsbabel"));
        command.add("-vs");
        command.add("-t");
        command.add("-i");
        command.add(Settings.get(Settings.SETTING.GPSBABEL_PROTOCOL, "garmin"));
        command.add("-f");
        command.add(Settings.get(Settings.SETTING.GPSBABEL_DEVICE, GPSBabel.getDefaultDevice()));
        command.add("-o");
        command.add("gpx");
        command.add("-F");
        file = new File("Geotag.gpx");
        try {
            file = File.createTempFile("Geotag", ".gpx");
            file.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        command.add(file.getPath());
        ProcessBuilder processBuilder = new ProcessBuilder(command).redirectErrorStream(true);
        try {
            process = processBuilder.redirectErrorStream(true).start();
            InputStream inputStream = process.getInputStream();
            gobbler.setInputStream(inputStream);
            gobbler.start();
            process.waitFor();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (process == null) {
            if (!file.delete()) {
                System.out.println("Failed to delete temp gpx file");
            }
            file = null;
        }
        process = null;
        return file;
    }

    public static synchronized void terminate() {
        if (process != null) {
            process.destroy();
            process = null;
        }
    }
}

