/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

@SelectableAction(checkOnPopup=true)
@EnabledAction(checkOnNodeChange=true)
public class SetBooleanMapViewPropertyAction
extends AFreeplaneAction {
    private String propertyName;

    public SetBooleanMapViewPropertyAction(String propertyName) {
        super("SetBooleanMapViewPropertyAction." + propertyName, TextUtils.getRawText("OptionPanel." + propertyName), null);
        this.propertyName = propertyName;
        this.setIcon(propertyName + ".icon");
        this.setTooltip(this.getTooltipKey());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent mapViewComponent = this.getMapViewComponent();
        if (mapViewComponent != null) {
            Boolean value = Boolean.TRUE.equals(mapViewComponent.getClientProperty(this.propertyName));
            boolean newValue = value == false;
            mapViewComponent.putClientProperty(this.propertyName, newValue);
            this.setSelected(newValue);
        }
    }

    private JComponent getMapViewComponent() {
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        return mapViewComponent;
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.propertyName;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        try {
            JComponent mapViewComponent = this.getMapViewComponent();
            if (mapViewComponent != null) {
                Boolean value = Boolean.TRUE.equals(mapViewComponent.getClientProperty(this.propertyName));
                this.setSelected(value);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSelected(false);
    }

    @Override
    public void setEnabled() {
        this.setEnabled(this.getMapViewComponent() != null);
    }
}

