/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeContainsCondition
extends StringConditionAdapter {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_contains_condition";
    static final String VALUE = "VALUE";
    private final Object attribute;
    private final String value;
    private final String comparedValue;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeContainsCondition(AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null)), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute("MATCH_CASE", null)), Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("MATCH_WORDWISE", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
    }

    public AttributeContainsCondition(Object attribute, String value, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
        this.attribute = attribute;
        this.value = value;
        this.comparedValue = value;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            String text;
            if (this.attribute.equals(AttributeConditionController.ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT)) {
                if (this.checkText(attributes.getValueAt(i, 0).toString())) {
                    return true;
                }
            } else if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            if (!this.checkText(text = textController.getTransformedTextNoThrow(node, attributes, originalContent = attributes.getValueAt(i, 1)))) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(String text) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(text), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        return this.createDescription(this.attribute.toString(), this.containsDescription(), this.value);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
        child.setAttribute(VALUE, this.value);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String conditionValue() {
        return this.comparedValue;
    }
}

