/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class BooleanProperty
extends PropertyBean
implements IPropertyControl {
    private final JCheckBox mCheckBox = new JCheckBox();

    public BooleanProperty(String name) {
        super(name);
        this.mCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent pE) {
                BooleanProperty.this.firePropertyChangeEvent();
            }
        });
    }

    @Override
    public String getValue() {
        return this.mCheckBox.isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    @Override
    public JComponent getValueComponent() {
        return this.mCheckBox;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.mCheckBox);
        this.getLabelComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BooleanProperty.this.mCheckBox.setSelected(!BooleanProperty.this.getBooleanValue());
            }
        });
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mCheckBox.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        boolean booleanValue = Boolean.parseBoolean(value);
        this.setValue(booleanValue);
    }

    public void setValue(boolean booleanValue) {
        this.mCheckBox.setSelected(booleanValue);
    }

    public boolean getBooleanValue() {
        return this.mCheckBox.isSelected();
    }

    public void enables(final IPropertyControl control) {
        control.setEnabled(this.getBooleanValue());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                control.setEnabled(BooleanProperty.this.getBooleanValue());
            }
        });
    }
}

