"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
const ITEM_PATTERN = /^(.*)\s(REG_SZ|REG_MULTI_SZ|REG_EXPAND_SZ|REG_DWORD|REG_QWORD|REG_BINARY|REG_NONE)\s+([^\s].*)$/;
var Hive;
(function (Hive) {
    Hive["HKCU"] = "HKCU";
})(Hive = exports.Hive || (exports.Hive = {}));
function getRegPath() {
    if (process.platform === "win32" && process.env.windir) {
        return path.join(process.env.windir, "system32", "reg.exe");
    }
    else {
        return "REG";
    }
}
function execAsync(command, args = []) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            child_process_1.execFile(command, args, (err, stdout, stderr) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve({ stdout, stderr });
                }
            });
        });
    });
}
function parseOutput(stdout) {
    const lines = stdout.split("\n");
    const result = {};
    for (const line of lines.slice(1)) {
        const match = ITEM_PATTERN.exec(line.trim());
        if (match) {
            const name = match[1].trim();
            const type = match[2].trim();
            const value = match[3].trim();
            result[name] = { type, value };
        }
    }
    return result;
}
function openKey(hive, key) {
    return __awaiter(this, void 0, void 0, function* () {
        const keyPath = `${hive}\\${key}`;
        const { stdout } = yield execAsync(getRegPath(), ["query", keyPath]);
        const values = parseOutput(stdout);
        return values;
    });
}
exports.openKey = openKey;
//# sourceMappingURL=winreg.js.map