"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabBarItem = exports.TabBar = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const Text_1 = require("../Text");
const util_1 = require("../util");
const tabBarStyle = ({}) => {
    return {
        display: 'flex',
        width: '100%',
    };
};
const filteredTabBarProps = (props) => (0, util_1.filterProps)(props, []);
const TabBar = (_a) => {
    var { children = null } = _a, props = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: tabBarStyle(props) }, filteredTabBarProps(props), { children: children })));
};
exports.TabBar = TabBar;
const tabBarItemStyle = (theme, _a) => {
    var { block = true, center = true, color = theme.general.color, bold = true, active = false, fontSize = theme.fontSizes.extraSmall, textTransform = 'uppercase' } = _a, props = __rest(_a, ["block", "center", "color", "bold", "active", "fontSize", "textTransform"]);
    return Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ block, bold, center, color, fontSize, textTransform }, props))), { borderBottom: active ? `1px solid ${Identity_1.COLOR.GRAY_DARKEN_48}` : `1px solid ${Identity_1.COLOR.GRAY_LIGHTEN_40}`, cursor: 'pointer', display: 'flex', flexGrow: 1, justifyContent: 'center', opacity: active ? 1 : 0.56, padding: '8px 0' });
};
const TabBarItem = (_a) => {
    var { children = null } = _a, props = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: (theme) => tabBarItemStyle(theme, props) }, props, { children: children })));
};
exports.TabBarItem = TabBarItem;
