"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuSubLink = exports.menuSubLinkStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const motions_1 = require("../../Identity/motions");
const mediaQueries_1 = require("../../mediaQueries");
const Text_1 = require("../../Text");
const menuSubLinkStyle = (theme, props) => (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, props)), { '&:hover': {
        filter: 'brightness(70%)',
    }, color: theme.general.color, cursor: 'pointer', fontWeight: 600, textDecoration: 'none', transition: motions_1.defaultTransition, [mediaQueries_1.media[mediaQueries_1.QueryKeys.DESKTOP]]: {
        '&:first-of-type': {
            marginLeft: 0,
        },
        '&:last-child': {
            marginRight: 0,
        },
        fontSize: theme.fontSizes.extraSmall,
        margin: '0 26px 0 10px',
        textTransform: 'uppercase',
    }, [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
        border: 'none',
        fontSize: '2rem !important',
        fontWeight: '400 !important',
        maxWidth: '480px',
        padding: '8px 24px',
        textTransform: 'none !important',
    } }));
exports.menuSubLinkStyle = menuSubLinkStyle;
const MenuSubLink = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => (0, exports.menuSubLinkStyle)(theme, props) }, props)));
exports.MenuSubLink = MenuSubLink;
