/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTManager;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjLivenessCCTNode;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.JTreeTable;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.treetable.AbstractTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.ExtendedTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.JTreeTablePanel;
import org.graalvm.visualvm.lib.ui.components.treetable.TreeTableModel;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.ReverseMemCallGraphPanel;

public class LiveReverseMemCallGraphPanel
extends ReverseMemCallGraphPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String NO_STACKS_MSG = messages.getString("LiveReverseMemCallGraphPanel_NoStacksMsg");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("LiveReverseMemCallGraphPanel_TreeTableAccessName");
    protected MemoryCCTManager callGraphManager;
    protected ProfilingSessionStatus status;
    protected int classId;
    private AbstractTreeTableModel abstractTreeTableModel;

    public LiveReverseMemCallGraphPanel(ProfilingSessionStatus status, MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler, status.currentInstrType == 6);
        this.status = status;
    }

    public void setCallGraph(MemoryCCTManager callGraphManager, int classId) {
        this.callGraphManager = callGraphManager;
        this.classId = classId;
        if (!callGraphManager.isEmpty()) {
            this.customBarCellRenderer = new CustomBarCellRenderer(0L, callGraphManager.getRootNode().totalObjSize);
            this.columnRenderers[1] = this.customBarCellRenderer;
        }
    }

    @Override
    public void prepareResults() {
        if (this.callGraphManager.isEmpty()) {
            this.removeAll();
            this.add((Component)new JLabel(NO_STACKS_MSG), "Center");
        } else {
            this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.callGraphManager.getRootNode(), 1, false){

                @Override
                public int getColumnCount() {
                    return LiveReverseMemCallGraphPanel.this.columnNames.length;
                }

                @Override
                public String getColumnName(int column) {
                    return LiveReverseMemCallGraphPanel.this.columnNames[column];
                }

                @Override
                public Class getColumnClass(int column) {
                    if (column == 0) {
                        return TreeTableModel.class;
                    }
                    return Object.class;
                }

                @Override
                public Object getValueAt(Object node, int column) {
                    if (LiveReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode pNode = (PresoObjLivenessCCTNode)node;
                        switch (column) {
                            case 0: {
                                return pNode.toString();
                            }
                            case 1: {
                                return new Long(pNode.totalObjSize);
                            }
                            case 2: {
                                long value = ((PresoObjLivenessCCTNode)this.root).totalObjSize;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.totalObjSize) + " B (" + (value == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.totalObjSize / (float)value)) + ")";
                            }
                            case 3: {
                                long value = ((PresoObjLivenessCCTNode)this.root).nLiveObjects;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.nLiveObjects) + " (" + (value == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.nLiveObjects / (float)value)) + ")";
                            }
                            case 4: {
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.nCalls);
                            }
                            case 5: {
                                return StringUtils.floatPerCentToString((float)pNode.avgObjectAge);
                            }
                            case 6: {
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.survGen);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode pNode = (PresoObjAllocCCTNode)node;
                        switch (column) {
                            case 0: {
                                return pNode.getNodeName();
                            }
                            case 1: {
                                return new Long(pNode.totalObjSize);
                            }
                            case 2: {
                                long value = ((PresoObjAllocCCTNode)this.root).totalObjSize;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.totalObjSize) + " B (" + (value == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.totalObjSize / (float)value)) + ")";
                            }
                            case 3: {
                                long value = ((PresoObjAllocCCTNode)this.root).nCalls;
                                return LiveReverseMemCallGraphPanel.this.intFormat.format(pNode.nCalls) + " (" + (value == 0L ? "-%" : LiveReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.nCalls / (float)value)) + ")";
                            }
                        }
                    }
                    return null;
                }

                @Override
                public String getColumnToolTipText(int col) {
                    return LiveReverseMemCallGraphPanel.this.columnToolTips[col];
                }

                @Override
                public void sortByColumn(int column, boolean order) {
                    if (LiveReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode pRoot = (PresoObjLivenessCCTNode)this.root;
                        switch (column) {
                            case 0: {
                                pRoot.sortChildren(6, order);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pRoot.sortChildren(1, order);
                                break;
                            }
                            case 3: {
                                pRoot.sortChildren(2, order);
                                break;
                            }
                            case 4: {
                                pRoot.sortChildren(3, order);
                                break;
                            }
                            case 5: {
                                pRoot.sortChildren(4, order);
                                break;
                            }
                            case 6: {
                                pRoot.sortChildren(5, order);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode pRoot = (PresoObjAllocCCTNode)this.root;
                        switch (column) {
                            case 0: {
                                pRoot.sortChildren(1, order);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pRoot.sortChildren(2, order);
                                break;
                            }
                            case 3: {
                                pRoot.sortChildren(3, order);
                            }
                        }
                    }
                }

                @Override
                public boolean getInitialSorting(int column) {
                    switch (column) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
            this.treeTable = new JTreeTable(this.treeTableModel){

                @Override
                public void doLayout() {
                    int columnsWidthsSum = 0;
                    int realFirstColumn = -1;
                    TableColumnModel colModel = this.getColumnModel();
                    for (int i = 0; i < LiveReverseMemCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                        int index = LiveReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(i);
                        if (index == 0) {
                            realFirstColumn = i;
                            continue;
                        }
                        columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                    }
                    if (realFirstColumn != -1) {
                        colModel.getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, LiveReverseMemCallGraphPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
            this.treeTable.setRowSelectionAllowed(true);
            this.treeTable.setSelectionMode(0);
            this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.treeTable.setShowHorizontalLines(false);
            this.treeTable.setShowVerticalLines(true);
            this.treeTable.setRowMargin(0);
            this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            this.setColumnsData();
            UIUtils.autoExpandRoot(this.treeTable.getTree());
            UIUtils.makeTreeAutoExpandable(this.treeTable.getTree());
            this.treeTable.addMouseListener(new MouseAdapter(){

                private void showPopupMenu(MouseEvent e) {
                    LiveReverseMemCallGraphPanel.this.treePath = LiveReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(LiveReverseMemCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                    if (LiveReverseMemCallGraphPanel.this.treePath == null) {
                        LiveReverseMemCallGraphPanel.this.treeTable.getTree().clearSelection();
                    } else {
                        LiveReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(LiveReverseMemCallGraphPanel.this.treePath);
                        LiveReverseMemCallGraphPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    LiveReverseMemCallGraphPanel.this.treePath = LiveReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(LiveReverseMemCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                    if (LiveReverseMemCallGraphPanel.this.treePath != null) {
                        LiveReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(LiveReverseMemCallGraphPanel.this.treePath);
                        if (e.getModifiers() == 16 && e.getClickCount() == 2 && LiveReverseMemCallGraphPanel.this.treeTableModel.isLeaf(LiveReverseMemCallGraphPanel.this.treePath.getPath()[LiveReverseMemCallGraphPanel.this.treePath.getPath().length - 1])) {
                            LiveReverseMemCallGraphPanel.this.performDefaultAction(LiveReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }
            });
            this.removeAll();
            this.treeTablePanel = new JTreeTablePanel(this.treeTable);
            this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
            this.add((Component)this.treeTablePanel, "Center");
        }
    }
}

