/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.api.search.ReplacePattern;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.ui.ComponentUtils;
import org.netbeans.api.search.ui.FileNameController;
import org.netbeans.api.search.ui.ScopeController;
import org.netbeans.api.search.ui.ScopeOptionsController;
import org.netbeans.api.search.ui.SearchPatternController;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.Bundle;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ListComboBoxModel;
import org.netbeans.modules.search.PatternSandbox;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.ui.FormLayoutHelper;
import org.netbeans.modules.search.ui.LinkButtonPanel;
import org.netbeans.modules.search.ui.PatternChangeListener;
import org.netbeans.modules.search.ui.ShorteningCellRenderer;
import org.netbeans.modules.search.ui.TextFieldFocusListener;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

final class BasicSearchForm
extends JPanel
implements ChangeListener,
ItemListener {
    private final String preferredSearchScopeType;
    private ChangeListener usabilityChangeListener;
    private BasicSearchCriteria searchCriteria = new BasicSearchCriteria();
    private SearchScopeDefinition[] extraSearchScopes;
    private boolean searchInGeneratedSetAutomatically = false;
    private PropertyChangeListener topComponentRegistryListener;
    private static final Logger watcherLogger = Logger.getLogger("org.netbeans.modules.search.BasicSearchForm.FileNamePatternWatcher");
    private SearchPatternController cboxTextToFind;
    private JComboBox<ReplaceModelItem> cboxReplacement;
    private FileNameController cboxFileNamePattern;
    private JCheckBox chkWholeWords;
    private JCheckBox chkCaseSensitive;
    private TextToFindTypeComboBox textToFindType;
    private JCheckBox chkPreserveCase;
    private JTextComponent replacementPatternEditor;
    protected SearchFormPanel formPanel;
    private JButton btnTestTextToFind;
    private LinkButtonPanel btnTestTextToFindPanel;
    private JLabel lblTextToFind;
    private JLabel lblTextToFindHint;
    private ScopeController cboxScope;
    private JLabel lblFileNamePattern;
    private JLabel lblFileNameHint;
    private JLabel lblScope;
    private JLabel lblReplacement;
    private Color errorTextColor;
    private Color defaultTextColor;
    private boolean invalidTextPattern = false;
    private boolean invalidReplacePattern = false;
    private ScopeOptionsController scopeSettingsPanel;
    private final DocumentFilter lengthFilter = new LengthFilter();

    BasicSearchForm(String string, boolean bl, BasicSearchCriteria basicSearchCriteria, SearchScopeDefinition ... searchScopeDefinitionArray) {
        this.preferredSearchScopeType = string;
        this.extraSearchScopes = searchScopeDefinitionArray;
        this.initComponents(bl);
        this.initAccessibility(bl);
        this.initHistory();
        if (bl && this.searchCriteria.getReplaceExpr() == null) {
            this.searchCriteria.setReplaceExpr("");
        }
        this.initInteraction(bl);
        this.setValuesOfComponents(basicSearchCriteria, bl);
        this.setContextAwareOptions(bl);
    }

    private void setValuesOfComponents(BasicSearchCriteria basicSearchCriteria, boolean bl) {
        if (basicSearchCriteria != null) {
            this.initValuesFromCriteria(basicSearchCriteria, bl);
        } else {
            this.initValuesFromHistory(bl);
        }
        if (bl) {
            this.updateReplacePatternColor();
        }
        this.useCurrentlySelectedText();
        this.setSearchCriteriaValues();
        this.updateTextToFindInfo();
        this.updateFileNamePatternInfo();
    }

    public void useCurrentlySelectedText() {
        String string;
        JEditorPane jEditorPane;
        EditorCookie editorCookie;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class)) != null && (jEditorPane = NbDocument.findRecentEditorPane((EditorCookie)editorCookie)) != null && (string = jEditorPane.getSelectedText()) != null) {
            this.cboxTextToFind.setSearchPattern(SearchPattern.create(string, false, false, false));
            this.searchCriteria.setTextPattern(string);
            return;
        }
        this.searchCriteria.setTextPattern(this.cboxTextToFind.getSearchPattern().getSearchExpression());
    }

    private void setContextAwareOptions(boolean bl) {
        if (!bl) {
            this.updateSearchInGeneratedForActiveTopComponent();
            this.topComponentRegistryListener = propertyChangeEvent -> {
                if (propertyChangeEvent.getPropertyName().equals("activated")) {
                    this.updateSearchInGeneratedForActiveTopComponent();
                }
            };
            TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.topComponentRegistryListener, (Object)TopComponent.getRegistry()));
        }
    }

    private void updateSearchInGeneratedForActiveTopComponent() {
        assert (this.searchCriteria != null && !this.searchCriteria.isSearchAndReplace());
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && topComponent.getHelpCtx() != null && "ProjectTab_Files".equals(topComponent.getHelpCtx().getHelpID())) {
            if (!this.scopeSettingsPanel.isSearchInGenerated()) {
                this.scopeSettingsPanel.setSearchInGenerated(true);
                this.searchInGeneratedSetAutomatically = true;
            }
        } else if (this.searchInGeneratedSetAutomatically) {
            this.scopeSettingsPanel.setSearchInGenerated(false);
            this.searchInGeneratedSetAutomatically = false;
        }
    }

    private void initComponents(boolean bl) {
        this.lblTextToFind = new JLabel();
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditor(new MultiLineComboBoxEditor(jComboBox));
        this.cboxTextToFind = ComponentUtils.adjustComboForSearchPattern(jComboBox);
        this.lblTextToFind.setLabelFor((Component)this.cboxTextToFind.getComponent());
        this.btnTestTextToFind = new JButton();
        this.lblTextToFindHint = new JLabel();
        this.lblTextToFindHint.setEnabled(false);
        this.setLengthFilter((JComboBox)this.cboxTextToFind.getComponent());
        if (bl) {
            this.lblReplacement = new JLabel();
            this.cboxReplacement = new JComboBox();
            this.cboxReplacement.setEditor(new MultiLineComboBoxEditor(this.cboxReplacement));
            this.cboxReplacement.setEditable(true);
            this.cboxReplacement.setRenderer(new ShorteningCellRenderer());
            this.lblReplacement.setLabelFor(this.cboxReplacement);
            this.chkPreserveCase = new JCheckBox();
            this.setLengthFilter(this.cboxReplacement);
        }
        this.lblScope = new JLabel();
        this.cboxScope = ComponentUtils.adjustComboForScope(new JComboBox(), this.preferredSearchScopeType, this.extraSearchScopes);
        this.lblScope.setLabelFor((Component)this.cboxScope.getComponent());
        this.lblFileNamePattern = new JLabel();
        this.lblFileNameHint = new JLabel();
        this.lblFileNameHint.setEnabled(false);
        this.cboxFileNamePattern = ComponentUtils.adjustComboForFileName(new JComboBox());
        this.lblFileNamePattern.setLabelFor((Component)this.cboxFileNamePattern.getComponent());
        this.setLengthFilter((JComboBox)this.cboxFileNamePattern.getComponent());
        this.chkWholeWords = new JCheckBox();
        this.chkCaseSensitive = new JCheckBox();
        this.textToFindType = new TextToFindTypeComboBox();
        TextPatternCheckBoxGroup.bind(this.chkCaseSensitive, this.chkWholeWords, this.textToFindType, this.chkPreserveCase);
        this.setMnemonics(bl);
        this.initFormPanel(bl);
        this.updateTextToFindInfo();
        this.add(this.formPanel);
        if (this.cboxReplacement != null) {
            Component component = this.cboxReplacement.getEditor().getEditorComponent();
            this.replacementPatternEditor = (JTextComponent)component;
        }
        this.setLayout(new BoxLayout(this, 3));
    }

    protected void initFormPanel(boolean bl) {
        this.formPanel = new SearchFormPanel();
        this.formPanel.addRow(this.lblTextToFind, (JComponent)this.cboxTextToFind.getComponent(), true);
        JPanel jPanel = this.initHintAndButtonPanel();
        this.formPanel.addRow(new JLabel(), jPanel);
        this.initContainingTextOptionsRow(bl);
        if (bl) {
            this.formPanel.addRow(this.lblReplacement, this.cboxReplacement, true);
        }
        this.formPanel.addSeparator();
        this.formPanel.addRow(this.lblScope, (JComponent)this.cboxScope.getComponent());
        this.initScopeOptionsRow(bl);
        this.formPanel.addSeparator();
        this.formPanel.addRow(this.lblFileNamePattern, (JComponent)this.cboxFileNamePattern.getComponent());
        this.formPanel.addRow(new JLabel(), this.lblFileNameHint);
        this.formPanel.addRow(new JLabel(), this.scopeSettingsPanel.getFileNameComponent());
        this.formPanel.addEmptyLine();
    }

    private void initContainingTextOptionsRow(boolean bl) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(this.textToFindType);
        this.lclz(jLabel, "BasicSearchForm.textToFindType.label.text");
        jLabel.setBorder(new EmptyBorder(0, 10, 0, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.textToFindType);
        if (bl) {
            FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);
            formLayoutHelper.addRow(this.chkCaseSensitive, this.chkPreserveCase);
            formLayoutHelper.addRow(this.chkWholeWords, jPanel2);
            jPanel.setMaximumSize(jPanel.getMinimumSize());
            this.formPanel.addRow(new JLabel(), jPanel);
        } else {
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.chkCaseSensitive);
            jPanel.add(this.chkWholeWords);
            jPanel.add(jPanel2);
            this.formPanel.addRow(new JLabel(), jPanel);
        }
    }

    private void initScopeOptionsRow(boolean bl) {
        this.scopeSettingsPanel = ComponentUtils.adjustPanelsForOptions(new JPanel(), new JPanel(), bl, this.cboxFileNamePattern);
        this.formPanel.addRow(new JLabel(), (JComponent)this.scopeSettingsPanel.getComponent());
    }

    private void initAccessibility(boolean bl) {
        this.chkCaseSensitive.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkCaseSensitive.AccessibleDescription"));
        this.textToFindType.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.textToFindType.AccessibleDescription"));
        this.chkWholeWords.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkWholeWords.AccessibleDescription"));
        if (bl) {
            this.cboxReplacement.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.cbox.Replacement.AccessibleDescription"));
            this.chkPreserveCase.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkPreserveCase.AccessibleDescription"));
        }
    }

    private void initValuesFromCriteria(BasicSearchCriteria basicSearchCriteria, boolean bl) {
        this.cboxTextToFind.setSearchPattern(basicSearchCriteria.getSearchPattern());
        if (this.cboxReplacement != null) {
            this.cboxReplacement.setSelectedItem(new ReplaceModelItem(ReplacePattern.create(basicSearchCriteria.getReplaceExpr(), basicSearchCriteria.isPreserveCase())));
        }
        BasicSearchForm.selectChk(this.chkPreserveCase, basicSearchCriteria.isPreserveCase());
        this.scopeSettingsPanel.setFileNameRegexp(basicSearchCriteria.isFileNameRegexp());
        this.scopeSettingsPanel.setUseIgnoreList(basicSearchCriteria.isUseIgnoreList());
        this.cboxFileNamePattern.setRegularExpression(basicSearchCriteria.isFileNameRegexp());
        this.cboxFileNamePattern.setFileNamePattern(basicSearchCriteria.getFileNamePatternExpr());
        if (!bl) {
            this.scopeSettingsPanel.setSearchInArchives(basicSearchCriteria.isSearchInArchives());
            this.scopeSettingsPanel.setSearchInGenerated(basicSearchCriteria.isSearchInGenerated());
        }
    }

    private static void selectChk(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    private void initInteraction(boolean bl) {
        TextFieldFocusListener textFieldFocusListener = new TextFieldFocusListener();
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.addFocusListener(textFieldFocusListener);
        }
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.getDocument().addDocumentListener(new ReplacementPatternListener());
        }
        this.textToFindType.addItemListener(this);
        this.cboxTextToFind.bindMatchTypeComboBox(this.textToFindType);
        this.cboxTextToFind.bind(SearchPatternController.Option.MATCH_CASE, this.chkCaseSensitive);
        this.cboxTextToFind.bind(SearchPatternController.Option.WHOLE_WORDS, this.chkWholeWords);
        this.textToFindType.addActionListener(actionEvent -> {});
        boolean bl2 = this.textToFindType.isRegexp();
        boolean bl3 = this.chkCaseSensitive.isSelected();
        this.chkWholeWords.setEnabled(!bl2);
        if (bl) {
            this.chkPreserveCase.addItemListener(this);
            this.chkPreserveCase.setEnabled(!bl2 && !bl3);
        }
        this.searchCriteria.setUsabilityChangeListener(this);
        this.scopeSettingsPanel.addChangeListener(changeEvent -> {
            this.searchCriteria.setSearchInArchives(this.scopeSettingsPanel.isSearchInArchives());
            this.searchCriteria.setSearchInGenerated(this.scopeSettingsPanel.isSearchInGenerated());
            this.searchCriteria.setUseIgnoreList(this.scopeSettingsPanel.isUseIgnoreList());
        });
        this.cboxFileNamePattern.addChangeListener(changeEvent -> {
            this.searchCriteria.setFileNamePattern(this.cboxFileNamePattern.getFileNamePattern());
            this.searchCriteria.setFileNameRegexp(this.cboxFileNamePattern.isRegularExpression());
            this.updateFileNamePatternInfo();
        });
        this.cboxTextToFind.addChangeListener(changeEvent -> {
            SearchPattern searchPattern = this.cboxTextToFind.getSearchPattern();
            this.searchCriteria.setTextPattern(searchPattern.getSearchExpression());
            this.searchCriteria.setMatchType(searchPattern.getMatchType());
            this.searchCriteria.setWholeWords(searchPattern.isWholeWords());
            this.searchCriteria.setCaseSensitive(searchPattern.isMatchCase());
        });
        this.initButtonInteraction();
    }

    private void initButtonInteraction() {
        this.btnTestTextToFind.addActionListener(actionEvent -> this.openTextPatternSandbox());
    }

    private void openTextPatternSandbox() {
        SearchPattern searchPattern = this.cboxTextToFind.getSearchPattern();
        String string = searchPattern.getSearchExpression() == null ? "" : searchPattern.getSearchExpression();
        boolean bl = this.chkCaseSensitive.isSelected();
        PatternSandbox.openDialog(new PatternSandbox.TextPatternSandbox(string, bl){

            @Override
            protected void onApply(String string, boolean bl) {
                BasicSearchForm.this.cboxTextToFind.setSearchPattern(SearchPattern.create(string, false, bl, true));
            }
        }, this.btnTestTextToFind);
    }

    private void initHistory() {
        ArrayList<ReplaceModelItem> arrayList = new ArrayList<ReplaceModelItem>(10);
        if (this.cboxReplacement != null) {
            for (ReplacePattern replacePattern : SearchHistory.getDefault().getReplacePatterns()) {
                arrayList.add(0, new ReplaceModelItem(replacePattern));
            }
            if (!arrayList.isEmpty()) {
                this.cboxReplacement.setModel(new ListComboBoxModel(arrayList, true));
            }
        }
    }

    private void initValuesFromHistory(boolean bl) {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (findDialogMemory.isFileNamePatternSpecified() && ((JComboBox)this.cboxFileNamePattern.getComponent()).getItemCount() != 0) {
            ((JComboBox)this.cboxFileNamePattern.getComponent()).setSelectedIndex(0);
        }
        this.cboxFileNamePattern.setRegularExpression(findDialogMemory.isFilePathRegex());
        if (this.cboxReplacement != null && this.cboxReplacement.getItemCount() != 0 && FindDialogMemory.getDefault().isReplacePatternSpecified()) {
            this.cboxReplacement.setSelectedIndex(0);
        }
        this.chkWholeWords.setSelected(findDialogMemory.isWholeWords());
        this.chkCaseSensitive.setSelected(findDialogMemory.isCaseSensitive());
        this.textToFindType.setSelectedItem((Object)findDialogMemory.getMatchType());
        this.scopeSettingsPanel.setFileNameRegexp(findDialogMemory.isFilePathRegex());
        this.scopeSettingsPanel.setUseIgnoreList(findDialogMemory.IsUseIgnoreList());
        if (bl) {
            this.chkPreserveCase.setSelected(findDialogMemory.isPreserveCase());
        } else {
            this.scopeSettingsPanel.setSearchInArchives(findDialogMemory.isSearchInArchives());
            this.scopeSettingsPanel.setSearchInGenerated(findDialogMemory.isSearchInGenerated());
        }
    }

    private void setSearchCriteriaValues() {
        this.searchCriteria.setWholeWords(this.chkWholeWords.isSelected());
        this.searchCriteria.setCaseSensitive(this.chkCaseSensitive.isSelected());
        this.searchCriteria.setMatchType(this.textToFindType.getSelectedMatchType());
        this.searchCriteria.setFileNameRegexp(this.scopeSettingsPanel.isFileNameRegExp());
        this.searchCriteria.setUseIgnoreList(this.scopeSettingsPanel.isUseIgnoreList());
        this.searchCriteria.setSearchInArchives(this.scopeSettingsPanel.isSearchInArchives());
        this.searchCriteria.setSearchInGenerated(this.scopeSettingsPanel.isSearchInGenerated());
        if (this.chkPreserveCase != null) {
            this.searchCriteria.setPreserveCase(this.chkPreserveCase.isSelected());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return ((JComboBox)this.cboxTextToFind.getComponent()).requestFocusInWindow();
    }

    private void updateReplacePatternColor() {
        boolean bl = this.invalidReplacePattern;
        this.invalidReplacePattern = this.searchCriteria.isReplacePatternInvalid();
        if (this.invalidReplacePattern != bl) {
            if (this.defaultTextColor == null) {
                assert (!bl);
                this.defaultTextColor = this.cboxReplacement.getForeground();
            }
            this.replacementPatternEditor.setForeground(this.invalidReplacePattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private static boolean isBackrefSyntaxUsed(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 2) {
            return false;
        }
        String string2 = string.substring(0, n2 - 1);
        int n3 = 0;
        while ((n = string2.indexOf(92, n3)) != -1) {
            char c = string.charAt(n + 1);
            if (c == '\\') {
                n3 = n + 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                return true;
            }
            n3 = n + 2;
        }
        return false;
    }

    private Color getErrorTextColor() {
        if (this.errorTextColor == null) {
            this.errorTextColor = UIManager.getDefaults().getColor("TextField.errorForeground");
            if (this.errorTextColor == null) {
                this.errorTextColor = Color.RED;
            }
        }
        return this.errorTextColor;
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.textToFindType) {
            if (this.cboxReplacement != null) {
                this.updateReplacePatternColor();
            }
            this.updateTextToFindInfo();
        } else if (itemSelectable == this.chkPreserveCase) {
            this.searchCriteria.setPreserveCase(bl);
        } else assert (false);
    }

    private void updateTextToFindInfo() {
        String string;
        switch (this.cboxTextToFind.getSearchPattern().getMatchType()) {
            case LITERAL: {
                string = "BasicSearchForm.cboxTextToFind.info.literal";
                break;
            }
            case BASIC: {
                string = "BasicSearchForm.cboxTextToFind.info";
                break;
            }
            case REGEXP: {
                string = "BasicSearchForm.cboxTextToFind.info.re";
                break;
            }
            default: {
                string = "BasicSearchForm.cboxTextToFind.info";
            }
        }
        String string2 = UiUtils.getText(string);
        ((JComboBox)this.cboxTextToFind.getComponent()).setToolTipText(string2);
        this.lblTextToFindHint.setText(string2);
        this.btnTestTextToFindPanel.setButtonEnabled(this.searchCriteria.getSearchPattern().isRegExp());
    }

    private void updateFileNamePatternInfo() {
        this.lblFileNameHint.setText(UiUtils.getFileNamePatternsExample(this.cboxFileNamePattern.isRegularExpression()));
    }

    void onOk() {
        this.searchCriteria.onOk();
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (this.searchCriteria.isTextPatternUsable()) {
            SearchHistory.getDefault().add(this.getCurrentSearchPattern());
            findDialogMemory.setTextPatternSpecified(true);
        } else {
            findDialogMemory.setTextPatternSpecified(false);
        }
        if (this.searchCriteria.isFileNamePatternUsable()) {
            findDialogMemory.storeFileNamePattern(this.searchCriteria.getFileNamePatternExpr());
            findDialogMemory.setFileNamePatternSpecified(true);
        } else {
            findDialogMemory.setFileNamePatternSpecified(false);
        }
        if (this.replacementPatternEditor != null) {
            String string = this.replacementPatternEditor.getText();
            SearchHistory.getDefault().addReplace(ReplacePattern.create(string, this.chkPreserveCase.isSelected()));
            FindDialogMemory.getDefault().setReplacePatternSpecified(string != null && !string.isEmpty());
        }
        findDialogMemory.setWholeWords(this.chkWholeWords.isSelected());
        findDialogMemory.setCaseSensitive(this.chkCaseSensitive.isSelected());
        findDialogMemory.setMatchType(this.textToFindType.getSelectedMatchType());
        if (this.searchCriteria.isSearchAndReplace()) {
            findDialogMemory.setPreserveCase(this.chkPreserveCase.isSelected());
        } else {
            findDialogMemory.setSearchInArchives(this.scopeSettingsPanel.isSearchInArchives());
            if (!this.searchInGeneratedSetAutomatically) {
                findDialogMemory.setSearchInGenerated(this.scopeSettingsPanel.isSearchInGenerated());
            }
        }
        findDialogMemory.setFilePathRegex(this.scopeSettingsPanel.isFileNameRegExp());
        findDialogMemory.setUseIgnoreList(this.scopeSettingsPanel.isUseIgnoreList());
        if (this.cboxScope.getSelectedScopeId() != null && !SearchPanel.isOpenedForSelection()) {
            findDialogMemory.setScopeTypeId(this.cboxScope.getSelectedScopeId());
        }
    }

    private SearchPattern getCurrentSearchPattern() {
        return this.cboxTextToFind.getSearchPattern();
    }

    public SearchInfo getSearchInfo() {
        return this.cboxScope.getSearchInfo();
    }

    public String getSelectedScopeName() {
        return this.cboxScope.getSelectedScopeTitle();
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        return this.searchCriteria;
    }

    boolean isUsable() {
        return this.cboxScope.getSearchInfo() != null && this.searchCriteria.isUsable();
    }

    private void setMnemonics(boolean bl) {
        this.lclz(this.lblTextToFind, "BasicSearchForm.lblTextToFind.text");
        this.lclz(this.lblScope, "BasicSearchForm.lblScope.text");
        this.lclz(this.lblFileNamePattern, "BasicSearchForm.lblFileNamePattern.text");
        this.lclz(this.chkWholeWords, "BasicSearchForm.chkWholeWords.text");
        this.lclz(this.chkCaseSensitive, "BasicSearchForm.chkCaseSensitive.text");
        this.btnTestTextToFind.setText(UiUtils.getHtmlLink("BasicSearchForm.btnTestTextToFind.text"));
        this.btnTestTextToFind.setToolTipText(UiUtils.getText("BasicSearchForm.btnTestTextToFind.tooltip"));
        if (bl) {
            this.lclz(this.lblReplacement, "BasicSearchForm.lblReplacement.text");
            this.lclz(this.chkPreserveCase, "BasicSearchForm.chkPreserveCase.text");
        }
    }

    private void lclz(AbstractButton abstractButton, String string) {
        UiUtils.lclz(abstractButton, string);
    }

    private void lclz(JLabel jLabel, String string) {
        UiUtils.lclz(jLabel, string);
    }

    private void setLengthFilter(JComboBox<?> jComboBox) {
        JTextComponent jTextComponent;
        Document document;
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent && (document = (jTextComponent = (JTextComponent)component).getDocument()) instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.setDocumentFilter(this.lengthFilter);
        }
    }

    private JPanel initHintAndButtonPanel() {
        this.btnTestTextToFindPanel = new LinkButtonPanel(this.btnTestTextToFind);
        this.btnTestTextToFindPanel.setButtonEnabled(this.searchCriteria.getSearchPattern().isRegExp());
        this.lblTextToFindHint.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.btnTestTextToFindPanel.getPreferredSize().getHeight()));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.lblTextToFindHint);
        jPanel.add(this.btnTestTextToFindPanel);
        return jPanel;
    }

    static final class MultiLineComboBoxEditor
    implements ComboBoxEditor {
        private final JTextArea area = new JTextArea();

        public MultiLineComboBoxEditor(JComboBox<?> jComboBox) {
            this.area.setWrapStyleWord(false);
            this.area.setLineWrap(false);
            Border border = ((JComponent)jComboBox.getEditor().getEditorComponent()).getBorder();
            if (border == null) {
                border = jComboBox.getBorder();
            }
            this.area.setBorder(border);
            this.area.setFocusTraversalKeys(0, null);
            this.area.setFocusTraversalKeys(1, null);
            this.area.getInputMap().put(KeyStroke.getKeyStroke("shift ENTER"), "insert-break");
            this.area.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "text-submit");
        }

        @Override
        public void setItem(Object object) {
            String string = Objects.toString(object, "");
            if (!string.equals(this.area.getText())) {
                this.area.setText(string);
            }
        }

        @Override
        public Object getItem() {
            return this.area.getText();
        }

        @Override
        public Component getEditorComponent() {
            return this.area;
        }

        @Override
        public void selectAll() {
            this.area.selectAll();
            this.area.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }
    }

    private static final class LengthFilter
    extends DocumentFilter {
        private static final int LIMIT = Integer.getInteger("nb.search.field.limit", 10000);

        private LengthFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3;
            int n4 = filterBypass.getDocument().getLength();
            int n5 = n4 + (n3 = string == null ? 0 : string.length()) - n2;
            if (n5 <= LIMIT) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            } else {
                this.limitReached();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = filterBypass.getDocument().getLength();
            int n3 = n2 + string.length();
            if (n3 <= LIMIT) {
                super.insertString(filterBypass, n, string, attributeSet);
            } else {
                this.limitReached();
            }
        }

        private void limitReached() {
            String string = Bundle.MSG_TextTooLong(LIMIT);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
            Logger.getLogger(BasicSearchForm.class.getName()).log(Level.INFO, string);
        }
    }

    private static class TextToFindTypeComboBox
    extends JComboBox<SearchPattern.MatchType> {
        public TextToFindTypeComboBox() {
            super(new SearchPattern.MatchType[]{SearchPattern.MatchType.LITERAL, SearchPattern.MatchType.BASIC, SearchPattern.MatchType.REGEXP});
        }

        public boolean isRegexp() {
            return this.isSelected(SearchPattern.MatchType.REGEXP);
        }

        public boolean isBasic() {
            return this.isSelected(SearchPattern.MatchType.BASIC);
        }

        public boolean isLiteral() {
            return this.isSelected(SearchPattern.MatchType.LITERAL);
        }

        public boolean isSelected(SearchPattern.MatchType matchType) {
            return this.getSelectedItem() == matchType;
        }

        private SearchPattern.MatchType getSelectedMatchType() {
            Object object = this.getSelectedItem();
            if (object instanceof SearchPattern.MatchType) {
                return (SearchPattern.MatchType)((Object)object);
            }
            throw new IllegalStateException("MatchType expected");
        }
    }

    private static class ReplaceModelItem {
        private ReplacePattern replacePattern;

        public ReplaceModelItem(ReplacePattern replacePattern) {
            this.replacePattern = replacePattern;
        }

        public ReplacePattern getReplacePattern() {
            return this.replacePattern;
        }

        public String toString() {
            return this.replacePattern.getReplaceExpression();
        }
    }

    private class ReplacementPatternListener
    extends PatternChangeListener {
        @Override
        public void handleComboBoxChange(String string) {
            BasicSearchForm.this.searchCriteria.setReplaceExpr(string);
            if (BasicSearchForm.this.cboxReplacement != null) {
                BasicSearchForm.this.updateReplacePatternColor();
            }
        }
    }

    static class TextPatternCheckBoxGroup
    implements ItemListener {
        private JCheckBox matchCase;
        private JCheckBox wholeWords;
        private TextToFindTypeComboBox textToFindType;
        private JCheckBox preserveCase;
        private boolean lastPreserveCaseValue;
        private boolean lastWholeWordsValue;

        private TextPatternCheckBoxGroup(JCheckBox jCheckBox, JCheckBox jCheckBox2, TextToFindTypeComboBox textToFindTypeComboBox, JCheckBox jCheckBox3) {
            this.matchCase = jCheckBox;
            this.wholeWords = jCheckBox2;
            this.textToFindType = textToFindTypeComboBox;
            this.preserveCase = jCheckBox3;
        }

        private void initListeners() {
            this.matchCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.textToFindType.addItemListener(this);
            if (this.preserveCase != null) {
                this.preserveCase.addItemListener(this);
            }
        }

        private void matchCaseChanged() {
            this.updatePreserveCaseAllowed();
        }

        private void regexpChanged() {
            this.updateWholeWordsAllowed();
            this.updatePreserveCaseAllowed();
        }

        private void updateWholeWordsAllowed() {
            if (this.textToFindType.isRegexp() == this.wholeWords.isEnabled()) {
                if (this.textToFindType.isRegexp()) {
                    this.lastWholeWordsValue = this.wholeWords.isSelected();
                    this.wholeWords.setSelected(false);
                    this.wholeWords.setEnabled(false);
                } else {
                    this.wholeWords.setEnabled(true);
                    this.wholeWords.setSelected(this.lastWholeWordsValue);
                }
            }
        }

        private void updatePreserveCaseAllowed() {
            if (this.preserveCase == null) {
                return;
            }
            if (this.preserveCase.isEnabled() == (this.textToFindType.isRegexp() || this.matchCase.isSelected())) {
                if (this.preserveCase.isEnabled()) {
                    this.lastPreserveCaseValue = this.preserveCase.isSelected();
                    this.preserveCase.setSelected(false);
                    this.preserveCase.setEnabled(false);
                } else {
                    this.preserveCase.setEnabled(true);
                    this.preserveCase.setSelected(this.lastPreserveCaseValue);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.matchCase) {
                this.matchCaseChanged();
            } else if (itemSelectable == this.textToFindType) {
                this.regexpChanged();
            }
        }

        static void bind(JCheckBox jCheckBox, JCheckBox jCheckBox2, TextToFindTypeComboBox textToFindTypeComboBox, JCheckBox jCheckBox3) {
            TextPatternCheckBoxGroup textPatternCheckBoxGroup = new TextPatternCheckBoxGroup(jCheckBox, jCheckBox2, textToFindTypeComboBox, jCheckBox3);
            textPatternCheckBoxGroup.initListeners();
        }
    }

    private final class SearchFormPanel
    extends JPanel {
        private int row = 0;

        public SearchFormPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        public void addRow(JComponent jComponent, JComponent jComponent2) {
            this.addRow(jComponent, jComponent2, false);
        }

        public void addRow(JComponent jComponent, JComponent jComponent2, boolean bl) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridy = this.row;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            if (bl) {
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
            } else {
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
            }
            this.add((Component)jComponent2, gridBagConstraints);
            ++this.row;
        }

        public void addSeparator() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.row++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 2;
            JSeparator jSeparator = new JSeparator(0);
            this.add((Component)jSeparator, gridBagConstraints);
        }

        public void addEmptyLine() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.row++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.1;
            JLabel jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(0, 0));
            jLabel.setMinimumSize(new Dimension(0, 0));
            this.add((Component)jLabel, gridBagConstraints);
        }
    }
}

