/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jogamp.graph.font.typecast.ot.TTFont;
import jogamp.graph.font.typecast.ot.mac.ResourceHeader;
import jogamp.graph.font.typecast.ot.mac.ResourceMap;
import jogamp.graph.font.typecast.ot.mac.ResourceReference;
import jogamp.graph.font.typecast.ot.mac.ResourceType;
import jogamp.graph.font.typecast.ot.table.TTCHeader;

public class OTFontCollection {
    private final boolean DEBUG = false;
    private TTCHeader _ttcHeader;
    private TTFont[] _fonts;
    private String _pathName;
    private String _fileName;
    private boolean _resourceFork = false;

    public String getPathName() {
        return this._pathName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public TTFont getFont(int n) {
        return this._fonts[n];
    }

    public int getFontCount() {
        return this._fonts.length;
    }

    public TTCHeader getTtcHeader() {
        return this._ttcHeader;
    }

    public OTFontCollection(File file) throws IOException {
        this.read(file);
    }

    public OTFontCollection(InputStream inputStream, int n) throws IOException {
        this.read(inputStream, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(File file) throws IOException {
        this._pathName = file.getPath();
        this._fileName = file.getName();
        if (!file.exists()) {
            throw new IOException("File <" + file.getName() + "> doesn't exist.");
        }
        if (file.length() == 0L) {
            if (!(file = new File(file, "..namedfork/rsrc")).exists()) {
                throw new IOException("File <" + file.getName() + "> doesn't exist.");
            }
            this._resourceFork = true;
        }
        int n = (int)file.length();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), n);){
            this.readImpl(bufferedInputStream, n);
        }
    }

    protected void read(InputStream inputStream, int n) throws IOException {
        this._pathName = "";
        this._fileName = "";
        InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, n);
        this.readImpl(inputStream2, n);
    }

    private void readImpl(InputStream inputStream, int n) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("stream of type " + inputStream.getClass().getName() + " doesn't support mark");
        }
        inputStream.mark(n);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (this._resourceFork || this._pathName.endsWith(".dfont")) {
            ResourceHeader resourceHeader = new ResourceHeader(dataInputStream);
            dataInputStream.reset();
            dataInputStream.skip(resourceHeader.getMapOffset());
            ResourceMap resourceMap = new ResourceMap(dataInputStream);
            ResourceType resourceType = resourceMap.getResourceType("sfnt");
            this._fonts = new TTFont[resourceType.getCount()];
            for (int i = 0; i < resourceType.getCount(); ++i) {
                ResourceReference resourceReference = resourceType.getReference(i);
                int n2 = resourceHeader.getDataOffset() + resourceReference.getDataOffset() + 4;
                this._fonts[i] = new TTFont(dataInputStream, n2, n2);
            }
        } else if (TTCHeader.isTTC(dataInputStream)) {
            dataInputStream.reset();
            this._ttcHeader = new TTCHeader(dataInputStream);
            this._fonts = new TTFont[this._ttcHeader.getDirectoryCount()];
            for (int i = 0; i < this._ttcHeader.getDirectoryCount(); ++i) {
                this._fonts[i] = new TTFont(dataInputStream, this._ttcHeader.getTableDirectory(i), 0);
            }
        } else {
            this._fonts = new TTFont[1];
            this._fonts[0] = new TTFont(dataInputStream, 0, 0);
        }
        dataInputStream.close();
    }
}

