/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteTextField;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.BaseboardChoiceController;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.RoomController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RoomPanel
extends JPanel
implements DialogView {
    private final RoomController controller;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private NullableCheckBox areaVisibleCheckBox;
    private NullableCheckBox floorVisibleCheckBox;
    private JRadioButton floorColorRadioButton;
    private ColorButton floorColorButton;
    private JRadioButton floorTextureRadioButton;
    private JComponent floorTextureComponent;
    private JRadioButton floorMattRadioButton;
    private JRadioButton floorShinyRadioButton;
    private NullableCheckBox ceilingVisibleCheckBox;
    private JRadioButton ceilingColorRadioButton;
    private ColorButton ceilingColorButton;
    private JRadioButton ceilingTextureRadioButton;
    private JComponent ceilingTextureComponent;
    private JRadioButton ceilingMattRadioButton;
    private JRadioButton ceilingShinyRadioButton;
    private NullableCheckBox ceilingFlatCheckBox;
    private JCheckBox splitSurroundingWallsCheckBox;
    private JRadioButton wallSidesColorRadioButton;
    private ColorButton wallSidesColorButton;
    private JRadioButton wallSidesTextureRadioButton;
    private JComponent wallSidesTextureComponent;
    private JRadioButton wallSidesMattRadioButton;
    private JRadioButton wallSidesShinyRadioButton;
    private JComponent wallSidesBaseboardComponent;
    private boolean firstWallChange;
    private String dialogTitle;

    public RoomPanel(UserPreferences userPreferences, RoomController roomController) {
        super(new GridBagLayout());
        this.controller = roomController;
        this.createComponents(userPreferences, roomController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
        this.firstWallChange = true;
    }

    private void createComponents(UserPreferences userPreferences, final RoomController roomController) {
        Object object;
        Object object2;
        if (roomController.isPropertyEditable(RoomController.Property.NAME)) {
            this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "nameLabel.text", new Object[0]));
            this.nameTextField = new AutoCompleteTextField(roomController.getName(), 10, userPreferences.getAutoCompletionStrings("RoomName"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
            }
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.nameTextField.setText(roomController.getName());
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.NAME, (PropertyChangeListener)object2);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$nameChangeListener;
                {
                    this.val$nameChangeListener = propertyChangeListener;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    roomController.removePropertyChangeListener(RoomController.Property.NAME, this.val$nameChangeListener);
                    String string = RoomPanel.this.nameTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        roomController.setName("");
                    } else {
                        roomController.setName(string);
                    }
                    roomController.addPropertyChangeListener(RoomController.Property.NAME, this.val$nameChangeListener);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.AREA_VISIBLE)) {
            this.areaVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "areaVisibleCheckBox.text", new Object[0]));
            this.areaVisibleCheckBox.setNullable(roomController.getAreaVisible() == null);
            this.areaVisibleCheckBox.setValue(roomController.getAreaVisible());
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.areaVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    RoomPanel.this.areaVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.AREA_VISIBLE, (PropertyChangeListener)object2);
            this.areaVisibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$visibleChangeListener;
                {
                    this.val$visibleChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    roomController.removePropertyChangeListener(RoomController.Property.AREA_VISIBLE, this.val$visibleChangeListener);
                    roomController.setAreaVisible(RoomPanel.this.areaVisibleCheckBox.getValue());
                    roomController.addPropertyChangeListener(RoomController.Property.AREA_VISIBLE, this.val$visibleChangeListener);
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.FLOOR_VISIBLE)) {
            this.floorVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorVisibleCheckBox.text", new Object[0]));
            this.floorVisibleCheckBox.setNullable(roomController.getFloorVisible() == null);
            this.floorVisibleCheckBox.setValue(roomController.getFloorVisible());
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.floorVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    RoomPanel.this.floorVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, (PropertyChangeListener)object2);
            this.floorVisibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$floorVisibleChangeListener;
                {
                    this.val$floorVisibleChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    roomController.removePropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, this.val$floorVisibleChangeListener);
                    roomController.setFloorVisible(RoomPanel.this.floorVisibleCheckBox.getValue());
                    roomController.addPropertyChangeListener(RoomController.Property.FLOOR_VISIBLE, this.val$floorVisibleChangeListener);
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.FLOOR_PAINT)) {
            this.floorColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorColorRadioButton.text", new Object[0]));
            this.floorColorRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.floorColorRadioButton.isSelected()) {
                        roomController.setFloorPaint(RoomController.RoomPaint.COLORED);
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.FLOOR_PAINT, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateFloorColorRadioButtons(roomController);
                }
            });
            this.floorColorButton = new ColorButton(userPreferences);
            this.floorColorButton.setColor(roomController.getFloorColor());
            this.floorColorButton.setColorDialogTitle(userPreferences.getLocalizedString(RoomPanel.class, "floorColorDialog.title", new Object[0]));
            this.floorColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    roomController.setFloorColor(RoomPanel.this.floorColorButton.getColor());
                    roomController.setFloorPaint(RoomController.RoomPaint.COLORED);
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.FLOOR_COLOR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.floorColorButton.setColor(roomController.getFloorColor());
                }
            });
            this.floorTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorTextureRadioButton.text", new Object[0]));
            this.floorTextureRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.floorTextureRadioButton.isSelected()) {
                        roomController.setFloorPaint(RoomController.RoomPaint.TEXTURED);
                    }
                }
            });
            this.floorTextureComponent = (JComponent)((Object)roomController.getFloorTextureController().getView());
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.floorColorRadioButton);
            ((ButtonGroup)object2).add(this.floorTextureRadioButton);
            this.updateFloorColorRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.FLOOR_SHININESS)) {
            this.floorMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorMattRadioButton.text", new Object[0]));
            this.floorMattRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.floorMattRadioButton.isSelected()) {
                        roomController.setFloorShininess(Float.valueOf(0.0f));
                    }
                }
            });
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateFloorShininessRadioButtons(roomController);
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.FLOOR_SHININESS, (PropertyChangeListener)object2);
            this.floorShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "floorShinyRadioButton.text", new Object[0]));
            this.floorShinyRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.floorShinyRadioButton.isSelected()) {
                        roomController.setFloorShininess(Float.valueOf(0.25f));
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.FLOOR_SHININESS, (PropertyChangeListener)object2);
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.floorMattRadioButton);
            ((ButtonGroup)object).add(this.floorShinyRadioButton);
            this.updateFloorShininessRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.CEILING_VISIBLE)) {
            this.ceilingVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingVisibleCheckBox.text", new Object[0]));
            this.ceilingVisibleCheckBox.setNullable(roomController.getCeilingVisible() == null);
            this.ceilingVisibleCheckBox.setValue(roomController.getCeilingVisible());
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.ceilingVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    RoomPanel.this.ceilingVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_VISIBLE, (PropertyChangeListener)object2);
            this.ceilingVisibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$ceilingVisibleChangeListener;
                {
                    this.val$ceilingVisibleChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    roomController.removePropertyChangeListener(RoomController.Property.CEILING_VISIBLE, this.val$ceilingVisibleChangeListener);
                    roomController.setCeilingVisible(RoomPanel.this.ceilingVisibleCheckBox.getValue());
                    roomController.addPropertyChangeListener(RoomController.Property.CEILING_VISIBLE, this.val$ceilingVisibleChangeListener);
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.CEILING_PAINT)) {
            this.ceilingColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingColorRadioButton.text", new Object[0]));
            this.ceilingColorRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.ceilingColorRadioButton.isSelected()) {
                        roomController.setCeilingPaint(RoomController.RoomPaint.COLORED);
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_PAINT, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateCeilingColorRadioButtons(roomController);
                }
            });
            this.ceilingColorButton = new ColorButton(userPreferences);
            this.ceilingColorButton.setColor(roomController.getCeilingColor());
            this.ceilingColorButton.setColorDialogTitle(userPreferences.getLocalizedString(RoomPanel.class, "ceilingColorDialog.title", new Object[0]));
            this.ceilingColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    roomController.setCeilingColor(RoomPanel.this.ceilingColorButton.getColor());
                    roomController.setCeilingPaint(RoomController.RoomPaint.COLORED);
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_COLOR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.ceilingColorButton.setColor(roomController.getCeilingColor());
                }
            });
            this.ceilingTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingTextureRadioButton.text", new Object[0]));
            this.ceilingTextureRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.ceilingTextureRadioButton.isSelected()) {
                        roomController.setCeilingPaint(RoomController.RoomPaint.TEXTURED);
                    }
                }
            });
            this.ceilingTextureComponent = (JComponent)((Object)roomController.getCeilingTextureController().getView());
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.ceilingColorRadioButton);
            ((ButtonGroup)object2).add(this.ceilingTextureRadioButton);
            this.updateCeilingColorRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.CEILING_SHININESS)) {
            this.ceilingMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingMattRadioButton.text", new Object[0]));
            this.ceilingMattRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.ceilingMattRadioButton.isSelected()) {
                        roomController.setCeilingShininess(Float.valueOf(0.0f));
                    }
                }
            });
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateCeilingShininessRadioButtons(roomController);
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_SHININESS, (PropertyChangeListener)object2);
            this.ceilingShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingShinyRadioButton.text", new Object[0]));
            this.ceilingShinyRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.ceilingShinyRadioButton.isSelected()) {
                        roomController.setCeilingShininess(Float.valueOf(0.25f));
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_SHININESS, (PropertyChangeListener)object2);
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.ceilingMattRadioButton);
            ((ButtonGroup)object).add(this.ceilingShinyRadioButton);
            this.updateCeilingShininessRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.CEILING_FLAT)) {
            this.ceilingFlatCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "ceilingFlatCheckBox.text", new Object[0]));
            this.ceilingFlatCheckBox.setNullable(roomController.getCeilingFlat() == null);
            this.ceilingFlatCheckBox.setValue(roomController.getCeilingFlat());
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.ceilingFlatCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    RoomPanel.this.ceilingFlatCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.CEILING_FLAT, (PropertyChangeListener)object2);
            this.ceilingFlatCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$ceilingFlatChangeListener;
                {
                    this.val$ceilingFlatChangeListener = propertyChangeListener;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    roomController.removePropertyChangeListener(RoomController.Property.CEILING_FLAT, this.val$ceilingFlatChangeListener);
                    roomController.setCeilingFlat(RoomPanel.this.ceilingFlatCheckBox.getValue());
                    roomController.addPropertyChangeListener(RoomController.Property.CEILING_FLAT, this.val$ceilingFlatChangeListener);
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.SPLIT_SURROUNDING_WALLS)) {
            this.splitSurroundingWallsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "splitSurroundingWallsCheckBox.text", new Object[0]));
            object2 = userPreferences.getLocalizedString(RoomPanel.class, "splitSurroundingWallsCheckBox.tooltip", new Object[0]);
            object = new PropertyChangeListener((String)object2){
                final /* synthetic */ String val$splitSurroundingWallsToolTip;
                {
                    this.val$splitSurroundingWallsToolTip = string;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.splitSurroundingWallsCheckBox.setEnabled(roomController.isSplitSurroundingWallsNeeded());
                    if (this.val$splitSurroundingWallsToolTip.length() > 0 && roomController.isSplitSurroundingWallsNeeded()) {
                        RoomPanel.this.splitSurroundingWallsCheckBox.setToolTipText(this.val$splitSurroundingWallsToolTip);
                    } else {
                        RoomPanel.this.splitSurroundingWallsCheckBox.setToolTipText(null);
                    }
                    RoomPanel.this.splitSurroundingWallsCheckBox.setSelected(roomController.isSplitSurroundingWalls());
                }
            };
            object.propertyChange(null);
            roomController.addPropertyChangeListener(RoomController.Property.SPLIT_SURROUNDING_WALLS, (PropertyChangeListener)object);
            this.splitSurroundingWallsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    roomController.setSplitSurroundingWalls(RoomPanel.this.splitSurroundingWallsCheckBox.isSelected());
                    RoomPanel.this.firstWallChange = false;
                }
            });
        }
        if (roomController.isPropertyEditable(RoomController.Property.WALL_SIDES_PAINT)) {
            this.wallSidesColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "wallSidesColorRadioButton.text", new Object[0]));
            this.wallSidesColorRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.wallSidesColorRadioButton.isSelected()) {
                        roomController.setWallSidesPaint(RoomController.RoomPaint.COLORED);
                        RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.WALL_SIDES_PAINT, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateWallSidesRadioButtons(roomController);
                }
            });
            this.wallSidesColorButton = new ColorButton(userPreferences);
            this.wallSidesColorButton.setColor(roomController.getWallSidesColor());
            this.wallSidesColorButton.setColorDialogTitle(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesColorDialog.title", new Object[0]));
            this.wallSidesColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    roomController.setWallSidesColor(RoomPanel.this.wallSidesColorButton.getColor());
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.WALL_SIDES_COLOR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.wallSidesColorButton.setColor(roomController.getWallSidesColor());
                    RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                }
            });
            this.wallSidesTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "wallSidesTextureRadioButton.text", new Object[0]));
            this.wallSidesTextureRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.wallSidesTextureRadioButton.isSelected()) {
                        roomController.setWallSidesPaint(RoomController.RoomPaint.TEXTURED);
                        RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                    }
                }
            });
            this.wallSidesTextureComponent = (JComponent)((Object)roomController.getWallSidesTextureController().getView());
            roomController.getWallSidesTextureController().addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                }
            });
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.wallSidesColorRadioButton);
            ((ButtonGroup)object2).add(this.wallSidesTextureRadioButton);
            this.updateWallSidesRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.WALL_SIDES_SHININESS)) {
            this.wallSidesMattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "wallSidesMattRadioButton.text", new Object[0]));
            this.wallSidesMattRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.wallSidesMattRadioButton.isSelected()) {
                        roomController.setWallSidesShininess(Float.valueOf(0.0f));
                        RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                    }
                }
            });
            object2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.updateWallSidesShininessRadioButtons(roomController);
                }
            };
            roomController.addPropertyChangeListener(RoomController.Property.WALL_SIDES_SHININESS, (PropertyChangeListener)object2);
            this.wallSidesShinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, RoomPanel.class, "wallSidesShinyRadioButton.text", new Object[0]));
            this.wallSidesShinyRadioButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (RoomPanel.this.wallSidesShinyRadioButton.isSelected()) {
                        roomController.setWallSidesShininess(Float.valueOf(0.25f));
                        RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                    }
                }
            });
            roomController.addPropertyChangeListener(RoomController.Property.WALL_SIDES_SHININESS, (PropertyChangeListener)object2);
            object = new ButtonGroup();
            ((ButtonGroup)object).add(this.wallSidesMattRadioButton);
            ((ButtonGroup)object).add(this.wallSidesShinyRadioButton);
            this.updateWallSidesShininessRadioButtons(roomController);
        }
        if (roomController.isPropertyEditable(RoomController.Property.WALL_SIDES_BASEBOARD)) {
            this.wallSidesBaseboardComponent = (JComponent)((Object)roomController.getWallSidesBaseboardController().getView());
            roomController.getWallSidesBaseboardController().addPropertyChangeListener(BaseboardChoiceController.Property.VISIBLE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RoomPanel.this.selectSplitSurroundingWallsAtFirstChange();
                }
            });
        }
        this.dialogTitle = userPreferences.getLocalizedString(RoomPanel.class, "room.title", new Object[0]);
    }

    private void updateFloorColorRadioButtons(RoomController roomController) {
        if (roomController.getFloorPaint() == RoomController.RoomPaint.COLORED) {
            this.floorColorRadioButton.setSelected(true);
        } else if (roomController.getFloorPaint() == RoomController.RoomPaint.TEXTURED) {
            this.floorTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.floorColorRadioButton, this.floorTextureRadioButton);
        }
    }

    private void updateFloorShininessRadioButtons(RoomController roomController) {
        if (roomController.getFloorShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.floorMattRadioButton, this.floorShinyRadioButton);
        } else if (roomController.getFloorShininess().floatValue() == 0.0f) {
            this.floorMattRadioButton.setSelected(true);
        } else {
            this.floorShinyRadioButton.setSelected(true);
        }
    }

    private void updateCeilingColorRadioButtons(RoomController roomController) {
        if (roomController.getCeilingPaint() == RoomController.RoomPaint.COLORED) {
            this.ceilingColorRadioButton.setSelected(true);
        } else if (roomController.getCeilingPaint() == RoomController.RoomPaint.TEXTURED) {
            this.ceilingTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.ceilingColorRadioButton, this.ceilingTextureRadioButton);
        }
    }

    private void updateCeilingShininessRadioButtons(RoomController roomController) {
        if (roomController.getCeilingShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.ceilingMattRadioButton, this.ceilingShinyRadioButton);
        } else if (roomController.getCeilingShininess().floatValue() == 0.0f) {
            this.ceilingMattRadioButton.setSelected(true);
        } else {
            this.ceilingShinyRadioButton.setSelected(true);
        }
    }

    private void updateWallSidesRadioButtons(RoomController roomController) {
        if (roomController.getWallSidesPaint() == RoomController.RoomPaint.COLORED) {
            this.wallSidesColorRadioButton.setSelected(true);
        } else if (roomController.getWallSidesPaint() == RoomController.RoomPaint.TEXTURED) {
            this.wallSidesTextureRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.wallSidesColorRadioButton, this.wallSidesTextureRadioButton);
        }
    }

    private void updateWallSidesShininessRadioButtons(RoomController roomController) {
        if (roomController.getWallSidesShininess() == null) {
            SwingTools.deselectAllRadioButtons(this.wallSidesMattRadioButton, this.wallSidesShinyRadioButton);
        } else if (roomController.getWallSidesShininess().floatValue() == 0.0f) {
            this.wallSidesMattRadioButton.setSelected(true);
        } else {
            this.wallSidesShinyRadioButton.setSelected(true);
        }
    }

    private void selectSplitSurroundingWallsAtFirstChange() {
        if (this.firstWallChange && this.splitSurroundingWallsCheckBox != null && this.splitSurroundingWallsCheckBox.isEnabled()) {
            this.splitSurroundingWallsCheckBox.doClick();
            this.firstWallChange = false;
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.nameLabel != null) {
                this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
                this.nameLabel.setLabelFor(this.nameTextField);
            }
            if (this.areaVisibleCheckBox != null) {
                this.areaVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "areaVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.floorVisibleCheckBox != null) {
                this.floorVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.floorColorRadioButton != null) {
                this.floorColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorColorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.floorTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.floorMattRadioButton != null) {
                this.floorMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorMattRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.floorShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "floorShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.ceilingVisibleCheckBox != null) {
                this.ceilingVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.ceilingColorRadioButton != null) {
                this.ceilingColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingColorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.ceilingTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.ceilingMattRadioButton != null) {
                this.ceilingMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingMattRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.ceilingShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.ceilingFlatCheckBox != null) {
                this.ceilingFlatCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "ceilingFlatCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.splitSurroundingWallsCheckBox != null) {
                this.splitSurroundingWallsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "splitSurroundingWallsCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.wallSidesColorRadioButton != null) {
                this.wallSidesColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesColorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.wallSidesTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.wallSidesMattRadioButton != null) {
                this.wallSidesMattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesMattRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.wallSidesShinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesShinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        Serializable serializable;
        JComponent jComponent;
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        if (this.nameLabel != null || this.areaVisibleCheckBox != null) {
            jComponent = SwingTools.createTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "nameAndAreaPanel.title", new Object[0]));
            if (this.nameLabel != null) {
                jComponent.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 8, 0, n2), 0, 0));
                jComponent.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
            }
            if (this.areaVisibleCheckBox != null) {
                jComponent.add((Component)this.areaVisibleCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            serializable = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, n2, 0);
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 2, (Insets)serializable, 0, 0));
        }
        if (this.floorVisibleCheckBox != null || this.floorColorRadioButton != null || this.floorMattRadioButton != null) {
            jComponent = new JLabel();
            jComponent.setPreferredSize(new JCheckBox().getPreferredSize());
            serializable = this.createVerticalTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "floorPanel.title", new Object[0]), new JComponent[][]{{this.floorVisibleCheckBox, null, this.floorColorRadioButton, this.floorColorButton, this.floorTextureRadioButton, this.floorTextureComponent, this.ceilingFlatCheckBox != null ? jComponent : null, null}, {this.floorMattRadioButton, this.floorShinyRadioButton}});
            this.add((Component)serializable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.ceilingVisibleCheckBox != null || this.ceilingColorRadioButton != null || this.ceilingMattRadioButton != null) {
            jComponent = new JLabel();
            jComponent.setPreferredSize(new JCheckBox().getPreferredSize());
            serializable = this.createVerticalTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "ceilingPanel.title", new Object[0]), new JComponent[][]{{this.ceilingVisibleCheckBox, null, this.ceilingColorRadioButton, this.ceilingColorButton, this.ceilingTextureRadioButton, this.ceilingTextureComponent, this.ceilingFlatCheckBox != null ? this.ceilingFlatCheckBox : jComponent, null}, {this.ceilingMattRadioButton, this.ceilingShinyRadioButton}});
            this.add((Component)serializable, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.wallSidesColorRadioButton != null || this.wallSidesMattRadioButton != null) {
            jComponent = new JLabel();
            jComponent.setPreferredSize(new JCheckBox().getPreferredSize());
            serializable = this.createVerticalTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesPanel.title", new Object[0]), new JComponent[][]{{this.splitSurroundingWallsCheckBox, null, this.wallSidesColorRadioButton, this.wallSidesColorButton, this.wallSidesTextureRadioButton, this.wallSidesTextureComponent, this.ceilingFlatCheckBox != null ? jComponent : null, null}, {this.wallSidesMattRadioButton, this.wallSidesShinyRadioButton}});
            this.add((Component)serializable, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.wallSidesBaseboardComponent != null) {
            jComponent = SwingTools.createTitledPanel(userPreferences.getLocalizedString(RoomPanel.class, "wallSidesBaseboardPanel.title", new Object[0]));
            jComponent.add((Component)this.wallSidesBaseboardComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, new JCheckBox().getPreferredSize().height, 0), 0, 0));
            this.add((Component)jComponent, new GridBagConstraints(3, 0, 1, 2, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private JPanel createVerticalTitledPanel(String string, JComponent[][] jComponentArray) {
        JPanel jPanel = SwingTools.createTitledPanel(string);
        int n = 0;
        block0: for (int i = 0; i < jComponentArray.length; ++i) {
            JComponent[] jComponentArray2 = jComponentArray[i];
            for (int j = 0; j < jComponentArray2.length; j += 2) {
                int n2 = j < jComponentArray2.length - 2 ? Math.round(2.0f * SwingTools.getResolutionScale()) : 0;
                JComponent jComponent = jComponentArray2[j];
                JComponent jComponent2 = jComponentArray2[j + 1];
                if (jComponent == null) continue;
                if (jComponent2 != null) {
                    jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, n2, Math.round(5.0f * SwingTools.getResolutionScale())), 0, 0));
                    jPanel.add((Component)jComponent2, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
                    continue;
                }
                jPanel.add((Component)jComponent, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
            }
            if (i >= jComponentArray.length - 1) continue;
            for (JComponent jComponent2 : jComponentArray[i + 1]) {
                if (jComponent2 == null) continue;
                jPanel.add((Component)new JSeparator(), new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
                continue block0;
            }
        }
        return jPanel;
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0 && this.controller != null) {
            this.controller.modifyRooms();
        }
    }
}

