/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.sdedit.util.Utilities;

public class ZipFile {
    private File file;
    private ZipOutputStream zos;
    private ZipInputStream zis;
    private Charset charset;
    private File rootDir;

    public ZipFile(File file, boolean createNew, Charset charset) throws IOException {
        this.file = file;
        this.charset = charset;
        if (createNew) {
            this.zos = this.openNew();
        } else {
            this.zis = this.openExisting();
        }
    }

    public ZipFile(File file, boolean createNew) throws IOException {
        this(file, createNew, null);
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDir = rootDirectory;
    }

    public static void createFromFiles(File file, File ... files) throws IOException {
        if (files != null) {
            ZipFile zipFile = new ZipFile(file, true);
            for (File f : files) {
                zipFile.addFile(f);
            }
            zipFile.close();
        }
    }

    @Deprecated
    public static void createFromFlatDirectory(File file, File dir) throws IOException {
        ZipFile.createFromDirectory(file, dir, Charset.defaultCharset());
    }

    public static void createFromDirectory(File zipFile, File dir, Charset charset) throws IOException {
        ZipFile zip = new ZipFile(zipFile, true);
        zip.setRootDirectory(dir);
        zip.addFile(dir);
        zip.close();
    }

    protected ZipOutputStream openNew() throws IOException {
        FileOutputStream os = new FileOutputStream(this.file);
        ZipOutputStream stream = this.charset == null ? new ZipOutputStream(os) : Utilities.newInstance(ZipOutputStream.class, os, this.charset);
        return stream;
    }

    protected ZipInputStream openExisting() throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        ZipInputStream stream = this.charset == null ? new ZipInputStream(is) : Utilities.newInstance(ZipInputStream.class, is, this.charset);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file) throws IOException {
        block7: {
            block6: {
                if (this.zos == null) {
                    throw new IllegalStateException("ZipFile in is read-file mode");
                }
                if (!file.isDirectory()) break block6;
                File[] files = file.listFiles();
                if (files == null) break block7;
                for (File f : files) {
                    this.addFile(f);
                }
                break block7;
            }
            FileInputStream fis = new FileInputStream(file);
            try {
                BufferedInputStream bis = new BufferedInputStream(fis);
                String name = file.getName();
                if (this.rootDir != null) {
                    name = file.getAbsolutePath().substring(this.rootDir.getAbsolutePath().length() + 1);
                }
                ZipEntry zipEntry = new ZipEntry(name);
                this.zos.putNextEntry(zipEntry);
                Utilities.pipe(bis, this.zos);
                this.zos.closeEntry();
            }
            finally {
                ((InputStream)fis).close();
            }
        }
    }

    public void close() throws IOException {
        if (this.zos != null) {
            this.zos.flush();
            this.zos.close();
        }
    }

    public String getNextEntry() throws IOException {
        ZipEntry zipEntry;
        if (this.zis == null) {
            throw new IllegalStateException("ZipFile is in create-new-file mode");
        }
        do {
            if ((zipEntry = this.zis.getNextEntry()) != null) continue;
            return null;
        } while (zipEntry.isDirectory());
        return zipEntry.getName();
    }

    public void storeNextEntry(OutputStream out) throws IOException {
        if (this.zis == null) {
            throw new IllegalStateException("ZipFile is in create-new-file mode");
        }
        Utilities.pipe(this.zis, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFiles(File directory, String regex, String replacement) throws IOException {
        if (this.zis == null) {
            throw new IllegalStateException("ZipFile is in create-new-file mode");
        }
        directory.mkdirs();
        try {
            String name;
            while ((name = this.getNextEntry()) != null) {
                if (regex != null) {
                    name = name.replaceAll(regex, replacement);
                }
                File outFile = new File(directory, name);
                outFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    this.storeNextEntry(out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            this.zis.close();
        }
    }

    public void storeFiles(File directory) throws IOException {
        this.storeFiles(directory, null, null);
    }
}

