/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opensearch.common.concurrent.CompletableContext;
import org.opensearch.nio.ChannelContext;
import org.opensearch.nio.ChannelFactory;
import org.opensearch.nio.Config;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.NioServerSocketChannel;
import org.opensearch.nio.NioSocketChannel;

public class ServerChannelContext
extends ChannelContext<ServerSocketChannel> {
    private final NioServerSocketChannel channel;
    private final NioSelector selector;
    private final Config.ServerSocket config;
    private final Consumer<NioSocketChannel> acceptor;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final ChannelFactory<?, ?> channelFactory;
    private final CompletableContext<Void> bindContext = new CompletableContext();

    public ServerChannelContext(NioServerSocketChannel channel, ChannelFactory<?, ?> channelFactory, NioSelector selector, Config.ServerSocket config, Consumer<NioSocketChannel> acceptor, Consumer<Exception> exceptionHandler) {
        super(channel.getRawChannel(), exceptionHandler);
        this.channel = channel;
        this.channelFactory = channelFactory;
        this.selector = selector;
        this.config = config;
        this.acceptor = acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptChannels(Supplier<NioSelector> selectorSupplier) throws IOException {
        try (SocketChannel acceptedChannel = null;){
            while ((acceptedChannel = ServerChannelContext.accept((ServerSocketChannel)this.rawChannel)) != null) {
                Object nioChannel = this.channelFactory.acceptNioChannel(acceptedChannel, selectorSupplier);
                this.acceptor.accept((NioSocketChannel)nioChannel);
            }
        }
    }

    public void addBindListener(BiConsumer<Void, Exception> listener) {
        this.bindContext.addListener(listener);
    }

    @Override
    protected void register() throws IOException {
        super.register();
        this.configureSocket(((ServerSocketChannel)this.rawChannel).socket());
        InetSocketAddress localAddress = this.config.getLocalAddress();
        try {
            ((ServerSocketChannel)this.rawChannel).bind(localAddress);
            this.bindContext.complete(null);
        }
        catch (IOException e) {
            BindException exception = new BindException("Failed to bind server socket channel {localAddress=" + localAddress + "}.");
            exception.initCause(e);
            this.bindContext.completeExceptionally((Exception)exception);
            throw exception;
        }
    }

    @Override
    public void closeChannel() {
        if (this.isClosing.compareAndSet(false, true)) {
            this.getSelector().queueChannelClose(this.channel);
        }
    }

    @Override
    public NioSelector getSelector() {
        return this.selector;
    }

    @Override
    public NioServerSocketChannel getChannel() {
        return this.channel;
    }

    private void configureSocket(ServerSocket socket) throws IOException {
        socket.setReuseAddress(this.config.tcpReuseAddress());
    }

    protected static SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
        try {
            assert (!serverSocketChannel.isBlocking());
            SocketChannel channel = AccessController.doPrivileged(serverSocketChannel::accept);
            if (serverSocketChannel.isBlocking()) {
                channel.close();
                throw new AssertionError((Object)"serverSocketChannel is blocking.");
            }
            return channel;
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

