/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.video;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FLVParser
extends AbstractParser {
    private static final long serialVersionUID = -8718013155719197679L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.video((String)"x-flv"));
    private static int TYPE_METADATA = 18;
    private static byte MASK_AUDIO = 1;
    private static byte MASK_VIDEO = (byte)4;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    private long readUInt32(DataInputStream input) throws IOException {
        return (long)input.readInt() & 0xFFFFFFFFL;
    }

    private int readUInt24(DataInputStream input) throws IOException {
        int uint = input.readUnsignedByte() << 16;
        uint += input.readUnsignedByte() << 8;
        return uint += input.readUnsignedByte();
    }

    private Object readAMFData(DataInputStream input, int type) throws IOException {
        if (type == -1) {
            type = input.readUnsignedByte();
        }
        switch (type) {
            case 0: {
                return input.readDouble();
            }
            case 1: {
                return input.readUnsignedByte() == 1;
            }
            case 2: {
                return this.readAMFString(input);
            }
            case 3: {
                return this.readAMFObject(input);
            }
            case 8: {
                return this.readAMFEcmaArray(input);
            }
            case 10: {
                return this.readAMFStrictArray(input);
            }
            case 11: {
                Date date = new Date((long)input.readDouble());
                input.readShort();
                return date;
            }
            case 13: {
                return "UNDEFINED";
            }
        }
        return null;
    }

    private Object readAMFStrictArray(DataInputStream input) throws IOException {
        long count = this.readUInt32(input);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while ((long)i < count) {
            list.add(this.readAMFData(input, -1));
            ++i;
        }
        return list;
    }

    private String readAMFString(DataInputStream input) throws IOException {
        int size = input.readUnsignedShort();
        byte[] chars = new byte[size];
        input.readFully(chars);
        return new String(chars, StandardCharsets.UTF_8);
    }

    private Object readAMFObject(DataInputStream input) throws IOException {
        HashMap<String, Object> array = new HashMap<String, Object>();
        while (true) {
            String key = this.readAMFString(input);
            int dataType = input.read();
            if (dataType == 9) break;
            array.put(key, this.readAMFData(input, dataType));
        }
        return array;
    }

    private Object readAMFEcmaArray(DataInputStream input) throws IOException {
        long size = this.readUInt32(input);
        HashMap<String, Object> array = new HashMap<String, Object>();
        int i = 0;
        while ((long)i < size) {
            String key = this.readAMFString(input);
            int dataType = input.read();
            array.put(key, this.readAMFData(input, dataType));
            ++i;
        }
        return array;
    }

    private boolean checkSignature(DataInputStream fis) throws IOException {
        return fis.read() == 70 && fis.read() == 76 && fis.read() == 86;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        int type;
        DataInputStream datainput = new DataInputStream(stream);
        if (!this.checkSignature(datainput)) {
            throw new TikaException("FLV signature not detected");
        }
        int version = datainput.readUnsignedByte();
        if (version != 1) {
            throw new TikaException("Unpexpected FLV version: " + version);
        }
        int typeFlags = datainput.readUnsignedByte();
        long len = this.readUInt32(datainput);
        if (len != 9L) {
            throw new TikaException("Unpexpected FLV header length: " + len);
        }
        long sizePrev = this.readUInt32(datainput);
        if (sizePrev != 0L) {
            throw new TikaException("Unpexpected FLV first previous block size: " + sizePrev);
        }
        metadata.set("Content-Type", "video/x-flv");
        metadata.set("hasVideo", Boolean.toString((typeFlags & MASK_VIDEO) != 0));
        metadata.set("hasAudio", Boolean.toString((typeFlags & MASK_AUDIO) != 0));
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        while ((type = datainput.read()) != -1) {
            int datalen;
            block34: {
                datalen = this.readUInt24(datainput);
                this.readUInt32(datainput);
                this.readUInt24(datainput);
                if (type == TYPE_METADATA) {
                    int r;
                    byte[] metaBytes = new byte[datalen];
                    for (int readCount = 0; readCount < datalen && (r = stream.read(metaBytes, readCount, datalen - readCount)) != -1; readCount += r) {
                    }
                    try (UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(metaBytes);
                         DataInputStream dis = new DataInputStream((InputStream)is);){
                        Object data = null;
                        for (int i = 0; i < 2; ++i) {
                            data = this.readAMFData(dis, -1);
                        }
                        if (!(data instanceof Map)) break block34;
                        Map extractedMetadata = (Map)data;
                        for (Map.Entry entry : extractedMetadata.entrySet()) {
                            if (entry.getValue() == null) continue;
                            metadata.set((String)entry.getKey(), entry.getValue().toString());
                        }
                        break block34;
                    }
                }
                for (int i = 0; i < datalen; ++i) {
                    datainput.readByte();
                }
            }
            if ((sizePrev = this.readUInt32(datainput)) == (long)(datalen + 11)) continue;
        }
        xhtml.endDocument();
    }
}

