/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.TransportActions;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.client.Client;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.translog.Translog;
import org.opensearch.replication.MappingNotAvailableException;
import org.opensearch.replication.ReplicationException;
import org.opensearch.replication.action.changes.GetChangesResponse;
import org.opensearch.replication.action.replay.ReplayChangesAction;
import org.opensearch.replication.action.replay.ReplayChangesRequest;
import org.opensearch.replication.action.replay.ReplayChangesResponse;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.task.shard.FollowerClusterStats;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.replication.util.InjectablesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010)\u001a\u00020\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\n \u001b*\u0004\u0018\u00010\u001f0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lorg/opensearch/replication/task/shard/TranslogSequencer;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "replicationMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "followerShardId", "Lorg/opensearch/core/index/shard/ShardId;", "leaderAlias", "", "leaderIndexName", "parentTaskId", "Lorg/opensearch/core/tasks/TaskId;", "client", "Lorg/opensearch/client/Client;", "initialSeqNo", "", "followerClusterStats", "Lorg/opensearch/replication/task/shard/FollowerClusterStats;", "writersPerShard", "", "(Lkotlinx/coroutines/CoroutineScope;Lorg/opensearch/replication/metadata/store/ReplicationMetadata;Lorg/opensearch/core/index/shard/ShardId;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/core/tasks/TaskId;Lorg/opensearch/client/Client;JLorg/opensearch/replication/task/shard/FollowerClusterStats;I)V", "completed", "Lkotlinx/coroutines/CompletableDeferred;", "", "followerIndexService", "Lorg/opensearch/index/IndexService;", "kotlin.jvm.PlatformType", "getFollowerIndexService", "()Lorg/opensearch/index/IndexService;", "indexShard", "Lorg/opensearch/index/shard/IndexShard;", "getIndexShard", "()Lorg/opensearch/index/shard/IndexShard;", "log", "Lorg/apache/logging/log4j/Logger;", "sequencer", "Lkotlinx/coroutines/channels/SendChannel;", "unAppliedChanges", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/opensearch/replication/action/changes/GetChangesResponse;", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "changes", "(Lorg/opensearch/replication/action/changes/GetChangesResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-cross-cluster-replication"})
@ObsoleteCoroutinesApi
public final class TranslogSequencer {
    @NotNull
    private final ReplicationMetadata replicationMetadata;
    @NotNull
    private final ShardId followerShardId;
    @NotNull
    private final String leaderAlias;
    @NotNull
    private final String leaderIndexName;
    @NotNull
    private final TaskId parentTaskId;
    @NotNull
    private final Client client;
    @NotNull
    private final FollowerClusterStats followerClusterStats;
    @NotNull
    private final ConcurrentHashMap<Long, GetChangesResponse> unAppliedChanges;
    @NotNull
    private final Logger log;
    @NotNull
    private final CompletableDeferred<Unit> completed;
    private final IndexService followerIndexService;
    private final IndexShard indexShard;
    @NotNull
    private final SendChannel<Unit> sequencer;

    public TranslogSequencer(@NotNull CoroutineScope scope, @NotNull ReplicationMetadata replicationMetadata, @NotNull ShardId followerShardId, @NotNull String leaderAlias, @NotNull String leaderIndexName, @NotNull TaskId parentTaskId, @NotNull Client client, long initialSeqNo, @NotNull FollowerClusterStats followerClusterStats, int writersPerShard) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)replicationMetadata, (String)"replicationMetadata");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderIndexName, (String)"leaderIndexName");
        Intrinsics.checkNotNullParameter((Object)parentTaskId, (String)"parentTaskId");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)followerClusterStats, (String)"followerClusterStats");
        this.replicationMetadata = replicationMetadata;
        this.followerShardId = followerShardId;
        this.leaderAlias = leaderAlias;
        this.leaderIndexName = leaderIndexName;
        this.parentTaskId = parentTaskId;
        this.client = client;
        this.followerClusterStats = followerClusterStats;
        this.unAppliedChanges = new ConcurrentHashMap();
        Logger logger = Loggers.getLogger(this.getClass(), (ShardId)this.followerShardId, (String[])new String[0]);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
        this.completed = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.followerIndexService = InjectablesKt.getIndicesService().indexServiceSafe(this.followerShardId.getIndex());
        this.indexShard = this.followerIndexService.getShard(this.followerShardId.getId());
        this.sequencer = ActorKt.actor$default((CoroutineScope)scope, null, (int)0, null, null, (Function2)((Function2)new Function2<ActorScope<Unit>, Continuation<? super Unit>, Object>(writersPerShard, initialSeqNo, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $writersPerShard;
            final /* synthetic */ long $initialSeqNo;
            final /* synthetic */ TranslogSequencer this$0;
            {
                this.$writersPerShard = $writersPerShard;
                this.$initialSeqNo = $initialSeqNo;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$actor = (ActorScope)this.L$0;
                        rateLimiter = SemaphoreKt.Semaphore$default((int)this.$writersPerShard, (int)0, (int)2, null);
                        highWatermark = this.$initialSeqNo;
                        var6_6 = $this$actor.getChannel().iterator();
                        while (true) {
                            this.L$0 = $this$actor;
                            this.L$1 = rateLimiter;
                            this.L$2 = var6_6;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.J$0 = highWatermark;
                            this.label = 1;
                            v0 = var6_6.hasNext((Continuation)this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl28
                            break;
                        }
                    }
                    case 1: {
                        highWatermark = this.J$0;
                        var6_6 = (ChannelIterator)this.L$2;
                        rateLimiter = (Semaphore)this.L$1;
                        $this$actor = (ActorScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        var6_6.next();
lbl31:
                        // 2 sources

                        while (true) {
                            if (!TranslogSequencer.access$getUnAppliedChanges$p(this.this$0).containsKey(Boxing.boxLong((long)(highWatermark + 1L)))) ** continue;
                            v1 = TranslogSequencer.access$getUnAppliedChanges$p(this.this$0).remove(Boxing.boxLong((long)(highWatermark + 1L)));
                            Intrinsics.checkNotNull(v1);
                            next = (GetChangesResponse)v1;
                            replayRequest = new ReplayChangesRequest(TranslogSequencer.access$getFollowerShardId$p(this.this$0), next.getChanges(), next.getMaxSeqNoOfUpdatesOrDeletes(), TranslogSequencer.access$getLeaderAlias$p(this.this$0), TranslogSequencer.access$getLeaderIndexName$p(this.this$0));
                            replayRequest.setParentTask(TranslogSequencer.access$getParentTaskId$p(this.this$0));
                            this.L$0 = $this$actor;
                            this.L$1 = rateLimiter;
                            this.L$2 = var6_6;
                            this.L$3 = next;
                            this.L$4 = replayRequest;
                            this.J$0 = highWatermark;
                            this.label = 2;
                            v2 = rateLimiter.acquire((Continuation)this);
                            if (v2 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl58
                            break;
                        }
                    }
                    case 2: {
                        highWatermark = this.J$0;
                        replayRequest = (ReplayChangesRequest)this.L$4;
                        next = (GetChangesResponse)this.L$3;
                        var6_6 = (ChannelIterator)this.L$2;
                        rateLimiter = (Semaphore)this.L$1;
                        $this$actor = (ActorScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl58:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)$this$actor), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, replayRequest, rateLimiter, null){
                            long J$0;
                            Object L$0;
                            int I$0;
                            int label;
                            final /* synthetic */ TranslogSequencer this$0;
                            final /* synthetic */ ReplayChangesRequest $replayRequest;
                            final /* synthetic */ Semaphore $rateLimiter;
                            {
                                this.this$0 = $receiver;
                                this.$replayRequest = $replayRequest;
                                this.$rateLimiter = $rateLimiter;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Could not resolve type clashes
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                block14: {
                                    var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            relativeStartNanos = System.nanoTime();
                                            retryOnExceptions = new ArrayList();
                                            retryOnExceptions.add(MappingNotAvailableException.class);
                                            tryReplay = 1;
lbl12:
                                            // 3 sources

                                            while (tryReplay != 0) {
                                                tryReplay = 0;
                                                this.L$0 = retryOnExceptions;
                                                this.J$0 = relativeStartNanos;
                                                this.I$0 = tryReplay;
                                                this.label = 1;
                                                v0 = v1 = ExtensionsKt.suspendExecuteWithRetries$default(TranslogSequencer.access$getClient$p(this.this$0), TranslogSequencer.access$getReplicationMetadata$p(this.this$0), ReplayChangesAction.Companion.getINSTANCE(), (ActionRequest)this.$replayRequest, 0, 0L, 0L, 0.0, TranslogSequencer.access$getLog$p(this.this$0), retryOnExceptions, false, false, (Continuation)this, 1656, null);
                                            }
                                            break;
                                            {
                                                if (v0 == var17_2) {
                                                    return var17_2;
                                                }
                                                ** GOTO lbl35
                                                break;
                                            }
                                        }
                                        case 1: {
                                            tryReplay = this.I$0;
                                            relativeStartNanos = this.J$0;
                                            retryOnExceptions = (ArrayList)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl35:
                                            // 2 sources

                                            if ((replayResponse = (ReplayChangesResponse)v1).getShardInfo().getFailed() > 0) {
                                                v2 = replayResponse.getShardInfo().getFailures();
                                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"replayResponse.shardInfo.failures");
                                                var7_10 = v2;
                                                var8_11 = this.this$0;
                                                $i$f$forEachIndexed = false;
                                                index$iv = 0;
                                                for (void item$iv : $this$forEachIndexed$iv) {
                                                    v3 = index$iv++;
                                                    var14_17 = (ReplicationResponse.ShardInfo.Failure)item$iv;
                                                    i = v3;
                                                    $i$a$-forEachIndexed-TranslogSequencer$sequencer$1$1$1 = false;
                                                    TranslogSequencer.access$getLog$p(var8_11).error("Failed replaying changes. Failure:" + i + ':' + failure + '}');
                                                }
                                                v4 = TranslogSequencer.access$getFollowerClusterStats$p(this.this$0).getStats().get(TranslogSequencer.access$getFollowerShardId$p(this.this$0));
                                                Intrinsics.checkNotNull((Object)v4);
                                                v4.getOpsWriteFailures().addAndGet(replayResponse.getShardInfo().getFailed());
                                                $this$forEachIndexed$iv = new Object[1];
                                                Intrinsics.checkNotNullExpressionValue((Object)replayResponse.getShardInfo().getFailures(), (String)"replayResponse.shardInfo.failures");
                                                throw new ReplicationException("failed to replay changes", $this$forEachIndexed$iv);
                                            }
                                            tookInNanos = System.nanoTime() - relativeStartNanos;
                                            v5 = TranslogSequencer.access$getFollowerClusterStats$p(this.this$0).getStats().get(TranslogSequencer.access$getFollowerShardId$p(this.this$0));
                                            Intrinsics.checkNotNull((Object)v5);
                                            v5.getTotalWriteTime().addAndGet(TimeUnit.NANOSECONDS.toMillis(tookInNanos));
                                            v6 = TranslogSequencer.access$getFollowerClusterStats$p(this.this$0).getStats().get(TranslogSequencer.access$getFollowerShardId$p(this.this$0));
                                            Intrinsics.checkNotNull((Object)v6);
                                            v6.getOpsWritten().addAndGet(this.$replayRequest.getChanges().size());
                                            v7 = TranslogSequencer.access$getFollowerClusterStats$p(this.this$0).getStats().get(TranslogSequencer.access$getFollowerShardId$p(this.this$0));
                                            Intrinsics.checkNotNull((Object)v7);
                                            v7.setFollowerCheckpoint(this.this$0.getIndexShard().getLocalCheckpoint());
                                            ** GOTO lbl12
                                            {
                                                catch (OpenSearchException e) {
                                                    if (e instanceof IndexNotFoundException || !retryOnExceptions.contains(e.getClass()) && !TransportActions.isShardNotAvailableException((Throwable)e) && e.status().getStatus() < 500 && e.status() != RestStatus.TOO_MANY_REQUESTS) ** GOTO lbl74
                                                    var5_5 = true;
                                                    ** GOTO lbl12
lbl74:
                                                    // 1 sources

                                                    TranslogSequencer.access$getLog$p(this.this$0).error("Got non-retriable Exception:" + e.getMessage() + " with status:" + e.status());
                                                    throw e;
                                                }
                                            }
                                        }
                                    }
                                    break block14;
                                    catch (Throwable var6_8) {
                                        this.$rateLimiter.release();
                                        throw var6_8;
                                    }
                                }
                                this.$rateLimiter.release();
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        v3 = (Translog.Operation)CollectionsKt.lastOrNull(next.getChanges());
                        highWatermark = v3 != null ? v3.seqNo() : highWatermark;
                        ** continue;
                    }
                }
                TranslogSequencer.access$getCompleted$p(this.this$0).complete((Object)Unit.INSTANCE);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ActorScope<Unit>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ActorScope<Unit> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)13, null);
    }

    public final IndexService getFollowerIndexService() {
        return this.followerIndexService;
    }

    public final IndexShard getIndexShard() {
        return this.indexShard;
    }

    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        SendChannel.DefaultImpls.close$default(this.sequencer, null, (int)1, null);
        Object object = this.completed.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object send(@NotNull GetChangesResponse changes, @NotNull Continuation<? super Unit> $completion) {
        ((Map)this.unAppliedChanges).put(Boxing.boxLong((long)changes.getFromSeqNo()), changes);
        Object object = this.sequencer.send((Object)Unit.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getUnAppliedChanges$p(TranslogSequencer $this) {
        return $this.unAppliedChanges;
    }

    public static final /* synthetic */ ShardId access$getFollowerShardId$p(TranslogSequencer $this) {
        return $this.followerShardId;
    }

    public static final /* synthetic */ String access$getLeaderAlias$p(TranslogSequencer $this) {
        return $this.leaderAlias;
    }

    public static final /* synthetic */ String access$getLeaderIndexName$p(TranslogSequencer $this) {
        return $this.leaderIndexName;
    }

    public static final /* synthetic */ TaskId access$getParentTaskId$p(TranslogSequencer $this) {
        return $this.parentTaskId;
    }

    public static final /* synthetic */ Client access$getClient$p(TranslogSequencer $this) {
        return $this.client;
    }

    public static final /* synthetic */ ReplicationMetadata access$getReplicationMetadata$p(TranslogSequencer $this) {
        return $this.replicationMetadata;
    }

    public static final /* synthetic */ Logger access$getLog$p(TranslogSequencer $this) {
        return $this.log;
    }

    public static final /* synthetic */ FollowerClusterStats access$getFollowerClusterStats$p(TranslogSequencer $this) {
        return $this.followerClusterStats;
    }

    public static final /* synthetic */ CompletableDeferred access$getCompleted$p(TranslogSequencer $this) {
        return $this.completed;
    }
}

