/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.join.aggregations.ChildrenAggregatorFactory;
import org.opensearch.join.aggregations.ParentToChildrenAggregator;
import org.opensearch.join.mapper.ParentIdFieldMapper;
import org.opensearch.join.mapper.ParentJoinFieldMapper;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public class ChildrenAggregationBuilder
extends ValuesSourceAggregationBuilder<ChildrenAggregationBuilder> {
    public static final String NAME = "children";
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ChildrenAggregationBuilder(String name, String childType) {
        super(name);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    protected ChildrenAggregationBuilder(ChildrenAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.childType = clone.childType;
        this.childFilter = clone.childFilter;
        this.parentFilter = clone.parentFilter;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ChildrenAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ChildrenAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.childType = in.readString();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    protected ValuesSourceAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ChildrenAggregatorFactory(this.name, config, this.childFilter, this.parentFilter, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    protected ValuesSourceConfig resolveConfig(QueryShardContext queryShardContext) {
        ParentJoinFieldMapper parentJoinFieldMapper = ParentJoinFieldMapper.getMapper(queryShardContext.getMapperService());
        if (parentJoinFieldMapper == null) {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnmapped((ValuesSourceType)this.defaultValueSourceType(), (QueryShardContext)queryShardContext);
            return config;
        }
        ParentIdFieldMapper parentIdFieldMapper = parentJoinFieldMapper.getParentIdFieldMapper(this.childType, false);
        if (parentIdFieldMapper == null) {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnmapped((ValuesSourceType)this.defaultValueSourceType(), (QueryShardContext)queryShardContext);
            return config;
        }
        this.parentFilter = parentIdFieldMapper.getParentFilter();
        this.childFilter = parentIdFieldMapper.getChildFilter(this.childType);
        MappedFieldType fieldType = parentIdFieldMapper.fieldType();
        ValuesSourceConfig config = ValuesSourceConfig.resolveFieldOnly((MappedFieldType)fieldType, (QueryShardContext)queryShardContext);
        return config;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ParentToChildrenAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ChildrenAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for children aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ChildrenAggregationBuilder(aggregationName, childType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.childType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChildrenAggregationBuilder other = (ChildrenAggregationBuilder)((Object)obj);
        return Objects.equals(this.childType, other.childType);
    }

    public String getType() {
        return NAME;
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return ValuesSourceRegistry.UNREGISTERED_KEY;
    }
}

