# Configurations
<!-- *lspconfig-all* *lspconfig-server-configurations* -->

LSP configs provided by nvim-lspconfig are listed below. This documentation is
autogenerated from the Lua files. You can view this file in Nvim by running
`:help lspconfig-all`.

- [aiken](#aiken)
- [als](#als)
- [anakin_language_server](#anakin_language_server)
- [angularls](#angularls)
- [ansiblels](#ansiblels)
- [antlersls](#antlersls)
- [apex_ls](#apex_ls)
- [arduino_language_server](#arduino_language_server)
- [asm_lsp](#asm_lsp)
- [ast_grep](#ast_grep)
- [astro](#astro)
- [autotools_ls](#autotools_ls)
- [awk_ls](#awk_ls)
- [azure_pipelines_ls](#azure_pipelines_ls)
- [bashls](#bashls)
- [beancount](#beancount)
- [bicep](#bicep)
- [biome](#biome)
- [blueprint_ls](#blueprint_ls)
- [bright_script](#bright_script)
- [bsl_ls](#bsl_ls)
- [buck2](#buck2)
- [buddy_ls](#buddy_ls)
- [bufls](#bufls)
- [cadence](#cadence)
- [cairo_ls](#cairo_ls)
- [ccls](#ccls)
- [circom-lsp](#circom-lsp)
- [clangd](#clangd)
- [clarity_lsp](#clarity_lsp)
- [clojure_lsp](#clojure_lsp)
- [cmake](#cmake)
- [cobol_ls](#cobol_ls)
- [codeqlls](#codeqlls)
- [coffeesense](#coffeesense)
- [contextive](#contextive)
- [coq_lsp](#coq_lsp)
- [crystalline](#crystalline)
- [csharp_ls](#csharp_ls)
- [cssls](#cssls)
- [cssmodules_ls](#cssmodules_ls)
- [cucumber_language_server](#cucumber_language_server)
- [custom_elements_ls](#custom_elements_ls)
- [cypher_ls](#cypher_ls)
- [dafny](#dafny)
- [dagger](#dagger)
- [dartls](#dartls)
- [denols](#denols)
- [dhall_lsp_server](#dhall_lsp_server)
- [diagnosticls](#diagnosticls)
- [digestif](#digestif)
- [docker_compose_language_service](#docker_compose_language_service)
- [dockerls](#dockerls)
- [dolmenls](#dolmenls)
- [dotls](#dotls)
- [drools_lsp](#drools_lsp)
- [ds_pinyin_lsp](#ds_pinyin_lsp)
- [ecsact](#ecsact)
- [efm](#efm)
- [elixirls](#elixirls)
- [elmls](#elmls)
- [elp](#elp)
- [ember](#ember)
- [emmet_language_server](#emmet_language_server)
- [emmet_ls](#emmet_ls)
- [erg_language_server](#erg_language_server)
- [erlangls](#erlangls)
- [esbonio](#esbonio)
- [eslint](#eslint)
- [facility_language_server](#facility_language_server)
- [fennel_language_server](#fennel_language_server)
- [fennel_ls](#fennel_ls)
- [flow](#flow)
- [flux_lsp](#flux_lsp)
- [foam_ls](#foam_ls)
- [fortls](#fortls)
- [fsautocomplete](#fsautocomplete)
- [fsharp_language_server](#fsharp_language_server)
- [fstar](#fstar)
- [futhark_lsp](#futhark_lsp)
- [gdscript](#gdscript)
- [ghcide](#ghcide)
- [ghdl_ls](#ghdl_ls)
- [gleam](#gleam)
- [glint](#glint)
- [glsl_analyzer](#glsl_analyzer)
- [glslls](#glslls)
- [golangci_lint_ls](#golangci_lint_ls)
- [gopls](#gopls)
- [gradle_ls](#gradle_ls)
- [grammarly](#grammarly)
- [graphql](#graphql)
- [groovyls](#groovyls)
- [guile_ls](#guile_ls)
- [haxe_language_server](#haxe_language_server)
- [hdl_checker](#hdl_checker)
- [helm_ls](#helm_ls)
- [hhvm](#hhvm)
- [hie](#hie)
- [hls](#hls)
- [hoon_ls](#hoon_ls)
- [html](#html)
- [htmx](#htmx)
- [hydra_lsp](#hydra_lsp)
- [idris2_lsp](#idris2_lsp)
- [intelephense](#intelephense)
- [java_language_server](#java_language_server)
- [jdtls](#jdtls)
- [jedi_language_server](#jedi_language_server)
- [jqls](#jqls)
- [jsonls](#jsonls)
- [jsonnet_ls](#jsonnet_ls)
- [julials](#julials)
- [kotlin_language_server](#kotlin_language_server)
- [lean3ls](#lean3ls)
- [leanls](#leanls)
- [lelwel_ls](#lelwel_ls)
- [lemminx](#lemminx)
- [lexical](#lexical)
- [ltex](#ltex)
- [lua_ls](#lua_ls)
- [luau_lsp](#luau_lsp)
- [m68k](#m68k)
- [marksman](#marksman)
- [matlab_ls](#matlab_ls)
- [mdx_analyzer](#mdx_analyzer)
- [metals](#metals)
- [millet](#millet)
- [mint](#mint)
- [mlir_lsp_server](#mlir_lsp_server)
- [mlir_pdll_lsp_server](#mlir_pdll_lsp_server)
- [mm0_ls](#mm0_ls)
- [mojo](#mojo)
- [move_analyzer](#move_analyzer)
- [mutt_ls](#mutt_ls)
- [nelua_lsp](#nelua_lsp)
- [neocmake](#neocmake)
- [nginx_language_server](#nginx_language_server)
- [nickel_ls](#nickel_ls)
- [nil_ls](#nil_ls)
- [nim_langserver](#nim_langserver)
- [nimls](#nimls)
- [nixd](#nixd)
- [nomad_lsp](#nomad_lsp)
- [ntt](#ntt)
- [nushell](#nushell)
- [nxls](#nxls)
- [ocamlls](#ocamlls)
- [ocamllsp](#ocamllsp)
- [ols](#ols)
- [omnisharp](#omnisharp)
- [opencl_ls](#opencl_ls)
- [openedge_ls](#openedge_ls)
- [openscad_ls](#openscad_ls)
- [openscad_lsp](#openscad_lsp)
- [pact_ls](#pact_ls)
- [pasls](#pasls)
- [perlls](#perlls)
- [perlnavigator](#perlnavigator)
- [perlpls](#perlpls)
- [pest_ls](#pest_ls)
- [phan](#phan)
- [phpactor](#phpactor)
- [pkgbuild_language_server](#pkgbuild_language_server)
- [please](#please)
- [postgres_lsp](#postgres_lsp)
- [powershell_es](#powershell_es)
- [prismals](#prismals)
- [prolog_ls](#prolog_ls)
- [prosemd_lsp](#prosemd_lsp)
- [psalm](#psalm)
- [puppet](#puppet)
- [purescriptls](#purescriptls)
- [pylsp](#pylsp)
- [pylyzer](#pylyzer)
- [pyre](#pyre)
- [pyright](#pyright)
- [qml_lsp](#qml_lsp)
- [qmlls](#qmlls)
- [quick_lint_js](#quick_lint_js)
- [r_language_server](#r_language_server)
- [racket_langserver](#racket_langserver)
- [raku_navigator](#raku_navigator)
- [reason_ls](#reason_ls)
- [regols](#regols)
- [relay_lsp](#relay_lsp)
- [remark_ls](#remark_ls)
- [rescriptls](#rescriptls)
- [rls](#rls)
- [rnix](#rnix)
- [robotframework_ls](#robotframework_ls)
- [rome](#rome)
- [rubocop](#rubocop)
- [ruby_ls](#ruby_ls)
- [ruff_lsp](#ruff_lsp)
- [rune_languageserver](#rune_languageserver)
- [rust_analyzer](#rust_analyzer)
- [salt_ls](#salt_ls)
- [scheme_langserver](#scheme_langserver)
- [scry](#scry)
- [serve_d](#serve_d)
- [sixtyfps](#sixtyfps)
- [slangd](#slangd)
- [slint_lsp](#slint_lsp)
- [smarty_ls](#smarty_ls)
- [smithy_ls](#smithy_ls)
- [solang](#solang)
- [solargraph](#solargraph)
- [solc](#solc)
- [solidity](#solidity)
- [solidity_ls](#solidity_ls)
- [solidity_ls_nomicfoundation](#solidity_ls_nomicfoundation)
- [sorbet](#sorbet)
- [sourcekit](#sourcekit)
- [sourcery](#sourcery)
- [spectral](#spectral)
- [spyglassmc_language_server](#spyglassmc_language_server)
- [sqlls](#sqlls)
- [sqls](#sqls)
- [standardrb](#standardrb)
- [starlark_rust](#starlark_rust)
- [statix](#statix)
- [steep](#steep)
- [stimulus_ls](#stimulus_ls)
- [stylelint_lsp](#stylelint_lsp)
- [svelte](#svelte)
- [svlangserver](#svlangserver)
- [svls](#svls)
- [swift_mesonls](#swift_mesonls)
- [syntax_tree](#syntax_tree)
- [tailwindcss](#tailwindcss)
- [taplo](#taplo)
- [tblgen_lsp_server](#tblgen_lsp_server)
- [teal_ls](#teal_ls)
- [templ](#templ)
- [terraform_lsp](#terraform_lsp)
- [terraformls](#terraformls)
- [texlab](#texlab)
- [textlsp](#textlsp)
- [tflint](#tflint)
- [theme_check](#theme_check)
- [thriftls](#thriftls)
- [tilt_ls](#tilt_ls)
- [tsserver](#tsserver)
- [ttags](#ttags)
- [turtle_ls](#turtle_ls)
- [typeprof](#typeprof)
- [typos_lsp](#typos_lsp)
- [typst_lsp](#typst_lsp)
- [uiua](#uiua)
- [unison](#unison)
- [unocss](#unocss)
- [uvls](#uvls)
- [v_analyzer](#v_analyzer)
- [vala_ls](#vala_ls)
- [vale_ls](#vale_ls)
- [vdmj](#vdmj)
- [verible](#verible)
- [veridian](#veridian)
- [veryl_ls](#veryl_ls)
- [vhdl_ls](#vhdl_ls)
- [vimls](#vimls)
- [visualforce_ls](#visualforce_ls)
- [vls](#vls)
- [volar](#volar)
- [vtsls](#vtsls)
- [vuels](#vuels)
- [wgsl_analyzer](#wgsl_analyzer)
- [yamlls](#yamlls)
- [yang_lsp](#yang_lsp)
- [yls](#yls)
- [zk](#zk)
- [zls](#zls)

## aiken

https://github.com/aiken-lang/aiken

A language server for Aiken Programming Language.
[Installation](https://aiken-lang.org/installation-instructions)

It can be i



**Snippet to enable the language server:**
```lua
require'lspconfig'.aiken.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "aiken", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "aiken" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("aiken.toml", ".git")
  ```


## als

https://github.com/AdaCore/ada_language_server

Installation instructions can be found [here](https://github.com/AdaCore/ada_language_server#Install).

Can be configured by passing a "settings" object to `als.setup{}`:

```lua
require('lspconfig').als.setup{
    settings = {
      ada = {
        projectFile = "project.gpr";
        scenarioVariables = { ... };
      }
    }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.als.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ada_language_server" }
  ```
  - `filetypes` : 
  ```lua
  { "ada" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("Makefile", ".git", "*.gpr", "*.adc")
  ```


## anakin_language_server

https://pypi.org/project/anakin-language-server/

`anakin-language-server` is yet another Jedi Python language server.

Available options:

* Initialization: https://github.com/muffinmad/anakin-language-server#initialization-option
* Configuration: https://github.com/muffinmad/anakin-language-server#configuration-options
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.anakin_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "anakinls" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    anakinls = {
      pyflakes_errors = { "ImportStarNotPermitted", "UndefinedExport", "UndefinedLocal", "UndefinedName", "DuplicateArgument", "MultiValueRepeatedKeyLiteral", "MultiValueRepeatedKeyVariable", "FutureFeatureNotDefined", "LateFutureImport", "ReturnOutsideFunction", "YieldOutsideFunction", "ContinueOutsideLoop", "BreakOutsideLoop", "TwoStarredExpressions", "TooManyExpressionsInStarredAssignment", "ForwardAnnotationSyntaxError", "RaiseNotImplemented", "StringDotFormatExtraPositionalArguments", "StringDotFormatExtraNamedArguments", "StringDotFormatMissingArgument", "StringDotFormatMixingAutomatic", "StringDotFormatInvalidFormat", "PercentFormatInvalidFormat", "PercentFormatMixedPositionalAndNamed", "PercentFormatUnsupportedFormat", "PercentFormatPositionalCountMismatch", "PercentFormatExtraNamedArguments", "PercentFormatMissingArgument", "PercentFormatExpectedMapping", "PercentFormatExpectedSequence", "PercentFormatStarRequiresSequence" }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## angularls

https://github.com/angular/vscode-ng-language-service

`angular-language-server` can be installed via npm `npm install -g @angular/language-server`.

Note, that if you override the default `cmd`, you must also update `on_new_config` to set `new_config.cmd` during startup.

```lua
local project_library_path = "/path/to/project/lib"
local cmd = {"ngserver", "--stdio", "--tsProbeLocations", project_library_path , "--ngProbeLocations", project_library_path}

require'lspconfig'.angularls.setup{
  cmd = cmd,
  on_new_config = function(new_config,new_root_dir)
    new_config.cmd = cmd
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.angularls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ngserver", "--stdio", "--tsProbeLocations", "", "--ngProbeLocations", "" }
  ```
  - `filetypes` : 
  ```lua
  { "typescript", "html", "typescriptreact", "typescript.tsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("angular.json")
  ```


## ansiblels

https://github.com/ansible/ansible-language-server

Language server for the ansible configuration management tool.

`ansible-language-server` can be installed via `npm`:

```sh
npm install -g @ansible/ansible-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ansiblels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ansible-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml.ansible" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    ansible = {
      ansible = {
        path = "ansible"
      },
      executionEnvironment = {
        enabled = false
      },
      python = {
        interpreterPath = "python"
      },
      validation = {
        enabled = true,
        lint = {
          enabled = true,
          path = "ansible-lint"
        }
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## antlersls

https://www.npmjs.com/package/antlers-language-server

`antlersls` can be installed via `npm`:
```sh
npm install -g antlers-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.antlersls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "antlersls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "antlers" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## apex_ls

https://github.com/forcedotcom/salesforcedx-vscode

Language server for Apex.

For manual installation, download the JAR file from the [VSCode
extension](https://github.com/forcedotcom/salesforcedx-vscode/tree/develop/packages/salesforcedx-vscode-apex).

```lua
require'lspconfig'.apex_ls.setup {
  apex_jar_path = '/path/to/apex-jorje-lsp.jar',
  apex_enable_semantic_errors = false, -- Whether to allow Apex Language Server to surface semantic errors
  apex_enable_completion_statistics = false, -- Whether to allow Apex Language Server to collect telemetry on code completion usage
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.apex_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "apexcode" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('sfdx-project.json')
  ```


## arduino_language_server

https://github.com/arduino/arduino-language-server

Language server for Arduino

The `arduino-language-server` can be installed by running:

```
go install github.com/arduino/arduino-language-server@latest
```

The `arduino-cli` tool must also be installed. Follow [these
installation instructions](https://arduino.github.io/arduino-cli/latest/installation/) for
your platform.

After installing `arduino-cli`, follow [these
instructions](https://arduino.github.io/arduino-cli/latest/getting-started/#create-a-configuration-file)
for generating a configuration file if you haven't done so already, and make
sure you [install any relevant platforms
libraries](https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board).

The language server also requires `clangd` to be installed. Follow [these
installation instructions](https://clangd.llvm.org/installation) for your
platform.

If you don't have a sketch yet create one.

```sh
$ arduino-cli sketch new test
$ cd  test
```

You will need a `sketch.yaml` file in order for the language server to understand your project. It will also save you passing options to `arduino-cli` each time you compile or upload a file. You can generate the file like using the following commands.


First gather some information about your board. Make sure your board is connected and run the following:

```sh
$ arduino-cli board list
Port         Protocol Type              Board Name  FQBN            Core
/dev/ttyACM0 serial   Serial Port (USB) Arduino Uno arduino:avr:uno arduino:avr
```

Then generate the file:

```sh
arduino-cli board attach -p /dev/ttyACM0 -b arduino:avr:uno test.ino
```

The resulting file should like like this:

```yaml
default_fqbn: arduino:avr:uno
default_port: /dev/ttyACM0
```

Your folder structure should look like this:

```
.
├── test.ino
└── sketch.yaml
```

For further instruction about configuration options, run `arduino-language-server --help`.

Note that an upstream bug makes keywords in some cases become undefined by the language server.
Ref: https://github.com/arduino/arduino-ide/issues/159



**Snippet to enable the language server:**
```lua
require'lspconfig'.arduino_language_server.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {
    general = {
      positionEncodings = { "utf-16" }
    },
    textDocument = {
      callHierarchy = {
        dynamicRegistration = false
      },
      codeAction = {
        codeActionLiteralSupport = {
          codeActionKind = {
            valueSet = { "", "quickfix", "refactor", "refactor.extract", "refactor.inline", "refactor.rewrite", "source", "source.organizeImports" }
          }
        },
        dataSupport = true,
        dynamicRegistration = true,
        isPreferredSupport = true,
        resolveSupport = {
          properties = { "edit" }
        }
      },
      completion = {
        completionItem = {
          commitCharactersSupport = false,
          deprecatedSupport = false,
          documentationFormat = { "markdown", "plaintext" },
          preselectSupport = false,
          snippetSupport = false
        },
        completionItemKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 }
        },
        contextSupport = false,
        dynamicRegistration = false
      },
      declaration = {
        linkSupport = true
      },
      definition = {
        dynamicRegistration = true,
        linkSupport = true
      },
      diagnostic = {
        dynamicRegistration = false
      },
      documentHighlight = {
        dynamicRegistration = false
      },
      documentSymbol = {
        dynamicRegistration = false,
        hierarchicalDocumentSymbolSupport = true,
        symbolKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 }
        }
      },
      formatting = {
        dynamicRegistration = true
      },
      hover = {
        contentFormat = { "markdown", "plaintext" },
        dynamicRegistration = true
      },
      implementation = {
        linkSupport = true
      },
      inlayHint = {
        dynamicRegistration = true,
        resolveSupport = {
          properties = { "textEdits", "tooltip", "location", "command" }
        }
      },
      publishDiagnostics = {
        dataSupport = true,
        relatedInformation = true,
        tagSupport = {
          valueSet = { 1, 2 }
        }
      },
      rangeFormatting = {
        dynamicRegistration = true
      },
      references = {
        dynamicRegistration = false
      },
      rename = {
        dynamicRegistration = true,
        prepareSupport = true
      },
      semanticTokens = vim.NIL,
      signatureHelp = {
        dynamicRegistration = false,
        signatureInformation = {
          activeParameterSupport = true,
          documentationFormat = { "markdown", "plaintext" },
          parameterInformation = {
            labelOffsetSupport = true
          }
        }
      },
      synchronization = {
        didSave = true,
        dynamicRegistration = false,
        willSave = true,
        willSaveWaitUntil = true
      },
      typeDefinition = {
        linkSupport = true
      }
    },
    window = {
      showDocument = {
        support = true
      },
      showMessage = {
        messageActionItem = {
          additionalPropertiesSupport = false
        }
      },
      workDoneProgress = true
    },
    workspace = {
      applyEdit = true,
      configuration = true,
      didChangeConfiguration = {
        dynamicRegistration = false
      },
      didChangeWatchedFiles = {
        dynamicRegistration = true,
        relativePatternSupport = true
      },
      inlayHint = {
        refreshSupport = true
      },
      semanticTokens = vim.NIL,
      symbol = {
        dynamicRegistration = false,
        symbolKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 }
        }
      },
      workspaceEdit = {
        resourceOperations = { "rename", "create", "delete" }
      },
      workspaceFolders = true
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "arduino-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "arduino" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## asm_lsp

https://github.com/bergercookie/asm-lsp

Language Server for GAS/GO Assembly

`asm-lsp` can be installed via cargo:
cargo install asm-lsp



**Snippet to enable the language server:**
```lua
require'lspconfig'.asm_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "asm-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "asm", "vmasm" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## ast_grep

https://ast-grep.github.io/

ast-grep(sg) is a fast and polyglot tool for code structural search, lint, rewriting at large scale.
ast-grep LSP only works in projects that have `sgconfig.y[a]ml` in their root directories.
```sh
npm install [-g] @ast-grep/cli
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ast_grep.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ast-grep", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "rust", "go", "java", "python", "javascript", "typescript", "html", "css", "kotlin", "dart", "lua" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('sgconfig.yaml', 'sgconfig.yml')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## astro

https://github.com/withastro/language-tools/tree/main/packages/language-server

`astro-ls` can be installed via `npm`:
```sh
npm install -g @astrojs/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.astro.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "astro-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "astro" }
  ```
  - `init_options` : 
  ```lua
  {
    typescript = {}
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "tsconfig.json", "jsconfig.json", ".git")
  ```


## autotools_ls

https://github.com/Freed-Wu/autotools-language-server

`autotools-language-server` can be installed via `pip`:
```sh
pip install autotools-language-server
```

Language server for autoconf, automake and make using tree sitter in python.



**Snippet to enable the language server:**
```lua
require'lspconfig'.autotools_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "autotools-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "config", "automake", "make" }
  ```
  - `root_dir` : 
  ```lua
  { "configure.ac", "Makefile", "Makefile.am", "*.mk" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## awk_ls

https://github.com/Beaglefoot/awk-language-server/

`awk-language-server` can be installed via `npm`:
```sh
npm install -g awk-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.awk_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "awk-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "awk" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## azure_pipelines_ls

https://github.com/microsoft/azure-pipelines-language-server

An Azure Pipelines language server

`azure-pipelines-ls` can be installed via `npm`:

```sh
npm install -g azure-pipelines-language-server
```

By default `azure-pipelines-ls` will only work in files named `azure-pipelines.yml`, this can be changed by providing additional settings like so:
```lua
require("lspconfig").azure_pipelines_ls.setup {
  ... -- other configuration for setup {}
  settings = {
      yaml = {
          schemas = {
              ["https://raw.githubusercontent.com/microsoft/azure-pipelines-vscode/master/service-schema.json"] = {
                  "/azure-pipeline*.y*l",
                  "/*.azure*",
                  "Azure-Pipelines/**/*.y*l",
                  "Pipelines/*.y*l",
              },
          },
      },
  },
}
```
The Azure Pipelines LSP is a fork of `yaml-language-server` and as such the same settings can be passed to it as `yaml-language-server`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.azure_pipelines_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "azure-pipelines-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bashls

https://github.com/bash-lsp/bash-language-server

`bash-language-server` can be installed via `npm`:
```sh
npm i -g bash-language-server
```

Language server for bash, written using tree sitter in typescript.



**Snippet to enable the language server:**
```lua
require'lspconfig'.bashls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bash-language-server", "start" }
  ```
  - `filetypes` : 
  ```lua
  { "sh" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    bashIde = {
      globPattern = "*@(.sh|.inc|.bash|.command)"
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## beancount

https://github.com/polarmutex/beancount-language-server#installation

See https://github.com/polarmutex/beancount-language-server#configuration for configuration options



**Snippet to enable the language server:**
```lua
require'lspconfig'.beancount.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "beancount-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "beancount", "bean" }
  ```
  - `init_options` : 
  ```lua
  {
    journalFile = ""
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bicep

https://github.com/azure/bicep
Bicep language server

Bicep language server can be installed by downloading and extracting a release of bicep-langserver.zip from [Bicep GitHub releases](https://github.com/Azure/bicep/releases).

Bicep language server requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

Neovim does not have built-in support for the bicep filetype which is required for lspconfig to automatically launch the language server.

Filetype detection can be added via an autocmd:
```lua
vim.cmd [[ autocmd BufNewFile,BufRead *.bicep set filetype=bicep ]]
```

**By default, bicep language server does not have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
local bicep_lsp_bin = "/path/to/bicep-langserver/Bicep.LangServer.dll"
require'lspconfig'.bicep.setup{
    cmd = { "dotnet", bicep_lsp_bin };
    ...
}
```

To download the latest release and place in /usr/local/bin/bicep-langserver:
```bash
(cd $(mktemp -d) \
    && curl -fLO https://github.com/Azure/bicep/releases/latest/download/bicep-langserver.zip \
    && rm -rf /usr/local/bin/bicep-langserver \
    && unzip -d /usr/local/bin/bicep-langserver bicep-langserver.zip)
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.bicep.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bicep" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## biome

https://biomejs.dev

Toolchain of the web. [Successor of Rome](https://biomejs.dev/blog/annoucing-biome).

```sh
npm install [-g] @biomejs/biome
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.biome.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "biome", "lsp-proxy" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "json", "jsonc", "typescript", "typescript.tsx", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('package.json', 'node_modules', '.git', 'biome.json')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## blueprint_ls

https://gitlab.gnome.org/jwestman/blueprint-compiler

`blueprint-compiler` can be installed via your system package manager.

Language server for the blueprint markup language, written in python and part
of the blueprint-compiler.



**Snippet to enable the language server:**
```lua
require'lspconfig'.blueprint_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "blueprint-compiler", "lsp" }
  ```
  - `cmd_env` : 
  ```lua
  {
    GLOB_PATTERN = "*@(.blp)"
  }
  ```
  - `filetypes` : 
  ```lua
  { "blueprint" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bright_script

https://github.com/RokuCommunity/brighterscript

`brightscript` can be installed via `npm`:
```sh
npm install -g brighterscript
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.bright_script.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bsc", "--lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "brs" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bsl_ls

    https://github.com/1c-syntax/bsl-language-server

    Language Server Protocol implementation for 1C (BSL) - 1C:Enterprise 8 and OneScript languages.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.bsl_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bsl", "os" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## buck2

https://github.com/facebook/buck2

Build system, successor to Buck

To better detect Buck2 project files, the following can be added:

```
vim.cmd [[ autocmd BufRead,BufNewFile *.bxl,BUCK,TARGETS set filetype=bzl ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.buck2.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "buck2", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "bzl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".buckconfig")
  ```


## buddy_ls

https://github.com/buddy-compiler/buddy-mlir#buddy-lsp-server
The Language Server for the buddy-mlir, a drop-in replacement for mlir-lsp-server,
supporting new dialects defined in buddy-mlir.
`buddy-lsp-server` can be installed at the buddy-mlir repository (buddy-compiler/buddy-mlir)



**Snippet to enable the language server:**
```lua
require'lspconfig'.buddy_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "buddy-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "mlir" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bufls

https://github.com/bufbuild/buf-language-server

`buf-language-server` can be installed via `go install`:
```sh
go install github.com/bufbuild/buf-language-server/cmd/bufls@latest
```

bufls is a Protobuf language server compatible with Buf modules and workspaces



**Snippet to enable the language server:**
```lua
require'lspconfig'.bufls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bufls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "proto" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("buf.work.yaml", ".git")
  ```


## cadence

[Cadence Language Server](https://github.com/onflow/cadence-tools/tree/master/languageserver)
using the [flow-cli](https://developers.flow.com/tools/flow-cli).

The `flow` command from flow-cli must be available. For install instructions see
[the docs](https://developers.flow.com/tools/flow-cli/install#install-the-flow-cli) or the
[Github page](https://github.com/onflow/flow-cli).

By default the configuration is taken from the closest `flow.json` or the `flow.json` in the users home directory.



**Snippet to enable the language server:**
```lua
require'lspconfig'.cadence.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "flow", "cadence", "language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "cdc" }
  ```
  - `init_options` : 
  ```lua
  {
    numberOfAccounts = "1"
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('flow.json') or vim.env.HOME
  ```


## cairo_ls

[Cairo Language Server](https://github.com/starkware-libs/cairo/tree/main/crates/cairo-lang-language-server)

First, install cairo following [this tutorial](https://medium.com/@elias.tazartes/ahead-of-the-curve-install-cairo-1-0-alpha-and-prepare-for-regenesis-85f4e3940e20)

Then enable cairo language server in your lua configuration.
```lua
require'lspconfig'.cairo_ls.setup{}
```

*cairo-language-server is still under active development, some features might not work yet !*



**Snippet to enable the language server:**
```lua
require'lspconfig'.cairo_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cairo-language-server", "/C", "--node-ipc" }
  ```
  - `filetypes` : 
  ```lua
  { "cairo" }
  ```
  - `init_options` : 
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Scarb.toml", "cairo_project.toml", ".git")
  ```


## ccls

https://github.com/MaskRay/ccls/wiki

ccls relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html) specified
as compile_commands.json or, for simpler projects, a .ccls.
For details on how to automatically generate one using CMake look [here](https://cmake.org/cmake/help/latest/variable/CMAKE_EXPORT_COMPILE_COMMANDS.html). Alternatively, you can use [Bear](https://github.com/rizsotto/Bear).

Customization options are passed to ccls at initialization time via init_options, a list of available options can be found [here](https://github.com/MaskRay/ccls/wiki/Customization#initialization-options). For example:

```lua
local lspconfig = require'lspconfig'
lspconfig.ccls.setup {
  init_options = {
    compilationDatabaseDirectory = "build";
    index = {
      threads = 0;
    };
    clang = {
      excludeArgs = { "-frounding-math"} ;
    };
  }
}

```




**Snippet to enable the language server:**
```lua
require'lspconfig'.ccls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ccls" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp", "cuda" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern('compile_commands.json', '.ccls', '.git')
  ```
  - `single_file_support` : 
  ```lua
  false
  ```


## circom-lsp

[Circom Language Server](https://github.com/rubydusa/circom-lsp)

`circom-lsp`, the language server for the Circom language.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.circom-lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "circom-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "circom" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## clangd

https://clangd.llvm.org/installation.html

- **NOTE:** Clang >= 11 is recommended! See [#23](https://github.com/neovim/nvim-lsp/issues/23).
- If `compile_commands.json` lives in a build directory, you should
  symlink it to the root of your source tree.
  ```
  ln -s /path/to/myproject/build/compile_commands.json /path/to/myproject/
  ```
- clangd relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html)
  specified as compile_commands.json, see https://clangd.llvm.org/installation#compile_commandsjson



**Snippet to enable the language server:**
```lua
require'lspconfig'.clangd.setup{}
```
**Commands:**
- ClangdSwitchSourceHeader: Switch between source/header

**Default values:**
  - `capabilities` : 
  ```lua
  default capabilities, with offsetEncoding utf-8
  ```
  - `cmd` : 
  ```lua
  { "clangd" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp", "cuda", "proto" }
  ```
  - `root_dir` : 
  ```lua
          root_pattern(
            '.clangd',
            '.clang-tidy',
            '.clang-format',
            'compile_commands.json',
            'compile_flags.txt',
            'configure.ac',
            '.git'
          )
        
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## clarity_lsp

`clarity-lsp` is a language server for the Clarity language. Clarity is a decidable smart contract language that optimizes for predictability and security. Smart contracts allow developers to encode essential business logic on a blockchain.

To learn how to configure the clarity language server, see the [clarity-lsp documentation](https://github.com/hirosystems/clarity-lsp).



**Snippet to enable the language server:**
```lua
require'lspconfig'.clarity_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clarity-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clar", "clarity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## clojure_lsp

https://github.com/clojure-lsp/clojure-lsp

Clojure Language Server



**Snippet to enable the language server:**
```lua
require'lspconfig'.clojure_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clojure-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clojure", "edn" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("project.clj", "deps.edn", "build.boot", "shadow-cljs.edn", ".git", "bb.edn")
  ```


## cmake

https://github.com/regen100/cmake-language-server

CMake LSP Implementation



**Snippet to enable the language server:**
```lua
require'lspconfig'.cmake.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cmake-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "cmake" }
  ```
  - `init_options` : 
  ```lua
  {
    buildDirectory = "build"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('CMakePresets.json', 'CTestConfig.cmake', '.git', 'build', 'cmake')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## cobol_ls

Cobol language support
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cobol_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cobol-language-support" }
  ```
  - `filetypes` : 
  ```lua
  { "cobol" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## codeqlls

Reference:
https://codeql.github.com/docs/codeql-cli/

Binaries:
https://github.com/github/codeql-cli-binaries
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.codeqlls.setup{}
```


**Default values:**
  - `before_init` : 
  ```lua
  see source file
  ```
  - `cmd` : 
  ```lua
  { "codeql", "execute", "language-server", "--check-errors", "ON_CHANGE", "-q" }
  ```
  - `filetypes` : 
  ```lua
  { "ql" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    search_path = "list containing all search paths, eg: '~/codeql-home/codeql-repo'"
  }
  ```


## coffeesense

https://github.com/phil294/coffeesense

CoffeeSense Language Server
`coffeesense-language-server` can be installed via `npm`:
```sh
npm install -g coffeesense-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.coffeesense.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "coffeesense-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "coffee" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## contextive

https://github.com/dev-cycles/contextive

Language Server for Contextive.

Contextive allows you to define terms in a central file and provides auto-completion suggestions and hover panels for these terms wherever they're used.

To install the language server, you need to download the appropriate [GitHub release asset](https://github.com/dev-cycles/contextive/releases/) for your operating system and architecture.

After the download unzip the Contextive.LanguageServer binary and copy the file into a folder that is included in your system's PATH.



**Snippet to enable the language server:**
```lua
require'lspconfig'.contextive.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "Contextive.LanguageServer" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## coq_lsp

https://github.com/ejgallego/coq-lsp/



**Snippet to enable the language server:**
```lua
require'lspconfig'.coq_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "coq-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "coq" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## crystalline

https://github.com/elbywan/crystalline

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.crystalline.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "crystalline" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## csharp_ls

https://github.com/razzmatazz/csharp-language-server

Language Server for C#.

csharp-ls requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install csharp-ls is with `dotnet tool install --global csharp-ls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.csharp_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "csharp-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "cs" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## cssls


https://github.com/hrsh7th/vscode-langservers-extracted

`css-languageserver` can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-css-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.cssls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.cssls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-css-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "scss", "less" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git") or bufdir
  ```
  - `settings` : 
  ```lua
  {
    css = {
      validate = true
    },
    less = {
      validate = true
    },
    scss = {
      validate = true
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## cssmodules_ls

https://github.com/antonk52/cssmodules-language-server

Language server for autocompletion and go-to-definition functionality for CSS modules.

You can install cssmodules-language-server via npm:
```sh
npm install -g cssmodules-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cssmodules_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cssmodules-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json")
  ```


## cucumber_language_server

https://cucumber.io
https://github.com/cucumber/common
https://www.npmjs.com/package/@cucumber/language-server

Language server for Cucumber.

`cucumber-language-server` can be installed via `npm`:
```sh
npm install -g @cucumber/language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cucumber_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cucumber-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cucumber" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## custom_elements_ls

https://github.com/Matsuuu/custom-elements-language-server

`custom-elements-languageserver` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript custom-elements-languageserver
```
To configure typescript language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.
Here's an example that disables type checking in JavaScript files.
```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.custom_elements_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "custom-elements-languageserver", "--stdio" }
  ```
  - `init_options` : 
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tsconfig.json", "package.json", "jsconfig.json", ".git")
  ```


## cypher_ls

https://github.com/neo4j/cypher-language-support/tree/main/packages/language-server

`cypher-language-server`, language server for Cypher query language.
Part of the umbrella project cypher-language-support: https://github.com/neo4j/cypher-language-support

`cypher-language-server` can be installed via `npm`:
```sh
npm i -g @neo4j-cypher/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.cypher_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cypher-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cypher" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dafny

    Support for the Dafny language server.

    The default `cmd` uses "dafny server", which works on Dafny 4.0.0+. For
    older versions of Dafny, you can compile the language server from source at
    [dafny-lang/language-server-csharp](https://github.com/dafny-lang/language-server-csharp)
    and set `cmd = {"dotnet", "<Path to your language server>"}`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dafny.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dafny", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "dfy", "dafny" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dagger

https://github.com/dagger/cuelsp

Dagger's lsp server for cuelang.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dagger.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cuelsp" }
  ```
  - `filetypes` : 
  ```lua
  { "cue" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("cue.mod", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dartls

https://github.com/dart-lang/sdk/tree/master/pkg/analysis_server/tool/lsp_spec

Language server for dart.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dartls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dart", "language-server", "--protocol=lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "dart" }
  ```
  - `init_options` : 
  ```lua
  {
    closingLabels = true,
    flutterOutline = true,
    onlyAnalyzeProjectsWithOpenFiles = true,
    outline = true,
    suggestFromUnimportedLibraries = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("pubspec.yaml")
  ```
  - `settings` : 
  ```lua
  {
    dart = {
      completeFunctionCalls = true,
      showTodos = true
    }
  }
  ```


## denols

https://github.com/denoland/deno

Deno's built-in language server

To appropriately highlight codefences returned from denols, you will need to augment vim.g.markdown_fenced languages
 in your init.lua. Example:

```lua
vim.g.markdown_fenced_languages = {
  "ts=typescript"
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.denols.setup{}
```
**Commands:**
- DenolsCache: Cache a module and all of its dependencies.

**Default values:**
  - `cmd` : 
  ```lua
  { "deno", "lsp" }
  ```
  - `cmd_env` : 
  ```lua
  {
    NO_COLOR = true
  }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `handlers` : 
  ```lua
  {
    ["textDocument/definition"] = <function 1>,
    ["textDocument/references"] = <function 1>,
    ["textDocument/typeDefinition"] = <function 1>,
    ["workspace/executeCommand"] = <function 2>
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("deno.json", "deno.jsonc", ".git")
  ```
  - `settings` : 
  ```lua
  {
    deno = {
      enable = true,
      suggest = {
        imports = {
          hosts = {
            ["https://crux.land"] = true,
            ["https://deno.land"] = true,
            ["https://x.nest.land"] = true
          }
        }
      }
    }
  }
  ```


## dhall_lsp_server

https://github.com/dhall-lang/dhall-haskell/tree/master/dhall-lsp-server

language server for dhall

`dhall-lsp-server` can be installed via cabal:
```sh
cabal install dhall-lsp-server
```
prebuilt binaries can be found [here](https://github.com/dhall-lang/dhall-haskell/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.dhall_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dhall-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "dhall" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## diagnosticls

https://github.com/iamcco/diagnostic-languageserver

Diagnostic language server integrate with linters.



**Snippet to enable the language server:**
```lua
require'lspconfig'.diagnosticls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "diagnostic-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  Empty by default, override to add filetypes
  ```
  - `root_dir` : 
  ```lua
  Vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## digestif

https://github.com/astoff/digestif

Digestif is a code analyzer, and a language server, for LaTeX, ConTeXt et caterva. It provides

context-sensitive completion, documentation, code navigation, and related functionality to any

text editor that speaks the LSP protocol.



**Snippet to enable the language server:**
```lua
require'lspconfig'.digestif.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "digestif" }
  ```
  - `filetypes` : 
  ```lua
  { "tex", "plaintex", "context" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## docker_compose_language_service

https://github.com/microsoft/compose-language-service
This project contains a language service for Docker Compose.

`compose-language-service` can be installed via `npm`:

```sh
npm install @microsoft/compose-language-service
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.docker_compose_language_service.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "docker-compose-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml.docker-compose" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("docker-compose.yaml")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dockerls

https://github.com/rcjsuen/dockerfile-language-server-nodejs

`docker-langserver` can be installed via `npm`:
```sh
npm install -g dockerfile-language-server-nodejs
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dockerls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "docker-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dockerfile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Dockerfile")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dolmenls

https://github.com/Gbury/dolmen/blob/master/doc/lsp.md

`dolmenls` can be installed via `opam`
```sh
opam install dolmen_lsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dolmenls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dolmenls" }
  ```
  - `filetypes` : 
  ```lua
  { "smt2", "tptp", "p", "cnf", "icnf", "zf" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dotls

https://github.com/nikeee/dot-language-server

`dot-language-server` can be installed via `npm`:
```sh
npm install -g dot-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dotls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dot-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dot" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## drools_lsp

https://github.com/kiegroup/drools-lsp

Language server for the [Drools Rule Language (DRL)](https://docs.drools.org/latest/drools-docs/docs-website/drools/language-reference/#con-drl_drl-rules).

The `drools-lsp` server is a self-contained java jar file (`drools-lsp-server-jar-with-dependencies.jar`), and can be downloaded from [https://github.com/kiegroup/drools-lsp/releases/](https://github.com/kiegroup/drools-lsp/releases/).

Configuration information:
```lua
-- Option 1) Specify the entire command:
require('lspconfig').drools_lsp.setup {
  cmd = { '/path/to/java', '-jar', '/path/to/drools-lsp-server-jar-with-dependencies.jar' },
}

-- Option 2) Specify just the jar path (the JAVA_HOME environment variable will be respected if present):
require('lspconfig').drools_lsp.setup {
  drools = { jar = '/path/to/drools-lsp-server-jar-with-dependencies.jar' },
}

-- Option 3) Specify the java bin and/or java opts in addition to the jar path:
require('lspconfig').drools_lsp.setup {
  drools = {
    java = { bin = '/path/to/java', opts = { '-Xmx100m' } },
    jar = '/path/to/drools-lsp-server-jar-with-dependencies.jar',
  },
}
```

Neovim does not yet have automatic detection for the `drools` filetype, but it can be added with:
```lua
vim.cmd [[ autocmd BufNewFile,BufRead *.drl set filetype=drools ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.drools_lsp.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "drools" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ds_pinyin_lsp

https://github.com/iamcco/ds-pinyin-lsp
Dead simple Pinyin language server for input Chinese without IME(input method).
To install, download the latest [release](https://github.com/iamcco/ds-pinyin-lsp/releases) and ensure `ds-pinyin-lsp` is on your path.
And make ensure the database file `dict.db3` is also downloaded. And put the path to `dict.dbs` in the following code.

```lua

require('lspconfig').ds_pinyin_lsp.setup {
    init_options = {
        db_path = "your_path_to_database"
    }
}

```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ds_pinyin_lsp.setup{}
```
**Commands:**
- DsPinyinCompletionOff: Turn off the ds-pinyin-lsp completion
- DsPinyinCompletionOn: Turn on the ds-pinyin-lsp completion

**Default values:**
  - `cmd` : 
  ```lua
  { "ds-pinyin-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown", "org" }
  ```
  - `init_options` : 
  ```lua
  {
    completion_on = true,
    match_as_same_as_input = true,
    match_long_input = true,
    max_suggest = 15,
    show_symbols = true,
    show_symbols_by_n_times = 0,
    show_symbols_only_follow_by_hanzi = false
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ecsact

https://github.com/ecsact-dev/ecsact_lsp_server

Language server for Ecsact.

The default cmd assumes `ecsact_lsp_server` is in your PATH. Typically from the
Ecsact SDK: https://ecsact.dev/start



**Snippet to enable the language server:**
```lua
require'lspconfig'.ecsact.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ecsact_lsp_server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ecsact" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## efm

https://github.com/mattn/efm-langserver

General purpose Language Server that can use specified error message format generated from specified command.

Requires at minimum EFM version [v0.0.38](https://github.com/mattn/efm-langserver/releases/tag/v0.0.38) to support
launching the language server on single files. If on an older version of EFM, disable single file support:

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = ..., -- Populate this according to the note below
  single_file_support = false, -- This is the important line for supporting older version of EFM
}
```

Note: In order for neovim's built-in language server client to send the appropriate `languageId` to EFM, **you must
specify `filetypes` in your call to `setup{}`**. Otherwise `lspconfig` will launch EFM on the `BufEnter` instead
of the `FileType` autocommand, and the `filetype` variable used to populate the `languageId` will not yet be set.

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = { 'python','cpp','lua' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.efm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "efm-langserver" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## elixirls

https://github.com/elixir-lsp/elixir-ls

`elixir-ls` can be installed by following the instructions [here](https://github.com/elixir-lsp/elixir-ls#building-and-running).

```bash
curl -fLO https://github.com/elixir-lsp/elixir-ls/releases/latest/download/elixir-ls.zip
unzip elixir-ls.zip -d /path/to/elixir-ls
# Unix
chmod +x /path/to/elixir-ls/language_server.sh
```

**By default, elixir-ls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your unzipped elixir-ls.

```lua
require'lspconfig'.elixirls.setup{
    -- Unix
    cmd = { "/path/to/elixir-ls/language_server.sh" };
    -- Windows
    cmd = { "/path/to/elixir-ls/language_server.bat" };
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elixirls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor(fname) or util.root_pattern 'mix.exs'(fname) or vim.loop.os_homedir()
  ```


## elmls

https://github.com/elm-tooling/elm-language-server#installation

If you don't want to use Nvim to install it, then you can use:
```sh
npm install -g elm elm-test elm-format @elm-tooling/elm-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elmls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "elm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "elm" }
  ```
  - `init_options` : 
  ```lua
  {
    elmAnalyseTrigger = "change"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("elm.json")
  ```


## elp

https://whatsapp.github.io/erlang-language-platform

ELP integrates Erlang into modern IDEs via the language server protocol and was
inspired by rust-analyzer.



**Snippet to enable the language server:**
```lua
require'lspconfig'.elp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "elp", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "erlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('rebar.config', 'erlang.mk', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ember

https://github.com/lifeart/ember-language-server

`ember-language-server` can be installed via `npm`:

```sh
npm install -g @lifeart/ember-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ember.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ember-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "handlebars", "typescript", "javascript", "typescript.glimmer", "javascript.glimmer" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("ember-cli-build.js", ".git")
  ```


## emmet_language_server

https://github.com/olrtg/emmet-language-server

Package can be installed via `npm`:
```sh
npm install -g @olrtg/emmet-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.emmet_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "emmet-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "eruby", "html", "htmldjango", "javascriptreact", "less", "pug", "sass", "scss", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  git root
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## emmet_ls

https://github.com/aca/emmet-ls

Package can be installed via `npm`:
```sh
npm install -g emmet-ls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.emmet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "emmet-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "astro", "css", "eruby", "html", "htmldjango", "javascriptreact", "less", "pug", "sass", "scss", "svelte", "typescriptreact", "vue" }
  ```
  - `root_dir` : 
  ```lua
  git root
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## erg_language_server

https://github.com/erg-lang/erg#flags ELS

ELS (erg-language-server) is a language server for the Erg programming language.

erg-language-server can be installed via `cargo` and used as follows:
 ```sh
 cargo install erg --features els
 erg --language-server
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.erg_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "erg", "--language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "erg" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.er") or find_git_ancestor
  ```


## erlangls

https://erlang-ls.github.io

Language Server for Erlang.

Clone [erlang_ls](https://github.com/erlang-ls/erlang_ls)
Compile the project with `make` and copy resulting binaries somewhere in your $PATH eg. `cp _build/*/bin/* ~/local/bin`

Installation instruction can be found [here](https://github.com/erlang-ls/erlang_ls).

Installation requirements:
    - [Erlang OTP 21+](https://github.com/erlang/otp)
    - [rebar3 3.9.1+](https://github.com/erlang/rebar3)



**Snippet to enable the language server:**
```lua
require'lspconfig'.erlangls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "erlang_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "erlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('rebar.config', 'erlang.mk', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## esbonio

https://github.com/swyddfa/esbonio

Esbonio is a language server for [Sphinx](https://www.sphinx-doc.org/en/master/) documentation projects.
The language server can be installed via pip

```
pip install esbonio
```

Since Sphinx is highly extensible you will get best results if you install the language server in the same
Python environment as the one used to build your documentation. To ensure that the correct Python environment
is picked up, you can either launch `nvim` with the correct environment activated.

```
source env/bin/activate
nvim
```

Or you can modify the default `cmd` to include the full path to the Python interpreter.

```lua
require'lspconfig'.esbonio.setup {
  cmd = { '/path/to/virtualenv/bin/python', '-m', 'esbonio' }
}
```

Esbonio supports a number of config values passed as `init_options` on startup, for example.

```lua
require'lspconfig'.esbonio.setup {
  init_options = {
    server = {
      logLevel = "debug"
    },
    sphinx = {
      confDir = "/path/to/docs",
      srcDir = "${confDir}/../docs-src"
    }
}
```

A full list and explanation of the available options can be found [here](https://swyddfa.github.io/esbonio/docs/latest/en/lsp/getting-started.html#configuration)



**Snippet to enable the language server:**
```lua
require'lspconfig'.esbonio.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "python3", "-m", "esbonio" }
  ```
  - `filetypes` : 
  ```lua
  { "rst" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## eslint

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-eslint-language-server` is a linting engine for JavaScript / Typescript.
It can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

`vscode-eslint-language-server` provides an `EslintFixAll` command that can be used to format a document on save:
```lua
lspconfig.eslint.setup({
  --- ...
  on_attach = function(client, bufnr)
    vim.api.nvim_create_autocmd("BufWritePre", {
      buffer = bufnr,
      command = "EslintFixAll",
    })
  end,
})
```

See [vscode-eslint](https://github.com/microsoft/vscode-eslint/blob/55871979d7af184bf09af491b6ea35ebd56822cf/server/src/eslintServer.ts#L216-L229) for configuration options.

Messages handled in lspconfig: `eslint/openDoc`, `eslint/confirmESLintExecution`, `eslint/probeFailed`, `eslint/noLibrary`

Additional messages you can handle: `eslint/noConfig`



**Snippet to enable the language server:**
```lua
require'lspconfig'.eslint.setup{}
```
**Commands:**
- EslintFixAll: Fix all eslint problems for this buffer

**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-eslint-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx", "vue", "svelte", "astro" }
  ```
  - `handlers` : 
  ```lua
  {
    ["eslint/confirmESLintExecution"] = <function 1>,
    ["eslint/noLibrary"] = <function 2>,
    ["eslint/openDoc"] = <function 3>,
    ["eslint/probeFailed"] = <function 4>
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    codeAction = {
      disableRuleComment = {
        enable = true,
        location = "separateLine"
      },
      showDocumentation = {
        enable = true
      }
    },
    codeActionOnSave = {
      enable = false,
      mode = "all"
    },
    experimental = {
      useFlatConfig = false
    },
    format = true,
    nodePath = "",
    onIgnoredFiles = "off",
    problems = {
      shortenToSingleLine = false
    },
    quiet = false,
    rulesCustomizations = {},
    run = "onType",
    useESLintClass = false,
    validate = "on",
    workingDirectory = {
      mode = "location"
    }
  }
  ```


## facility_language_server

https://github.com/FacilityApi/FacilityLanguageServer

Facility language server protocol (LSP) support.



**Snippet to enable the language server:**
```lua
require'lspconfig'.facility_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "facility-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "fsd" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## fennel_language_server

https://github.com/rydesun/fennel-language-server

Fennel language server protocol (LSP) support.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fennel_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fennel-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "fennel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## fennel_ls

https://sr.ht/~xerool/fennel-ls/

A language server for fennel.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fennel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fennel-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "fennel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## flow

https://flow.org/
https://github.com/facebook/flow

See below for how to setup Flow itself.
https://flow.org/en/docs/install/

See below for lsp command options.

```sh
npx flow lsp --help
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.flow.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "npx", "--no-install", "flow", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".flowconfig")
  ```


## flux_lsp

https://github.com/influxdata/flux-lsp
`flux-lsp` can be installed via `cargo`:
```sh
cargo install --git https://github.com/influxdata/flux-lsp
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.flux_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "flux-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "flux" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## foam_ls

https://github.com/FoamScience/foam-language-server

`foam-language-server` can be installed via `npm`
```sh
npm install -g foam-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.foam_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "foam-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "foam", "OpenFOAM" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fortls

https://github.com/gnikit/fortls

fortls is a Fortran Language Server, the server can be installed via pip

```sh
pip install fortls
```

Settings to the server can be passed either through the `cmd` option or through
a local configuration file e.g. `.fortls`. For more information
see the `fortls` [documentation](https://gnikit.github.io/fortls/options.html).
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fortls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fortls", "--notify_init", "--hover_signature", "--hover_language=fortran", "--use_signature_help" }
  ```
  - `filetypes` : 
  ```lua
  { "fortran" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".fortls")
  ```
  - `settings` : 
  ```lua
  {}
  ```


## fsautocomplete

https://github.com/fsharp/FsAutoComplete

Language Server for F# provided by FsAutoComplete (FSAC).

FsAutoComplete requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install FsAutoComplete is with `dotnet tool install --global fsautocomplete`.

Instructions to compile from source are found on the main [repository](https://github.com/fsharp/FsAutoComplete).

You may also need to configure the filetype as Vim defaults to Forth for `*.fs` files:

`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`

This is automatically done by plugins such as [PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fsautocomplete.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fsautocomplete", "--adaptive-lsp-server-enabled" }
  ```
  - `filetypes` : 
  ```lua
  { "fsharp" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fsharp_language_server

F# Language Server
https://github.com/faldor20/fsharp-language-server

An implementation of the language server protocol using the F# Compiler Service.

Build the project from source and override the command path to location of DLL.

If filetype determination is not already performed by an available plugin ([PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).
), then the following must be added to initialization configuration:


`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`



**Snippet to enable the language server:**
```lua
require'lspconfig'.fsharp_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dotnet", "FSharpLanguageServer.dll" }
  ```
  - `filetypes` : 
  ```lua
  { "fsharp" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## fstar

https://github.com/FStarLang/FStar

LSP support is included in FStar. Make sure `fstar.exe` is in your PATH.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fstar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fstar.exe", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "fstar" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## futhark_lsp

https://github.com/diku-dk/futhark

Futhark Language Server

This language server comes with the futhark compiler and is run with the command
```
futhark lsp
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.futhark_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "futhark", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "futhark", "fut" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gdscript

https://github.com/godotengine/godot

Language server for GDScript, used by Godot Engine.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gdscript.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  see source file
  ```
  - `filetypes` : 
  ```lua
  { "gd", "gdscript", "gdscript3" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("project.godot", ".git")
  ```


## ghcide

https://github.com/digital-asset/ghcide

A library for building Haskell IDE tooling.
"ghcide" isn't for end users now. Use "haskell-language-server" instead of "ghcide".



**Snippet to enable the language server:**
```lua
require'lspconfig'.ghcide.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ghcide", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "hie-bios", "BUILD.bazel", "cabal.config", "package.yaml")
  ```


## ghdl_ls

https://github.com/ghdl/ghdl-language-server

A language server for VHDL, using ghdl as its backend.

`ghdl-ls` is part of pyghdl, for installation instructions see
[the upstream README](https://github.com/ghdl/ghdl/tree/master/pyGHDL/lsp).



**Snippet to enable the language server:**
```lua
require'lspconfig'.ghdl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ghdl-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "vhdl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gleam

https://github.com/gleam-lang/gleam

A language server for Gleam Programming Language.
[Installation](https://gleam.run/getting-started/installing/)

It can be i



**Snippet to enable the language server:**
```lua
require'lspconfig'.gleam.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gleam", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "gleam" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("gleam.toml", ".git")
  ```


## glint

  https://github.com/typed-ember/glint

  https://typed-ember.gitbook.io/glint/

  `glint-language-server` is installed when adding `@glint/core` to your project's devDependencies:

  ```sh
  npm install @glint/core --save-dev
  ```

  or

  ```sh
  yarn add -D @glint/core
  ```

  or

  ```sh
  pnpm add -D @glint/core
  ```



**Snippet to enable the language server:**
```lua
require'lspconfig'.glint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "glint-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "html.handlebars", "handlebars", "typescript", "typescript.glimmer", "javascript", "javascript.glimmer" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## glsl_analyzer

https://github.com/nolanderc/glsl_analyzer

Language server for GLSL
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.glsl_analyzer.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {}
  ```
  - `cmd` : 
  ```lua
  { "glsl_analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "glsl", "vert", "tesc", "tese", "frag", "geom", "comp" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## glslls

https://github.com/svenstaro/glsl-language-server

Language server implementation for GLSL

`glslls` can be compiled and installed manually, or, if your distribution has access to the AUR,
via the `glsl-language-server` AUR package
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.glslls.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" },
    textDocument = {
      completion = {
        editsNearCursor = true
      }
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "glslls", "--stdin" }
  ```
  - `filetypes` : 
  ```lua
  { "glsl", "vert", "tesc", "tese", "frag", "geom", "comp" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## golangci_lint_ls

Combination of both lint server and client

https://github.com/nametake/golangci-lint-langserver
https://github.com/golangci/golangci-lint


Installation of binaries needed is done via

```
go install github.com/nametake/golangci-lint-langserver@latest
go install github.com/golangci/golangci-lint/cmd/golangci-lint@latest
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.golangci_lint_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "golangci-lint-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod" }
  ```
  - `init_options` : 
  ```lua
  {
    command = { "golangci-lint", "run", "--out-format", "json" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.golangci.yml', '.golangci.yaml', '.golangci.toml', '.golangci.json', 'go.work', 'go.mod', '.git')
  ```


## gopls

https://github.com/golang/tools/tree/master/gopls

Google's lsp server for golang.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gopls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gopls" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod", "gowork", "gotmpl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("go.work", "go.mod", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gradle_ls

https://github.com/microsoft/vscode-gradle

Microsoft's lsp server for gradle files

If you're setting this up manually, build vscode-gradle using `./gradlew installDist` and point `cmd` to the `gradle-language-server` generated in the build directory



**Snippet to enable the language server:**
```lua
require'lspconfig'.gradle_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gradle-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `init_options` : 
  ```lua
  {
    settings = {
      gradleWrapperEnabled = true
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle", "build.gradle")
  ```


## grammarly

https://github.com/znck/grammarly

`grammarly-languageserver` can be installed via `npm`:

```sh
npm i -g grammarly-languageserver
```

WARNING: Since this language server uses Grammarly's API, any document you open with it running is shared with them. Please evaluate their [privacy policy](https://www.grammarly.com/privacy-policy) before using this.



**Snippet to enable the language server:**
```lua
require'lspconfig'.grammarly.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "grammarly-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `handlers` : 
  ```lua
  {
    ["$/updateDocumentState"] = <function 1>
  }
  ```
  - `init_options` : 
  ```lua
  {
    clientId = "client_BaDkMgx4X19X9UxxYRCXZo"
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## graphql

https://github.com/graphql/graphiql/tree/main/packages/graphql-language-service-cli

`graphql-lsp` can be installed via `npm`:

```sh
npm install -g graphql-language-service-cli
```

Note that you must also have [the graphql package](https://github.com/graphql/graphql-js) installed within your project and create a [GraphQL config file](https://the-guild.dev/graphql/config/docs).



**Snippet to enable the language server:**
```lua
require'lspconfig'.graphql.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "graphql-lsp", "server", "-m", "stream" }
  ```
  - `filetypes` : 
  ```lua
  { "graphql", "typescriptreact", "javascriptreact" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('.git', '.graphqlrc*', '.graphql.config.*', 'graphql.config.*')
  ```


## groovyls

https://github.com/prominic/groovy-language-server.git

Requirements:
 - Linux/macOS (for now)
 - Java 11+

`groovyls` can be installed by following the instructions [here](https://github.com/prominic/groovy-language-server.git#build).

If you have installed groovy language server, you can set the `cmd` custom path as follow:

```lua
require'lspconfig'.groovyls.setup{
    -- Unix
    cmd = { "java", "-jar", "path/to/groovyls/groovy-language-server-all.jar" },
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.groovyls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "java", "-jar", "groovy-language-server-all.jar" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## guile_ls

https://codeberg.org/rgherdt/scheme-lsp-server

The recommended way is to install guile-lsp-server is using Guix. Unfortunately it is still not available at the official Guix channels, but you can use the provided channel guix.scm in the repo:
```sh
guix package -f guix.scm
```

Checkout the repo for more info.

Note: This LSP will start on `scheme.guile` filetype. You can set this file type using `:help modeline` or adding https://gitlab.com/HiPhish/guile.vim to your plugins to automatically set it.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.guile_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "guile-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "scheme.guile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("guix.scm", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## haxe_language_server

https://github.com/vshaxe/haxe-language-server

The Haxe language server can be built by running the following commands from
the project's root directory:

    npm install
    npx lix run vshaxe-build -t language-server

This will create `bin/server.js`. Note that the server requires Haxe 3.4.0 or
higher.

After building the language server, set the `cmd` setting in your setup
function:

```lua
lspconfig.haxe_language_server.setup({
  cmd = {"node", "path/to/bin/server.js"},
})
```

By default, an HXML compiler arguments file named `build.hxml` is expected in
your project's root directory. If your file is named something different,
specify it using the `init_options.displayArguments` setting.



**Snippet to enable the language server:**
```lua
require'lspconfig'.haxe_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haxe-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "haxe" }
  ```
  - `init_options` : 
  ```lua
  {
    displayArguments = { "build.hxml" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.hxml")
  ```
  - `settings` : 
  ```lua
  {
    haxe = {
      executable = "haxe"
    }
  }
  ```


## hdl_checker

https://github.com/suoto/hdl_checker
Language server for hdl-checker.
Install using: `pip install hdl-checker --upgrade`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hdl_checker.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hdl_checker", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "vhdl", "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## helm_ls

https://github.com/mrjosh/helm-ls

Helm Language server. (This LSP is in early development)

`helm Language server` can be installed by following the instructions [here](https://github.com/mrjosh/helm-ls).

The default `cmd` assumes that the `helm_ls` binary can be found in `$PATH`.

If need Helm file highlight use [vim-helm](https://github.com/towolf/vim-helm) plugin.



**Snippet to enable the language server:**
```lua
require'lspconfig'.helm_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "helm_ls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "helm" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Chart.yaml")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hhvm

Language server for programs written in Hack
https://hhvm.com/
https://github.com/facebook/hhvm
See below for how to setup HHVM & typechecker:
https://docs.hhvm.com/hhvm/getting-started/getting-started
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.hhvm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hh_client", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "php", "hack" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".hhconfig")
  ```


## hie

https://github.com/haskell/haskell-ide-engine

the following init_options are supported (see https://github.com/haskell/haskell-ide-engine#configuration):
```lua
init_options = {
  languageServerHaskell = {
    hlintOn = bool;
    maxNumberOfProblems = number;
    diagnosticsDebounceDuration = number;
    liquidOn = bool (default false);
    completionSnippetsOn = bool (default true);
    formatOnImportOn = bool (default true);
    formattingProvider = string (default "brittany", alternate "floskell");
  }
}
```
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.hie.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hie-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "package.yaml", ".git")
  ```


## hls

https://github.com/haskell/haskell-language-server

Haskell Language Server

If you are using HLS 1.9.0.0, enable the language server to launch on Cabal files as well:

```lua
require('lspconfig')['hls'].setup{
  filetypes = { 'haskell', 'lhaskell', 'cabal' },
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.hls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haskell-language-server-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `lspinfo` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("hie.yaml", "stack.yaml", "cabal.project", "*.cabal", "package.yaml")
  ```
  - `settings` : 
  ```lua
  {
    haskell = {
      cabalFormattingProvider = "cabalfmt",
      formattingProvider = "ormolu"
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hoon_ls

https://github.com/urbit/hoon-language-server

A language server for Hoon.

The language server can be installed via `npm install -g @hoon-language-server`

Start a fake ~zod with `urbit -F zod`.
Start the language server at the Urbit Dojo prompt with: `|start %language-server`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hoon_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hoon-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "hoon" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## html

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-html-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-html-language-server` only provides completions when snippet support is enabled.
To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

The code-formatting feature of the lsp can be controlled with the `provideFormatter` option.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.html.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.html.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-html-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html" }
  ```
  - `init_options` : 
  ```lua
  {
    configurationSection = { "html", "css", "javascript" },
    embeddedLanguages = {
      css = true,
      javascript = true
    },
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## htmx

https://github.com/ThePrimeagen/htmx-lsp

`htmx-lsp` can be installed via `cargo`:
```sh
cargo install htmx-lsp
```

Lsp is still very much work in progress and experimental. Use at your own risk.



**Snippet to enable the language server:**
```lua
require'lspconfig'.htmx.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "htmx-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "html" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hydra_lsp

https://github.com/Retsediv/hydra-lsp

LSP for Hydra Python package config files.



**Snippet to enable the language server:**
```lua
require'lspconfig'.hydra_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hydra-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern '.git'
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## idris2_lsp

https://github.com/idris-community/idris2-lsp

The Idris 2 language server.

Plugins for the Idris 2 filetype include
[Idris2-Vim](https://github.com/edwinb/idris2-vim) (fewer features, stable) and
[Nvim-Idris2](https://github.com/ShinKage/nvim-idris2) (cutting-edge,
experimental).

Idris2-Lsp requires a build of Idris 2 that includes the "Idris 2 API" package.
Package managers with known support for this build include the
[AUR](https://aur.archlinux.org/packages/idris2/) and
[Homebrew](https://formulae.brew.sh/formula/idris2#default).

If your package manager does not support the Idris 2 API, you will need to build
Idris 2 from source. Refer to the
[the Idris 2 installation instructions](https://github.com/idris-lang/Idris2/blob/main/INSTALL.md)
for details.  Steps 5 and 8 are listed as "optional" in that guide, but they are
necessary in order to make the Idris 2 API available.

You need to install a version of Idris2-Lsp that is compatible with your
version of Idris 2. There should be a branch corresponding to every released
Idris 2 version after v0.4.0. Use the latest commit on that branch. For example,
if you have Idris v0.5.1, you should use the v0.5.1 branch of Idris2-Lsp.

If your Idris 2 version is newer than the newest Idris2-Lsp branch, use the
latest commit on the `master` branch, and set a reminder to check the Idris2-Lsp
repo for the release of a compatible versioned branch.



**Snippet to enable the language server:**
```lua
require'lspconfig'.idris2_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "idris2-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "idris2" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## intelephense

https://intelephense.com/

`intelephense` can be installed via `npm`:
```sh
npm install -g intelephense
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.intelephense.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "intelephense", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## java_language_server

https://github.com/georgewfraser/java-language-server

Java language server

Point `cmd` to `lang_server_linux.sh` or the equivalent script for macOS/Windows provided by java-language-server



**Snippet to enable the language server:**
```lua
require'lspconfig'.java_language_server.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## jdtls

https://projects.eclipse.org/projects/eclipse.jdt.ls

Language server for Java.

IMPORTANT: If you want all the features jdtls has to offer, [nvim-jdtls](https://github.com/mfussenegger/nvim-jdtls)
is highly recommended. If all you need is diagnostics, completion, imports, gotos and formatting and some code actions
you can keep reading here.

For manual installation you can download precompiled binaries from the
[official downloads site](http://download.eclipse.org/jdtls/snapshots/?d)
and ensure that the `PATH` variable contains the `bin` directory of the extracted archive.

```lua
  -- init.lua
  require'lspconfig'.jdtls.setup{}
```

You can also pass extra custom jvm arguments with the JDTLS_JVM_ARGS environment variable as a space separated list of arguments,
that will be converted to multiple --jvm-arg=<param> args when passed to the jdtls script. This will allow for example tweaking
the jvm arguments or integration with external tools like lombok:

```sh
export JDTLS_JVM_ARGS="-javaagent:$HOME/.local/share/java/lombok.jar"
```

For automatic installation you can use the following unofficial installers/launchers under your own risk:
  - [jdtls-launcher](https://github.com/eruizc-dev/jdtls-launcher) (Includes lombok support by default)
    ```lua
      -- init.lua
      require'lspconfig'.jdtls.setup{ cmd = { 'jdtls' } }
    ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jdtls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jdtls", "-configuration", "/home/user/.cache/jdtls/config", "-data", "/home/user/.cache/jdtls/workspace" }
  ```
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `handlers` : 
  ```lua
  {
    ["language/status"] = <function 1>,
    ["textDocument/codeAction"] = <function 2>,
    ["textDocument/rename"] = <function 3>,
    ["workspace/applyEdit"] = <function 4>
  }
  ```
  - `init_options` : 
  ```lua
  {
    jvm_args = {},
    workspace = "/home/user/.cache/jdtls/workspace"
  }
  ```
  - `root_dir` : 
  ```lua
  {
          -- Single-module projects
          {
            'build.xml', -- Ant
            'pom.xml', -- Maven
            'settings.gradle', -- Gradle
            'settings.gradle.kts', -- Gradle
          },
          -- Multi-module projects
          { 'build.gradle', 'build.gradle.kts' },
        } or vim.fn.getcwd()
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jedi_language_server

https://github.com/pappasam/jedi-language-server

`jedi-language-server`, a language server for Python, built on top of jedi
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jedi_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jedi-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jqls

https://github.com/wader/jq-lsp
Language server for jq, written using Go.
You can install the server easily using go install:
```sh
# install directly
go install github.com/wader/jq-lsp@master
# copy binary to $PATH
cp $(go env GOPATH)/bin/jq-lsp /usr/local/bin
```
Note: To activate properly nvim needs to know the jq filetype.
You can add it via:
```lua
vim.cmd(\[\[au BufRead,BufNewFile *.jq setfiletype jq\]\])
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jqls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jq-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "jq" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonls

https://github.com/hrsh7th/vscode-langservers-extracted

vscode-json-language-server, a language server for JSON and JSON schema

`vscode-json-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-json-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.jsonls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-json-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "json", "jsonc" }
  ```
  - `init_options` : 
  ```lua
  {
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonnet_ls

https://github.com/grafana/jsonnet-language-server

A Language Server Protocol (LSP) server for Jsonnet.

The language server can be installed with `go`:
```sh
go install github.com/grafana/jsonnet-language-server@latest
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonnet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jsonnet-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "jsonnet", "libsonnet" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("jsonnetfile.json")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## julials

https://github.com/julia-vscode/julia-vscode

LanguageServer.jl can be installed with `julia` and `Pkg`:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.add("LanguageServer")'
```
where `~/.julia/environments/nvim-lspconfig` is the location where
the default configuration expects LanguageServer.jl to be installed.

To update an existing install, use the following command:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.update()'
```

Note: In order to have LanguageServer.jl pick up installed packages or dependencies in a
Julia project, you must make sure that the project is instantiated:
```sh
julia --project=/path/to/my/project -e 'using Pkg; Pkg.instantiate()'
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.julials.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "julia", "--startup-file=no", "--history-file=no", "-e", '    # Load LanguageServer.jl: attempt to load from ~/.julia/environments/nvim-lspconfig\n    # with the regular load path as a fallback\n    ls_install_path = joinpath(\n        get(DEPOT_PATH, 1, joinpath(homedir(), ".julia")),\n        "environments", "nvim-lspconfig"\n    )\n    pushfirst!(LOAD_PATH, ls_install_path)\n    using LanguageServer\n    popfirst!(LOAD_PATH)\n    depot_path = get(ENV, "JULIA_DEPOT_PATH", "")\n    project_path = let\n        dirname(something(\n            ## 1. Finds an explicitly set project (JULIA_PROJECT)\n            Base.load_path_expand((\n                p = get(ENV, "JULIA_PROJECT", nothing);\n                p === nothing ? nothing : isempty(p) ? nothing : p\n            )),\n            ## 2. Look for a Project.toml file in the current working directory,\n            ##    or parent directories, with $HOME as an upper boundary\n            Base.current_project(),\n            ## 3. First entry in the load path\n            get(Base.load_path(), 1, nothing),\n            ## 4. Fallback to default global environment,\n            ##    this is more or less unreachable\n            Base.load_path_expand("@v#.#"),\n        ))\n    end\n    @info "Running language server" VERSION pwd() project_path depot_path\n    server = LanguageServer.LanguageServerInstance(stdin, stdout, project_path, depot_path)\n    server.runlinter = true\n    run(server)\n  ' }
  ```
  - `filetypes` : 
  ```lua
  { "julia" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## kotlin_language_server

    A kotlin language server which was developed for internal usage and
    released afterwards. Maintaining is not done by the original author,
    but by fwcd.

    It is built via gradle and developed on github.
    Source and additional description:
    https://github.com/fwcd/kotlin-language-server

    This server requires vim to be aware of the kotlin-filetype.
    You could refer for this capability to:
    https://github.com/udalov/kotlin-vim (recommended)
    Note that there is no LICENSE specified yet.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.kotlin_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "kotlin-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "kotlin" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle")
  ```


## lean3ls

https://github.com/leanprover/lean-client-js/tree/master/lean-language-server

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

Once Lean is installed, you can install the Lean 3 language server by running
```sh
npm install -g lean-language-server
```

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `lean3ls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.lean3ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lean-language-server", "--stdio", "--", "-M", "4096", "-T", "100000" }
  ```
  - `filetypes` : 
  ```lua
  { "lean3" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern("leanpkg.toml") or root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## leanls

https://github.com/leanprover/lean4

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

The Lean 4 language server is built-in with a Lean 4 install
(and can be manually run with, e.g., `lean --server`).

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `leanls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.leanls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lake", "serve", "--" }
  ```
  - `filetypes` : 
  ```lua
  { "lean" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `options` : 
  ```lua
  {
    no_lake_lsp_cmd = { "lean", "--server" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("lakefile.lean", "lean-toolchain", "leanpkg.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## lelwel_ls

https://github.com/0x2a-42/lelwel

Language server for lelwel grammars.

You can install `lelwel-ls` via cargo:
```sh
cargo install --features="lsp" lelwel
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.lelwel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lelwel-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "llw" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## lemminx

https://github.com/eclipse/lemminx

The easiest way to install the server is to get a binary from https://github.com/redhat-developer/vscode-xml/releases and place it on your PATH.

NOTE to macOS users: Binaries from unidentified developers are blocked by default. If you trust the downloaded binary, run it once, cancel the prompt, then remove the binary from Gatekeeper quarantine with `xattr -d com.apple.quarantine lemminx`. It should now run without being blocked.




**Snippet to enable the language server:**
```lua
require'lspconfig'.lemminx.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lemminx" }
  ```
  - `filetypes` : 
  ```lua
  { "xml", "xsd", "xsl", "xslt", "svg" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## lexical

    https://github.com/lexical-lsp/lexical

    Lexical is a next-generation language server for the Elixir programming language.

    Follow the [Detailed Installation Instructions](https://github.com/lexical-lsp/lexical/blob/main/pages/installation.md)

    **By default, `lexical` doesn't have a `cmd` set.**
    This is because nvim-lspconfig does not make assumptions about your path.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.lexical.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ltex

https://github.com/valentjn/ltex-ls

LTeX Language Server: LSP language server for LanguageTool 🔍✔️ with support for LaTeX 🎓, Markdown 📝, and others

To install, download the latest [release](https://github.com/valentjn/ltex-ls/releases) and ensure `ltex-ls` is on your path.

This server accepts configuration via the `settings` key.

```lua
  settings = {
		ltex = {
			language = "en-GB",
		},
	},
```

To support org files or R sweave, users can define a custom filetype autocommand (or use a plugin which defines these filetypes):

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.org set filetype=org ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ltex.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ltex-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "bib", "gitcommit", "markdown", "org", "plaintex", "rst", "rnoweb", "tex", "pandoc", "quarto", "rmd" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## lua_ls

https://github.com/luals/lua-language-server

Lua language server.

`lua-language-server` can be installed by following the instructions [here](https://luals.github.io/#neovim-install).

The default `cmd` assumes that the `lua-language-server` binary can be found in `$PATH`.

If you primarily use `lua-language-server` for Neovim, and want to provide completions,
analysis, and location handling for plugins on runtime path, you can use the following
settings.

```lua
require'lspconfig'.lua_ls.setup {
  on_init = function(client)
    local path = client.workspace_folders[1].name
    if not vim.loop.fs_stat(path..'/.luarc.json') and not vim.loop.fs_stat(path..'/.luarc.jsonc') then
      client.config.settings = vim.tbl_deep_extend('force', client.config.settings, {
        Lua = {
          runtime = {
            -- Tell the language server which version of Lua you're using
            -- (most likely LuaJIT in the case of Neovim)
            version = 'LuaJIT'
          },
          -- Make the server aware of Neovim runtime files
          workspace = {
            checkThirdParty = false,
            library = {
              vim.env.VIMRUNTIME
              -- "${3rd}/luv/library"
              -- "${3rd}/busted/library",
            }
            -- or pull in all of 'runtimepath'. NOTE: this is a lot slower
            -- library = vim.api.nvim_get_runtime_file("", true)
          }
        }
      })

      client.notify("workspace/didChangeConfiguration", { settings = client.config.settings })
    end
    return true
  end
}
```

See `lua-language-server`'s [documentation](https://luals.github.io/wiki/settings/) for an explanation of the above fields:
* [Lua.runtime.path](https://luals.github.io/wiki/settings/#runtimepath)
* [Lua.workspace.library](https://luals.github.io/wiki/settings/#workspacelibrary)




**Snippet to enable the language server:**
```lua
require'lspconfig'.lua_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lua-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "lua" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".luarc.json", ".luarc.jsonc", ".luacheckrc", ".stylua.toml", "stylua.toml", "selene.toml", "selene.yml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## luau_lsp



**Snippet to enable the language server:**
```lua
require'lspconfig'.luau_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "luau-lsp", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "luau" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## m68k

https://github.com/grahambates/m68k-lsp

Language server for Motorola 68000 family assembly

`m68k-lsp-server` can be installed via `npm`:

```sh
npm install -g m68k-lsp-server
```

Ensure you are using the 68k asm syntax variant in Neovim.

```lua
vim.g.asmsyntax = 'asm68k'
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.m68k.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "m68k-lsp-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "asm68k" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## marksman

https://github.com/artempyanykh/marksman

Marksman is a Markdown LSP server providing completion, cross-references, diagnostics, and more.

Marksman works on MacOS, Linux, and Windows and is distributed as a self-contained binary for each OS.

Pre-built binaries can be downloaded from https://github.com/artempyanykh/marksman/releases



**Snippet to enable the language server:**
```lua
require'lspconfig'.marksman.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "marksman", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown", "markdown.mdx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", ".marksman.toml")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## matlab_ls

https://github.com/mathworks/MATLAB-language-server

MATLAB® language server implements the Microsoft® Language Server Protocol for the MATLAB language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.matlab_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "matlab-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "matlab" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    MATLAB = {
      indexWorkspace = false,
      installPath = "",
      matlabConnectionTiming = "onStart",
      telemetry = true
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  false
  ```


## mdx_analyzer

https://github.com/mdx-js/mdx-analyzer

`mdx-analyzer`, a language server for MDX



**Snippet to enable the language server:**
```lua
require'lspconfig'.mdx_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mdx-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown.mdx" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## metals

https://scalameta.org/metals/

Scala language server with rich IDE features.

See full instructions in the Metals documentation:

https://scalameta.org/metals/docs/editors/vim#using-an-alternative-lsp-client

Note: that if you're using [nvim-metals](https://github.com/scalameta/nvim-metals), that plugin fully handles the setup and installation of Metals, and you shouldn't set up Metals both with it and `lspconfig`.

To install Metals, make sure to have [coursier](https://get-coursier.io/docs/cli-installation) installed, and once you do you can install the latest Metals with `cs install metals`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.metals.setup{}
```


**Default values:**
  - `capabilities` : 
  ```lua
  {
    workspace = {
      configuration = false
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "metals" }
  ```
  - `filetypes` : 
  ```lua
  { "scala" }
  ```
  - `init_options` : 
  ```lua
  {
    compilerOptions = {
      snippetAutoIndent = false
    },
    isHttpEnabled = true,
    statusBarProvider = "show-message"
  }
  ```
  - `message_level` : 
  ```lua
  4
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("build.sbt", "build.sc", "build.gradle", "pom.xml")
  ```


## millet

https://github.com/azdavis/millet

Millet, a language server for Standard ML

To use with nvim:

1. Install a Rust toolchain: https://rustup.rs
2. Clone the repo
3. Run `cargo build --release --bin lang-srv`
4. Move `target/release/lang-srv` to somewhere on your $PATH as `millet`
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.millet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "millet" }
  ```
  - `filetypes` : 
  ```lua
  { "sml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mint

https://www.mint-lang.com

Install Mint using the [instructions](https://www.mint-lang.com/install).
The language server is included since version 0.12.0.



**Snippet to enable the language server:**
```lua
require'lspconfig'.mint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mint", "ls" }
  ```
  - `filetypes` : 
  ```lua
  { "mint" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mlir_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#mlir-lsp-language-server--mlir-lsp-server=

The Language Server for the LLVM MLIR language

`mlir-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.mlir_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mlir-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "mlir" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mlir_pdll_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#pdll-lsp-language-server--mlir-pdll-lsp-server

The Language Server for the LLVM PDLL language

`mlir-pdll-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.mlir_pdll_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mlir-pdll-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "pdll" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## mm0_ls

https://github.com/digama0/mm0

Language Server for the metamath-zero theorem prover.

Requires [mm0-rs](https://github.com/digama0/mm0/tree/master/mm0-rs) to be installed
and available on the `PATH`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.mm0_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mm0-rs", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "metamath-zero" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mojo

https://github.com/modularml/mojo

`mojo-lsp-server` can be installed [via Modular](https://developer.modular.com/download)

Mojo is a new programming language that bridges the gap between research and production by combining Python syntax and ecosystem with systems programming and metaprogramming features.



**Snippet to enable the language server:**
```lua
require'lspconfig'.mojo.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mojo-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "mojo" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## move_analyzer

https://github.com/move-language/move/tree/main/language/move-analyzer

Language server for Move

The `move-analyzer` can be installed by running:

```
cargo install --git https://github.com/move-language/move move-analyzer
```

See [`move-analyzer`'s doc](https://github.com/move-language/move/blob/1b258a06e3c7d2bc9174578aac92cca3ac19de71/language/move-analyzer/editors/code/README.md#how-to-install) for details.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.move_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "move-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "move" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Move.toml")
  ```


## mutt_ls

https://github.com/neomutt/mutt-language-server

A language server for (neo)mutt's muttrc. It can be installed via pip.

```sh
pip install mutt-language-server
```
  


**Snippet to enable the language server:**
```lua
require'lspconfig'.mutt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mutt-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "muttrc", "neomuttrc" }
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nelua_lsp

https://github.com/codehz/nelua-lsp

nelua-lsp is an experimental nelua language server.

You need [nelua.vim](https://github.com/stefanos82/nelua.vim/blob/main/ftdetect/nelua.vim) for nelua files to be recognized or add this to your config:

in vimscript:
```vimscript
au BufNewFile,BufRead *.nelua setf nelua
```

in lua:
```lua
vim.api.nvim_create_autocmd({ "BufNewFile", "BufRead" }, { pattern = { "*.nelua" }, command = "setf nelua"})
```

**By default, nelua-lsp doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
require'lspconfig'.nelua_lsp.setup {
    cmd = { "nelua", "-L", "/path/to/nelua-lsp/", "--script", "/path/to/nelua-lsp/nelua-lsp.lua" },
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.nelua_lsp.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "nelua" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## neocmake

https://github.com/Decodetalkers/neocmakelsp

CMake LSP Implementation



**Snippet to enable the language server:**
```lua
require'lspconfig'.neocmake.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "neocmakelsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cmake" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git', 'cmake')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nginx_language_server

https://pypi.org/project/nginx-language-server/

`nginx-language-server` can be installed via pip:

```sh
pip install -U nginx-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nginx_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nginx-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "nginx" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nickel_ls

Nickel Language Server

https://github.com/tweag/nickel

`nls` can be installed with nix, or cargo, from the Nickel repository.
```sh
git clone https://github.com/tweag/nickel.git
```

Nix:
```sh
cd nickel
nix-env -f . -i
```

cargo:
```sh
cd nickel/lsp/nls
cargo install --path .
```

In order to have lspconfig detect Nickel filetypes (a prerequisite for autostarting a server),
install the [Nickel vim plugin](https://github.com/nickel-lang/vim-nickel).
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.nickel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nls" }
  ```
  - `filetypes` : 
  ```lua
  { "ncl", "nickel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## nil_ls

https://github.com/oxalica/nil

A new language server for Nix Expression Language.

If you are using Nix with Flakes support, run `nix profile install github:oxalica/nil` to install.
Check the repository README for more information.

_See an example config at https://github.com/oxalica/nil/blob/main/dev/nvim-lsp.nix._
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nil_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nil" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("flake.nix", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nim_langserver

https://github.com/nim-lang/langserver


`nim-langserver` can be installed via the `nimble` package manager:
```sh
nimble install nimlangserver
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nim_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nimlangserver" }
  ```
  - `filetypes` : 
  ```lua
  { "nim" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nimls

https://github.com/PMunch/nimlsp

`nimlsp` can be installed via the `nimble` package manager:

```sh
nimble install nimlsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nimlsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nim" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nixd

https://github.com/nix-community/nixd

Nix language server, based on nix libraries.

If you are using Nix with Flakes support, run `nix profile install github:nix-community/nixd` to install.
Check the repository README for more information.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nixd.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nixd" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".nixd.json", "flake.nix",".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nomad_lsp

https://github.com/juliosueiras/nomad-lsp

Written in Go, compilation is needed for `nomad_lsp` to be used. Please see the [original repository](https://github.com/juliosuieras/nomad-lsp).

Add the executable to your system or vim PATH and it will be set to go.

No configuration option is needed unless you choose not to add `nomad-lsp` executable to the PATH. You should know what you are doing if you choose so.

```lua
require('lspconfig').nomad_lsp.setup{ }
```

However, a `hcl.nomad` or `nomad` filetype should be defined.

Description of your jobs should be written in `.nomad` files for the LSP client to configure the server's `root_dir` configuration option.



**Snippet to enable the language server:**
```lua
require'lspconfig'.nomad_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nomad-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "hcl.nomad", "nomad" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("hcl.nomad", "nomad")
  ```


## ntt

https://github.com/nokia/ntt
Installation instructions can be found [here](https://github.com/nokia/ntt#Install).
Can be configured by passing a "settings" object to `ntt.setup{}`:
```lua
require('lspconfig').ntt.setup{
    settings = {
      ntt = {
      }
    }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ntt.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ntt", "langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "ttcn" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```


## nushell

https://github.com/nushell/nushell

Nushell built-in language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.nushell.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nu", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nu" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nxls

https://github.com/nrwl/nx-console/tree/master/apps/nxls

nxls, a language server for Nx Workspaces

`nxls` can be installed via `npm`:
```sh
npm i -g nxls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.nxls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nxls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "json", "jsonc" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern
  ```


## ocamlls

https://github.com/ocaml-lsp/ocaml-language-server

`ocaml-language-server` can be installed via `npm`
```sh
npm install -g ocaml-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "reason" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json")
  ```


## ocamllsp

https://github.com/ocaml/ocaml-lsp

`ocaml-lsp` can be installed as described in [installation guide](https://github.com/ocaml/ocaml-lsp#installation).

To install the lsp server in a particular opam switch:
```sh
opam install ocaml-lsp-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamllsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocamllsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "ocaml.menhir", "ocaml.interface", "ocaml.ocamllex", "reason", "dune" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json", ".git", "dune-project", "dune-workspace")
  ```


## ols

           https://github.com/DanielGavin/ols

           `Odin Language Server`.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.ols.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ols" }
  ```
  - `filetypes` : 
  ```lua
  { "odin" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("ols.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## omnisharp

https://github.com/omnisharp/omnisharp-roslyn
OmniSharp server based on Roslyn workspaces

`omnisharp-roslyn` can be installed by downloading and extracting a release from [here](https://github.com/OmniSharp/omnisharp-roslyn/releases).
OmniSharp can also be built from source by following the instructions [here](https://github.com/omnisharp/omnisharp-roslyn#downloading-omnisharp).

OmniSharp requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

**By default, omnisharp-roslyn doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

For `go_to_definition` to work fully, extended `textDocument/definition` handler is needed, for example see [omnisharp-extended-lsp.nvim](https://github.com/Hoffs/omnisharp-extended-lsp.nvim)

```lua
require'lspconfig'.omnisharp.setup {
    cmd = { "dotnet", "/path/to/omnisharp/OmniSharp.dll" },

    -- Enables support for reading code style, naming convention and analyzer
    -- settings from .editorconfig.
    enable_editorconfig_support = true,

    -- If true, MSBuild project system will only load projects for files that
    -- were opened in the editor. This setting is useful for big C# codebases
    -- and allows for faster initialization of code navigation features only
    -- for projects that are relevant to code that is being edited. With this
    -- setting enabled OmniSharp may load fewer projects and may thus display
    -- incomplete reference lists for symbols.
    enable_ms_build_load_projects_on_demand = false,

    -- Enables support for roslyn analyzers, code fixes and rulesets.
    enable_roslyn_analyzers = false,

    -- Specifies whether 'using' directives should be grouped and sorted during
    -- document formatting.
    organize_imports_on_format = false,

    -- Enables support for showing unimported types and unimported extension
    -- methods in completion lists. When committed, the appropriate using
    -- directive will be added at the top of the current file. This option can
    -- have a negative impact on initial completion responsiveness,
    -- particularly for the first few completion sessions after opening a
    -- solution.
    enable_import_completion = false,

    -- Specifies whether to include preview versions of the .NET SDK when
    -- determining which version to use for project loading.
    sdk_include_prereleases = true,

    -- Only run analyzers against open files when 'enableRoslynAnalyzers' is
    -- true
    analyze_open_documents_only = false,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.omnisharp.setup{}
```


**Default values:**
  - `analyze_open_documents_only` : 
  ```lua
  false
  ```
  - `enable_editorconfig_support` : 
  ```lua
  true
  ```
  - `enable_import_completion` : 
  ```lua
  false
  ```
  - `enable_ms_build_load_projects_on_demand` : 
  ```lua
  false
  ```
  - `enable_roslyn_analyzers` : 
  ```lua
  false
  ```
  - `filetypes` : 
  ```lua
  { "cs", "vb" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `organize_imports_on_format` : 
  ```lua
  false
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.sln", "*.csproj", "omnisharp.json", "function.json")
  ```
  - `sdk_include_prereleases` : 
  ```lua
  true
  ```


## opencl_ls

https://github.com/Galarius/opencl-language-server

Build instructions can be found [here](https://github.com/Galarius/opencl-language-server/blob/main/_dev/build.md).

Prebuilt binaries are available for Linux, macOS and Windows [here](https://github.com/Galarius/opencl-language-server/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.opencl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "opencl-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "opencl" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```


## openedge_ls

[Language server](https://github.com/vscode-abl/vscode-abl) for Progress OpenEdge ABL.

For manual installation, download abl-lsp.jar from the [VSCode
extension](https://github.com/vscode-abl/vscode-abl/releases/latest).

Configuration

```lua
require('lspconfig').['openedge_ls'].setup {
  oe_jar_path = '/path/to/abl-lsp.jar',
  dlc = '12.2:/path/to/dlc-12.2', -- Version number and OpenEdge root directory (colon separator)
  debug = false, -- Set to true for debug logging
  trace = false -- Set to true for trace logging (REALLY verbose)
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.openedge_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "progress" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('openedge-project.json')
  ```


## openscad_ls

https://github.com/dzhu/openscad-language-server

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-language-server` binary with `cargo`:
```sh
cargo install openscad-language-server
```

Vim does not have built-in syntax for the `openscad` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.scad set filetype=openscad ]]
```

or by installing a filetype plugin such as https://github.com/sirtaj/vim-openscad



**Snippet to enable the language server:**
```lua
require'lspconfig'.openscad_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "openscad-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "openscad" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## openscad_lsp

https://github.com/Leathong/openscad-LSP

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-lsp` binary with `cargo`:
```sh
cargo install openscad-lsp
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.openscad_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "openscad-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "openscad" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pact_ls

https://github.com/kadena-io/pact-lsp

The Pact language server
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.pact_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pact-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "pact" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pasls

https://github.com/genericptr/pascal-language-server

An LSP server implementation for Pascal variants that are supported by Free Pascal, including Object Pascal. It uses CodeTools from Lazarus as backend.

First set `cmd` to the Pascal lsp binary.

Customization options are passed to pasls as environment variables for example in your `.bashrc`:
```bash
export FPCDIR='/usr/lib/fpc/src'      # FPC source directory (This is the only required option for the server to work).
export PP='/usr/lib/fpc/3.2.2/ppcx64' # Path to the Free Pascal compiler executable.
export LAZARUSDIR='/usr/lib/lazarus'  # Path to the Lazarus sources.
export FPCTARGET=''                   # Target operating system for cross compiling.
export FPCTARGETCPU='x86_64'          # Target CPU for cross compiling.
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.pasls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pasls" }
  ```
  - `filetypes` : 
  ```lua
  { "pascal" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlls

https://github.com/richterger/Perl-LanguageServer/tree/master/clients/vscode/perl

`Perl-LanguageServer`, a language server for Perl.

To use the language server, ensure that you have Perl::LanguageServer installed and perl command is on your path.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "perl", "-MPerl::LanguageServer", "-e", "Perl::LanguageServer::run", "--", "--port 13603", "--nostdio 0" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      fileFilter = { ".pm", ".pl" },
      ignoreDirs = ".git",
      perlCmd = "perl",
      perlInc = " "
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlnavigator

https://github.com/bscan/PerlNavigator

A Perl language server

**By default, perlnavigator doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

Clone the PerlNavigator repo, install based on the [instructions](https://github.com/bscan/PerlNavigator#installation-for-other-editors),
and point `cmd` to `server.js` inside the `server/out` directory:

```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}
```

At minimum, you will need `perl` in your path. If you want to use a non-standard `perl` you will need to set your configuration like so:
```lua
settings = {
  perlnavigator = {
    perlPath = '/some/odd/location/my-perl'
  }
}
```

The `contributes.configuration.properties` section of `perlnavigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `perlnavigator` at your `perltidy` and `perlcritic` configurations.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlnavigator.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlpls

https://github.com/FractalBoy/perl-language-server
https://metacpan.org/pod/PLS

`PLS`, another language server for Perl.

To use the language server, ensure that you have PLS installed and that it is in your path



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlpls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pls" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      perlcritic = {
        enabled = false
      },
      syntax = {
        enabled = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pest_ls

https://github.com/pest-parser/pest-ide-tools

Language server for pest grammars.



**Snippet to enable the language server:**
```lua
require'lspconfig'.pest_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pest-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "pest" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## phan

https://github.com/phan/phan

Installation: https://github.com/phan/phan#getting-started



**Snippet to enable the language server:**
```lua
require'lspconfig'.phan.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "phan", "-m", "json", "--no-color", "--no-progress-bar", "-x", "-u", "-S", "--language-server-on-stdin", "--allow-polyfill-parser" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## phpactor

https://github.com/phpactor/phpactor

Installation: https://phpactor.readthedocs.io/en/master/usage/standalone.html#global-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.phpactor.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "phpactor", "language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## pkgbuild_language_server

https://github.com/Freed-Wu/pkgbuild-language-server

Language server for ArchLinux/Windows Msys2's PKGBUILD.



**Snippet to enable the language server:**
```lua
require'lspconfig'.pkgbuild_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pkgbuild-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "PKGBUILD" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## please

https://github.com/thought-machine/please

High-performance extensible build system for reproducible multi-language builds.

The `plz` binary will automatically install the LSP for you on first run



**Snippet to enable the language server:**
```lua
require'lspconfig'.please.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "plz", "tool", "lps" }
  ```
  - `filetypes` : 
  ```lua
  { "bzl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## postgres_lsp

https://github.com/supabase/postgres_lsp

A Language Server for Postgres
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.postgres_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "postgres_lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "sql" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern 'root-file.txt'
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## powershell_es

https://github.com/PowerShell/PowerShellEditorServices

Language server for PowerShell.

To install, download and extract PowerShellEditorServices.zip
from the [releases](https://github.com/PowerShell/PowerShellEditorServices/releases).
To configure the language server, set the property `bundle_path` to the root
of the extracted PowerShellEditorServices.zip.

The default configuration doesn't set `cmd` unless `bundle_path` is specified.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
}
```

By default the languageserver is started in `pwsh` (PowerShell Core). This can be changed by specifying `shell`.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
  shell = 'powershell.exe',
}
```

Note that the execution policy needs to be set to `Unrestricted` for the languageserver run under PowerShell

If necessary, specific `cmd` can be defined instead of `bundle_path`.
See [PowerShellEditorServices](https://github.com/PowerShell/PowerShellEditorServices#stdio)
to learn more.

```lua
require'lspconfig'.powershell_es.setup{
  cmd = {'pwsh', '-NoLogo', '-NoProfile', '-Command', "c:/PSES/Start-EditorServices.ps1 ..."}
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.powershell_es.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "ps1" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  git root or current directory
  ```
  - `shell` : 
  ```lua
  "pwsh"
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## prismals

Language Server for the Prisma JavaScript and TypeScript ORM

`@prisma/language-server` can be installed via npm
```sh
npm install -g @prisma/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.prismals.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prisma-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "prisma" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```
  - `settings` : 
  ```lua
  {
    prisma = {
      prismaFmtBinPath = ""
    }
  }
  ```


## prolog_ls

  https://github.com/jamesnvc/lsp_server

  Language Server Protocol server for SWI-Prolog
  


**Snippet to enable the language server:**
```lua
require'lspconfig'.prolog_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "swipl", "-g", "use_module(library(lsp_server)).", "-g", "lsp_server:main", "-t", "halt", "--", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "prolog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## prosemd_lsp

https://github.com/kitten/prosemd-lsp

An experimental LSP for Markdown.

Please see the manual installation instructions: https://github.com/kitten/prosemd-lsp#manual-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.prosemd_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prosemd-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  <function 1>
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## psalm

https://github.com/vimeo/psalm

Can be installed with composer.
```sh
composer global require vimeo/psalm
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.psalm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "psalm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("psalm.xml", "psalm.xml.dist")
  ```


## puppet

LSP server for Puppet.

Installation:

- Clone the editor-services repository:
    https://github.com/puppetlabs/puppet-editor-services

- Navigate into that directory and run: `bundle install`

- Install the 'puppet-lint' gem: `gem install puppet-lint`

- Add that repository to $PATH.

- Ensure you can run `puppet-languageserver` from outside the editor-services directory.



**Snippet to enable the language server:**
```lua
require'lspconfig'.puppet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "puppet-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "puppet" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("manifests", ".puppet-lint.rc", "hiera.yaml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## purescriptls

https://github.com/nwolverson/purescript-language-server

The `purescript-language-server` can be added to your project and `$PATH` via

* JavaScript package manager such as npm, pnpm, Yarn, et al.
* Nix under the `nodePackages` and `nodePackages_latest` package sets



**Snippet to enable the language server:**
```lua
require'lspconfig'.purescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "purescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "purescript" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('spago.dhall', 'psc-package.json', 'bower.json', 'flake.nix', 'shell.nix'),
  ```


## pylsp

https://github.com/python-lsp/python-lsp-server

A Python 3.6+ implementation of the Language Server Protocol.

See the [project's README](https://github.com/python-lsp/python-lsp-server) for installation instructions.

Configuration options are documented [here](https://github.com/python-lsp/python-lsp-server/blob/develop/CONFIGURATION.md).
In order to configure an option, it must be translated to a nested Lua table and included in the `settings` argument to the `setup{}` function.
For example, in order to set the `pylsp.plugins.pycodestyle.ignore` option:
```lua
require'lspconfig'.pylsp.setup{
  settings = {
    pylsp = {
      plugins = {
        pycodestyle = {
          ignore = {'W391'},
          maxLineLength = 100
        }
      }
    }
  }
}
```

Note: This is a community fork of `pyls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.pylsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pylsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pylyzer

  https://github.com/mtshiba/pylyzer

  `pylyzer`, a fast static code analyzer & language server for Python.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.pylyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pylyzer", "--server" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    python = {
      checkOnType = false,
      diagnostics = true,
      inlayHints = true,
      smartCompletion = true
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pyre

https://pyre-check.org/

`pyre` a static type checker for Python 3.

`pyre` offers an extremely limited featureset. It currently only supports diagnostics,
which are triggered on save.

Do not report issues for missing features in `pyre` to `lspconfig`.




**Snippet to enable the language server:**
```lua
require'lspconfig'.pyre.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pyre", "persistent" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## pyright

https://github.com/microsoft/pyright

`pyright`, a static type checker and language server for python



**Snippet to enable the language server:**
```lua
require'lspconfig'.pyright.setup{}
```
**Commands:**
- PyrightOrganizeImports: Organize Imports
- PyrightSetPythonPath: Reconfigure pyright with the provided python path

**Default values:**
  - `cmd` : 
  ```lua
  { "pyright-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    python = {
      analysis = {
        autoSearchPaths = true,
        diagnosticMode = "openFilesOnly",
        useLibraryCodeForTypes = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## qml_lsp

https://invent.kde.org/sdk/qml-lsp

LSP implementation for QML (autocompletion, live linting, etc. in editors)
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.qml_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "qml-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "qmljs" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## qmlls

https://github.com/qt/qtdeclarative

LSP implementation for QML (autocompletion, live linting, etc. in editors),
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.qmlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "qmlls" }
  ```
  - `filetypes` : 
  ```lua
  { "qml", "qmljs" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## quick_lint_js

https://quick-lint-js.com/

quick-lint-js finds bugs in JavaScript programs.

See installation [instructions](https://quick-lint-js.com/install/)



**Snippet to enable the language server:**
```lua
require'lspconfig'.quick_lint_js.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "quick-lint-js", "--lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## r_language_server

[languageserver](https://github.com/REditorSupport/languageserver) is an
implementation of the Microsoft's Language Server Protocol for the R
language.

It is released on CRAN and can be easily installed by

```R
install.packages("languageserver")
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.r_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "R", "--slave", "-e", "languageserver::run()" }
  ```
  - `filetypes` : 
  ```lua
  { "r", "rmd" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git") or os_homedir
  ```


## racket_langserver

[https://github.com/jeapostrophe/racket-langserver](https://github.com/jeapostrophe/racket-langserver)

The Racket language server. This project seeks to use
[DrRacket](https://github.com/racket/drracket)'s public API to provide
functionality that mimics DrRacket's code tools as closely as possible.

Install via `raco`: `raco pkg install racket-langserver`



**Snippet to enable the language server:**
```lua
require'lspconfig'.racket_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "racket", "--lib", "racket-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "racket", "scheme" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## raku_navigator

https://github.com/bscan/RakuNavigator
A Raku language server
**By default, raku_navigator doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.
Clone the RakuNavigator repo, install based on the [instructions](https://github.com/bscan/raku_Navigator#installation-for-other-editors),
and point `cmd` to `server.js` inside the `server/out` directory:
```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}
```
At minimum, you will need `raku` in your path. If you want to use a non-standard `raku` you will need to set your configuration like so:
```lua
settings = {
  raku_navigator = {
    rakuPath = '/some/odd/location/my-raku'
  }
}
```
The `contributes.configuration.properties` section of `raku_navigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `raku_navigator` at your `raku_tidy` and `raku_critic` configurations.



**Snippet to enable the language server:**
```lua
require'lspconfig'.raku_navigator.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "raku" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## reason_ls

Reason language server

You can install reason language server from [reason-language-server](https://github.com/jaredly/reason-language-server) repository.



**Snippet to enable the language server:**
```lua
require'lspconfig'.reason_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "reason-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "reason" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## regols

https://github.com/kitagry/regols

OPA Rego language server.

`regols` can be installed by running:
```sh
go install github.com/kitagry/regols@latest
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.regols.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "regols" }
  ```
  - `filetypes` : 
  ```lua
  { "rego" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.rego", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## relay_lsp

    https://github.com/facebook/relay
    `Relay` is a JavaScript framework for building data-driven React applications

    Setup:

    - Make sure you have a Relay config file somewhere in your project.
    - We support standard config file formats (`.yml`, `.js`, `.json`), and the the `relay` field in your `package.json`
    - Make sure you have the `relay-compiler` installed in your project. The bare minimum is v13.
    - Make sure you are able to run the `relay-compiler` command from the command line. If `yarn relay-compiler` works, it's very likely that the LSP will work.
    - Remove / disable any conflicting GraphQL LSPs you have installed.

    Relay LSP is a part of the Relay Compiler binary and available when adding `relay-compiler` to your project's devDependencies.

    ```lua
    require'lspconfig'.relay_lsp.setup {
      -- (default: false) Whether or not we should automatically start
      -- the Relay Compiler in watch mode when you open a project
      auto_start_compiler = false,


      -- (default: null) Path to a relay config relative to the
      -- `root_dir`. Without this, the compiler will search for your
      -- config. This is helpful if your relay project is in a nested
      -- directory.
      path_to_config = nil,
    }
    ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.relay_lsp.setup{}
```


**Default values:**
  - `auto_start_compiler` : 
  ```lua
  false
  ```
  - `cmd` : 
  ```lua
  { "relay-compiler", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `handlers` : 
  ```lua
  {
    ["window/showStatus"] = <function 1>
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("relay.config.*", "package.json")
  ```


## remark_ls

https://github.com/remarkjs/remark-language-server

`remark-language-server` can be installed via `npm`:
```sh
npm install -g remark-language-server
```

`remark-language-server` uses the same
[configuration files](https://github.com/remarkjs/remark/tree/main/packages/remark-cli#example-config-files-json-yaml-js)
as `remark-cli`.

This uses a plugin based system. Each plugin needs to be installed locally using `npm` or `yarn`.

For example, given the following `.remarkrc.json`:

```json
{
  "presets": [
    "remark-preset-lint-recommended"
  ]
}
```

`remark-preset-lint-recommended` needs to be installed in the local project:

```sh
npm install remark-preset-lint-recommended
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.remark_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "remark-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rescriptls

https://github.com/rescript-lang/rescript-vscode/tree/master/server

ReScript Language Server can be installed via npm:
```sh
npm install -g @rescript/language-server
```

See the init_options supported (see https://github.com/rescript-lang/rescript-vscode/tree/master/server/config.md):



**Snippet to enable the language server:**
```lua
require'lspconfig'.rescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "rescript" }
  ```
  - `init_options` : 
  ```lua
  {
    extensionConfiguration = {
      askToStartBuild = false
    }
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## rls

https://github.com/rust-lang/rls

rls, a language server for Rust

See https://github.com/rust-lang/rls#setup to setup rls itself.
See https://github.com/rust-lang/rls#configuration for rls-specific settings.
All settings listed on the rls configuration section of the readme
must be set under settings.rust as follows:

```lua
nvim_lsp.rls.setup {
  settings = {
    rust = {
      unstable_features = true,
      build_on_save = false,
      all_features = true,
    },
  },
}
```

If you want to use rls for a particular build, eg nightly, set cmd as follows:

```lua
cmd = {"rustup", "run", "nightly", "rls"}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rls" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml")
  ```


## rnix

https://github.com/nix-community/rnix-lsp

A language server for Nix providing basic completion and formatting via nixpkgs-fmt.

To install manually, run `cargo install rnix-lsp`. If you are using nix, rnix-lsp is in nixpkgs.

This server accepts configuration via the `settings` key.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rnix.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rnix-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {}
  ```


## robotframework_ls

https://github.com/robocorp/robotframework-lsp

Language Server Protocol implementation for Robot Framework.



**Snippet to enable the language server:**
```lua
require'lspconfig'.robotframework_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "robotframework_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "robot" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('robotidy.toml', 'pyproject.toml', 'conda.yaml', 'robot.yaml')(fname)
    or util.find_git_ancestor(fname)
  ```


## rome

https://rome.tools

Language server for the Rome Frontend Toolchain.

(Unmaintained, use [Biome](https://biomejs.dev/blog/annoucing-biome) instead.)

```sh
npm install [-g] rome
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.rome.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rome", "lsp-proxy" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "json", "typescript", "typescript.tsx", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('package.json', 'node_modules', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rubocop

https://github.com/rubocop/rubocop
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rubocop.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rubocop", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## ruby_ls

https://shopify.github.io/ruby-lsp/

This gem is an implementation of the language server protocol specification for
Ruby, used to improve editor features.

Install the gem. There's no need to require it, since the server is used as a
standalone executable.

```sh
group :development do
  gem "ruby-lsp", require: false
end
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ruby_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ruby-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `init_options` : 
  ```lua
  {
    formatter = "auto"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ruff_lsp

https://github.com/astral-sh/ruff-lsp

A Language Server Protocol implementation for Ruff, an extremely fast Python linter and code transformation tool, written in Rust. It can be installed via pip.

```sh
pip install ruff-lsp
```

Extra CLI arguments for `ruff` can be provided via

```lua
require'lspconfig'.ruff_lsp.setup{
  init_options = {
    settings = {
      -- Any extra CLI arguments for `ruff` go here.
      args = {},
    }
  }
}
```

  


**Snippet to enable the language server:**
```lua
require'lspconfig'.ruff_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ruff-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rune_languageserver

https://crates.io/crates/rune-languageserver

A language server for the [Rune](https://rune-rs.github.io/) Language,
an embeddable dynamic programming language for Rust
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.rune_languageserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rune-languageserver" }
  ```
  - `filetypes` : 
  ```lua
  { "rune" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rust_analyzer

https://github.com/rust-lang/rust-analyzer

rust-analyzer (aka rls 2.0), a language server for Rust


See [docs](https://github.com/rust-lang/rust-analyzer/blob/master/docs/user/generated_config.adoc) for extra settings. The settings can be used like this:
```lua
require'lspconfig'.rust_analyzer.setup{
  settings = {
    ['rust-analyzer'] = {
      diagnostics = {
        enable = false;
      }
    }
  }
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rust_analyzer.setup{}
```
**Commands:**
- CargoReload: Reload current cargo workspace

**Default values:**
  - `capabilities` : 
  ```lua
  {
    experimental = {
      serverStatusNotification = true
    },
    general = {
      positionEncodings = { "utf-16" }
    },
    textDocument = {
      callHierarchy = {
        dynamicRegistration = false
      },
      codeAction = {
        codeActionLiteralSupport = {
          codeActionKind = {
            valueSet = { "", "quickfix", "refactor", "refactor.extract", "refactor.inline", "refactor.rewrite", "source", "source.organizeImports" }
          }
        },
        dataSupport = true,
        dynamicRegistration = true,
        isPreferredSupport = true,
        resolveSupport = {
          properties = { "edit" }
        }
      },
      completion = {
        completionItem = {
          commitCharactersSupport = false,
          deprecatedSupport = false,
          documentationFormat = { "markdown", "plaintext" },
          preselectSupport = false,
          snippetSupport = false
        },
        completionItemKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 }
        },
        contextSupport = false,
        dynamicRegistration = false
      },
      declaration = {
        linkSupport = true
      },
      definition = {
        dynamicRegistration = true,
        linkSupport = true
      },
      diagnostic = {
        dynamicRegistration = false
      },
      documentHighlight = {
        dynamicRegistration = false
      },
      documentSymbol = {
        dynamicRegistration = false,
        hierarchicalDocumentSymbolSupport = true,
        symbolKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 }
        }
      },
      formatting = {
        dynamicRegistration = true
      },
      hover = {
        contentFormat = { "markdown", "plaintext" },
        dynamicRegistration = true
      },
      implementation = {
        linkSupport = true
      },
      inlayHint = {
        dynamicRegistration = true,
        resolveSupport = {
          properties = { "textEdits", "tooltip", "location", "command" }
        }
      },
      publishDiagnostics = {
        dataSupport = true,
        relatedInformation = true,
        tagSupport = {
          valueSet = { 1, 2 }
        }
      },
      rangeFormatting = {
        dynamicRegistration = true
      },
      references = {
        dynamicRegistration = false
      },
      rename = {
        dynamicRegistration = true,
        prepareSupport = true
      },
      semanticTokens = {
        augmentsSyntaxTokens = true,
        dynamicRegistration = false,
        formats = { "relative" },
        multilineTokenSupport = false,
        overlappingTokenSupport = true,
        requests = {
          full = {
            delta = true
          },
          range = false
        },
        serverCancelSupport = false,
        tokenModifiers = { "declaration", "definition", "readonly", "static", "deprecated", "abstract", "async", "modification", "documentation", "defaultLibrary" },
        tokenTypes = { "namespace", "type", "class", "enum", "interface", "struct", "typeParameter", "parameter", "variable", "property", "enumMember", "event", "function", "method", "macro", "keyword", "modifier", "comment", "string", "number", "regexp", "operator", "decorator" }
      },
      signatureHelp = {
        dynamicRegistration = false,
        signatureInformation = {
          activeParameterSupport = true,
          documentationFormat = { "markdown", "plaintext" },
          parameterInformation = {
            labelOffsetSupport = true
          }
        }
      },
      synchronization = {
        didSave = true,
        dynamicRegistration = false,
        willSave = true,
        willSaveWaitUntil = true
      },
      typeDefinition = {
        linkSupport = true
      }
    },
    window = {
      showDocument = {
        support = true
      },
      showMessage = {
        messageActionItem = {
          additionalPropertiesSupport = false
        }
      },
      workDoneProgress = true
    },
    workspace = {
      applyEdit = true,
      configuration = true,
      didChangeConfiguration = {
        dynamicRegistration = false
      },
      didChangeWatchedFiles = {
        dynamicRegistration = true,
        relativePatternSupport = true
      },
      inlayHint = {
        refreshSupport = true
      },
      semanticTokens = {
        refreshSupport = true
      },
      symbol = {
        dynamicRegistration = false,
        symbolKind = {
          valueSet = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 }
        }
      },
      workspaceEdit = {
        resourceOperations = { "rename", "create", "delete" }
      },
      workspaceFolders = true
    }
  }
  ```
  - `cmd` : 
  ```lua
  { "rust-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml", "rust-project.json")
  ```


## salt_ls

Language server for Salt configuration files.
https://github.com/dcermak/salt-lsp

The language server can be installed with `pip`:
```sh
pip install salt-lsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.salt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "salt_lsp_server" }
  ```
  - `filetypes` : 
  ```lua
  { "sls" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## scheme_langserver

https://github.com/ufo5260987423/scheme-langserver
`scheme-langserver`, a language server protocol implementation for scheme.
And for nvim user, please add .sls to scheme file extension list.



**Snippet to enable the language server:**
```lua
require'lspconfig'.scheme_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "scheme-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "scheme" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## scry

https://github.com/crystal-lang-tools/scry

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.scry.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "scry" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## serve_d

           https://github.com/Pure-D/serve-d

           `Microsoft language server protocol implementation for D using workspace-d.`
           Download a binary from https://github.com/Pure-D/serve-d/releases and put it in your $PATH.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.serve_d.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "serve-d" }
  ```
  - `filetypes` : 
  ```lua
  { "d" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("dub.json", "dub.sdl", ".git")
  ```


## sixtyfps

https://github.com/sixtyfpsui/sixtyfps
`SixtyFPS`'s language server

You can build and install `sixtyfps-lsp` binary with `cargo`:
```sh
cargo install sixtyfps-lsp
```

Vim does not have built-in syntax for the `sixtyfps` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.60 set filetype=sixtyfps ]]
```

or by installing a filetype plugin such as https://github.com/RustemB/sixtyfps-vim



**Snippet to enable the language server:**
```lua
require'lspconfig'.sixtyfps.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sixtyfps-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "sixtyfps" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## slangd

https://github.com/shader-slang/slang

The `slangd` binary can be downloaded as part of [slang releases](https://github.com/shader-slang/slang/releases) or
by [building `slang` from source](https://github.com/shader-slang/slang/blob/master/docs/building.md).

The server can be configured by passing a "settings" object to `slangd.setup{}`:

```lua
require('lspconfig').slangd.setup{
  settings = {
    slang = {
      predefinedMacros = {"MY_VALUE_MACRO=1"},
      inlayHints = {
        deducedTypes = true,
        parameterNames = true,
      }
    }
  }
}
```
Available options are documented [here](https://github.com/shader-slang/slang-vscode-extension/tree/main?tab=readme-ov-file#configurations)
or in more detail [here](https://github.com/shader-slang/slang-vscode-extension/blob/main/package.json#L70).



**Snippet to enable the language server:**
```lua
require'lspconfig'.slangd.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "slangd" }
  ```
  - `filetypes` : 
  ```lua
  { "hlsl", "shaderslang" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## slint_lsp

https://github.com/slint-ui/slint
`Slint`'s language server

You can build and install `slint-lsp` binary with `cargo`:
```sh
cargo install slint-lsp
```

Vim does not have built-in syntax for the `slint` filetype at this time.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.slint set filetype=slint ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.slint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "slint-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "slint" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## smarty_ls

https://github.com/landeaux/vscode-smarty-langserver-extracted

Language server for Smarty.

`smarty-language-server` can be installed via `npm`:

```sh
npm i -g vscode-smarty-langserver-extracted
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.smarty_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "smarty-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "smarty" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    css = {
      validate = true
    },
    smarty = {
      pluginDirs = {}
    }
  }
  ```


## smithy_ls

https://github.com/awslabs/smithy-language-server

`Smithy Language Server`, A Language Server Protocol implementation for the Smithy IDL



**Snippet to enable the language server:**
```lua
require'lspconfig'.smithy_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "smithy-language-server", "0" }
  ```
  - `filetypes` : 
  ```lua
  { "smithy" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("smithy-build.json", "build.gradle", "build.gradle.kts", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## solang

A language server for Solidity

See the [documentation](https://solang.readthedocs.io/en/latest/installing.html) for installation instructions.

The language server only provides the following capabilities:
* Syntax highlighting
* Diagnostics
* Hover

There is currently no support for completion, goto definition, references, or other functionality.




**Snippet to enable the language server:**
```lua
require'lspconfig'.solang.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solang", "language-server", "--target", "evm" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## solargraph

https://solargraph.org/

solargraph, a language server for Ruby

You can install solargraph via gem install.

```sh
gem install --user-install solargraph
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.solargraph.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solargraph", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `init_options` : 
  ```lua
  {
    formatting = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```
  - `settings` : 
  ```lua
  {
    solargraph = {
      diagnostics = true
    }
  }
  ```


## solc

https://docs.soliditylang.org/en/latest/installing-solidity.html

solc is the native language server for the Solidity language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solc.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('hardhat.config.*', '.git')
  ```


## solidity

https://github.com/qiuxiang/solidity-ls

npm i solidity-ls -g

Make sure that solc is installed and it's the same version of the file.  solc-select is recommended.

Solidity language server is a LSP with autocomplete, go to definition and diagnostics.

If you use brownie, use this root_dir:
root_dir = util.root_pattern('brownie-config.yaml', '.git')

on includePath, you can add an extra path to search for external libs, on remapping you can remap lib <> path, like:

```lua
{ solidity = { includePath = '/Users/your_user/.brownie/packages/', remapping = { ["@OpenZeppelin/"] = 'OpenZeppelin/openzeppelin-contracts@4.6.0/' } } }
```

**For brownie users**
Change the root_dir to:

```lua
root_pattern("brownie-config.yaml", ".git")
```

The best way of using it is to have a package.json in your project folder with the packages that you will use.
After installing with package.json, just create a `remappings.txt` with:

```
@OpenZeppelin/=node_modules/OpenZeppelin/openzeppelin-contracts@4.6.0/
```

You can omit the node_modules as well.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solidity-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git")
  ```
  - `settings` : 
  ```lua
  {
    solidity = {
      includePath = "",
      remapping = {}
    }
  }
  ```


## solidity_ls

npm install -g solidity-language-server

solidity-language-server is a language server for the solidity language ported from the vscode solidity extension



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solidity-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```


## solidity_ls_nomicfoundation

https://github.com/NomicFoundation/hardhat-vscode/blob/development/server/README.md

`nomicfoundation-solidity-language-server` can be installed via `npm`:

```sh
npm install -g @nomicfoundation/solidity-language-server
```

A language server for the Solidity programming language, built by the Nomic Foundation for the Ethereum community.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity_ls_nomicfoundation.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nomicfoundation-solidity-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("hardhat.config.js", "hardhat.config.ts", "foundry.toml", "remappings.txt", "truffle.js", "truffle-config.js", "ape-config.yaml", ".git", "package.json")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## sorbet

https://sorbet.org

Sorbet is a fast, powerful type checker designed for Ruby.

You can install Sorbet via gem install. You might also be interested in how to set
Sorbet up for new projects: https://sorbet.org/docs/adopting.

```sh
gem install sorbet
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sorbet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "srb", "tc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## sourcekit

https://github.com/apple/sourcekit-lsp

Language server for Swift and C/C++/Objective-C.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcekit.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcekit-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "swift", "c", "cpp", "objective-c", "objective-cpp" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Package.swift", ".git")
  ```


## sourcery

https://github.com/sourcery-ai/sourcery

Refactor Python instantly using the power of AI.

It requires the init_options param to be populated as shown below and will respond with the list of ServerCapabilities that it supports:

```lua
require'lspconfig'.sourcery.setup {
    init_options = {
        --- The Sourcery token for authenticating the user.
        --- This is retrieved from the Sourcery website and must be
        --- provided by each user. The extension must provide a
        --- configuration option for the user to provide this value.
        token = <YOUR_TOKEN>,

        --- The extension's name and version as defined by the extension.
        extension_version = 'vim.lsp',

        --- The editor's name and version as defined by the editor.
        editor_version = 'vim',
    },
}
```

Alternatively, you can login to sourcery by running `sourcery login` with sourcery-cli.



**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcery.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcery", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "python", "typescript", "typescriptreact" }
  ```
  - `init_options` : 
  ```lua
  {
    editor_version = "vim",
    extension_version = "vim.lsp"
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## spectral

https://github.com/luizcorreia/spectral-language-server
 `A flexible JSON/YAML linter for creating automated style guides, with baked in support for OpenAPI v2 & v3.`

`spectral-language-server` can be installed via `npm`:
```sh
npm i -g spectral-language-server
```
See [vscode-spectral](https://github.com/stoplightio/vscode-spectral#extension-settings) for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.spectral.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "spectral-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "json", "yml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    enable = true,
    run = "onType",
    validateLanguages = { "yaml", "json", "yml" }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## spyglassmc_language_server

https://github.com/SpyglassMC/Spyglass/tree/main/packages/language-serve

Language server for Minecraft datapacks.

`spyglassmc-language-server` can be installed via `npm`:

```sh
npm i -g @spyglassmc/language-server
```

You may also need to configure the filetype:

`autocmd BufNewFile,BufRead *.mcfunction set filetype=mcfunction`

This is automatically done by [CrystalAlpha358/vim-mcfunction](https://github.com/CrystalAlpha358/vim-mcfunction), which also provide syntax highlight.



**Snippet to enable the language server:**
```lua
require'lspconfig'.spyglassmc_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "spyglassmc-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "mcfunction" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## sqlls

https://github.com/joe-re/sql-language-server

This LSP can be installed via  `npm`. Find further instructions on manual installation of the sql-language-server at [joe-re/sql-language-server](https://github.com/joe-re/sql-language-server).
<br>
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sql-language-server", "up", "--method", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## sqls

https://github.com/lighttiger2505/sqls

```lua
require'lspconfig'.sqls.setup{
  cmd = {"path/to/command", "-config", "path/to/config.yml"};
  ...
}
```
Sqls can be installed via `go get github.com/lighttiger2505/sqls`. Instructions for compiling Sqls from the source can be found at [lighttiger2505/sqls](https://github.com/lighttiger2505/sqls).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sqls" }
  ```
  - `deprecate` : 
  ```lua
  {
    to = "sqlls",
    version = "0.2.0"
  }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## standardrb

https://github.com/testdouble/standard

Ruby Style Guide, with linter & automatic code fixer.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.standardrb.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "standardrb", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## starlark_rust

https://github.com/facebookexperimental/starlark-rust/
The LSP part of `starlark-rust` is not currently documented,
 but the implementation works well for linting.
This gives valuable warnings for potential issues in the code,
but does not support refactorings.

It can be installed with cargo: https://crates.io/crates/starlark



**Snippet to enable the language server:**
```lua
require'lspconfig'.starlark_rust.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "starlark", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "star", "bzl", "BUILD.bazel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## statix

https://github.com/nerdypepper/statix

lints and suggestions for the nix programming language
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.statix.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "statix" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("flake.nix", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## steep

https://github.com/soutaro/steep

`steep` is a static type checker for Ruby.

You need `Steepfile` to make it work. Generate it with `steep init`.



**Snippet to enable the language server:**
```lua
require'lspconfig'.steep.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "steep", "langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Steepfile", ".git")
  ```


## stimulus_ls

https://www.npmjs.com/package/stimulus-language-server

`stimulus-lsp` can be installed via `npm`:

```sh
npm install -g stimulus-language-server
```

or via `yarn`:

```sh
yarn global add stimulus-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.stimulus_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stimulus-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "ruby", "eruby", "blade", "php" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## stylelint_lsp

https://github.com/bmatcuk/stylelint-lsp

`stylelint-lsp` can be installed via `npm`:

```sh
npm i -g stylelint-lsp
```

Can be configured by passing a `settings.stylelintplus` object to `stylelint_lsp.setup`:

```lua
require'lspconfig'.stylelint_lsp.setup{
  settings = {
    stylelintplus = {
      -- see available options in stylelint-lsp documentation
    }
  }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.stylelint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stylelint-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "less", "scss", "sugarss", "vue", "wxss", "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## svelte

https://github.com/sveltejs/language-tools/tree/master/packages/language-server

Note: assuming that [tsserver](#tsserver) is setup, full JavaScript/TypeScript support (find references, rename, etc of symbols in Svelte files when working in JS/TS files) requires per-project installation and configuration of [typescript-svelte-plugin](https://github.com/sveltejs/language-tools/tree/master/packages/typescript-plugin#usage).

`svelte-language-server` can be installed via `npm`:
```sh
npm install -g svelte-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.svelte.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svelteserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "svelte" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git")
  ```


## svlangserver

https://github.com/imc-trading/svlangserver

Language server for SystemVerilog.

`svlangserver` can be installed via `npm`:

```sh
$ npm install -g @imc-trading/svlangserver
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.svlangserver.setup{}
```
**Commands:**
- SvlangserverBuildIndex: Instructs language server to rerun indexing
- SvlangserverReportHierarchy: Generates hierarchy for the given module

**Default values:**
  - `cmd` : 
  ```lua
  { "svlangserver" }
  ```
  - `filetypes` : 
  ```lua
  { "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".svlangserver", ".git")
  ```
  - `settings` : 
  ```lua
  {
    systemverilog = {
      includeIndexing = { "*.{v,vh,sv,svh}", "**/*.{v,vh,sv,svh}" }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## svls

https://github.com/dalance/svls

Language server for verilog and SystemVerilog

`svls` can be installed via `cargo`:
 ```sh
 cargo install svls
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.svls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svls" }
  ```
  - `filetypes` : 
  ```lua
  { "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## swift_mesonls

https://github.com/JCWasmx86/Swift-MesonLSP

Meson language server written in Swift



**Snippet to enable the language server:**
```lua
require'lspconfig'.swift_mesonls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "Swift-MesonLSP", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "meson" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("meson_options.txt", ".git")
  ```


## syntax_tree

https://ruby-syntax-tree.github.io/syntax_tree/

A fast Ruby parser and formatter.

Syntax Tree is a suite of tools built on top of the internal CRuby parser. It
provides the ability to generate a syntax tree from source, as well as the
tools necessary to inspect and manipulate that syntax tree. It can be used to
build formatters, linters, language servers, and more.

```sh
gem install syntax_tree
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.syntax_tree.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stree", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".streerc", "Gemfile", ".git")
  ```


## tailwindcss

https://github.com/tailwindlabs/tailwindcss-intellisense

Tailwind CSS Language Server can be installed via npm:
```sh
npm install -g @tailwindcss/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tailwindcss.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tailwindcss-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "aspnetcorerazor", "astro", "astro-markdown", "blade", "clojure", "django-html", "htmldjango", "edge", "eelixir", "elixir", "ejs", "erb", "eruby", "gohtml", "gohtmltmpl", "haml", "handlebars", "hbs", "html", "html-eex", "heex", "jade", "leaf", "liquid", "markdown", "mdx", "mustache", "njk", "nunjucks", "php", "razor", "slim", "twig", "css", "less", "postcss", "sass", "scss", "stylus", "sugarss", "javascript", "javascriptreact", "reason", "rescript", "typescript", "typescriptreact", "vue", "svelte" }
  ```
  - `init_options` : 
  ```lua
  {
    userLanguages = {
      eelixir = "html-eex",
      eruby = "erb"
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('tailwind.config.js', 'tailwind.config.cjs', 'tailwind.config.mjs', 'tailwind.config.ts', 'postcss.config.js', 'postcss.config.cjs', 'postcss.config.mjs', 'postcss.config.ts', 'package.json', 'node_modules', '.git')
  ```
  - `settings` : 
  ```lua
  {
    tailwindCSS = {
      classAttributes = { "class", "className", "class:list", "classList", "ngClass" },
      lint = {
        cssConflict = "warning",
        invalidApply = "error",
        invalidConfigPath = "error",
        invalidScreen = "error",
        invalidTailwindDirective = "error",
        invalidVariant = "error",
        recommendedVariantOrder = "warning"
      },
      validate = true
    }
  }
  ```


## taplo

https://taplo.tamasfe.dev/cli/usage/language-server.html

Language server for Taplo, a TOML toolkit.

`taplo-cli` can be installed via `cargo`:
```sh
cargo install --features lsp --locked taplo-cli
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.taplo.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "taplo", "lsp", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "toml" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tblgen_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#tablegen-lsp-language-server--tblgen-lsp-server

The Language Server for the LLVM TableGen language

`tblgen-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)



**Snippet to enable the language server:**
```lua
require'lspconfig'.tblgen_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tblgen-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "tablegen" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## teal_ls

https://github.com/teal-language/teal-language-server

Install with:
```
luarocks install --dev teal-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.teal_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "teal-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "teal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tlconfig.lua", ".git")
  ```


## templ

https://templ.guide

The official language server for the templ HTML templating language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.templ.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "templ", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "templ" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('go.work', 'go.mod', '.git')
  ```


## terraform_lsp

https://github.com/juliosueiras/terraform-lsp

Terraform language server
Download a released binary from
https://github.com/juliosueiras/terraform-lsp/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraform_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform", "hcl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## terraformls

https://github.com/hashicorp/terraform-ls

Terraform language server
Download a released binary from https://github.com/hashicorp/terraform-ls/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraformls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-ls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform", "terraform-vars" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## texlab

https://github.com/latex-lsp/texlab

A completion engine built from scratch for (La)TeX.

See https://github.com/latex-lsp/texlab/wiki/Configuration for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.texlab.setup{}
```
**Commands:**
- TexlabBuild: Build the current buffer
- TexlabForward: Forward search from current position

**Default values:**
  - `cmd` : 
  ```lua
  { "texlab" }
  ```
  - `filetypes` : 
  ```lua
  { "tex", "plaintex", "bib" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    texlab = {
      auxDirectory = ".",
      bibtexFormatter = "texlab",
      build = {
        args = { "-pdf", "-interaction=nonstopmode", "-synctex=1", "%f" },
        executable = "latexmk",
        forwardSearchAfter = false,
        onSave = false
      },
      chktex = {
        onEdit = false,
        onOpenAndSave = false
      },
      diagnosticsDelay = 300,
      formatterLineLength = 80,
      forwardSearch = {
        args = {}
      },
      latexFormatter = "latexindent",
      latexindent = {
        modifyLineBreaks = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## textlsp

https://github.com/hangyav/textLSP

`textLSP` is an LSP server for text spell and grammar checking with various AI tools.
It supports multiple text file formats, such as LaTeX, Org or txt.

For the available text analyzer tools and their configuration, see the [GitHub](https://github.com/hangyav/textLSP) page.
By default, all analyzers are disabled in textLSP, since most of them need special settings.
For quick testing, LanguageTool is enabled in the default `nvim-lspconfig` configuration.

To install run: `pip install textLSP`



**Snippet to enable the language server:**
```lua
require'lspconfig'.textlsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "textlsp" }
  ```
  - `filetypes` : 
  ```lua
  { "text", "tex", "org" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    textLSP = {
      analysers = {
        languagetool = {
          check_text = {
            on_change = false,
            on_open = true,
            on_save = true
          },
          enabled = true
        }
      },
      documents = {
        org = {
          org_todo_keywords = { "TODO", "IN_PROGRESS", "DONE" }
        }
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tflint

https://github.com/terraform-linters/tflint

A pluggable Terraform linter that can act as lsp server.
Installation instructions can be found in https://github.com/terraform-linters/tflint#installation.



**Snippet to enable the language server:**
```lua
require'lspconfig'.tflint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tflint", "--langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git", ".tflint.hcl")
  ```


## theme_check

https://github.com/Shopify/shopify-cli

`theme-check-language-server` is bundled with `shopify-cli` or it can also be installed via

https://github.com/Shopify/theme-check#installation

**NOTE:**
If installed via Homebrew, `cmd` must be set to 'theme-check-liquid-server'

```lua
require lspconfig.theme_check.setup {
  cmd = { 'theme-check-liquid-server' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.theme_check.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "theme-check-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "liquid" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## thriftls

https://github.com/joyme123/thrift-ls

you can install thriftls by mason or download binary here: https://github.com/joyme123/thrift-ls/releases



**Snippet to enable the language server:**
```lua
require'lspconfig'.thriftls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "thriftls" }
  ```
  - `filetypes` : 
  ```lua
  { "thrift" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".thrift")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tilt_ls

https://github.com/tilt-dev/tilt

Tilt language server.

You might need to add filetype detection manually:

```vim
autocmd BufRead Tiltfile setf=tiltfile
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tilt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tilt", "lsp", "start" }
  ```
  - `filetypes` : 
  ```lua
  { "tiltfile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tsserver

https://github.com/typescript-language-server/typescript-language-server

`typescript-language-server` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript typescript-language-server
```

To configure typescript language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.

Here's an example that disables type checking in JavaScript files.

```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tsserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `init_options` : 
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tsconfig.json", "package.json", "jsconfig.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ttags

https://github.com/npezza93/ttags
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ttags.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ttags", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "rust", "javascript", "haskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## turtle_ls

https://github.com/stardog-union/stardog-language-servers/tree/master/packages/turtle-language-server
`turtle-language-server`, An editor-agnostic server providing language intelligence (diagnostics, hover tooltips, etc.) for the W3C standard Turtle RDF syntax via the Language Server Protocol.
installable via npm install -g turtle-language-server or yarn global add turtle-language-server.
requires node.



**Snippet to enable the language server:**
```lua
require'lspconfig'.turtle_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "node",
    [3] = "--stdio"
  }
  ```
  - `filetypes` : 
  ```lua
  { "turtle", "ttl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## typeprof

https://github.com/ruby/typeprof

`typeprof` is the built-in analysis and LSP tool for Ruby 3.1+.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.typeprof.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typeprof", "--lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## typos_lsp

https://github.com/crate-ci/typos
https://github.com/tekumara/typos-vscode

A Language Server Protocol implementation for Typos, a low false-positive
source code spell checker, written in Rust. Download it from the releases page
on GitHub: https://github.com/tekumara/typos-vscode/releases
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.typos_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typos-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "*" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## typst_lsp

https://github.com/nvarner/typst-lsp

Language server for Typst.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.typst_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typst-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "typst" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## uiua

https://github.com/uiua-lang/uiua/

The builtin language server of the Uiua interpreter.

The Uiua interpreter can be installed with `cargo install uiua`



**Snippet to enable the language server:**
```lua
require'lspconfig'.uiua.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "uiua", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "uiua" }
  ```
  - `root_dir` : 
  ```lua
          root_pattern(
            'main.ua',
            'fmt.ua',
            '.git'
          )
        
  ```


## unison

https://github.com/unisonweb/unison/blob/trunk/docs/language-server.markdown


    


**Snippet to enable the language server:**
```lua
require'lspconfig'.unison.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nc", "localhost", "5757" }
  ```
  - `filetypes` : 
  ```lua
  { "unison" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## unocss

https://github.com/xna00/unocss-language-server

UnoCSS Language Server can be installed via npm:
```sh
npm i unocss-language-server -g
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.unocss.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "unocss-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "javascriptreact", "rescript", "typescriptreact", "vue", "svelte" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('unocss.config.js', 'unocss.config.ts', 'uno.config.js', 'uno.config.ts')
  ```


## uvls

https://codeberg.org/caradhras/uvls
Language server for UVL, written using tree sitter and rust.
You can install the server easily using cargo:
```sh
git clone https://codeberg.org/caradhras/uvls
cd  uvls
cargo install --path .
```
Note: To activate properly nvim needs to know the uvl filetype.
You can add it via:
```lua
vim.cmd(\[\[au BufRead,BufNewFile *.uvl setfiletype uvl\]\])
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.uvls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "uvls" }
  ```
  - `filetypes` : 
  ```lua
  { "uvl" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## v_analyzer

https://github.com/v-analyzer/v-analyzer

V language server.

`v-analyzer` can be installed by following the instructions [here](https://github.com/v-analyzer/v-analyzer#installation).



**Snippet to enable the language server:**
```lua
require'lspconfig'.v_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "v-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "v", "vsh", "vv" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("v.mod", ".git")
  ```


## vala_ls

https://github.com/Prince781/vala-language-server


**Snippet to enable the language server:**
```lua
require'lspconfig'.vala_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vala-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "vala", "genie" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("meson.build", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## vale_ls

https://github.com/errata-ai/vale-ls

An implementation of the Language Server Protocol (LSP) for the Vale command-line tool.



**Snippet to enable the language server:**
```lua
require'lspconfig'.vale_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vale-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown", "text" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vdmj

https://github.com/nickbattle/vdmj

The VDMJ language server can be installed by cloning the VDMJ repository and
running `mvn clean install`.

Various options are provided to configure the language server (see below). In
particular:
- `annotation_paths` is a list of folders and/or jar file paths for annotations
that should be used with the language server;
- any value of `debugger_port` less than zero will disable the debugger; note
that if a non-zero value is used, only one instance of the server can be active
at a time.

More settings for VDMJ can be changed in a file called `vdmj.properties` under
`root_dir/.vscode`. For a description of the available settings, see
[Section 7 of the VDMJ User Guide](https://raw.githubusercontent.com/nickbattle/vdmj/master/vdmj/documentation/UserGuide.pdf).

Note: proof obligations and combinatorial testing are not currently supported
by neovim.



**Snippet to enable the language server:**
```lua
require'lspconfig'.vdmj.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  Generated from the options given
  ```
  - `filetypes` : 
  ```lua
  { "vdmsl", "vdmpp", "vdmrt" }
  ```
  - `options` : 
  ```lua
  {
    annotation_paths = {},
    debugger_port = -1,
    high_precision = false,
    java = "$JAVA_HOME/bin/java",
    java_opts = { "-Xmx3000m", "-Xss1m" },
    logfile = "path.join(vim.fn.stdpath 'cache', 'vdm-lsp.log')",
    mavenrepo = "$HOME/.m2/repository/dk/au/ece/vdmj",
    version = "The latest version installed in `mavenrepo`"
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor(fname) or find_vscode_ancestor(fname)
  ```


## verible

https://github.com/chipsalliance/verible

A linter and formatter for verilog and SystemVerilog files.

Release binaries can be downloaded from [here](https://github.com/chipsalliance/verible/releases)
and placed in a directory on PATH.

See https://github.com/chipsalliance/verible/tree/master/verilog/tools/ls/README.md for options.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.verible.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "verible-verilog-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "systemverilog", "verilog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## veridian

https://github.com/vivekmalneedi/veridian

A SystemVerilog LanguageServer.

Download the latest release for your OS from the releases page

# install with slang feature, if C++17 compiler is available
cargo install --git https://github.com/vivekmalneedi/veridian.git --all-features
# install if C++17 compiler is not available
cargo install --git https://github.com/vivekmalneedi/veridian.git
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.veridian.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "veridian" }
  ```
  - `filetypes` : 
  ```lua
  { "systemverilog", "verilog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## veryl_ls

https://github.com/dalance/veryl

Language server for Veryl

`veryl-ls` can be installed via `cargo`:
 ```sh
 cargo install veryl-ls
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.veryl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "veryl-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "veryl" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## vhdl_ls

Install vhdl_ls from https://github.com/VHDL-LS/rust_hdl and add it to path

Configuration

The language server needs to know your library mapping to perform full analysis of the code. For this it uses a configuration file in the TOML format named vhdl_ls.toml.

vhdl_ls will load configuration files in the following order of priority (first to last):

    A file named .vhdl_ls.toml in the user home folder.
    A file name from the VHDL_LS_CONFIG environment variable.
    A file named vhdl_ls.toml in the workspace root.

Settings in a later files overwrites those from previously loaded files.

Example vhdl_ls.toml
```
# File names are either absolute or relative to the parent folder of the vhdl_ls.toml file
[libraries]
lib2.files = [
  'pkg2.vhd',
]
lib1.files = [
  'pkg1.vhd',
  'tb_ent.vhd'
]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vhdl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vhdl_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "vhd", "vhdl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## vimls

https://github.com/iamcco/vim-language-server

You can install vim-language-server via npm:
```sh
npm install -g vim-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vim-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vim" }
  ```
  - `init_options` : 
  ```lua
  {
    diagnostic = {
      enable = true
    },
    indexes = {
      count = 3,
      gap = 100,
      projectRootPatterns = { "runtime", "nvim", ".git", "autoload", "plugin" },
      runtimepath = true
    },
    isNeovim = true,
    iskeyword = "@,48-57,_,192-255,-#",
    runtimepath = "",
    suggest = {
      fromRuntimepath = true,
      fromVimruntime = true
    },
    vimruntime = ""
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## visualforce_ls

https://github.com/forcedotcom/salesforcedx-vscode

Language server for Visualforce.

For manual installation, download the .vsix archive file from the
[forcedotcom/salesforcedx-vscode](https://github.com/forcedotcom/salesforcedx-vscode)
GitHub releases. Then, configure `cmd` to run the Node script at the unpacked location:

```lua
require'lspconfig'.visualforce_ls.setup {
  cmd = {
    'node',
    '/path/to/unpacked/archive/extension/node_modules/@salesforce/salesforcedx-visualforce-language-server/out/src/visualforceServer.js',
    '--stdio'
  }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.visualforce_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "visualforce" }
  ```
  - `init_options` : 
  ```lua
  {
    embeddedLanguages = {
      css = true,
      javascript = true
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('sfdx-project.json')
  ```


## vls

https://github.com/vlang/vls

V language server.

`v-language-server` can be installed by following the instructions [here](https://github.com/vlang/vls#installation).



**Snippet to enable the language server:**
```lua
require'lspconfig'.vls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "v", "ls" }
  ```
  - `filetypes` : 
  ```lua
  { "v", "vlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("v.mod", ".git")
  ```


## volar

https://github.com/johnsoncodehk/volar/tree/20d713b/packages/vue-language-server

Volar language server for Vue

Volar can be installed via npm:

```sh
npm install -g @vue/language-server
```

Volar by default supports Vue 3 projects. Vue 2 projects need
[additional configuration](https://github.com/vuejs/language-tools/tree/master/packages/vscode-vue#usage).

**Take Over Mode**

Volar can serve as a language server for both Vue and TypeScript via [Take Over Mode](https://github.com/johnsoncodehk/volar/discussions/471).

To enable Take Over Mode, override the default filetypes in `setup{}` as follows:

```lua
require'lspconfig'.volar.setup{
  filetypes = {'typescript', 'javascript', 'javascriptreact', 'typescriptreact', 'vue', 'json'}
}
```

**Overriding the default TypeScript Server used by Volar**

The default config looks for TS in the local `node_modules`. This can lead to issues
e.g. when working on a [monorepo](https://monorepo.tools/). The alternatives are:

- use a global TypeScript Server installation

```lua
require'lspconfig'.volar.setup{
  init_options = {
    typescript = {
      tsdk = '/path/to/.npm/lib/node_modules/typescript/lib'
      -- Alternative location if installed as root:
      -- tsdk = '/usr/local/lib/node_modules/typescript/lib'
    }
  }
}
```

- use a local server and fall back to a global TypeScript Server installation

```lua
local util = require 'lspconfig.util'
local function get_typescript_server_path(root_dir)

  local global_ts = '/home/[yourusernamehere]/.npm/lib/node_modules/typescript/lib'
  -- Alternative location if installed as root:
  -- local global_ts = '/usr/local/lib/node_modules/typescript/lib'
  local found_ts = ''
  local function check_dir(path)
    found_ts =  util.path.join(path, 'node_modules', 'typescript', 'lib')
    if util.path.exists(found_ts) then
      return path
    end
  end
  if util.search_ancestors(root_dir, check_dir) then
    return found_ts
  else
    return global_ts
  end
end

require'lspconfig'.volar.setup{
  on_new_config = function(new_config, new_root_dir)
    new_config.init_options.typescript.tsdk = get_typescript_server_path(new_root_dir)
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.volar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vue-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    typescript = {
      tsdk = ""
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vtsls

https://github.com/yioneko/vtsls

`vtsls` can be installed with npm:
```sh
npm install -g @vtsls/language-server
```

To configure a TypeScript project, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html)
or [`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to
the root of your project.



**Snippet to enable the language server:**
```lua
require'lspconfig'.vtsls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vtsls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tsconfig.json", "package.json", "jsconfig.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## vuels

https://github.com/vuejs/vetur/tree/master/server

Vue language server(vls)
`vue-language-server` can be installed via `npm`:
```sh
npm install -g vls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vuels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vls" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    config = {
      css = {},
      emmet = {},
      html = {
        suggest = {}
      },
      javascript = {
        format = {}
      },
      stylusSupremacy = {},
      typescript = {
        format = {}
      },
      vetur = {
        completion = {
          autoImport = false,
          tagCasing = "kebab",
          useScaffoldSnippets = false
        },
        format = {
          defaultFormatter = {
            js = "none",
            ts = "none"
          },
          defaultFormatterOptions = {},
          scriptInitialIndent = false,
          styleInitialIndent = false
        },
        useWorkspaceDependencies = false,
        validation = {
          script = true,
          style = true,
          template = true
        }
      }
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "vue.config.js")
  ```


## wgsl_analyzer

https://github.com/wgsl-analyzer/wgsl-analyzer

`wgsl_analyzer` can be installed via `cargo`:
```sh
cargo install --git https://github.com/wgsl-analyzer/wgsl-analyzer wgsl_analyzer
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.wgsl_analyzer.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "wgsl_analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "wgsl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git"
  ```
  - `settings` : 
  ```lua
  {}
  ```


## yamlls

https://github.com/redhat-developer/yaml-language-server

`yaml-language-server` can be installed via `yarn`:
```sh
yarn global add yaml-language-server
```

To use a schema for validation, there are two options:

1. Add a modeline to the file. A modeline is a comment of the form:

```
# yaml-language-server: $schema=<urlToTheSchema|relativeFilePath|absoluteFilePath}>
```

where the relative filepath is the path relative to the open yaml file, and the absolute filepath
is the filepath relative to the filesystem root ('/' on unix systems)

2. Associated a schema url, relative , or absolute (to root of project, not to filesystem root) path to
the a glob pattern relative to the detected project root. Check `:LspInfo` to determine the resolved project
root.

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://json.schemastore.org/github-workflow.json"] = "/.github/workflows/*",
        ["../path/relative/to/file.yml"] = "/.github/workflows/*",
        ["/path/from/root/of/project"] = "/.github/workflows/*",
      },
    },
  }
}
```

Currently, kubernetes is special-cased in yammls, see the following upstream issues:
* [#211](https://github.com/redhat-developer/yaml-language-server/issues/211).
* [#307](https://github.com/redhat-developer/yaml-language-server/issues/307).

To override a schema to use a specific k8s schema version (for example, to use 1.18):

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://raw.githubusercontent.com/instrumenta/kubernetes-json-schema/master/v1.18.0-standalone-strict/all.json"] = "/*.k8s.yaml",
        ... -- other schemas
      },
    },
  }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.yamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "yaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "yaml.docker-compose" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    redhat = {
      telemetry = {
        enabled = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## yang_lsp

https://github.com/TypeFox/yang-lsp

A Language Server for the YANG data modeling language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.yang_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "yang-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "yang" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## yls

https://pypi.org/project/yls-yara/

An YLS plugin adding YARA linting capabilities.

This plugin runs yara.compile on every save, parses the errors, and returns list of diagnostic messages.

Language Server: https://github.com/avast/yls



**Snippet to enable the language server:**
```lua
require'lspconfig'.yls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "yls", "-vv" }
  ```
  - `filetypes` : 
  ```lua
  { "yar", "yara" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## zk

https://github.com/mickael-menu/zk

A plain text note-taking assistant



**Snippet to enable the language server:**
```lua
require'lspconfig'.zk.setup{}
```
**Commands:**
- ZkIndex: ZkIndex
- ZkNew: ZkNew

**Default values:**
  - `cmd` : 
  ```lua
  { "zk", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".zk")
  ```


## zls

https://github.com/zigtools/zls

Zig LSP implementation + Zig Language Server
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.zls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "zls" }
  ```
  - `filetypes` : 
  ```lua
  { "zig", "zir" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("zls.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```



vim:ft=markdown
