/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.IconAware;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererLabel
extends JLabel
implements PainterAware,
IconAware {
    protected Painter painter;

    public JRendererLabel() {
        this.setOpaque(true);
    }

    public void setPainter(Painter painter) {
        Painter old = this.getPainter();
        this.painter = painter;
        this.firePropertyChange("painter", old, this.getPainter());
    }

    public Painter getPainter() {
        return this.painter;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.painter != null || this.isNimbus()) {
            if (this.isOpaque()) {
                this.paintComponentWithPainter((Graphics2D)g2);
            } else {
                this.paintPainter(g2);
                super.paintComponent(g2);
            }
        } else {
            super.paintComponent(g2);
        }
    }

    private boolean isNimbus() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPainter(Graphics g2) {
        if (this.painter == null) {
            return;
        }
        Graphics2D scratch = (Graphics2D)g2.create();
        try {
            this.painter.paint(scratch, this, this.getWidth(), this.getHeight());
        }
        finally {
            scratch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentWithPainter(Graphics2D g2) {
        if (this.ui != null) {
            Graphics2D scratchGraphics = (Graphics2D)g2.create();
            try {
                scratchGraphics.setColor(this.getBackground());
                scratchGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(g2);
                this.ui.paint(scratchGraphics, this);
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

