/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.OptimisedWhenGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.DisjointUnions;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201H\u0002J\u0015\u00102\u001a\u00020$2\u0006\u0010,\u001a\u00020*H\u0000\u00a2\u0006\u0002\b3J\u0018\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u000208J \u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002J \u0010<\u001a\u00020$2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002J \u0010=\u001a\u00020$2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010>\u001a\u00020$2\u0006\u0010)\u001a\u00020?H\u0002J\u001d\u0010@\u001a\u00020$2\u0006\u0010,\u001a\u00020*2\u0006\u0010A\u001a\u00020.H\u0000\u00a2\u0006\u0002\bBJ\u0018\u0010C\u001a\u00020D2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020.H\u0002J \u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020.2\u0006\u0010A\u001a\u00020.2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010G\u001a\u00020D2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020$2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010M\u001a\u00020D2\u0006\u00100\u001a\u0002012\u0006\u0010N\u001a\u00020OH\u0002J\u0018\u0010P\u001a\u00020D2\u0006\u00100\u001a\u0002012\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010Q\u001a\u00020$2\u0006\u0010\f\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020$2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020$2\u0006\u0010,\u001a\u00020WH\u0016J\u0014\u0010X\u001a\u00020$2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030YH\u0016J\u0010\u0010Z\u001a\u00020$2\u0006\u0010,\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020$2\u0006\u0010,\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020$2\u0006\u0010T\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020$2\u0006\u0010,\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020$2\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020$2\u0006\u0010f\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020$2\u0006\u0010,\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020$2\u0006\u0010,\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020$2\u0006\u0010,\u001a\u00020mH\u0016J\u0010\u0010n\u001a\u00020$2\u0006\u0010,\u001a\u00020iH\u0016J\u0010\u0010o\u001a\u00020$2\u0006\u0010,\u001a\u00020pH\u0016J\u0010\u0010q\u001a\u00020$2\u0006\u0010,\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020$2\u0006\u0010,\u001a\u00020tH\u0016J\u0010\u0010u\u001a\u00020$2\u0006\u0010v\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020$2\u0006\u0010,\u001a\u00020yH\u0016J\u0010\u0010z\u001a\u00020$2\u0006\u0010,\u001a\u00020IH\u0016J\u0010\u0010{\u001a\u00020$2\u0006\u0010|\u001a\u00020}H\u0016J\u0010\u0010~\u001a\u00020$2\u0006\u0010,\u001a\u00020\u007fH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020$2\u0007\u0010c\u001a\u00030\u0081\u0001H\u0016J\u000b\u0010\u0082\u0001\u001a\u00020$*\u00020\rJ\r\u0010\u0083\u0001\u001a\u00020'*\u00020gH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "functionContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "hierarchyDisjointUnions", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "getFunctionContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "unitInstanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getUnitInstanceField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "unitInstanceField$delegate", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "generateAnyParameters", "", "klassSymbol", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "generateAsStatement", "statement", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateBox", "expression", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateExpression", "generateExpression$backend_wasm", "generateInstanceFieldAccess", "field", "generateObjectCreationPrefixIfNeeded", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "generateRefCast", "fromType", "toType", "generateRefNullCast", "generateRefTest", "generateStatement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "generateWithExpectedType", "expectedType", "generateWithExpectedType$backend_wasm", "isDownCastAlwaysSuccessInRuntime", "", "recoverToExpectedType", "actualType", "tryGenerateConstVarargArray", "irVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "wasmArrayType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GcType;", "tryGenerateVarargArray", "tryToGenerateIntrinsicCall", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "tryToGenerateWasmOpIntrinsicCall", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunctionReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "buildGetUnit", "getSourceLocation", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nBodyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,988:1\n1747#2,3:989\n1549#2:992\n1620#2,3:993\n1549#2:996\n1620#2,3:997\n1549#2:1000\n1620#2,3:1001\n1549#2:1004\n1620#2,3:1005\n1549#2:1008\n1620#2,3:1009\n1549#2:1012\n1620#2,3:1013\n1855#2,2:1016\n1864#2,3:1041\n350#2,7:1046\n350#2,7:1057\n1855#2,2:1081\n1864#2,3:1085\n179#3,2:1018\n1#4:1020\n222#5,2:1021\n222#5,2:1023\n222#5,2:1025\n222#5,2:1027\n222#5,2:1029\n222#5,2:1031\n222#5,2:1033\n222#5,2:1035\n226#5,2:1037\n226#5,2:1039\n222#5,2:1044\n226#5,2:1053\n226#5,2:1055\n52#5,3:1064\n51#5,6:1067\n55#5,2:1073\n51#5,6:1075\n226#5,2:1083\n222#5,2:1088\n59#5,4:1090\n51#5,4:1094\n51#5,6:1098\n55#5,2:1104\n63#5,2:1106\n59#5,4:1108\n51#5,6:1112\n63#5,2:1118\n*S KotlinDebug\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n*L\n87#1:989,3\n89#1:992\n89#1:993,3\n92#1:996\n92#1:997,3\n93#1:1000\n93#1:1001,3\n94#1:1004\n94#1:1005,3\n95#1:1008\n95#1:1009,3\n96#1:1012\n96#1:1013,3\n111#1:1016,2\n341#1:1041,3\n427#1:1046,7\n455#1:1057,7\n655#1:1081,2\n681#1:1085,3\n125#1:1018,2\n201#1:1021,2\n224#1:1023,2\n241#1:1025,2\n245#1:1027,2\n263#1:1029,2\n269#1:1031,2\n296#1:1033,2\n306#1:1035,2\n316#1:1037,2\n334#1:1039,2\n372#1:1044,2\n433#1:1053,2\n447#1:1055,2\n544#1:1064,3\n545#1:1067,6\n544#1:1073,2\n609#1:1075,6\n674#1:1083,2\n822#1:1088,2\n884#1:1090,4\n885#1:1094,4\n886#1:1098,6\n885#1:1104,2\n884#1:1106,2\n908#1:1108,4\n909#1:1112,6\n908#1:1118,2\n*E\n"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmFunctionCodegenContext functionContext;
    @NotNull
    private final DisjointUnions<IrClassSymbol> hierarchyDisjointUnions;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;
    @NotNull
    private final Lazy unitInstanceField$delegate;

    public BodyGenerator(@NotNull WasmModuleCodegenContext context2, @NotNull WasmFunctionCodegenContext functionContext, @NotNull DisjointUnions<IrClassSymbol> hierarchyDisjointUnions) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(functionContext, "functionContext");
        Intrinsics.checkNotNullParameter(hierarchyDisjointUnions, "hierarchyDisjointUnions");
        this.context = context2;
        this.functionContext = functionContext;
        this.hierarchyDisjointUnions = hierarchyDisjointUnions;
        this.body = this.functionContext.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ BodyGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(BodyGenerator.access$getBackendContext$p(this.this$0));
            }
        });
        this.unitInstanceField$delegate = LazyKt.lazy((Function0)new Function0<IrField>(this){
            final /* synthetic */ BodyGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrField invoke() {
                return MiscKt.findUnitInstanceField(BodyGenerator.access$getBackendContext$p(this.this$0));
            }
        });
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmFunctionCodegenContext getFunctionContext() {
        return this.functionContext;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrField getUnitInstanceField() {
        Lazy lazy = this.unitInstanceField$delegate;
        return (IrField)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter($this$buildGetUnit, "<this>");
        $this$buildGetUnit.buildGetGlobal(this.context.referenceGlobalField(this.getUnitInstanceField().getSymbol()), SourceLocation.Companion.NoLocation("GET_UNIT"));
    }

    public final void generateExpression$backend_wasm(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrVisitorsKt.acceptVoid(expression2, this);
        if (IrTypePredicatesKt.isNothing(expression2.getType())) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
        }
    }

    private final void generateAsStatement(IrExpression statement2) {
        this.generateExpression$backend_wasm(statement2);
        if (!Intrinsics.areEqual(statement2.getType(), this.wasmSymbols.getVoidType())) {
            this.body.buildDrop(this.getSourceLocation(statement2));
        }
    }

    private final void generateStatement(IrStatement statement2) {
        IrStatement irStatement = statement2;
        if (irStatement instanceof IrExpression) {
            this.generateAsStatement((IrExpression)statement2);
        } else if (irStatement instanceof IrVariable) {
            IrVisitorsKt.acceptVoid(statement2, this);
        } else {
            throw new IllegalStateException(("Unsupported node type: " + Reflection.getOrCreateKotlinClass(statement2.getClass()).getSimpleName()).toString());
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryGenerateConstVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType2) {
        Pair<List, WasmType> pair;
        Object it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Collection collection;
        Iterator iterator2;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        boolean bl;
        block23: {
            if (irVararg.getElements().isEmpty()) {
                return false;
            }
            IrVarargElement irVarargElement = irVararg.getElements().get(0);
            Object object = irVarargElement instanceof IrConst ? (IrConst)irVarargElement : null;
            if (object == null || (object = ((IrConst)object).getKind()) == null) {
                return false;
            }
            Object kind = object;
            if (Intrinsics.areEqual(kind, IrConstKind.String.INSTANCE) || Intrinsics.areEqual(kind, IrConstKind.Null.INSTANCE)) {
                return false;
            }
            Iterable $this$any$iv = irVararg.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    IrVarargElement it2 = (IrVarargElement)element$iv2;
                    boolean bl2 = false;
                    if (!(!(it2 instanceof IrConst) || !Intrinsics.areEqual(((IrConst)it2).getKind(), kind))) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Iterable $this$map$iv2 = irVararg.getElements();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            iterator2 = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull(it3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            Object t = ((IrConst)it3).getValue();
            Intrinsics.checkNotNull(t);
            collection.add(t);
        }
        List elementConstValues = (List)destination$iv$iv2;
        IrType $i$f$map22 = irVararg.getVarargElementType();
        if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getByteType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            Iterable $i$f$mapTo22 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                Object e = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Byte");
                collection.add(Long.valueOf(((Byte)it).byteValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getBooleanType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Boolean");
                collection.add((Boolean)it != false ? 1L : 0L);
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getIntType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Int");
                collection.add(Long.valueOf(((Integer)it).intValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI32.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getShortType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Short");
                collection.add(Long.valueOf(((Short)it).shortValue()));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI16.INSTANCE);
        } else if (Intrinsics.areEqual($i$f$map22, this.irBuiltIns.getLongType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Long");
                collection.add(Long.valueOf((Long)it));
            }
            pair = TuplesKt.to((List)destination$iv$iv, WasmI64.INSTANCE);
        } else {
            return false;
        }
        Pair<List, WasmI8> resource = pair;
        WasmSymbol<Integer> constantArrayId = this.context.referenceConstantArray(resource);
        SourceLocation location = this.getSourceLocation(irVararg);
        boolean bl9 = false;
        this.body.buildConstI32(0, location);
        this.body.buildConstI32(irVararg.getElements().size(), location);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType2, new WasmImmediate.DataIdx(constantArrayId)};
        this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        return true;
    }

    private final void tryGenerateVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType2) {
        Iterable $this$forEach$iv = irVararg.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrVarargElement it = (IrVarargElement)element$iv;
            boolean bl = false;
            if (!(it instanceof IrExpression)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            this.generateExpression$backend_wasm((IrExpression)it);
        }
        WasmImmediate.ConstI32 length = new WasmImmediate.ConstI32(irVararg.getElements().size());
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType2, length};
        this.body.buildInstr(WasmOp.ARRAY_NEW_FIXED, this.getSourceLocation(irVararg), wasmImmediateArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitVararg(@NotNull IrVararg expression) {
        block5: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            v0 = IrTypesKt.getClass(expression.getType());
            Intrinsics.checkNotNull(v0);
            arrayClass = v0;
            var5_3 = SequencesKt.mapNotNull(IrUtilsKt.getConstructors(arrayClass), visitVararg.wasmArrayType.1.INSTANCE);
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (IrType)element$iv;
                $i$a$-firstOrNull-BodyGenerator$visitVararg$wasmArrayType$2 = false;
                v1 = IrTypesKt.getClass((IrType)it);
                if (!((v1 != null ? AnnotationsKt.getWasmArrayAnnotation(v1) : null) != null)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        var4_11 = v2;
        if (var4_11 == null || (var5_3 = TypeTransformerKt.getRuntimeClass(var4_11, this.irBuiltIns)) == null || (var6_5 = var5_3.getSymbol()) == null) ** GOTO lbl-1000
        var8_7 = var6_5;
        it = this.context;
        p0 = var8_7;
        $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$3 = false;
        var7_6 = it.referenceGcType(p0);
        if (var7_6 != null) {
            p0 = var7_6;
            $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$4 = false;
            v3 = new WasmImmediate.GcType((WasmSymbol<? extends WasmTypeDeclaration>)p0);
        } else lbl-1000:
        // 2 sources

        {
            v3 = wasmArrayType = null;
        }
        if (!(wasmArrayType != null)) {
            var5_3 = "Check failed.";
            throw new IllegalStateException(var5_3.toString());
        }
        location = this.getSourceLocation(expression);
        this.generateAnyParameters(arrayClass.getSymbol(), location);
        if (!this.tryGenerateConstVarargArray(expression, wasmArrayType)) {
            this.tryGenerateVarargArray(expression, wasmArrayType);
        }
        this.body.buildStructNew(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(expression.getType(), this.irBuiltIns).getSymbol()), location);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        if (this.context.getBackendContext().getConfiguration().getBoolean(JSConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.body.buildUnreachable(SourceLocation.Companion.NoLocation("Unreachable is inserted instead of a `throw` instruction"));
            return;
        }
        this.body.buildThrow(this.functionContext.getTagIdx(), this.getSourceLocation(expression2));
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.irBuiltIns);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "expected canonical try/catch";
            throw new AssertionError((Object)string2);
        }
        if (this.context.getBackendContext().getConfiguration().getBoolean(JSConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.generateExpression$backend_wasm(aTry.getTryResult());
            return;
        }
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        this.body.buildTry(null, resultType);
        this.generateExpression$backend_wasm(aTry.getTryResult());
        this.body.buildCatch(this.functionContext.getTagIdx());
        IrVariableSymbol it = CollectionsKt.single(aTry.getCatches()).getCatchParameter().getSymbol();
        boolean bl3 = false;
        this.functionContext.defineLocal(it);
        this.body.buildSetLocal(this.functionContext.referenceLocal(it), this.getSourceLocation((IrElement)it.getOwner()));
        this.generateExpression$backend_wasm(CollectionsKt.single(aTry.getCatches()).getResult());
        this.body.buildEnd();
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression$backend_wasm(expression2.getArgument());
                break;
            }
            case 2: {
                this.generateAsStatement(expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string2 = "Other types of casts must be lowered";
                throw new AssertionError((Object)string2);
            }
        }
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        DeclarationGeneratorKt.generateConstExpression(expression2, this.body, this.context, this.getSourceLocation(expression2));
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation(expression2);
        if (receiver != null) {
            this.generateExpression$backend_wasm(receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(field2))) {
                this.generateInstanceFieldAccess(field2, location);
            }
        } else {
            String string2;
            this.body.buildGetGlobal(this.context.referenceGlobalField(field2.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "type: " + RenderIrElementKt.render$default(field2.getType(), null, 1, null);
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
    }

    private final void generateInstanceFieldAccess(IrField field2, SourceLocation location) {
        String string2;
        WasmImmediate[] wasmImmediateArray = field2.getType();
        WasmOp opcode = Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (((Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getBooleanType()) ? true : Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getByteType())) ? true : Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getShortType())) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol())), new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field2))};
        this.body.buildInstr(opcode, location, wasmImmediateArray);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "name: " + field2.getName().asString() + ", type: " + RenderIrElementKt.render$default(field2.getType(), null, 1, null);
        wasmImmediateArray3[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation(expression2);
        if (receiver != null) {
            String string2;
            this.generateExpression$backend_wasm(receiver);
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol()), this.context.getStructFieldRef(field2), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "name: " + field2.getName() + ", type: " + RenderIrElementKt.render$default(field2.getType(), null, 1, null);
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        } else {
            String string4;
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobalField(expression2.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string5 = string4 = "type: " + RenderIrElementKt.render$default(field2.getType(), null, 1, null);
            wasmImmediateArray3[n] = new WasmImmediate.ConstString(string5);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        String string2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.functionContext.referenceLocal(0) : this.functionContext.referenceLocal(valueSymbol), this.getSourceLocation(expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "type: " + RenderIrElementKt.render$default(valueDeclaration.getType(), null, 1, null);
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        String string2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        this.body.buildSetLocal(this.functionContext.referenceLocal(expression2.getSymbol()), this.getSourceLocation(expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "type: " + RenderIrElementKt.render$default(expression2.getSymbol().getOwner().getType(), null, 1, null);
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateCall(expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)expression2.getSymbol().getOwner());
        IrClassSymbol klassSymbol = klass.getSymbol();
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klassSymbol);
        SourceLocation location = this.getSourceLocation(expression2);
        if (AnnotationsKt.getWasmArrayAnnotation(klass) != null) {
            String string2;
            if (!(expression2.getValueArgumentsCount() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            this.generateExpression$backend_wasm(irExpression);
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT, location, wasmImmediateArray);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "@WasmArrayOf ctor call: " + IrUtilsKt.getFqNameWhenAvailable(klass);
            wasmImmediateArray3[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)expression2.getSymbol().getOwner())) {
            String string4;
            this.generateAnyParameters(klassSymbol, location);
            int $i$f$commentPreviousInstr = expression2.getValueArgumentsCount();
            for (int i = 0; i < $i$f$commentPreviousInstr; ++i) {
                IrExpression irExpression = expression2.getValueArgument(i);
                Intrinsics.checkNotNull(irExpression);
                this.generateExpression$backend_wasm(irExpression);
            }
            this.body.buildStructNew(wasmGcType, location);
            WasmExpressionBuilder this_$iv = this.body;
            $i$f$commentPreviousInstr = 0;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray4 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string5 = string4 = "@WasmPrimitiveConstructor ctor call: " + IrUtilsKt.getFqNameWhenAvailable(klass);
            wasmImmediateArray4[n] = new WasmImmediate.ConstString(string5);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            return;
        }
        this.body.buildRefNull(WasmHeapType.Simple.None.INSTANCE, location);
        this.generateCall(expression2);
    }

    private final void generateAnyParameters(IrClassSymbol klassSymbol, SourceLocation location) {
        String string2;
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "Any parameters";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        this.body.buildGetGlobal(this.context.referenceGlobalVTable(klassSymbol), location);
        if (ClassInfoKt.hasInterfaceSuperClass((IrClass)klassSymbol.getOwner())) {
            this.body.buildGetGlobal(this.context.referenceGlobalClassITable(klassSymbol), location);
        } else {
            this.body.buildRefNull(WasmHeapType.Simple.Struct.INSTANCE, location);
        }
        this.body.buildConstI32Symbol(this.context.referenceTypeId(klassSymbol), location);
        this.body.buildConstI32(0, location);
        this.body.commentGroupEnd();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateObjectCreationPrefixIfNeeded(@NotNull IrConstructor constructor2) {
        String string2;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        IrClass parentClass = IrUtilsKt.getParentAsClass(constructor2);
        if (Intrinsics.areEqual(constructor2.getOrigin(), PrimaryConstructorLowering.SYNTHETIC_PRIMARY_CONSTRUCTOR.INSTANCE)) {
            return;
        }
        if (UtilsKt.isAbstractOrSealed(parentClass)) {
            return;
        }
        IrValueParameter irValueParameter = parentClass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        WasmLocal thisParameter = this.functionContext.referenceLocal(irValueParameter.getSymbol());
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "Object creation prefix";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        SourceLocation location = SourceLocation.Companion.NoLocation("Constructor preamble");
        boolean bl2 = false;
        this.body.buildGetLocal(thisParameter, location);
        this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
        WasmExpressionBuilder.buildIf$default(this.body, "this_init", null, 2, null);
        this.generateAnyParameters(parentClass.getSymbol(), location);
        List<IrField> irFields = ClassInfoKt.allFields(parentClass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field2;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index2 = n2;
            boolean bl3 = false;
            if (index2 <= 1) continue;
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(field2.getType()), this.body);
        }
        this.body.buildStructNew(this.context.referenceGcType(parentClass.getSymbol()), location);
        this.body.buildSetLocal(thisParameter, location);
        this.body.buildEnd();
        this.body.commentGroupEnd();
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClass klass = IrUtilsKt.getParentAsClass(this.functionContext.getIrFunction());
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(klass))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        this.generateCall(expression2);
    }

    private final void generateBox(IrExpression expression2, IrType type2) {
        String string2;
        IrClassSymbol klassSymbol = TypeTransformerKt.getRuntimeClass(type2, this.irBuiltIns).getSymbol();
        SourceLocation location = this.getSourceLocation(expression2);
        this.generateAnyParameters(klassSymbol, location);
        this.generateExpression$backend_wasm(expression2);
        this.body.buildStructNew(this.context.referenceGcType(klassSymbol), location);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string3 = string2 = "box";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        IrExpression it;
        SourceLocation location = this.getSourceLocation(call2);
        if (Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getBoxIntrinsic())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            this.generateBox(irExpression, irType);
            return;
        }
        if (!this.backendContext.getConfiguration().getNotNull(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS).booleanValue() && Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getRangeCheck())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (!this.backendContext.getConfiguration().getNotNull(JSConfigurationKeys.WASM_ENABLE_ASSERTS).booleanValue() && CollectionsKt.contains((Iterable)this.wasmSymbols.getAssertFuncs(), call2.getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression != null) {
            it = irExpression;
            boolean bl = false;
            this.generateExpression$backend_wasm(it);
        }
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl = false;
            this.generateExpression$backend_wasm(it);
        }
        int n = call2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression valueArgument = call2.getValueArgument(i);
            if (valueArgument == null) {
                DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(function2.getValueParameters().get(i).getType()), this.body);
                continue;
            }
            this.generateExpression$backend_wasm(valueArgument);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (IrTypePredicatesKt.isUnit(function2.getReturnType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation(function2.getSymbol().getOwner())) {
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass(function2);
            if (!IrUtilsKt.isInterface(klass)) {
                String string2;
                int n2;
                WasmImmediate[] wasmImmediateArray;
                block21: {
                    ClassMetadata classMetadata = this.context.getClassMetadata(klass.getSymbol());
                    List<VirtualMethodMetadata> $this$indexOfFirst$iv = classMetadata.getVirtualMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    wasmImmediateArray = $this$indexOfFirst$iv.iterator();
                    while (wasmImmediateArray.hasNext()) {
                        VirtualMethodMetadata item$iv;
                        VirtualMethodMetadata it2 = item$iv = wasmImmediateArray.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(it2.getFunction(), function2)) {
                            n2 = index$iv;
                            break block21;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int vfSlot = n2;
                IrExpression irExpression3 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression3);
                IrExpression receiver = irExpression3;
                this.generateExpression$backend_wasm(receiver);
                WasmImmediate[] this_$iv2 = this.body;
                boolean $i$f$commentGroupStart = false;
                wasmImmediateArray = new WasmImmediate[1];
                int n3 = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                WasmImmediate[] wasmImmediateArray3 = this_$iv2;
                boolean bl3 = false;
                String string3 = string2 = "virtual call: " + IrUtilsKt.getFqNameWhenAvailable(function2);
                wasmImmediateArray2[n3] = new WasmImmediate.ConstString(string3);
                wasmImmediateArray3.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
                this.generateRefCast(receiver.getType(), IrUtilsKt.getDefaultType(klass), location);
                this.body.buildStructGet(this.context.referenceGcType(klass.getSymbol()), new WasmSymbol<Integer>(0), location);
                this.body.buildStructGet(this.context.referenceVTableGcType(klass.getSymbol()), new WasmSymbol<Integer>(vfSlot), location);
                this_$iv2 = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()))};
                this.body.buildInstr(WasmOp.CALL_REF, location, this_$iv2);
                this.body.commentGroupEnd();
            } else {
                IrClassSymbol symbol2 = klass.getSymbol();
                if (this.hierarchyDisjointUnions.contains(symbol2)) {
                    int n4;
                    block22: {
                        void $this$indexOfFirst$iv;
                        String string4;
                        IrExpression irExpression4 = call2.getDispatchReceiver();
                        Intrinsics.checkNotNull(irExpression4);
                        this.generateExpression$backend_wasm(irExpression4);
                        WasmExpressionBuilder this_$iv = this.body;
                        boolean $i$f$commentGroupStart = false;
                        Object this_$iv2 = new WasmImmediate[1];
                        int n5 = 0;
                        WasmImmediate[] wasmImmediateArray = this_$iv2;
                        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                        boolean bl4 = false;
                        String string5 = string4 = "interface call: " + IrUtilsKt.getFqNameWhenAvailable(function2);
                        wasmImmediateArray[n5] = new WasmImmediate.ConstString(string5);
                        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, (WasmImmediate)this_$iv2);
                        this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol<Integer>(1), location);
                        WasmSymbol<WasmTypeDeclaration> classITableReference = this.context.referenceClassITableGcType(symbol2);
                        this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classITableReference, location);
                        this.body.buildStructGet(classITableReference, this.context.referenceClassITableInterfaceSlot(symbol2), location);
                        this_$iv2 = this.context.getInterfaceMetadata(symbol2).getMethods();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            VirtualMethodMetadata it3 = (VirtualMethodMetadata)item$iv;
                            boolean bl5 = false;
                            if (Intrinsics.areEqual(it3.getFunction(), function2)) {
                                n4 = index$iv;
                                break block22;
                            }
                            ++index$iv;
                        }
                        n4 = -1;
                    }
                    int vfSlot = n4;
                    this.body.buildStructGet(this.context.referenceVTableGcType(symbol2), new WasmSymbol<Integer>(vfSlot), location);
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()))};
                    this.body.buildInstr(WasmOp.CALL_REF, location, wasmImmediateArray);
                    this.body.commentGroupEnd();
                } else {
                    LocationUtilsKt.buildUnreachableForVerifier(this.body);
                }
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()), location);
        }
        if (IrTypePredicatesKt.isUnit(function2.getReturnType()) && !(function2 instanceof IrConstructor)) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateRefNullCast(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefCastNullStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        }
    }

    private final void generateRefCast(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        }
    }

    private final void generateRefTest(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefTestStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        } else {
            this.body.buildDrop(location);
            this.body.buildConstI32(1, location);
        }
    }

    private final boolean isDownCastAlwaysSuccessInRuntime(IrType fromType, IrType toType) {
        IrClass upperBound = TypeTranformerKt.getErasedUpperBound(fromType);
        if (upperBound != null && IrTypeUtilsKt.isSubtypeOfClass(upperBound.getSymbol(), this.backendContext.getWasmSymbols().getWasmAnyRefClass())) {
            return false;
        }
        return IrUtilsKt.isSubclassOf(TypeTransformerKt.getRuntimeClass(fromType, this.irBuiltIns), TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        SourceLocation location = this.getSourceLocation(call2);
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmTypeId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass2 = IrTypesKt.getClass(irType);
            if (irClass2 == null) {
                throw new IllegalStateException("No class given for wasmTypeId intrinsic".toString());
            }
            IrClass klass = irClass2;
            this.body.buildConstI32Symbol(this.context.referenceTypeId(klass.getSymbol()), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmIsInterface())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass3 = IrTypesKt.getClass(irType);
            if (irClass3 == null) {
                throw new IllegalStateException("No interface given for wasmIsInterface intrinsic".toString());
            }
            IrClass irInterface = irClass3;
            boolean bl = IrUtilsKt.isInterface(irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (this.hierarchyDisjointUnions.contains(irInterface.getSymbol())) {
                void $this$iv;
                void this_$iv;
                WasmSymbol<WasmTypeDeclaration> classITable = this.context.referenceClassITableGcType(irInterface.getSymbol());
                WasmLocal parameterLocal = this.functionContext.referenceLocal(SyntheticLocalType.IS_INTERFACE_PARAMETER);
                this.body.buildSetLocal(parameterLocal, location);
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                String string3 = "isInterface";
                WasmType resultType$iv = WasmI32.INSTANCE;
                boolean $i$f$buildBlock = false;
                int n = this_$iv.getNumberOfNestedBlocks();
                this_$iv.setNumberOfNestedBlocks(n + 1);
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
                this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
                int outerLabel = this_$iv.getNumberOfNestedBlocks();
                boolean bl2 = false;
                WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
                String label$iv = "isInterface";
                WasmType resultType$iv2 = null;
                boolean $i$f$buildBlock2 = false;
                int n2 = $this$iv.getNumberOfNestedBlocks();
                $this$iv.setNumberOfNestedBlocks(n2 + 1);
                WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
                $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
                int innerLabel = $this$iv.getNumberOfNestedBlocks();
                boolean bl3 = false;
                this.body.buildGetLocal(parameterLocal, location);
                this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol<Integer>(1), location);
                WasmLocal tmpLocal = this.functionContext.referenceLocal(SyntheticLocalType.TMP_FOR_BR_ON_CAST_EMULATION);
                WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.LocalIdx(tmpLocal)};
                this.body.buildInstr(WasmOp.LOCAL_TEE, location, wasmImmediateArray3);
                this.body.buildRefTestStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classITable, location);
                this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
                this.body.buildBrIf(innerLabel, location);
                this.body.buildGetLocal(tmpLocal, location);
                this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)classITable, location);
                this.body.buildStructGet(classITable, this.context.referenceClassITableInterfaceSlot(irInterface.getSymbol()), location);
                this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
                this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
                this.body.buildBr(outerLabel, location);
                $this$iv.buildEnd();
                this.body.buildConstI32(0, location);
                this_$iv.buildEnd();
            } else {
                this.body.buildDrop(location);
                this.body.buildConstI32(0, location);
            }
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getRefCastNull())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrType irType = irExpression.getType();
            IrType irType2 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType2);
            this.generateRefNullCast(irType, irType2, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getRefTest())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrType irType = irExpression.getType();
            IrType irType3 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType3);
            this.generateRefTest(irType, irType3, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing(fromType)) {
                LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
                return true;
            }
            IrType irType4 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull(irType4);
            IrType toType = irType4;
            IrClass irClass4 = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull(irClass4);
            IrClass klass = irClass4;
            IrField field2 = InlineClassesKt.getInlineClassBackingField(klass);
            this.generateRefCast(fromType, toType, location);
            this.generateInstanceFieldAccess(field2, location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr(), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getReturnArgumentIfItIsKotlinAny())) {
            void $this$iv;
            WasmExpressionBuilder fromType = this.body;
            String label$iv = "returnIfAny";
            WasmType resultType$iv = null;
            boolean $i$f$buildBlock = false;
            int n = $this$iv.getNumberOfNestedBlocks();
            $this$iv.setNumberOfNestedBlocks(n + 1);
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
            $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
            int innerLabel = $this$iv.getNumberOfNestedBlocks();
            boolean bl = false;
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), location);
            this.body.buildInstr(WasmOp.EXTERN_INTERNALIZE, location, new WasmImmediate[0]);
            WasmLocal tmpLocal = this.functionContext.referenceLocal(SyntheticLocalType.TMP_FOR_BR_ON_CAST_EMULATION);
            WasmImmediate[] outerLabel = new WasmImmediate[]{new WasmImmediate.LocalIdx(tmpLocal)};
            this.body.buildInstr(WasmOp.LOCAL_TEE, location, outerLabel);
            WasmSymbol<WasmTypeDeclaration> toType = this.context.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass());
            this.body.buildRefTestStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)toType, location);
            this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
            this.body.buildBrIf(innerLabel, location);
            this.body.buildGetLocal(tmpLocal, location);
            this.body.buildRefCastStatic((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)toType, location);
            this.body.buildInstr(WasmOp.RETURN, location, new WasmImmediate[0]);
            $this$iv.buildEnd();
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmArrayCopy())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            WasmImmediate.GcType immediate = new WasmImmediate.GcType(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{immediate, immediate};
            this.body.buildInstr(WasmOp.ARRAY_COPY, location, wasmImmediateArray);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getStringGetPoolSize())) {
            this.body.buildConstI32Symbol(this.context.getStringPoolSize(), location);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmArrayNewData0())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            WasmImmediate.GcType arrayGcType = new WasmImmediate.GcType(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{arrayGcType, new WasmImmediate.DataIdx(0)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Iterable $this$forEach$iv = body2.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement p0 = (IrStatement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        WasmImmediate[] wasmImmediateArray;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<IrStatement> statements2 = expression2.getStatements();
        if (statements2.isEmpty()) {
            if (Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (expression2 instanceof IrReturnableBlock) {
            String string2;
            Object object;
            IrFunction inlineFunction2 = IrInlineUtilsKt.getInlineFunction((IrReturnableBlock)((IrReturnableBlock)expression2).getSymbol().getOwner());
            IrSimpleFunction irSimpleFunction = inlineFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)inlineFunction2 : null;
            IrPropertySymbol correspondingProperty2 = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
            Object object2 = correspondingProperty2;
            IrElement owner = object2 != null && (object2 = (IrProperty)object2.getOwner()) != null ? (IrElement)object2 : (IrElement)inlineFunction2;
            Object object3 = owner;
            if ((object3 == null || (object3 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object3)) == null || (object3 = ((FqName)object3).asString()) == null) && ((object = owner) != null && (object = ((IrPossiblyExternalDeclaration)object).getName()) != null ? ((Name)object).asString() : (object3 = null)) == null) {
                object3 = "<UNKNOWN>";
            }
            Object name2 = object3;
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentGroupStart = false;
            wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string2 = "Inlined call of `" + (String)name2 + '`';
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            this.functionContext.defineNonLocalReturnLevel(((IrReturnableBlock)expression2).getSymbol(), this.body.buildBlock(this.context.transformBlockResultType(expression2.getType())));
        }
        Iterable $this$forEachIndexed$iv = statements2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void statement2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            wasmImmediateArray = (WasmImmediate[])item$iv;
            int i = n;
            boolean bl = false;
            if (i != CollectionsKt.getLastIndex(statements2)) {
                this.generateStatement((IrStatement)statement2);
                continue;
            }
            if (statement2 instanceof IrExpression) {
                this.generateWithExpectedType$backend_wasm((IrExpression)statement2, expression2.getType());
                continue;
            }
            this.generateStatement((IrStatement)statement2);
            if (Intrinsics.areEqual(expression2.getType(), this.wasmSymbols.getVoidType())) continue;
            this.buildGetUnit(this.body);
        }
        if (expression2 instanceof IrReturnableBlock) {
            this.body.buildEnd();
            this.body.commentGroupEnd();
        }
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        boolean bl = Intrinsics.areEqual(jump.getType(), this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK), this.getSourceLocation(jump));
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        boolean bl = Intrinsics.areEqual(jump.getType(), this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE), this.getSourceLocation(jump));
    }

    private final void visitFunctionReturn(IrReturn expression2) {
        IrType returnType2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType(expression2.getReturnTargetSymbol().getOwner(), this.backendContext);
        boolean isGetUnitFunction = Intrinsics.areEqual(expression2.getReturnTargetSymbol().getOwner(), this.getUnitGetInstance());
        if (isGetUnitFunction) {
            this.generateExpression$backend_wasm(expression2.getValue());
        } else if (Intrinsics.areEqual(returnType2, this.irBuiltIns.getUnitType())) {
            this.generateAsStatement(expression2.getValue());
        } else {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), returnType2);
        }
        if (this.functionContext.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        }
        this.body.buildInstr(WasmOp.RETURN, this.getSourceLocation(expression2), new WasmImmediate[0]);
    }

    public final void generateWithExpectedType$backend_wasm(@NotNull IrExpression expression2, @NotNull IrType expectedType) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        IrType actualType = expression2.getType();
        if (Intrinsics.areEqual(expectedType, this.wasmSymbols.getVoidType())) {
            this.generateAsStatement(expression2);
            return;
        }
        if (IrTypePredicatesKt.isUnit(expectedType) && !IrTypePredicatesKt.isUnit(actualType)) {
            this.generateAsStatement(expression2);
            this.buildGetUnit(this.body);
            return;
        }
        this.generateExpression$backend_wasm(expression2);
        this.recoverToExpectedType(actualType, expectedType, this.getSourceLocation(expression2));
    }

    private final void recoverToExpectedType(IrType actualType, IrType expectedType, SourceLocation location) {
        boolean actualIsPrimitive;
        IrSimpleType actualTypeErased;
        if (IrTypePredicatesKt.isNothing(expectedType)) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrTypePredicatesKt.isNothing(actualType)) {
            return;
        }
        if (IrTypePredicatesKt.isNullableNothing(actualType) && IrTypeUtilsKt.isNullable(expectedType)) {
            IrClass irClass2 = IrTypesKt.getClass(expectedType);
            boolean bl = irClass2 != null ? irClass2.isExternal() : false;
            if (bl) {
                this.body.buildDrop(location);
                this.body.buildRefNull(WasmHeapType.Simple.NoExtern.INSTANCE, location);
            }
            return;
        }
        if (IrTypeUtilsKt.isNullable(actualType) && IrTypePredicatesKt.isNullableNothing(expectedType)) {
            IrClass irClass3 = IrTypesKt.getClass(expectedType);
            WasmHeapType.Simple type2 = (irClass3 != null ? irClass3.isExternal() : false) ? (WasmHeapType.Simple)WasmHeapType.Simple.NoExtern.INSTANCE : (WasmHeapType.Simple)WasmHeapType.Simple.None.INSTANCE;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(type2)};
            this.body.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
            return;
        }
        IrClass expectedClassErased = TypeTransformerKt.getRuntimeClass(expectedType, this.irBuiltIns);
        if (expectedClassErased.isExternal()) {
            return;
        }
        IrClass actualClassErased = TypeTransformerKt.getRuntimeClass(actualType, this.irBuiltIns);
        IrSimpleType expectedTypeErased = IrUtilsKt.getDefaultType(expectedClassErased);
        if (Intrinsics.areEqual(expectedTypeErased, actualTypeErased = IrUtilsKt.getDefaultType(actualClassErased))) {
            return;
        }
        if (IrTypePredicatesKt.isNothing(expectedTypeErased) && !IrTypePredicatesKt.isNothing(actualTypeErased)) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrUtilsKt.isSubclassOf(actualClassErased, expectedClassErased)) {
            return;
        }
        boolean expectedIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default(expectedTypeErased, false, 1, null) && !IrTypeUtilsKt.isNullable(expectedType);
        boolean bl = actualIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default(actualTypeErased, false, 1, null) && !IrTypeUtilsKt.isNullable(actualType);
        if (expectedIsPrimitive != actualIsPrimitive) {
            LocationUtilsKt.buildUnreachableForVerifier(this.body);
            return;
        }
        if (!expectedIsPrimitive) {
            if (IrUtilsKt.isSubclassOf(expectedClassErased, actualClassErased)) {
                String string2;
                if (IrTypeUtilsKt.isNullable(expectedType)) {
                    this.generateRefNullCast(actualTypeErased, expectedTypeErased, location);
                } else {
                    this.generateRefCast(actualTypeErased, expectedTypeErased, location);
                }
                WasmExpressionBuilder this_$iv = this.body;
                boolean $i$f$commentPreviousInstr = false;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl2 = false;
                String string3 = string2 = "to make verifier happy";
                wasmImmediateArray2[n] = new WasmImmediate.ConstString(string3);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            } else {
                LocationUtilsKt.buildUnreachableForVerifier(this.body);
            }
        }
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrReturnableBlockSymbol nonLocalReturnSymbol;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrReturnTargetSymbol irReturnTargetSymbol = expression2.getReturnTargetSymbol();
        IrReturnableBlockSymbol irReturnableBlockSymbol = nonLocalReturnSymbol = irReturnTargetSymbol instanceof IrReturnableBlockSymbol ? (IrReturnableBlockSymbol)irReturnTargetSymbol : null;
        if (nonLocalReturnSymbol != null) {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), ((IrReturnableBlock)nonLocalReturnSymbol.getOwner()).getType());
            this.body.buildBr(this.functionContext.referenceNonLocalReturnLevel(nonLocalReturnSymbol), this.getSourceLocation(expression2));
        } else {
            this.visitFunctionReturn(expression2);
        }
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (OptimisedWhenGeneratorKt.tryGenerateOptimisedWhen(this, expression2, this.context.getBackendContext().getWasmSymbols())) {
            return;
        }
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        for (IrBranch irBranch : expression2.getBranches()) {
            if (!IrUtilsKt.isElseBranch(irBranch)) {
                this.generateExpression$backend_wasm(irBranch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateWithExpectedType$backend_wasm(irBranch.getResult(), expression2.getType());
                this.body.buildElse();
                ++ifCount;
                continue;
            }
            this.generateWithExpectedType$backend_wasm(irBranch.getResult(), expression2.getType());
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (IrTypePredicatesKt.isUnit(expression2.getType())) {
                this.buildGetUnit(this.body);
            } else {
                throw new IllegalStateException(("'When' without else branch and non Unit type: " + DumpKotlinLikeKt.dumpKotlinLike(expression2.getType())).toString());
            }
        }
        int n = 0;
        while (n < ifCount) {
            int n2 = n++;
            boolean bl = false;
            this.body.buildEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        void $this$iv;
        void $this$iv2;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder $this$iv3 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv3.getNumberOfNestedBlocks();
        $this$iv3.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv3.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv3.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv2.getNumberOfNestedBlocks();
        boolean bl2 = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "CONTINUE_" + label;
        WasmType resultType$iv3 = null;
        boolean $i$f$buildBlock2 = false;
        int n3 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n3 + 1);
        WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv3)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray3);
        int wasmContinueBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl3 = false;
        this.functionContext.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl4 = false;
            this.generateAsStatement(it);
        }
        $this$iv.buildEnd();
        this.generateExpression$backend_wasm(loop2.getCondition());
        this.body.buildBrIf(wasmLoop, this.getSourceLocation(loop2.getCondition()));
        $this$iv2.buildEnd();
        $this$iv3.buildEnd();
        this.buildGetUnit(this.body);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        void $this$iv;
        Intrinsics.checkNotNullParameter(loop2, "loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder $this$iv2 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv2.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        this.functionContext.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression$backend_wasm(loop2.getCondition());
        SourceLocation location = this.getSourceLocation(loop2.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock, location);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl3 = false;
            this.generateAsStatement(it);
        }
        this.body.buildBr(wasmLoop, SourceLocation.Companion.NoLocation("Continue in the loop"));
        $this$iv.buildEnd();
        $this$iv2.buildEnd();
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.functionContext.defineLocal(declaration.getSymbol());
        if (declaration.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration.getInitializer();
        Intrinsics.checkNotNull(irExpression);
        IrExpression init2 = irExpression;
        this.generateExpression$backend_wasm(init2);
        WasmLocal varName = this.functionContext.referenceLocal(declaration.getSymbol());
        this.body.buildSetLocal(varName, this.getSourceLocation(declaration));
    }

    private final boolean tryToGenerateWasmOpIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation(function2);
        if (opString != null) {
            SourceLocation location = this.getSourceLocation(call2);
            WasmOp op = WasmOp.valueOf(opString);
            switch (op.getImmediates().size()) {
                case 0: {
                    this.body.buildInstr(op, location, new WasmImmediate[0]);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$1[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            wasmImmediate = new WasmImmediate.GcType(BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 3: {
                            wasmImmediate = new WasmImmediate.HeapType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this)));
                            break;
                        }
                        case 4: {
                            wasmImmediate = new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 5: {
                            wasmImmediate = new WasmImmediate.MemoryIdx(0);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + (Object)((Object)imm) + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    WasmImmediate[] immediates = wasmImmediateArray;
                    this.body.buildInstr(op, location, Arrays.copyOf(immediates, immediates.length));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            return true;
        }
        return false;
    }

    private final SourceLocation getSourceLocation(IrElement $this$getSourceLocation) {
        IrFile irFile = IrUtilsKt.getFileOrNull(this.functionContext.getIrFunction());
        return LocationUtilsKt.getSourceLocation($this$getSourceLocation, irFile != null ? irFile.getFileEntry() : null);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    private static final WasmSymbol<WasmTypeDeclaration> tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(IrFunction $function, IrFunctionAccessExpression $call, BodyGenerator this$0) {
        IrAnnotationContainer irAnnotationContainer = $function.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrType irType = $call.getTypeArgument(0);
            irAnnotationContainer = irType;
            Intrinsics.checkNotNull(irType);
        }
        IrAnnotationContainer type2 = irAnnotationContainer;
        WasmModuleCodegenContext wasmModuleCodegenContext = this$0.context;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type2);
        Intrinsics.checkNotNull(irClassSymbol);
        return wasmModuleCodegenContext.referenceGcType(irClassSymbol);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(BodyGenerator $this) {
        return $this.backendContext;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            try {
                nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.HEAP_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.TYPE_IDX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.MEMORY_IDX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

