/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignerOutputStream
extends ByteArrayOutputStream {
    private static Logger log = Logger.getLogger(SignerOutputStream.class.getName());
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm sa) {
        this.sa = sa;
    }

    @Override
    public void write(byte[] arg0) {
        try {
            this.sa.update(arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(int arg0) {
        try {
            this.sa.update((byte)arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Canonicalized SignedInfo:");
            StringBuilder sb = new StringBuilder(arg2);
            for (int i = arg1; i < arg1 + arg2; ++i) {
                sb.append((char)arg0[i]);
            }
            log.log(Level.FINE, sb.toString());
        }
        try {
            this.sa.update(arg0, arg1, arg2);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }
}

