/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.BS;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.C;

public class Balls
extends AtomShape {
    @Override
    protected void setSize(int size, BS bsSelected) {
        if (size == Integer.MAX_VALUE) {
            this.isActive = true;
            if (this.bsSizeSet == null) {
                this.bsSizeSet = new BS();
            }
            this.bsSizeSet.or(bsSelected);
            return;
        }
        this.setSize2(size, bsSelected);
    }

    @Override
    protected void setSizeRD(RadiusData rd, BS bsSelected) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        int bsLength = Math.min(this.ms.at.length, bsSelected.length());
        int i = bsSelected.nextSetBit(0);
        while (i >= 0 && i < bsLength) {
            Atom atom = this.ms.at[i];
            atom.setMadAtom(this.vwr, rd);
            this.bsSizeSet.set(i);
            i = bsSelected.nextSetBit(i + 1);
        }
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("color" == propertyName) {
            short colix = C.getColixO(value);
            if (colix == 0) {
                colix = 2;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            byte pid = PAL.pidOf(value);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                Atom atom = this.ms.at[i];
                atom.colixAtom = this.getColixA(colix, pid, atom);
                this.bsColixSet.setBitTo(i, colix != 2 || pid != PAL.NONE.id);
                atom.paletteID = pid;
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("colorValues" == propertyName) {
            int[] values = (int[])value;
            if (values.length == 0) {
                return;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            int n = 0;
            Integer color = null;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                short colix;
                if (n >= values.length) {
                    return;
                }
                if ((colix = C.getColixO(color = Integer.valueOf(values[n++]))) == 0) {
                    colix = 2;
                }
                byte pid = PAL.pidOf(color);
                Atom atom = this.ms.at[i];
                atom.colixAtom = this.getColixA(colix, pid, atom);
                this.bsColixSet.setBitTo(i, colix != 2 || pid != PAL.NONE.id);
                atom.paletteID = pid;
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("colors" == propertyName) {
            Object[] data = (Object[])value;
            short[] colixes = (short[])data[0];
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            Atom[] atoms = this.ms.at;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                short c;
                if (i < colixes.length && (c = colixes[i]) != 0) {
                    atoms[i].colixAtom = c;
                    atoms[i].paletteID = PAL.UNKNOWN.id;
                    this.bsColixSet.set(i);
                }
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = ((String)value).equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            Atom[] atoms = this.ms.at;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                atoms[i].setTranslucent(isTranslucent, this.translucentLevel);
                if (isTranslucent) {
                    this.bsColixSet.set(i);
                }
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if (propertyName.startsWith("ball")) {
            propertyName = propertyName.substring(4).intern();
        }
        this.setPropAS(propertyName, value, bs);
    }

    @Override
    public void setAtomClickability() {
        BS bsDeleted = this.vwr.slm.bsDeleted;
        int i = this.ms.ac;
        while (--i >= 0) {
            Atom atom = this.ms.at[i];
            if (atom == null) continue;
            atom.setClickable(0);
            if (bsDeleted != null && bsDeleted.get(i) || (atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(i)) continue;
            atom.setClickable(this.vf);
        }
    }
}

