module temperature #
(
    parameter WIDTH = 32,
    parameter S_WIDTH_A = 1
)
(
    input clk, // Must be less than 80 MHz, should be greater than 20 MHz
    input resetn,

    // Agent port
    input [S_WIDTH_A-1:0] agent_address,  // Word address
    input [WIDTH-1:0] agent_writedata,
    input agent_read,
    input agent_write,
    input [WIDTH/8-1:0] agent_byteenable,
    output agent_waitrequest,
    output [WIDTH-1:0] agent_readdata,
    output agent_readdatavalid
);

localparam DIVIDER = 80;

wire tsdcaldone;
wire [7:0] tsdcalo;

temp_sense temp(
	.ce(agent_read),
	.clk(clk),
	.clr(!agent_read),
	.tsdcaldone(tsdcaldone),
	.tsdcalo(tsdcalo));


assign agent_waitrequest = agent_read && !tsdcaldone;
assign agent_readdata = {{WIDTH-8{1'b0}},tsdcalo} - 32'h080;  // Convert to Celsius
assign agent_readdatavalid = agent_read && tsdcaldone;

endmodule
