/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.configurationcache.InstrumentedInputAccessListenerKt;
import org.gradle.configurationcache.UndeclaredBuildInputListener;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.serialization.Workarounds;
import org.gradle.configurationcache.services.EnvironmentChangeTracker;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001a\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\"\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\"\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gradle/configurationcache/InstrumentedInputAccessListener;", "Lorg/gradle/internal/classpath/Instrumented$Listener;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "configurationCacheProblemsListener", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "environmentChangeTracker", "Lorg/gradle/configurationcache/services/EnvironmentChangeTracker;", "(Lorg/gradle/internal/event/ListenerManager;Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;Lorg/gradle/configurationcache/services/EnvironmentChangeTracker;)V", "externalProcessListener", "undeclaredInputBroadcast", "Lorg/gradle/configurationcache/UndeclaredBuildInputListener;", "kotlin.jvm.PlatformType", "envVariableQueried", "", "key", "", "value", "consumer", "externalProcessStarted", "command", "fileCollectionObserved", "fileCollection", "Lorg/gradle/api/file/FileCollection;", "fileObserved", "file", "Ljava/io/File;", "fileOpened", "systemPropertiesCleared", "systemPropertyChanged", "", "systemPropertyQueried", "systemPropertyRemoved", "configuration-cache"})
public final class InstrumentedInputAccessListener
implements Instrumented.Listener {
    @NotNull
    private final EnvironmentChangeTracker environmentChangeTracker;
    private final UndeclaredBuildInputListener undeclaredInputBroadcast;
    @NotNull
    private final ConfigurationCacheProblemsListener externalProcessListener;

    public InstrumentedInputAccessListener(@NotNull ListenerManager listenerManager, @NotNull ConfigurationCacheProblemsListener configurationCacheProblemsListener, @NotNull EnvironmentChangeTracker environmentChangeTracker) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        Intrinsics.checkNotNullParameter((Object)configurationCacheProblemsListener, (String)"configurationCacheProblemsListener");
        Intrinsics.checkNotNullParameter((Object)environmentChangeTracker, (String)"environmentChangeTracker");
        this.environmentChangeTracker = environmentChangeTracker;
        this.undeclaredInputBroadcast = (UndeclaredBuildInputListener)listenerManager.getBroadcaster(UndeclaredBuildInputListener.class);
        this.externalProcessListener = configurationCacheProblemsListener;
    }

    public void systemPropertyQueried(@NotNull String key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (InstrumentedInputAccessListenerKt.access$getAllowedProperties$p().contains(key) || Workarounds.INSTANCE.canReadSystemProperty(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.systemPropertyRead(key, value, consumer);
    }

    public void systemPropertyChanged(@NotNull Object key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertyChanged(key, value, consumer);
    }

    public void systemPropertyRemoved(@NotNull Object key, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertyRemoved(key);
    }

    public void systemPropertiesCleared(@NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.environmentChangeTracker.systemPropertiesCleared();
    }

    public void envVariableQueried(@NotNull String key, @Nullable String value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadEnvironmentVariable(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.envVariableRead(key, value, consumer);
    }

    public void externalProcessStarted(@NotNull String command, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canStartExternalProcesses(consumer)) {
            return;
        }
        this.externalProcessListener.onExternalProcessStarted(command, consumer);
    }

    public void fileOpened(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.fileOpened(file, consumer);
    }

    public void fileObserved(@NotNull File file, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.undeclaredInputBroadcast.fileObserved(file, consumer);
    }

    public void fileCollectionObserved(@NotNull FileCollection fileCollection, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"fileCollection");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.fileCollectionObserved(fileCollection, consumer);
    }
}

