/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL url = context.getResource(path);
        if (url == null) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string);
        }
        URL uRL = url;
        return uRL != null ? PathUtilKt.extractRoot(uRL, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            File file = PathUtilKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull((Object)file);
            String path = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String testPath = StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string2 = path.substring(0, path.length() - resourcePath.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                resultPath = string2;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string3 = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resourceURL.file");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string3);
            if ((pair != null ? (String)pair.getFirst() : null) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        String string4 = resultPath;
        if (string4 != null) {
            char[] cArray = new char[]{File.separatorChar};
            string = StringsKt.trimEnd(string4, (char[])cArray);
        } else {
            string = null;
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String string = url.substring(pivot + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            resourcePath = string;
            String string2 = url.substring(0, pivot);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            jarPath = string2;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                String string3 = jarPath.substring(JAR_PROTOCOL.length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                jarPath = string3;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file = PathUtilKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull((Object)file);
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string5 = jarPath.substring(FILE_PROTOCOL.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    jarPath = string5;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        String string6 = jarPath.substring(SCHEME_SEPARATOR.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                        jarPath = string6;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block6;
                    String string7 = jarPath.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                    jarPath = string7;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string2 = PathUtilKt.getResourceRoot(aClass, path);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            file = new File(it).getAbsoluteFile();
        } else {
            file = null;
        }
        return file;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        File file = PathUtilKt.tryGetResourcePathForClass(aClass);
        if (file == null) {
            throw new IllegalStateException("Resource for class: " + aClass.getName() + " not found");
        }
        return file;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name, @NotNull ClassLoader classLoader) {
        File file;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        try {
            File file2;
            Class<?> clazz = classLoader.loadClass(name);
            if (clazz != null) {
                Class<?> p0 = clazz;
                boolean bl = false;
                file2 = PathUtilKt.tryGetResourcePathForClass(p0);
            } else {
                file2 = null;
            }
            file = file2;
        }
        catch (ClassNotFoundException _) {
            file = null;
        }
        catch (NoClassDefFoundError _) {
            file = null;
        }
        return file;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$toFileOrNull, (String)"<this>");
        try {
            file2 = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            file2 = null;
        }
        catch (URISyntaxException e) {
            file2 = null;
        }
        if ((file = file2) == null) {
            URL $this$toFileOrNull_u24lambda_u2d2 = $this$toFileOrNull;
            boolean bl = false;
            file = !Intrinsics.areEqual((Object)$this$toFileOrNull_u24lambda_u2d2.getProtocol(), (Object)FILE_PROTOCOL) ? null : new File($this$toFileOrNull_u24lambda_u2d2.getFile());
        }
        return file;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        URLConnection uRLConnection;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toContainingJarOrNull, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$toContainingJarOrNull.getProtocol(), (Object)JAR_PROTOCOL) ? ((object = (uRLConnection = $this$toContainingJarOrNull.openConnection()) instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null) != null && (object = ((JarURLConnection)object).getJarFileURL()) != null ? PathUtilKt.toFileOrNull((URL)object) : null) : null;
    }
}

