/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.TableImpl;

public class DefaultColumnsImpl
implements GraphModel.DefaultColumns {
    protected final GraphStore store;
    protected TableDefaultColumns<Node> nodeDefaultColumns;
    protected TableDefaultColumns<Edge> edgeDefaultColumns;
    protected final ColumnImpl degreeColumn;
    protected final ColumnImpl inDegreeColumn;
    protected final ColumnImpl outDegreeColumn;
    protected final ColumnImpl typeColumn;

    public DefaultColumnsImpl(GraphStore store) {
        this.store = store;
        this.nodeDefaultColumns = new TableDefaultColumns<Node>(store.nodeTable);
        this.edgeDefaultColumns = new TableDefaultColumns<Edge>(store.edgeTable);
        this.degreeColumn = new ColumnImpl(store.nodeTable, "degree", Integer.class, "Degree", null, Origin.PROPERTY, false, true);
        this.inDegreeColumn = new ColumnImpl(store.nodeTable, "indegree", Integer.class, "In-Degree", null, Origin.PROPERTY, false, true);
        this.outDegreeColumn = new ColumnImpl(store.nodeTable, "outdegree", Integer.class, "Out-Degree", null, Origin.PROPERTY, false, true);
        this.typeColumn = new ColumnImpl(store.edgeTable, "type", Integer.class, "Type", null, Origin.PROPERTY, false, true);
    }

    public void resetConfiguration() {
        this.nodeDefaultColumns = new TableDefaultColumns<Node>(this.store.nodeTable);
        this.edgeDefaultColumns = new TableDefaultColumns<Edge>(this.store.edgeTable);
    }

    @Override
    public Column nodeId() {
        return this.nodeDefaultColumns.id;
    }

    @Override
    public Column edgeId() {
        return this.edgeDefaultColumns.id;
    }

    @Override
    public Column edgeWeight() {
        return this.store.edgeTable.getColumn(3);
    }

    @Override
    public Column nodeLabel() {
        return this.nodeDefaultColumns.label;
    }

    @Override
    public Column edgeLabel() {
        return this.edgeDefaultColumns.label;
    }

    @Override
    public Column nodeTimeSet() {
        return this.nodeDefaultColumns.timeset;
    }

    @Override
    public Column edgeTimeSet() {
        return this.edgeDefaultColumns.timeset;
    }

    @Override
    public Column degree() {
        return this.degreeColumn;
    }

    @Override
    public Column inDegree() {
        return this.inDegreeColumn;
    }

    @Override
    public Column outDegree() {
        return this.outDegreeColumn;
    }

    @Override
    public Column edgeType() {
        return this.typeColumn;
    }

    protected static class TableDefaultColumns<T extends Element> {
        protected final ColumnImpl id;
        protected final ColumnImpl label;
        protected final ColumnImpl timeset;

        public TableDefaultColumns(TableImpl<T> table) {
            this.id = table.getColumn(0);
            this.label = table.getColumn(1);
            this.timeset = table.getColumn(2);
        }
    }
}

