/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.FontUtils;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;

class MindMapHTMLWriter {
    private static final String CLOUD_PADDING = "padding: 0.5em;";
    private static String lf = System.getProperty("line.separator");
    private static final Pattern PARAGRAPH_PATTERN = Pattern.compile("^\\s*<(?:p|h\\d|table)\\b");
    private final boolean basedOnHeadings;
    private final boolean writesColors;
    private final Writer writer;
    private final MapController mapController;
    private final NodeStyleController nodeStyleController;
    private final TextController textController;
    private final CloudController clouds;
    private final Filter filter;
    private final MapClipboardController.CopiedNodeSet copiedNodeSet;
    private boolean writeFoldingCode;
    private Font defaultFont;
    private Color defaultColor;
    private String charset;

    private static String convertSpecialChar(char c) {
        String cvt;
        switch (c) {
            case '\u00e4': {
                cvt = "&auml;";
                break;
            }
            case '\u00f6': {
                cvt = "&ouml;";
                break;
            }
            case '\u00fc': {
                cvt = "&uuml;";
                break;
            }
            case '\u00c4': {
                cvt = "&Auml;";
                break;
            }
            case '\u00d6': {
                cvt = "&Ouml;";
                break;
            }
            case '\u00dc': {
                cvt = "&Uuml;";
                break;
            }
            case '\u00df': {
                cvt = "&szlig;";
                break;
            }
            default: {
                cvt = "&#" + Integer.toString(c) + ";";
            }
        }
        return cvt;
    }

    private static String writeHTML_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        boolean previousSpace = false;
        boolean spaceOccured = false;
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue >= '\u0080') {
                result.append(MindMapHTMLWriter.convertSpecialChar(myChar));
                continue;
            }
            spaceOccured = false;
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case ' ': {
                    spaceOccured = true;
                    if (previousSpace) {
                        result.append("&nbsp;");
                        break;
                    }
                    result.append(" ");
                    break;
                }
                case '\n': {
                    result.append("\n<br>\n");
                    break;
                }
                default: {
                    result.append(myChar);
                }
            }
            previousSpace = spaceOccured;
        }
        return result.toString();
    }

    MindMapHTMLWriter(MapController mapController, MapClipboardController.CopiedNodeSet copiedNodeSet, Writer fileout) {
        this.mapController = mapController;
        this.copiedNodeSet = copiedNodeSet;
        ModeController modeController = mapController.getModeController();
        this.nodeStyleController = NodeStyleController.getController(modeController);
        this.clouds = CloudController.getController(modeController);
        this.textController = TextController.getController(modeController);
        this.writer = fileout;
        this.writeFoldingCode = false;
        this.basedOnHeadings = this.getProperty("html_export_folding").equals("html_export_based_on_headings");
        this.writesColors = ResourceController.getResourceController().getBooleanProperty("html_export_includes_colors");
        this.filter = modeController.getController().getSelection().getFilter();
    }

    public void configureCharset(String charset) {
        this.charset = charset;
    }

    private String fontStyle(Color color, Font font) throws IOException {
        StringBuilder fontStyle = new StringBuilder();
        if (!(color == null || this.defaultColor != null && color.equals(this.defaultColor))) {
            fontStyle.append("color: ").append(ColorUtils.colorToString(color)).append("; ");
        }
        if (font != null) {
            int fontSize = font.getSize();
            if (this.defaultFont == null || fontSize != this.defaultFont.getSize()) {
                fontStyle.append("font-size: ").append(fontSize).append("pt; ");
            }
            String fontFamily = font.getFamily();
            if (this.defaultFont == null || !fontFamily.equals(this.defaultFont.getFamily())) {
                fontStyle.append("font-family: &quot;").append(fontFamily).append("&quot;, sans-serif; ");
            }
            if ((this.defaultFont == null || !this.defaultFont.isItalic()) && font.isItalic()) {
                fontStyle.append("font-style: italic; ");
            }
            if ((this.defaultFont == null || !this.defaultFont.isBold()) && font.isBold()) {
                fontStyle.append("font-weight: bold; ");
            }
            if ((this.defaultFont == null || !FontUtils.isStrikedThrough(this.defaultFont)) && FontUtils.isStrikedThrough(font)) {
                fontStyle.append("text-decoration: line-through; ");
            }
        }
        return fontStyle.toString();
    }

    private String getProperty(String key) {
        return ResourceController.getResourceController().getProperty(key);
    }

    private void writeHTMLWithFoldingJavaScript(NodeModel rootNodeOfBranch) throws IOException {
        this.writeJavaScript();
        this.writer.write("<SPAN class=\"foldspecial\" onclick=\"unfold_document()\">All +</SPAN>" + lf);
        this.writer.write("<SPAN class=\"foldspecial\" onclick=\"fold_document()\">All -</SPAN>" + lf);
        this.writeHTML(rootNodeOfBranch, "1", 0, this.getCloudColor(rootNodeOfBranch.getParentNode(), true), false, 1);
        this.writer.write("<SCRIPT type=\"text/javascript\">" + lf);
        this.writer.write("fold_document();" + lf);
        this.writer.write("</SCRIPT>" + lf);
    }

    private void writeFoldingButtons(String localParentID) throws IOException {
        this.writer.write("<span id=\"show" + localParentID + "\" class=\"foldclosed\" onClick=\"show_folder('" + localParentID + "')\" style=\"POSITION: absolute\">+</span> <span id=\"hide" + localParentID + "\" class=\"foldopened\" onClick=\"hide_folder('" + localParentID + "')\">-</span>");
        this.writer.write("\n");
    }

    void writeHTML(Collection<NodeModel> selectedNodes) throws IOException {
        this.writer.write("<html>" + lf);
        if (!selectedNodes.isEmpty()) {
            MapModel map = selectedNodes.iterator().next().getMap();
            this.setDefaultsFrom(map);
            this.writer.write("<head>" + lf);
            this.writeStyle();
            this.writer.write(lf + "</head>" + lf);
            this.startBodyWithBackgroundColor(map);
        } else {
            this.writer.write("<body>" + lf);
        }
        for (NodeModel node : selectedNodes) {
            this.writeHTML(node, "1", 0, this.getCloudColor(node.getParentNode(), true), false, 1);
        }
        this.writer.write("</body>" + lf);
        this.writer.write("</html>" + lf);
        this.writer.close();
        this.resetDefaults();
    }

    private void resetDefaults() {
        this.defaultFont = null;
        this.defaultColor = null;
    }

    private void setDefaultsFrom(MapModel map) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel styleNode = model.getDefaultStyleNode();
        this.defaultFont = this.nodeStyleController.getFont(styleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.defaultColor = this.writesColors ? this.nodeStyleController.getColor(styleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : null;
    }

    void writeHTML(List<NodeModel> branchRootNodes) throws IOException {
        if (branchRootNodes.isEmpty()) {
            return;
        }
        NodeModel firstNode = branchRootNodes.get(0);
        MapModel map = firstNode.getMap();
        this.setDefaultsFrom(map);
        String htmlExportFoldingOption = this.getProperty("html_export_folding");
        this.writeFoldingCode = htmlExportFoldingOption.equals("html_export_fold_all") || htmlExportFoldingOption.equals("html_export_fold_currently_folded") && this.hasFoldedStrictDescendant(branchRootNodes);
        ResourceController.getResourceController().getBooleanProperty("export_icons_in_html");
        this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + lf + "<html>" + lf + "<head>" + lf);
        if (this.charset != null) {
            this.writer.write("<meta charset=\"" + this.charset + "\">");
        }
        this.writer.write("<title>" + MindMapHTMLWriter.writeHTML_escapeUnicodeAndSpecialCharacters(this.textController.getPlainTransformedTextWithoutNodeNumber(branchRootNodes.size() == 1 ? firstNode : map.getRootNode()).replace('\n', ' ')) + "</title>" + lf);
        this.writeStyle();
        this.writer.write(lf + "</head>" + lf);
        this.startBodyWithBackgroundColor(map);
        for (NodeModel node : branchRootNodes) {
            if (this.writeFoldingCode) {
                this.writeHTMLWithFoldingJavaScript(node);
                continue;
            }
            this.writeHTML(node, "1", 0, this.getCloudColor(node.getParentNode(), true), false, 1);
        }
        this.writer.write("</body>" + lf);
        this.writer.write("</html>" + lf);
        this.writer.close();
        this.resetDefaults();
    }

    private void startBodyWithBackgroundColor(MapModel map) throws IOException {
        if (this.writesColors) {
            MapStyleModel style = MapStyleModel.getExtension(map);
            Color backgroundColor = style != null ? style.getBackgroundColor() : null;
            this.writeElementWithBackgroundColorAndPadding("body", backgroundColor, "");
        } else {
            this.writeElementWithBackgroundColorAndPadding("body", null, "");
        }
    }

    private void writeDivWithBackgroundColorAndCloudPadding(Color backgroundColor) throws IOException {
        this.writeElementWithBackgroundColorAndPadding("div", backgroundColor, CLOUD_PADDING);
    }

    private void writeDivWithBackgroundColor(Color backgroundColor) throws IOException {
        this.writeElementWithBackgroundColorAndPadding("div", backgroundColor, "");
    }

    private void writeElementWithBackgroundColorAndPadding(String element, Color backgroundColor, String otherStyleAttributes) throws IOException {
        this.writer.write("<" + element);
        if (backgroundColor != null) {
            this.writer.write(" style=\"background-color:" + ColorUtils.colorToString(backgroundColor) + ";" + otherStyleAttributes + "\"");
        }
        this.writer.write(">" + lf);
    }

    private Color getCloudColor(NodeModel node, boolean considerAncestors) {
        if (node == null) {
            return null;
        }
        Color color = this.clouds.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (color != null) {
            return color;
        }
        if (considerAncestors) {
            return this.getCloudColor(node.getParentNode(), true);
        }
        return null;
    }

    private Color getWrittenCloudColor(NodeModel node, Color ancestorCloudColor) {
        if (!this.writesColors) {
            return null;
        }
        if (node == null) {
            return null;
        }
        Color color = this.clouds.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (color != null) {
            return color;
        }
        return ancestorCloudColor;
    }

    private Color getWrittenBackgroundColor(NodeModel node) {
        if (!this.writesColors) {
            return null;
        }
        Color color = this.nodeStyleController.getBackgroundColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        return color;
    }

    private boolean hasFoldedStrictDescendant(List<NodeModel> branchRootNodes) {
        for (NodeModel node : branchRootNodes) {
            if (!this.mapController.hasFoldedStrictDescendant(node)) continue;
            return true;
        }
        return false;
    }

    private int writeHTML(NodeModel node, String parentID, int lastChildNumber, Color ancestorCloudColor, boolean isListElement, int depth) throws IOException {
        String noteContent;
        String detailText;
        String link;
        boolean shouldOutputFontStyle;
        Color backgroundColor;
        boolean writesBackgroundColor;
        boolean writesCloudColor;
        Color cloudColor = this.getWrittenCloudColor(node, ancestorCloudColor);
        if (this.copiedNodeSet == MapClipboardController.CopiedNodeSet.FILTERED_NODES && !node.hasVisibleContent(this.filter)) {
            for (NodeModel child : node.getChildren()) {
                lastChildNumber = this.writeHTML(child, parentID, lastChildNumber, cloudColor, isListElement, depth);
            }
            return lastChildNumber;
        }
        Object userObject = node.getUserObject();
        Object transformed = this.textController.getTransformedObjectNoFormattingNoThrow(node, node, userObject);
        boolean containsIcon = transformed instanceof Icon;
        String text = containsIcon ? HtmlUtils.iconToHtml((Icon)transformed) : transformed.toString();
        boolean containsHtml = !containsIcon && HtmlUtils.isHtml(text);
        boolean childSubtreesHaveVisibleContent = node.childSubtreesHaveVisibleContent(this.filter);
        boolean heading = this.basedOnHeadings && !containsHtml && childSubtreesHaveVisibleContent && depth <= 6;
        boolean bl = writesCloudColor = cloudColor != null;
        if (isListElement) {
            this.writer.write("<li>");
        }
        if (writesCloudColor) {
            this.writeDivWithBackgroundColorAndCloudPadding(cloudColor);
        }
        boolean bl2 = writesBackgroundColor = (backgroundColor = this.getWrittenBackgroundColor(node)) != null;
        if (writesBackgroundColor) {
            this.writeDivWithBackgroundColor(backgroundColor);
        }
        if (heading) {
            this.writer.write(lf + "<h" + depth + ">");
        } else if (!containsHtml && !isListElement) {
            this.writer.write("<p>");
        }
        boolean createFolding = childSubtreesHaveVisibleContent && this.shouldCreateFoldingCode(node);
        String localParentID = parentID;
        if (createFolding) {
            localParentID = parentID + "_" + ++lastChildNumber;
            this.writeFoldingButtons(localParentID);
        }
        String fontStyle = this.fontStyle(this.writesColors ? this.nodeStyleController.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : null, this.nodeStyleController.getFont(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        boolean bl3 = shouldOutputFontStyle = !fontStyle.equals("");
        if (shouldOutputFontStyle) {
            this.writer.write("<span style=\"" + fontStyle + "\">");
        }
        if ((link = NodeLinks.getLinkAsString(node)) != null && !text.contains(link)) {
            if (link.endsWith(".mm")) {
                link = link + ".html";
            }
            this.writer.write("<a href=\"" + link + "\" target=\"_blank\">");
        }
        if (ResourceController.getResourceController().getBooleanProperty("export_icons_in_html")) {
            this.writeIcons(node);
        }
        if (containsIcon) {
            this.writer.write(text);
        } else {
            this.writeModelContent(text);
        }
        if (link != null) {
            this.writer.write("</a>" + lf);
        }
        if (shouldOutputFontStyle) {
            this.writer.write("</span>");
        }
        if ((detailText = DetailModel.getDetailText(node)) != null) {
            this.writeModelContent(node, DetailModel.getDetail(node), detailText);
        }
        if ((noteContent = NoteModel.getNoteText(node)) != null) {
            this.writeModelContent(node, NoteModel.getNote(node), noteContent);
        }
        if (heading) {
            this.writer.write("</h" + depth + ">" + lf);
        }
        if (writesBackgroundColor) {
            this.writer.write("</div>" + lf);
        }
        if (this.getProperty("html_export_folding").equals("html_export_based_on_headings")) {
            for (NodeModel child : node.getChildren()) {
                lastChildNumber = this.writeHTML(child, localParentID, lastChildNumber, null, false, depth + 1);
            }
        } else if (childSubtreesHaveVisibleContent) {
            if (createFolding) {
                this.writer.write("<ul id=\"fold" + localParentID + "\" style=\"POSITION: relative; VISIBILITY: visible;\">" + lf);
                int localLastChildNumber = 0;
                for (NodeModel child : node.getChildren()) {
                    localLastChildNumber = this.writeHTML(child, localParentID, localLastChildNumber, null, true, depth + 1);
                }
            } else {
                this.writer.write("<ul>" + lf);
                for (NodeModel child : node.getChildren()) {
                    lastChildNumber = this.writeHTML(child, localParentID, lastChildNumber, null, true, depth + 1);
                }
            }
            this.writer.write("</ul>" + lf);
        }
        if (writesCloudColor) {
            this.writer.write("</div>" + lf);
        }
        if (isListElement) {
            this.writer.write("</li>");
        }
        return lastChildNumber;
    }

    private boolean shouldCreateFoldingCode(NodeModel node) {
        boolean createFolding = false;
        if (this.writeFoldingCode) {
            createFolding = this.getProperty("html_export_folding").equals("html_export_no_folding") || this.basedOnHeadings ? false : (this.getProperty("html_export_folding").equals("html_export_fold_all") ? node.hasChildren() : this.mapController.isFolded(node));
        }
        return createFolding;
    }

    private void writeModelContent(NodeModel node, Object nodeProperty, String data) throws IOException {
        Object transformed = this.textController.getTransformedObjectNoFormattingNoThrow(node, nodeProperty, data);
        String text = HtmlUtils.objectToHtml(transformed);
        this.writeModelContent(text);
    }

    private void writeIcons(NodeModel model) throws IOException {
        IconController iconController = IconController.getController();
        Collection<NamedIcon> icons = iconController.getIcons(model, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        for (NamedIcon icon : icons) {
            if (!(icon instanceof MindIcon)) continue;
            MindIcon mindIcon = (MindIcon)icon;
            try {
                String iconFile = new URI(null, mindIcon.getFile(), null).toString();
                this.writer.write("<img src=\"icons/" + iconFile + "\" alt=\"" + mindIcon.getTranslatedDescription() + "\"");
                Quantity<LengthUnit> iconSize = iconController.getIconSize(model, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                this.writer.write(" height = \"" + iconSize.toBaseUnitsRounded() + "\"");
                this.writer.write(">");
            }
            catch (Exception e) {
                LogUtils.severe(e);
            }
        }
    }

    private void writeJavaScript() throws IOException {
        this.writer.write("<script type=\"text/javascript\">" + lf);
        this.writer.write(FileUtils.slurpResource("/html/folding.js"));
        this.writer.write(lf + "</script>" + lf);
    }

    private void writeModelContent(String string) throws IOException {
        if (string.matches(" +")) {
            this.writer.write("&nbsp;");
        } else if (string.startsWith("<html")) {
            boolean startsWithParagraph;
            String output = string.substring(6);
            int start = output.indexOf("<body");
            start = start == -1 ? output.indexOf(62) + 1 : output.indexOf(62, start + 5) + 1;
            int end = output.indexOf("</body>");
            if (end == -1) {
                end = output.indexOf("</html>");
            }
            if (end == -1) {
                end = output.length();
            }
            if (!(startsWithParagraph = PARAGRAPH_PATTERN.matcher(output = output.substring(start, end)).find())) {
                this.writer.write("<p>");
            }
            this.writer.write(output);
        } else {
            this.writer.write(HtmlUtils.unicodeToHTMLUnicodeEntity(string));
        }
    }

    private void writeStyle() throws IOException {
        this.writer.write("<style type=\"text/css\">" + lf);
        this.writer.write("    body {");
        this.writeDefaultFontStyle();
        this.writer.write("}" + lf);
        this.writer.write(FileUtils.slurpResource("/html/freeplane.css"));
        if (this.writeFoldingCode) {
            this.writer.write(FileUtils.slurpResource("/html/folding.css"));
        }
        this.writer.write(lf + "</style>");
    }

    private void writeDefaultFontStyle() throws IOException {
        Font font = this.defaultFont;
        this.defaultFont = null;
        Color color = this.defaultColor;
        this.defaultColor = null;
        this.writer.write(this.fontStyle(color, font));
        this.defaultFont = font;
        this.defaultColor = color;
    }
}

