/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public class ModuleBinding
extends Binding
implements IUpdatableModule {
    public static final char[] UNNAMED = "".toCharArray();
    public static final char[] ALL_UNNAMED = "ALL-UNNAMED".toCharArray();
    public static final char[] ANY = "".toCharArray();
    public static final char[] ANY_NAMED = "".toCharArray();
    public static final char[] UNOBSERVABLE = "".toCharArray();
    public char[] moduleName;
    protected ModuleBinding[] requires;
    protected ModuleBinding[] requiresTransitive;
    protected PlainPackageBinding[] exportedPackages;
    private Map<PlainPackageBinding, SimpleSetOfCharArray> exportRestrictions;
    protected PlainPackageBinding[] openedPackages;
    private Map<PlainPackageBinding, SimpleSetOfCharArray> openRestrictions;
    protected TypeBinding[] uses;
    protected TypeBinding[] services;
    public Map<TypeBinding, TypeBinding[]> implementations;
    public char[] mainClassName;
    private SimpleSetOfCharArray packageNames;
    public int modifiers;
    public LookupEnvironment environment;
    public long tagBits;
    public int defaultNullness = 0;
    ModuleBinding[] requiredModules = null;
    boolean isAuto = false;
    private boolean[] isComplete = new boolean[IUpdatableModule.UpdateKind.values().length];
    private Set<ModuleBinding> transitiveRequires;
    SimpleLookupTable storedAnnotations = null;
    public HashtableOfPackage<PlainPackageBinding> declaredPackages;

    ModuleBinding(LookupEnvironment lookupEnvironment) {
        this.moduleName = UNNAMED;
        this.environment = lookupEnvironment;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PLAIN_PACKAGES;
        this.openedPackages = Binding.NO_PLAIN_PACKAGES;
        this.declaredPackages = new HashtableOfPackage();
        Arrays.fill(this.isComplete, true);
    }

    ModuleBinding(char[] cArray) {
        this.moduleName = cArray;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PLAIN_PACKAGES;
        this.openedPackages = Binding.NO_PLAIN_PACKAGES;
        this.uses = Binding.NO_TYPES;
        this.services = Binding.NO_TYPES;
        this.declaredPackages = new HashtableOfPackage(5);
    }

    protected ModuleBinding(char[] cArray, LookupEnvironment lookupEnvironment) {
        this.moduleName = cArray;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.environment = new LookupEnvironment(lookupEnvironment.root, this);
        this.declaredPackages = new HashtableOfPackage(5);
    }

    public PlainPackageBinding[] getExports() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.exportedPackages;
    }

    public String[] getExportRestrictions(PackageBinding packageBinding) {
        SimpleSetOfCharArray simpleSetOfCharArray;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.exportRestrictions != null && (simpleSetOfCharArray = this.exportRestrictions.get(packageBinding)) != null) {
            char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
            simpleSetOfCharArray.asArray((Object[])cArrayArray);
            return CharOperation.charArrayToStringArray(cArrayArray);
        }
        return CharOperation.NO_STRINGS;
    }

    public PlainPackageBinding[] getOpens() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.openedPackages;
    }

    public String[] getOpenRestrictions(PackageBinding packageBinding) {
        SimpleSetOfCharArray simpleSetOfCharArray;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.openRestrictions != null && (simpleSetOfCharArray = this.openRestrictions.get(packageBinding)) != null) {
            char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
            simpleSetOfCharArray.asArray((Object[])cArrayArray);
            return CharOperation.charArrayToStringArray(cArrayArray);
        }
        return CharOperation.NO_STRINGS;
    }

    public TypeBinding[] getImplementations(TypeBinding typeBinding) {
        if (this.implementations != null) {
            return this.implementations.get(typeBinding);
        }
        return null;
    }

    public ModuleBinding[] getRequires() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requires;
    }

    public ModuleBinding[] getRequiresTransitive() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requiresTransitive;
    }

    public TypeBinding[] getUses() {
        return this.uses;
    }

    public TypeBinding[] getServices() {
        return this.services;
    }

    void completeIfNeeded(IUpdatableModule.UpdateKind updateKind) {
        if (!this.isComplete[updateKind.ordinal()]) {
            this.isComplete[updateKind.ordinal()] = true;
            if (this.environment.nameEnvironment instanceof IModuleAwareNameEnvironment) {
                ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).applyModuleUpdates(this, updateKind);
            }
        }
    }

    @Override
    public void addReads(char[] cArray) {
        ModuleBinding moduleBinding = this.environment.getModule(cArray);
        if (moduleBinding != null) {
            int n = this.requires.length;
            if (n == 0) {
                this.requires = new ModuleBinding[]{moduleBinding};
            } else {
                this.requires = new ModuleBinding[n + 1];
                System.arraycopy(this.requires, 0, this.requires, 0, n);
                this.requires[n] = moduleBinding;
            }
        } else {
            this.environment.problemReporter.missingModuleAddReads(cArray);
            return;
        }
    }

    @Override
    public void addExports(char[] cArray, char[][] cArray2) {
        PlainPackageBinding plainPackageBinding = this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', cArray));
        if (plainPackageBinding != null && plainPackageBinding.isValidBinding()) {
            this.addResolvedExport(plainPackageBinding, cArray2);
        }
    }

    @Override
    public void setMainClassName(char[] cArray) {
        this.mainClassName = cArray;
    }

    @Override
    public void setPackageNames(SimpleSetOfCharArray simpleSetOfCharArray) {
        this.packageNames = simpleSetOfCharArray;
    }

    public char[][] getPackageNamesForClassFile() {
        if (this.packageNames == null) {
            return null;
        }
        for (PlainPackageBinding plainPackageBinding : this.exportedPackages) {
            this.packageNames.add(plainPackageBinding.readableName());
        }
        for (PlainPackageBinding plainPackageBinding : this.openedPackages) {
            this.packageNames.add(plainPackageBinding.readableName());
        }
        if (this.implementations != null) {
            Iterator<TypeBinding[]> iterator = this.implementations.values().iterator();
            while (iterator.hasNext()) {
                TypeBinding[] typeBindingArray;
                for (TypeBinding typeBinding : typeBindingArray = (TypeBinding[])iterator.next()) {
                    this.packageNames.add(((ReferenceBinding)typeBinding).fPackage.readableName());
                }
            }
        }
        return this.packageNames.values;
    }

    PlainPackageBinding createDeclaredToplevelPackage(char[] cArray) {
        PlainPackageBinding plainPackageBinding = new PlainPackageBinding(cArray, this.environment, this);
        this.declaredPackages.put(cArray, plainPackageBinding);
        return plainPackageBinding;
    }

    PlainPackageBinding createDeclaredPackage(char[][] cArray, PackageBinding packageBinding) {
        PlainPackageBinding plainPackageBinding = new PlainPackageBinding(cArray, packageBinding, this.environment, this);
        this.declaredPackages.put(CharOperation.concatWith(cArray, '.'), plainPackageBinding);
        return plainPackageBinding;
    }

    public PlainPackageBinding getOrCreateDeclaredPackage(char[][] cArray) {
        char[] cArray2 = CharOperation.concatWith(cArray, '.');
        PlainPackageBinding plainPackageBinding = (PlainPackageBinding)this.declaredPackages.get(cArray2);
        if (plainPackageBinding != null) {
            return plainPackageBinding;
        }
        if (cArray.length > 1) {
            PlainPackageBinding plainPackageBinding2 = this.getOrCreateDeclaredPackage(CharOperation.subarray(cArray, 0, cArray.length - 1));
            plainPackageBinding = new PlainPackageBinding(cArray, plainPackageBinding2, this.environment, this);
            plainPackageBinding2.addPackage(plainPackageBinding, this);
        } else {
            plainPackageBinding = new PlainPackageBinding(cArray[0], this.environment, this);
            PackageBinding packageBinding = this.environment.getPackage0(cArray[0]);
            if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
                this.environment.knownPackages.put(cArray[0], null);
            }
        }
        this.declaredPackages.put(cArray2, plainPackageBinding);
        return plainPackageBinding;
    }

    public void addResolvedExport(PlainPackageBinding plainPackageBinding, char[][] cArray) {
        if (plainPackageBinding == null || !plainPackageBinding.isValidBinding()) {
            return;
        }
        if (this.exportedPackages == null || this.exportedPackages.length == 0) {
            this.exportedPackages = new PlainPackageBinding[]{plainPackageBinding};
        } else {
            int n = this.exportedPackages.length;
            this.exportedPackages = new PlainPackageBinding[n + 1];
            System.arraycopy(this.exportedPackages, 0, this.exportedPackages, 0, n);
            this.exportedPackages[n] = plainPackageBinding;
        }
        plainPackageBinding.isExported = Boolean.TRUE;
        this.recordExportRestrictions(plainPackageBinding, cArray);
    }

    public void addResolvedOpens(PlainPackageBinding plainPackageBinding, char[][] cArray) {
        int n = this.openedPackages.length;
        if (plainPackageBinding == null || !plainPackageBinding.isValidBinding()) {
            return;
        }
        if (n == 0) {
            this.openedPackages = new PlainPackageBinding[]{plainPackageBinding};
        } else {
            this.openedPackages = new PlainPackageBinding[n + 1];
            System.arraycopy(this.openedPackages, 0, this.openedPackages, 0, n);
            this.openedPackages[n] = plainPackageBinding;
        }
        this.recordOpensRestrictions(plainPackageBinding, cArray);
    }

    protected void recordExportRestrictions(PlainPackageBinding plainPackageBinding, char[][] cArray) {
        if (cArray != null && cArray.length > 0) {
            SimpleSetOfCharArray simpleSetOfCharArray = null;
            if (this.exportRestrictions != null) {
                simpleSetOfCharArray = this.exportRestrictions.get(plainPackageBinding);
            } else {
                this.exportRestrictions = new HashMap<PlainPackageBinding, SimpleSetOfCharArray>();
            }
            if (simpleSetOfCharArray == null) {
                simpleSetOfCharArray = new SimpleSetOfCharArray(cArray.length);
                this.exportRestrictions.put(plainPackageBinding, simpleSetOfCharArray);
            }
            for (int i = 0; i < cArray.length; ++i) {
                simpleSetOfCharArray.add(cArray[i]);
            }
        }
    }

    protected void recordOpensRestrictions(PlainPackageBinding plainPackageBinding, char[][] cArray) {
        if (cArray != null && cArray.length > 0) {
            SimpleSetOfCharArray simpleSetOfCharArray = null;
            if (this.openRestrictions != null) {
                simpleSetOfCharArray = this.openRestrictions.get(plainPackageBinding);
            } else {
                this.openRestrictions = new HashMap<PlainPackageBinding, SimpleSetOfCharArray>();
            }
            if (simpleSetOfCharArray == null) {
                simpleSetOfCharArray = new SimpleSetOfCharArray(cArray.length);
                this.openRestrictions.put(plainPackageBinding, simpleSetOfCharArray);
            }
            for (int i = 0; i < cArray.length; ++i) {
                simpleSetOfCharArray.add(cArray[i]);
            }
        }
    }

    Stream<ModuleBinding> getRequiredModules(boolean bl) {
        return Stream.of(bl ? this.getRequiresTransitive() : this.getRequires());
    }

    private void collectAllDependencies(Set<ModuleBinding> set) {
        this.getRequiredModules(false).forEach(moduleBinding -> {
            if (set.add((ModuleBinding)moduleBinding)) {
                moduleBinding.collectAllDependencies(set);
            }
        });
    }

    private void collectTransitiveDependencies(Set<ModuleBinding> set) {
        this.getRequiredModules(true).forEach(moduleBinding -> {
            if (set.add((ModuleBinding)moduleBinding)) {
                moduleBinding.collectTransitiveDependencies(set);
            }
        });
    }

    public Supplier<Collection<ModuleBinding>> dependencyGraphCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (hashSet, moduleBinding) -> {
            hashSet.add(moduleBinding);
            moduleBinding.collectAllDependencies((Set<ModuleBinding>)hashSet);
        }, AbstractCollection::addAll);
    }

    public Supplier<Collection<ModuleBinding>> dependencyCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (hashSet, moduleBinding) -> {
            hashSet.add(moduleBinding);
            moduleBinding.collectTransitiveDependencies((Set<ModuleBinding>)hashSet);
        }, AbstractCollection::addAll);
    }

    public ModuleBinding[] getAllRequiredModules() {
        if (this.requiredModules != null) {
            return this.requiredModules;
        }
        Collection<ModuleBinding> collection = this.dependencyCollector().get();
        if (collection.contains(this)) {
            return NO_MODULES;
        }
        ModuleBinding moduleBinding = this.environment.javaBaseModule();
        if (!CharOperation.equals(this.moduleName, TypeConstants.JAVA_BASE) && moduleBinding != null && moduleBinding != this.environment.UnNamedModule) {
            collection.add(moduleBinding);
        }
        this.requiredModules = collection.size() > 0 ? collection.toArray(new ModuleBinding[collection.size()]) : Binding.NO_MODULES;
        return this.requiredModules;
    }

    @Override
    public char[] name() {
        return this.moduleName;
    }

    public char[] nameForLookup() {
        return this.moduleName;
    }

    public char[] nameForCUCheck() {
        return this.nameForLookup();
    }

    public boolean isPackageExportedTo(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        PlainPackageBinding plainPackageBinding = packageBinding.getIncarnation(this);
        if (plainPackageBinding != null) {
            if (this.isAuto) {
                return packageBinding.enclosingModule == this;
            }
            PlainPackageBinding[] plainPackageBindingArray = this.getExports();
            for (int i = 0; i < plainPackageBindingArray.length; ++i) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                PlainPackageBinding plainPackageBinding2 = plainPackageBindingArray[i];
                if (!plainPackageBinding2.subsumes(plainPackageBinding)) continue;
                if (this.exportRestrictions != null && (simpleSetOfCharArray = this.exportRestrictions.get(plainPackageBinding2)) != null) {
                    if (moduleBinding.isUnnamed()) {
                        return simpleSetOfCharArray.includes(ALL_UNNAMED);
                    }
                    return simpleSetOfCharArray.includes(moduleBinding.name());
                }
                return true;
            }
        }
        return false;
    }

    public PackageBinding getTopLevelPackage(char[] cArray) {
        return this.getVisiblePackage(null, cArray);
    }

    PlainPackageBinding getDeclaredPackage(char[] cArray) {
        return (PlainPackageBinding)this.declaredPackages.get(cArray);
    }

    PackageBinding getVisiblePackage(PackageBinding packageBinding, char[] cArray) {
        PackageBinding packageBinding2 = packageBinding != null ? packageBinding.getPackage0(cArray) : this.environment.getPackage0(cArray);
        if (packageBinding2 != null) {
            if (packageBinding2 == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return packageBinding2;
        }
        char[][] cArray2 = packageBinding == null ? CharOperation.NO_CHAR_CHAR : packageBinding.compoundName;
        char[][] cArray3 = CharOperation.arrayConcat(cArray2, cArray);
        char[] cArray4 = CharOperation.concatWith(cArray3, '.');
        PackageBinding packageBinding3 = (PackageBinding)this.declaredPackages.get(cArray4);
        char[][] cArray5 = null;
        if (this.environment.useModuleSystem) {
            IModuleAwareNameEnvironment iModuleAwareNameEnvironment = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
            cArray5 = iModuleAwareNameEnvironment.getUniqueModulesDeclaringPackage(cArray3, this.nameForLookup());
            if (packageBinding3 == null && cArray5 != null) {
                if (CharOperation.containsEqual(cArray5, this.moduleName)) {
                    PlainPackageBinding plainPackageBinding;
                    if (packageBinding != null && (plainPackageBinding = packageBinding.getIncarnation(this)) != null && plainPackageBinding != packageBinding) {
                        packageBinding3 = plainPackageBinding.getPackage0(cArray);
                    }
                    if (packageBinding3 == null) {
                        packageBinding3 = this.createDeclaredPackage(cArray3, packageBinding);
                    }
                } else {
                    for (char[] cArray6 : cArray5) {
                        ModuleBinding moduleBinding = this.environment.root.getModule(cArray6);
                        if (moduleBinding == null) continue;
                        PlainPackageBinding plainPackageBinding = moduleBinding.getDeclaredPackage(cArray4);
                        packageBinding3 = SplitPackageBinding.combine(plainPackageBinding, packageBinding3, this);
                    }
                }
            }
        } else if (this.environment.nameEnvironment.isPackage(cArray2, cArray)) {
            packageBinding3 = this.createDeclaredPackage(cArray3, packageBinding);
        }
        packageBinding3 = this.combineWithPackagesFromOtherRelevantModules(packageBinding3, cArray3, cArray5);
        assert (packageBinding3 == null || packageBinding3 instanceof PlainPackageBinding || packageBinding3.enclosingModule == this);
        if (packageBinding3 == null || !packageBinding3.isValidBinding()) {
            if (packageBinding != null) {
                if (packageBinding3 == null) {
                    packageBinding.addNotFoundPackage(cArray);
                } else {
                    packageBinding.knownPackages.put(cArray, packageBinding3);
                }
            } else {
                this.environment.knownPackages.put(cArray, LookupEnvironment.TheNotFoundPackage);
            }
            return null;
        }
        if (cArray2.length == 0) {
            this.environment.knownPackages.put(cArray, packageBinding3);
        } else if (packageBinding != null) {
            packageBinding3 = packageBinding.addPackage(packageBinding3, this);
        }
        return packageBinding3;
    }

    public PackageBinding getVisiblePackage(char[][] cArray) {
        if (cArray == null || cArray.length == 0) {
            return this.environment.defaultPackage;
        }
        PackageBinding packageBinding = this.getTopLevelPackage(cArray[0]);
        if (packageBinding == null) {
            return null;
        }
        for (int i = 1; i < cArray.length; ++i) {
            PackageBinding packageBinding2 = this.getVisiblePackage(packageBinding, cArray[i]);
            if (packageBinding2 == null) {
                return null;
            }
            packageBinding = packageBinding2;
        }
        return packageBinding;
    }

    PackageBinding combineWithPackagesFromOtherRelevantModules(PackageBinding packageBinding, char[][] cArray, char[][] cArray2) {
        for (ModuleBinding moduleBinding : this.otherRelevantModules(cArray2)) {
            PlainPackageBinding plainPackageBinding = moduleBinding.getDeclaredPackage(CharOperation.concatWith(cArray, '.'));
            packageBinding = SplitPackageBinding.combine(plainPackageBinding, packageBinding, this);
        }
        return packageBinding;
    }

    List<ModuleBinding> otherRelevantModules(char[][] cArray2) {
        if (this.isUnnamed() && cArray2 != null) {
            return Arrays.stream(cArray2).filter(cArray -> cArray != UNNAMED).map(cArray -> this.environment.getModule((char[])cArray)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Arrays.asList(this.getAllRequiredModules());
    }

    public boolean canAccess(PackageBinding packageBinding) {
        if (packageBinding.isDeclaredIn(this)) {
            return true;
        }
        for (ModuleBinding moduleBinding : this.getAllRequiredModules()) {
            if (!moduleBinding.isPackageExportedTo(packageBinding, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        return CharOperation.prepend('\"', this.moduleName);
    }

    @Override
    public int kind() {
        return 64;
    }

    @Override
    public char[] readableName() {
        return this.moduleName;
    }

    public String toString() {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.isOpen()) {
            stringBuilder.append("open ");
        }
        stringBuilder.append("module " + new String(this.readableName()));
        if (this.requires.length > 0) {
            stringBuilder.append("\n/*    requires    */\n");
            for (n = 0; n < this.requires.length; ++n) {
                stringBuilder.append("\n\t");
                if (this.requiresTransitive != null) {
                    for (ModuleBinding object22 : this.requiresTransitive) {
                        if (object22 != this.requires[n]) continue;
                        stringBuilder.append("transitive ");
                        break;
                    }
                }
                stringBuilder.append(this.requires[n].moduleName);
            }
        } else {
            stringBuilder.append("\nNo Requires");
        }
        if (this.exportedPackages != null && this.exportedPackages.length > 0) {
            stringBuilder.append("\n/*    exports    */\n");
            for (n = 0; n < this.exportedPackages.length; ++n) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                object = this.exportedPackages[n];
                stringBuilder.append("\n\t");
                if (object == null) {
                    stringBuilder.append("<unresolved>");
                    continue;
                }
                stringBuilder.append(((PackageBinding)object).readableName());
                SimpleSetOfCharArray simpleSetOfCharArray2 = simpleSetOfCharArray = this.exportRestrictions != null ? this.exportRestrictions.get(object) : null;
                if (simpleSetOfCharArray == null) continue;
                stringBuilder.append(" to ");
                String string = "";
                char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
                simpleSetOfCharArray.asArray((Object[])cArrayArray);
                for (char[] cArray : cArrayArray) {
                    stringBuilder.append(string);
                    stringBuilder.append(cArray);
                    string = ", ";
                }
            }
        } else {
            stringBuilder.append("\nNo Exports");
        }
        if (this.openedPackages != null && this.openedPackages.length > 0) {
            stringBuilder.append("\n/*    exports    */\n");
            for (n = 0; n < this.openedPackages.length; ++n) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                object = this.openedPackages[n];
                stringBuilder.append("\n\t");
                if (object == null) {
                    stringBuilder.append("<unresolved>");
                    continue;
                }
                stringBuilder.append(((PackageBinding)object).readableName());
                SimpleSetOfCharArray simpleSetOfCharArray3 = simpleSetOfCharArray = this.openRestrictions != null ? this.openRestrictions.get(object) : null;
                if (simpleSetOfCharArray == null) continue;
                stringBuilder.append(" to ");
                String string = "";
                char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
                simpleSetOfCharArray.asArray((Object[])cArrayArray);
                for (char[] cArray : cArrayArray) {
                    stringBuilder.append(string);
                    stringBuilder.append(cArray);
                    string = ", ";
                }
            }
        } else {
            stringBuilder.append("\nNo Opens");
        }
        if (this.uses != null && this.uses.length > 0) {
            stringBuilder.append("\n/*    uses    /*\n");
            for (n = 0; n < this.uses.length; ++n) {
                stringBuilder.append("\n\t");
                stringBuilder.append(this.uses[n].debugName());
            }
        } else {
            stringBuilder.append("\nNo Uses");
        }
        if (this.services != null && this.services.length > 0) {
            stringBuilder.append("\n/*    Services    */\n");
            for (n = 0; n < this.services.length; ++n) {
                stringBuilder.append("\n\t");
                stringBuilder.append("provides ");
                stringBuilder.append(this.services[n].debugName());
                stringBuilder.append(" with ");
                if (this.implementations != null && this.implementations.containsKey(this.services[n])) {
                    object = "";
                    TypeBinding[] typeBindingArray = this.implementations.get(this.services[n]);
                    int n2 = typeBindingArray.length;
                    for (int i = 0; i < n2; ++i) {
                        Object object2 = typeBindingArray[i];
                        stringBuilder.append((String)object).append(((TypeBinding)object2).debugName());
                        object = ", ";
                    }
                    continue;
                }
                stringBuilder.append("<missing implementations>");
            }
        } else {
            stringBuilder.append("\nNo Services");
        }
        return stringBuilder.toString();
    }

    public boolean isUnnamed() {
        return false;
    }

    public boolean isAutomatic() {
        return this.isAuto;
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isDeprecated() {
        return (this.tagBits & 0x400000000000L) != 0L;
    }

    public boolean hasUnstableAutoName() {
        return false;
    }

    public boolean isTransitivelyRequired(ModuleBinding moduleBinding) {
        if (this.transitiveRequires == null) {
            HashSet<ModuleBinding> hashSet = new HashSet<ModuleBinding>();
            this.collectTransitiveDependencies(hashSet);
            this.transitiveRequires = hashSet;
        }
        return this.transitiveRequires.contains(moduleBinding);
    }

    public int getDefaultNullness() {
        this.getAnnotationTagBits();
        return this.defaultNullness;
    }

    SimpleLookupTable storedAnnotations(boolean bl, boolean bl2) {
        if (bl && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations && !bl2) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(bl, false);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.storeAnnotations(this, annotationBindingArray, bl);
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray, boolean bl) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, bl);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, bl);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    public static class UnNamedModule
    extends ModuleBinding {
        private static final char[] UNNAMED_READABLE_NAME = "<unnamed>".toCharArray();

        UnNamedModule(LookupEnvironment lookupEnvironment) {
            super(lookupEnvironment);
        }

        @Override
        public ModuleBinding[] getAllRequiredModules() {
            return Binding.NO_MODULES;
        }

        @Override
        public boolean canAccess(PackageBinding packageBinding) {
            if (packageBinding instanceof SplitPackageBinding) {
                for (PackageBinding packageBinding2 : ((SplitPackageBinding)packageBinding).incarnations) {
                    if (!this.canAccess(packageBinding2)) continue;
                    return true;
                }
                return false;
            }
            ModuleBinding moduleBinding = packageBinding.enclosingModule;
            if (moduleBinding != null && moduleBinding != this) {
                return moduleBinding.isPackageExportedTo(packageBinding, this);
            }
            return true;
        }

        @Override
        public boolean isPackageExportedTo(PackageBinding packageBinding, ModuleBinding moduleBinding) {
            return packageBinding.isDeclaredIn(this) && packageBinding.hasCompilationUnit(false);
        }

        @Override
        PlainPackageBinding getDeclaredPackage(char[] cArray) {
            char[][] cArray2;
            IModuleAwareNameEnvironment iModuleAwareNameEnvironment;
            char[][] cArray3;
            PlainPackageBinding plainPackageBinding = super.getDeclaredPackage(cArray);
            if (plainPackageBinding == null && this.environment.useModuleSystem && (cArray3 = (iModuleAwareNameEnvironment = (IModuleAwareNameEnvironment)this.environment.nameEnvironment).getUniqueModulesDeclaringPackage(cArray2 = CharOperation.splitOn('.', cArray), this.nameForLookup())) != null && CharOperation.containsEqual(cArray3, this.moduleName)) {
                plainPackageBinding = this.getOrCreateDeclaredPackage(cArray2);
            }
            return plainPackageBinding;
        }

        @Override
        public boolean isUnnamed() {
            return true;
        }

        @Override
        public char[] nameForLookup() {
            return ANY;
        }

        @Override
        public char[] nameForCUCheck() {
            return UNNAMED;
        }

        @Override
        public char[] readableName() {
            return UNNAMED_READABLE_NAME;
        }

        @Override
        public String toString() {
            return "The Unnamed Module";
        }
    }
}

