/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:
 * Abstract:
 */

#include <stdio.h>
#include "yforth.h"
#include "searche.h"

/**************************************************************************/
/* WORDS ******************************************************************/
/**************************************************************************/

void _also() {
	if (top < WORD_LISTS) {
		top++;
		list[top] = list[top - 1];
	}
}

void _forth() {
	list[top] = forth_wid;
}

void _only() {
	top = 0;
	list[0] = forth_wid;
}

void _order() {
	register int i;
	printf("[%p] ", voc);
	for (i = 0; i <= top; i++) printf("%d: %p ", i, list[i]);
}

void _previous() {
	if (top >= 0) top--;
}


