// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain.
// SPDX-FileCopyrightText: 2025 Wilson Snyder
// SPDX-License-Identifier: CC0-1.0
//
//     assign localparam from interface typedef, single level nesting

// verilog_format: off
`define stop $stop
`define checkd(gotv,expv) do if ((gotv) !== (expv)) begin $write("%%Error: %s:%0d:  got=%0d exp=%0d\n", `__FILE__,`__LINE__, (gotv), (expv)); `stop; end while(0);
`define checkh(gotv,expv) do if ((gotv) !== (expv)) begin $write("%%Error: %s:%0d:  got=%0h exp=%0h\n", `__FILE__,`__LINE__, (gotv), (expv)); `stop; end while(0);
// verilog_format: on

interface x_if #(
    parameter int p_awidth = 4,
    parameter int p_dwidth = 7
) ();
  localparam int Bits = p_awidth + p_dwidth;
  typedef struct packed {
    logic [p_awidth-1:0] addr;
    logic [p_dwidth-1:0] data;
  } rq_t;
endinterface

interface y_if #(
    parameter int p_awidth = 4,
    parameter int p_dwidth = 7
) ();
  x_if #(
      .p_awidth(p_awidth),
      .p_dwidth(p_dwidth)
  ) x_if_a[2] ();
endinterface

module top ();
  y_if #(
      .p_awidth(16),
      .p_dwidth(8)
  ) y_if0 ();

  typedef y_if0.x_if_a[0].rq_t rq_t;

  rq_t rq;

  always_comb begin
    rq.addr = 'h1234;
    rq.data = 'h37;
  end

  initial begin
    #1;
    `checkh(rq.addr, 16'h1234);
    `checkh(rq.data, 8'h37);
    $write("*-* All Finished *-*\n");
    $finish;
  end
endmodule
