#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of either the GNU Lesser General Public License Version 3
# or the Perl Artistic License Version 2.0.
# SPDX-FileCopyrightText: 2024 Wilson Snyder
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('vlt_all')
test.pli_filename = "t/t_trace_dumpvars_dyn.cpp"
test.top_filename = "t/t_trace_dumpvars_dyn.v"

test.compile(make_main=False,
             verilator_flags2=["--trace-vcd --exe", test.pli_filename, "-CFLAGS -DVL_DEBUG"])

test.execute()

test.vcd_identical(test.trace_filename, test.golden_filename)

test.passes()
