#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of either the GNU Lesser General Public License Version 3
# or the Perl Artistic License Version 2.0.
# SPDX-FileCopyrightText: 2024 Wilson Snyder
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('simulator')


def gen(filename):
    # Generate using file to avoid missing newline in repository
    with open(filename, 'w', encoding="utf8") as fh:
        fh.write("// Generated by t_vthread.py\n")
        fh.write("1\n")
        fh.write("10\n")
        fh.write("20\n")
        fh.write("30")
        # No newline


gen(test.obj_dir + "/dat.mem")

test.compile()

test.execute()

test.passes()
