// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain
// SPDX-FileCopyrightText: 2025 Antmicro
// SPDX-License-Identifier: CC0-1.0

class SubClass;
  rand bit [2:0] field;
  function new();
    field = 0;
  endfunction
endclass
class MyClass;
  SubClass sc_inst2[2];
  function new();
    sc_inst2[1] = new;
  endfunction
endclass
;
class Deep;
  MyClass sc_inst1;
  function new();
    sc_inst1 = new;
  endfunction
endclass
;
class WeNeedToGoDeeper;
  Deep sc_inst;
  function new();
    sc_inst = new;
  endfunction
endclass
;

module t;
  initial begin
    WeNeedToGoDeeper cl_inst[100];
    cl_inst[1] = new;
    if (cl_inst[1].sc_inst.sc_inst2.sc_inst2[1].randomize() with {
          field inside {1, 2, 3};
        } == 0) begin
      $stop;
    end
  end
endmodule
