#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of either the GNU Lesser General Public License Version 3
# or the Perl Artistic License Version 2.0.
# SPDX-FileCopyrightText: 2024 Wilson Snyder
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('vlt')
test.top_filename = os.path.join(test.obj_dir, "t_inst_long.v")

length = 200
longname = "long_" * int((length + 4) / 5)


def gen_top(filename):
    with open(filename, 'w', encoding="utf8") as fh:
        fh.write("// Generated by t_inst_long.py\n")
        fh.write("module t;\n")
        fh.write("\n")
        fh.write("  " + longname + " inst ();\n")
        fh.write("\n")
        fh.write("endmodule\n")


def gen_sub(filename):
    with open(filename, 'w', encoding="utf8") as fh:
        fh.write("// Generated by t_inst_long.py\n")
        fh.write("module " + longname + ";\n")
        fh.write("\n")
        fh.write("  initial begin\n")
        fh.write("     $write(\"*-* All Finished *-*\\n\");\n")
        fh.write("     $finish;\n")
        fh.write("  end\n")
        fh.write("endmodule\n")


gen_top(test.top_filename)
gen_sub(os.path.join(test.obj_dir, longname + ".v"))

test.compile()

test.passes()
